<?php
/**
 * Description of Ajax
 *
 * @author carlos
 */
class Ajax extends EntityRepository
{
    public $flashmessenger = null;
    
    public function __construct()
    {
        if (!$this->flashmessenger instanceof FlashMessenger) {
            $this->flashmessenger = new FlashMessenger();
        }
    }
    
    public function getResponse($request, $options)
    {
        return $this->$request($options);
    }
    
    public function _getTranslation($text)
    {
        $translator = new Translator();
        return $translator->_getTranslation($text);
    }
    
    public function getTranslation($options)
    {
        $msj = $options['msj'];
        
        return array(
            'response'=>true,
            'translation'=>$this->_getTranslation($msj)
                );
    }
    
    public function confirmAction($options)
    {
        $query = "SELECT * FROM usuarios WHERE master_key = '{$options['masterKey']}' LIMIT 1";
        $result = $this->query($query);
        
        $data = null;
        if ($result->num_rows > 0) {
            $result = $this->resultToArray($result);
            $data = $result[0];
        }
        
        if ($data) {
            $operacion = $options['operation'];
            $permisos = array(
                'edit_salesRecord'=>array('1'), #admin, supervisor
                'special_decorated'=>array('1'), #admin, supervisor
                'edit_special_order'=>array('1'),
                'delete_special_order_detail'=>array('1'),
                'delete_special_order'=>array('1')
            );
            
            $permiso = $permisos[$operacion];
            if (in_array($data['role'], $permiso)) {
                return array(
                    'response'=>true
                );
            } else {
                $this->flashmessenger->addMessage(array('danger'=>'No tienes provilegios para confirmar esta operacion.'));
                return array(
                    'response'=>false,
                    'msg'=>$this->flashmessenger->getMessageString());
            }
        } else {
            $this->flashmessenger->addMessage(array('danger'=>'Clave incorrecta.'));
            return array(
                    'response'=>false,
                    'msg'=>$this->flashmessenger->getMessageString());
        }
    }
    
    public function deleteFile(array $file)
    {
        $fileDelete = $file['fileDelete'];
        if (unlink(ROOT.$fileDelete)) {
            $response = true;
            $this->flashmessenger->addMessage(array('success'=>'Documento eliminado correctamente.'));
        } else {
            $response = null;
            $this->flashmessenger->addMessage(array('danger'=>'Eror al tratat de eliminar documento.'));
        }

        return array(
            'response' => true,
            'msj'=>$this->flashmessenger->getMessageString(),
        );
    }
    
    public function setLanguage($options)
    {
        $translator = new Translator();
        $translator->setLenguage($options['language']);
        
        $login = new Login();
        $entityRepo = new EntityRepository();
        $entityRepo->update($login->getId(), array('language'=>$options['language']), 'users');
        
        return array('response'=>true);
    }
    
    public function getPaymentTermsList($options)
    {
        $customerRepo = new PaymentTermsRepository();
        $paymentTermList = $customerRepo->getListSelectPaymentTerms();
        
        $string = '<option value="">'.$this->flashmessenger->_getTranslation('Selccionar una opcion...').'</option>';
        if ($paymentTermList) {
            foreach ($paymentTermList as $key => $value) {
                $string .= "<option value='{$key}'>{$value}</option>";
            }
        }
        
        return array(
            'response'=>true,
            'paymentTermList'=>$string
        );
    }
    
    public function setCodigosPostales($options)
    {
        $empresa = new EmpresaRepository();
        $result = $empresa->getListSelectCodigosPostales($options['estado']);
       
        $list = "<option value='0'>".$this->_getTranslation('Seleccionar una opcion...')."</value>";
        foreach ($result as $key => $value) {
            $list .= "<option value='$key'>".($value)."</option>";
        }
       
        return array(
            'response'=>true,
            'codigosPostales'=>$list
                );
    }
    
    public function setMunicipios($options)
    {
        $empresa = new EmpresaRepository();
        $result = $empresa->getListSelectMunicipios($options['estado']);
       
        $list = "<option value='0'>".$this->_getTranslation('Seleccionar una opcion...')."</value>";
        foreach ($result as $key => $value) {
            $list .= "<option value='". utf8_encode($key)."'>". utf8_encode($value)."</option>";
        }
       
        return array(
            'response'=>true,
            'municipios'=>$list
                );
    }
    
    public function setColonias($options)
    {
        $empresa = new EmpresaRepository();
        $result = $empresa->getListSelectColonias($options['codigoPostal']);
       
        $list = "<option value='0'>".$this->_getTranslation('Seleccionar una opcion...')."</value>";
        foreach ($result as $key => $value) {
            $list .= "<option value='".($key)."'>".($value)."</option>";
        }
       
        return array(
            'response'=>true,
            'colonias'=>$list
                );
    }
    
    public function searchByDescriptionWildCard($options)
    {
        $prodRepo = new ProductoRepository();
        return $prodRepo->searchByDescriptionWildCard($options['wildCard']);
    }
    
    public function setListaDivisiones($options)
    {
        $repo = new ProductoRepository();
        $result = $repo->getListaDivisionesSATProdServ($options['tipo']);
        
        $list = "<option value='0'>".$this->_getTranslation('Seleccionar una opcion...')."</value>";
        foreach ($result as $key => $value) {
            $list .= "<option value='".($key)."'>".utf8_encode($value)."</option>";
        }
        //var_dump($list);exit;
        return array(
            'response'=>true,
            'divisiones'=>$list
                );
    }
    
    public function setListaGrupos($options)
    {
        $repo = new ProductoRepository();
        $result = $repo->getListaGruposSATProdServ($options['division']);
        
        $list = "<option value='0'>".$this->_getTranslation('Seleccionar una opcion...')."</value>";
        foreach ($result as $key => $value) {
            $list .= "<option value='".($key)."'>".utf8_encode($value)."</option>";
        }
       
        return array(
            'response'=>true,
            'grupos'=>$list
                );
    }
    public function setListaProductosSAT($options)
    {
        $repo = new ProductoRepository();
        $result = $repo->getListaSATProductos($options['grupo']);
        
        $list = "<option value='0'>".$this->_getTranslation('Seleccionar una opcion...')."</value>";
        foreach ($result as $key => $value) {
            $list .= "<option value='".($key)."'>".(utf8_encode($value))."</option>";
        }
       
        return array(
            'response'=>true,
            'productos'=>$list
                );
    }
    
    public function saveForm($options)
    {
        $data = array();
        foreach ($options['options'] as $row) {
            $data[$row['name']] = $row['value'];
        }
        
        switch ($data['formName']) {
            case 'cliente':
                $form = new ClienteForm();
                $form->populate($data);
                $isValid = $form->isValid();
                
                if ($isValid) {
                    $customerRepo = new ClienteRepository();
                    $id = $data['id'];
                    $customerRepo->setOptions($data);
                    
                    if (!is_null($id) && trim($id) != '') {
                        $customerRepo->update($id, $customerRepo->getOptions());
                    } else {
                        $customerRepo->save($customerRepo->getOptions());
                        $id = $customerRepo->getLastInsertId();
                    }
                    
                    return array(
                        'response'=>true,
                        'customer_id'=>$id
                    );
                } else {
                    return array(
                        'response'=>false,
                        'msg'=>$this->flashmessenger->getMessageString(),
                        'errorElements'=>$form->getNameElementWithError()
                    );
                }
                break;
                
            
             case 'paymentterms':
                $form = new PaymentTermsForm();
                $form->populate($data);
                $isValid = $form->isValid();
                
                if ($isValid) {
                    $paymentTermsRepo = new PaymentTermsRepository();
                    $id = $data['id'];
                    $paymentTermsRepo->setOptions($data);
                    
                    if (!is_null($id) && trim($id) != '') {
                        $paymentTermsRepo->update($id, $paymentTermsRepo->getOptions());
                    } else {
                        $paymentTermsRepo->save($paymentTermsRepo->getOptions());
                        $id = $paymentTermsRepo->getLastInsertId();
                    }
                    
                    return array(
                        'response'=>true,
                        'payment_terms_id'=>$id
                    );
                } else {
                    return array(
                        'response'=>false,
                        'msg'=>$this->flashmessenger->getMessageString(),
                        'errorElements'=>$form->getNameElementWithError()
                    );
                }
                break;
        }
    }
    
    public function getCustomerList($options)
    {
        $customerRepo = new ClienteRepository();
        $customerList = $customerRepo->getListSelectClientes();
        
        $string = '<option value="">'.$this->flashmessenger->_getTranslation('Selccionar una opcion...').'</option>';
        if ($customerList) {
            foreach ($customerList as $key => $value) {
                $string .= "<option value='{$key}'>{$value}</option>";
            }
        }
        
        return array(
            'response'=>true,
            'customerList'=>$string
        );
    }
	
	/*Para facturar en linea */ 
	/* Copie y pegue de otro codigo */
	public function validarTicket($options){

        $data = array();

        foreach($options['options'] as $row){

            $data[$row['name']] = $row['value'];

        }

        

        $ticket = new TicketEntity();

        $ticket->setOptions($data);

        $datosTicket = $ticket->getDatosTicket();

        

        if($datosTicket['status']=='1'){

            $this->flashmessenger->addMessage(array('success'=>"Este ticket ya fue facturado.\nPuede descargarlo la factura desde <a href='assets/descargarFactura.php?id={$datosTicket['idFactura']}'>aqui</a>"));

            return array(

                'response'=>true,

                'status'=>$datosTicket['status'],

                'msg'=>$this->flashmessenger->getMessageString()   

            );

        }

        

        if($datosTicket){         

           return array(

                'response'=>true,

                'id_ticket_table'=>$datosTicket['id'],

                'status'=>$datosTicket['status']

            );

        }

        

       $this->flashmessenger->addMessage(array('info'=>'Lo sentimos =( No se encontraron resultados con la informacion ingresada.'));

        return array(

                'response'=>null,

                'msg'=>$this->flashmessenger->getMessageString()   

           );

    }
	
	public function getDomiciliosFiscalesByRFC($options){

        $clienteRepo = new ClienteRepository();

        $listClientes = $clienteRepo->getDomiciliosFiscalesByRFC($options['rfc']);

        

        $string = "";

        if($listClientes){

            foreach($listClientes as $cliente){

                $cliente['id_cliente'] = $cliente['id'];

                $array = json_encode($cliente);

                $string .= "<tr>";                

                $string .= "<td class='text-center'>{$cliente['razon_social']}</td>";

                $string .= "<td class='text-center'>{$cliente['codigo_postal']}</td>";      

                $string .= "<td class='text-center'>{$cliente['pais']}</td>";

                $string .= "<td class='text-center'>{$cliente['estado']}</td>";

                $string .= "<td class='text-center'>{$cliente['ciudad']}</td>";

                $string .= "<td class='text-center'>{$cliente['colonia']}</td>";

                $string .= "<td class='text-center'>{$cliente['calle']}</td>";

                $string .= "<td class='text-center'>{$cliente['numero_exterior']}</td>";

                $string .= "<td class='text-center'>{$cliente['numero_interior']}</td>";

                $string .= "<td><a class='btn btn-md btn-default' onclick='setDomicilioFiscalToEdit($array);$(\"#modalListaDomiciliosPorRFC\").modal(\"hide\")'><i class='fa fa-map-marker'></i></a></td>";

                $string .= "</tr>";

            }

            

            return array(

                'response'=>true,

                'domiciliosFiscales'=>$string

            );

        }else{

            return array(

                'response'=>null

            );

        }

    }
	public function facturarTicket($options){

        $data = array();

        foreach($options['options'] as $row){

            $data[$row['name']] = $row['value'];

        }

        

        $ticket = new TicketEntity();

        $idFactura = $ticket->facturarTicket($data);

        

        $facturar = new FacturarRepository($idFactura,'Factura');

        if($facturar->_timbrar()){

            $invoice = new FacturaEntity();

            $invoice->setOptions($invoice->getById($idFactura));

            $invoice->setId($idFactura);            

            

            $fields = array(

                'idFactura'=>$idFactura,

                'idCliente'=>$invoice->getIdCliente(),

                'metodoPago'=>$invoice->getFormaDePago(),

                'numCtaPago'=>$invoice->getNumCuentaPago(),

                'status'=>'1');

            

            $ticket->update($data['id_ticket_table'],$fields);



            $invoice->crearPDF();

            $zipFile = $invoice->crearZip();



            try{

                $emailer = new Emailer();

                $emailer->sendEmail(array(

                    'to'=>$data['email'],

                    'subject'=>'Factura - '.$invoice->getNumFactura(),

                    'message'=>'Revisar factura adjunta',

                    'attachment'=>$zipFile

                ));



                $this->flashmessenger->addMessage(array('success'=>'Genial!! La Factura se envio correctamente.'));

                

            } catch (Exception $ex) {

                $this->flashmessenger->addMsg(array('danger'=>'Oops =(. Algo salio mal al tratar de enviar la Factura.'));

            }        

            

            $response = true;

            $msg = $this->flashmessenger->getMessageString();   

            $step_factura_content = "<div style='width:50%;margin:auto;text-align:center'><a href='assets/descargarFactura.php?id=$idFactura' class='btn btn-primary' target='iframe'><i class='fa fa-download'></i> Descarga tu factura aqui</a></div>";

            

        }else{

            $response = null;

            $msg = $this->flashmessenger->getMessageString();

            $step_factura_content = '';

        }

        

        return array(

            'response'=>$response,

            'msg'=>$msg,

            'step_factura_content'=>$step_factura_content

        );

        

    }    

     /*FIN Para Facturacion de tickets en Linea  */
}
