<?php
class AjaxModalForms extends EntityRepository
{
    public $flashmessenger = null;
    public function __construct()
    {
        if (!$this->flashmessenger instanceof FlashMessenger) {
            $this->flashmessenger = new FlashMessenger();
        }
    }
    
    public function getResponse($request, $options)
    {
        return $this->$request($options);
    }
    
    public function _getTranslation($text)
    {
        $translator = new Translator();
        return $translator->_getTranslation($text);
    }
    
    public function getStringForm($options)
    {
        $stringForm = "Error al tratar de obtener formulario.";
        switch ($options['name']) {
            case 'cliente':
                $form = new ClienteForm();
                $stringForm = $form->getModalFormString();
                break;
        }
        
        return array(
            'response'=>true,
            'stringForm'=>utf8_encode($stringForm)
        );
    }
    
    public function saveCliente($options)
    {
        $data = array();
        
        foreach ($options['options'] as $row) {
            $data[$row['name']] = $row['value'];
        }
        
        $form = new ClienteForm();
        $form->populate($data);
        
        if (!$form->isValid($data)) {
            return array(
                'response'=>false,
                'message'=>$this->flashmessenger->getMessageString(),
                'formString'=>utf8_encode($form->getModalFormString()),
            );
        }
        
        $entity = new ClienteRepository();
        $entity->setOptions($data);
        if ($data["idCliente"] == null) {
            $data["action"] = "insert";
        } else {
            $data["action"] = "edit";
        }
        
        if ($data['action']=='insert') {
            $result = $entity->save($entity->getOptions());
            $lastCliente = $entity->getInsertId();
        } elseif ($data['action']=='edit') {
            $result = $entity->update($data['idCliente'], $entity->getOptions());
            $lastCliente = $data['idCliente'];
        }

        if ($result) {
            $this->flashmessenger->addMessage(array('success'=>'Excelente!! El cliente se registro exitosamente.'));
        } else {
            $this->flashmessenger->addMessage(array('danger'=>'Opss. Algo salio mal al intetar registrar el cliente.'));
        }
        
        return array(
            'response'=>true,
            'message'=>$this->flashmessenger->getMessageString(),
            'listClientes'=>utf8_encode($this->getListClientes($lastCliente))
        );
    }
    
    public function saveProducto($options)
    {
        $data = array();
        foreach ($options['options'] as $row) {
            $data[$row['name']] = $row['value'];
        }
        
        $form = new ProductoForm();
        $form->populate($data);
        if (!$form->isValid($data)) {
            return array(
                'response'=>false,
                'message'=>$this->flashmessenger->getMessageString(),
                'formString'=>utf8_encode($form->getModalFormString()),
                'formString2'=>utf8_encode($form->getModalFormString2())
            );
        }
        
        $entity = new ProductoRepository();
        $entity->setOptions($data);
        if ($data['action']=='insert') {
            $result = $entity->save($entity->getOptions());
            $lastCliente = $entity->getInsertId();
        } elseif ($data['action']=='edit') {
            $result = $entity->update($data['id'], $entity->getOptions());
            $lastCliente = $data['id'];
        }
        
        if ($result) {
            $this->flashmessenger->addMessage(array('success'=>'Excelente!! El producto se registro exitosamente.'));
        } else {
            $this->flashmessenger->addMessage(array('danger'=>'Opss. Algo salio mal al intetar registrar el producto.'));
        }
        
        return array(
            'response'=>true,
            'message'=>$this->flashmessenger->getMessageString(),
            'listProductos'=>utf8_encode($this->getListProductos($lastCliente))
        );
    }

    public function getListClientes($selectedCustomer = null)
    {
        $entity = new ClienteRepository();
        $listClientes= $entity->getListSelectClientes();
        

        $list = "<option value=''>".$this->_getTranslation('Seleccionar una opcion...')."</option>";

        foreach ($listClientes as $key => $value) {
            $selected = "";

            if ($key == $selectedCustomer) {
                $selected = "selected";
            }

            $list .= "<option value='$key' $selected >$value</option>";
        }

        return $list;
    }
    
    public function getListProductos($selectedCustomer = null)
    {
        $entity = new ProductoRepository();
        $listClientes= $entity->getSelectListProductos();
        

        $list = "<option value=''>".$this->_getTranslation('Seleccionar una opcion...')."</option>";

        foreach ($listClientes as $key => $value) {
            $selected = "";

            if ($key == $selectedCustomer) {
                $selected = "selected";
            }

            $list .= "<option value='$key' $selected >$value</option>";
        }
        
        return $list;
    }

    

    public function getClienteInfo($options)
    {
        $customerId = $options['id'];

        

        $repo = new ClienteRepository();

        $data = $repo->getById($customerId);

   

        return array(

            'response'=>true,

            'clienteInfo'=>$data

        );
    }
}
