<?php
class ClienteAjax extends ClienteRepository
{
    public $flashmessenger = null;

    public function __construct()
    {
        if (!$this->flashmessenger instanceof FlashMessenger) {
            $this->flashmessenger = new FlashMessenger();
        }
    }

    public function getResponse($request, $options)
    {
        return $this->$request($options);
    }

    public function _getTranslation($text)
    {
        $translator = new Translator();
        return $translator->_getTranslation($text);
    }

    public function getTranslation($options)
    {
        $msj = $options['msj'];

        return array(
            'response'=>true,
            'translation'=>$this->_getTranslation($msj)
                );
    }

    public function getDataToEdit($options)
    {
        $colegioRepo = new ClienteRepository();
        $data = $colegioRepo->getById($options['id']);
        $data['action'] = 'edit';

        return array(
            'response'=>true,
            'userData'=>$data
        );
    }

    public function deleteCliente($options)
    {
        $colegioRepo = new ClienteRepository();
        if (!$colegioRepo->isUsedInRecord($options['id'])) {
            if ($colegioRepo->delete($options['id'])) {
                $this->flashmessenger->addMessage(array('success'=>'El cliente fue elimino satisfactoriamente.'));
            }
        } else {
            $message = 'Este cliente no puede ser eliminada, esta siendo utilizado en almenos un registro.';
            $this->flashmessenger->addMessage(array('info'=>$message));
        }

        return array(
            'response'=>true
        );
    }

    public function SaveCuentaBancaria($options)
    {
        $cuentaRepo = new ClienteRepository();
        $data = array();

        foreach ($options['options'] as $row) {
            $data[$row['name']] = $row['value'];
        }
        //echo "<pre>";var_dump($data['banco']);echo "</pre>";exit;
        $data2 = array(
            'banco'=>$data['banco'],
            'cuenta'=>$data['cuenta'],
            'clabe_interbancaria'=>$data['clabe_interbancaria'],
            'status'=>$data['status'],
            'id_cliente'=>$data['id_cliente']
        );

        if (!isset($data['idCuentaBancaria'])) {
            $this->flashmessenger->addMessage(array('success'=>'Cuenta bancaria agregada exitosamente.'));
            $cuentaRepo->saveCuentaBancaria($data2);
        } else {
            $this->flashmessenger->addMessage(array('success'=>'Cuenta bancaria actualizada exitosamente.'));
            $cuentaRepo->updateCuentaBancaria($options['idCuentaBancaria'], $data2);
        }


        $CuentasCliente = $cuentaRepo->getCuentasBancariasByIdCliente($data2['id_cliente']);
        $list =  $this->listCuentasBancarias($CuentasCliente);

        return array(
            'response'=>true,
            'listCuentas'=>$list['datos'],
            'msg'=> $this->flashmessenger->getMessageString()
        );
    }

    public function listCuentasBancarias($options)
    {
        $string = "";

        if ($options) {
            foreach ($options as $listCliente) {
                $id = $listCliente['id'];
                $array = json_encode($listCliente);

                $string .= "<tr id='{$listCliente['id_cliente']}'>";
                $string .= "<td class='text-center'>{$listCliente['bancoName']} </td>";
                $string .= "<td class='text-center'>{$listCliente['cuenta']} </td>";
                $string .= "<td class='text-center'>{$listCliente['SatusName']} </td>";
                $string .= "<td class='text-center'>
                                <a class='btn btn-xs btn-default' onclick='setCuentaBancariaOrdenanteToEditCliente($array,this);'><i class='fa fa-pencil'></i></a>
                                <a class='btn btn-xs btn-danger' onclick='deleteCuentaBancariaOrdenanteCliente($id);'><i class='fa fa-trash'></i></a>
                            </td>";
                $string .= "</tr>";
            }
        } else {
            $string = "<tr id='default' ><td style='text-align:center' colspan='8'>" . $this->_getTranslation('Aun no existen cuentas bancarias para este cliente.') . "</tr></td>";
        }
        return array(
            'datos' => $string
        );
    }
    public function getListCuentaBancarias($options)
    {
        $cuentaRepo = new ClienteRepository();
        $CuentasCliente = $cuentaRepo->getCuentasBancariasByIdCliente($options['id_cliente']);

        $list =  $this->listCuentasBancarias($CuentasCliente);
        return array(
            'response'=>true,
            'listCuentas'=>$list['datos']
        );
    }


    public function DeleteCuentaBancaria($options)
    {
        $cuentaRepo = new ClienteRepository();
        $cuentaRepo->deleteCuentaBancaria($options['idCuentaBancaria']);
    }

    public function getClientList($options) {
        $repo = new ClienteRepository();

        if(empty($options['search']))
            return [];

        $clientList = $repo->searchByTerm($options['search'], " id, razon_social ");

        return $clientList;
    }
}
