<?php
class CuentaBancariaAjax extends CuentaBancariaRepository
{
    public $flashmessenger = null;
    
    public function __construct()
    {
        if (!$this->flashmessenger instanceof FlashMessenger) {
            $this->flashmessenger = new FlashMessenger();
        }
    }
    
    public function getResponse($request, $options)
    {
        return $this->$request($options);
    }
    
    public function _getTranslation($text)
    {
        $translator = new Translator();
        return $translator->_getTranslation($text);
    }
    
    public function getTranslation($options)
    {
        $msj = $options['msj'];
        
        return array(
            'response'=>true,
            'translation'=>$this->_getTranslation($msj)
                );
    }
    
    public function getDataToEdit($options)
    {
        $colegioRepo = new CuentaBancariaRepository();
        $data = $colegioRepo->getById($options['id']);
        $data['action'] = 'edit';
        
        return array(
            'response'=>true,
            'userData'=>$data
        );
    }
    
    public function deleteCuentaBancaria($options)
    {
        $colegioRepo = new CuentaBancariaRepository();
        if (!$colegioRepo->isUsedInRecord($options['id'])) {
            if ($colegioRepo->delete($options['id'])) {
                $this->flashmessenger->addMessage(array('success'=>'La cuenta fue elimina satisfactoriamente.'));
            }
        } else {
            $message = 'Esta cuenta no puede ser eliminada, esta siendo utilizado en almenos un registro.';
            $this->flashmessenger->addMessage(array('info'=>$message));
        }
        
        return array(
            'response'=>true
        );
    }
}
