<?php
class FacturaAjax extends FacturaRepository
{
    public function __construct()
    {
        parent::__construct();
    }

    public function getResponse($request, $options)
    {
        return $this->$request($options);
    }

    public function setFacturaDetalles(array $options)
    {
        $data = array();
        foreach ($options['options'] as $row) {
            $data[$row['name']] = $row['value'];
        }

        $producto = $this->getProductById($data['id_producto']);
        if ($producto) {
            $data2 = array(
                'token_form'=>$data['token_form'],
                'idDetailTemp'=>$data['idDetailTemp'],
                'id_producto'=>$data['id_producto'],
                'nombre'=>$producto['nombre'],
                'descripcion'=>$data['descripcion'],
                'cantidad'=>$data['cantidad'],
                'precio_unitario'=>$data['precio_unitario'],
                'descuento_detalle'=>$data['descuento_detalle'],
                'impuestos_incluidos'=>$producto['impuestos_incluidos'],
                'impuestos'=>$producto['impuestos'],
            );

            $this->insertDetalle($data2);
            $facturaDetalles = $this->getFacturaDetalles($data['token_form']);
            $detalles = $this->listFacturaDetalles($facturaDetalles);
            //echo "<pre>";var_dump($facturaDetalles,$detalles);echo "</pre>";exit;
            $json = array(
                'response' => true,
                'facturaDetalles' => $detalles['facturaDetalles'],
                'totalItems'=>number_format($detalles['totalItems'], 2),
                'totalSubtotal'=>number_format($detalles['totalSubtotal'], 2, '.', ''),
                'totalDescuento'=>number_format($detalles['totalDescuento'], 2, '.', ''),
                'grandSubtotal'=>number_format($detalles['totalSubtotal'] - $detalles['totalDescuento'], 2, '.', ''),
                'total'=>number_format($detalles['total'], 2, '.', ''),
                'stringImpuestos'=>$detalles['stringImpuestos'],
                'totalImpuestoRetenido'=>number_format($detalles['totalImpuestoRetenido'], 2, '.', ''),
                'totalImpuestoTrasladado'=>number_format($detalles['totalImpuestoTrasladado'], 2, '.', '')
            );

            return $json;
        } else {
            $this->flashmessenger->addMessage(array('info'=>$this->_getTranslation('Producto no registrado.')));
            return $json = array(
                'response'=>null,
                'message'=>$this->flashmessenger->getMessageString());
        }
    }

    public function listFacturaDetalles($detalles)
    {
        $listDetalles = "";
        $cantidadItems = 0;
        $subtotal = 0;
        $totalSubtotal = 0;
        $grandSubtotal = 0;
        $totalGrandSubtotal = 0;
        $totalDescuento = 0;

        $stringImpuestos = '';
        $totalImpuestoTrasladado = 0;
        $totalImpuestoRetenido = 0;
        $impuestosAplicables = array('Trasladable'=>array(),'Retenible'=>array());

        foreach ($detalles as $detalle) {
            $id = $detalle['id'];
            unset($detalle['id']);
            $subtotal = 0;

            $array = json_encode($detalle);
            $cantidadItems += $detalle['cantidad'];

            $totalSubtotal += $detalle['cantidad'] * $detalle['precio_unitario'];
            $totalDescuento += $detalle['descuento_monto'];
            $totalGrandSubtotal += $detalle['importe']; #Ya este importe ya se desglozo los impuestos y resto descuento

            if ($detalle['impuestos_aplicables'] != '') {
                $impuestos = unserialize($detalle['impuestos_aplicables']);
                foreach ($impuestos as $tipo =>  $impuesto) {
                    foreach ($impuesto as $idImpuesto =>$impuestoInfo) {
                        if (key_exists($idImpuesto, $impuestosAplicables[$tipo])) {
                            $impuestosAplicables[$tipo][$idImpuesto]['Importe'] += number_format($impuestoInfo['Importe'], 2, '.', '');
                        } else {
                            $impuestosAplicables[$tipo][$idImpuesto]['Importe'] = number_format($impuestoInfo['Importe'], 2, '.', '');
                            $impuestosAplicables[$tipo][$idImpuesto]['nombre'] = $impuestoInfo['nombre'];
                            $impuestosAplicables[$tipo][$idImpuesto]['descripcion'] = $impuestoInfo['descripcion'];
                            $impuestosAplicables[$tipo][$idImpuesto]['Impuesto'] = $impuestoInfo['Impuesto'];
                            $impuestosAplicables[$tipo][$idImpuesto]['TipoFactor'] = $impuestoInfo['TipoFactor'];
                            $impuestosAplicables[$tipo][$idImpuesto]['TasaOCuota'] = $impuestoInfo['TasaOCuota'];
                        }
                    }
                }
            }

            $listDetalles .= "<tr>
                <td class='text-left'>
                    <a class='btn btn-sm btn-default' onclick='setFacturaDetallesToEdit($array);'><i class='fa fa-pencil'></i></a>
                    <a class='btn btn-sm btn-danger' onclick='deleteDetalles($id);'><i class='fa fa-trash'></i></a>
                </td>
                <td class='text-center'>".$detalle['codigo']."</td>
                <td>".$detalle['nombre']."<br/>".$detalle['descripcion']."</td>
                <td class='text-right'>".number_format($detalle['cantidad'], 2)."</td>
                <td class='text-center'>".utf8_encode($detalle['umName'])."</td>
                <td class='text-right'>".number_format($detalle['precio_unitario'], 2)."</td>
                <td class='text-right'>".number_format($detalle['descuento_detalle'], 2)."</td>
                <td class='text-right'>".number_format($detalle['importe'], 2)."</td>
                </tr>";
        }

        if (count($impuestosAplicables['Retenible']) > 0) {
            foreach ($impuestosAplicables['Retenible'] as $impuestoAplicable) {
                $totalImpuestoRetenido +=  $impuestoAplicable['Importe'];
                $stringImpuestos .= "<div class='col-xs-8 col-md-8 text-right'>{$impuestoAplicable['descripcion']}</div>";
                $stringImpuestos .= "<div class='col-xs-4 col-md-4 text-right p-r-0'>-".number_format($impuestoAplicable['Importe'], 2)."</div>";
            }
        }

        if (count($impuestosAplicables['Trasladable']) > 0) {
            foreach ($impuestosAplicables['Trasladable'] as $impuestoAplicable) {
                $totalImpuestoTrasladado +=  $impuestoAplicable['Importe'];
                $stringImpuestos .= "<div class='col-xs-8 col-md-8 text-right'>{$impuestoAplicable['descripcion']}</div>";
                $stringImpuestos .= "<div class='col-xs-4 col-md-4 text-right p-r-0'>".number_format($impuestoAplicable['Importe'], 2)."</div>";
            }
        }

        $total = $totalGrandSubtotal - $totalImpuestoRetenido + $totalImpuestoTrasladado;
        $_SESSION['detalles_impuestos_aplicables'] = '';
        $_SESSION['detalles_impuestos_aplicables'] = serialize($impuestosAplicables);

        return array('facturaDetalles'=>$listDetalles,
                     'totalItems'=>$cantidadItems,
                     'totalSubtotal'=>$totalSubtotal,
                     'totalDescuento'=>$totalDescuento,
                     'grandSubtotal'=>$totalGrandSubtotal,
                     'total'=>$total,
                     'stringImpuestos'=>$stringImpuestos,
                     'totalImpuestoRetenido'=>$totalImpuestoRetenido,
                     'totalImpuestoTrasladado'=>$totalImpuestoTrasladado,
                     'message'=>$this->flashmessenger->getMessageString()
            );
    }

    public function getListFacturaDetalles($tokenForm)
    {
        $facturaDetalles = $this->getFacturaDetalles($tokenForm);
        $detalles = $this->listFacturaDetalles($facturaDetalles);

        $json = array(
                'response' => true,
                'facturaDetalles' => $detalles['facturaDetalles'],
                'totalItems'=>number_format($detalles['totalItems'], 2),
                'totalSubtotal'=>number_format($detalles['totalSubtotal'], 2, '.', ''),
                'totalDescuento'=>number_format($detalles['totalDescuento'], 2, '.', ''),
                'grandSubtotal'=>number_format($detalles['totalSubtotal'] - $detalles['totalDescuento'], 2, '.', ''),
                'total'=>number_format($detalles['total'], 2, '.', ''),
                'stringImpuestos'=>$detalles['stringImpuestos'],
                'totalImpuestoRetenido'=>number_format($detalles['totalImpuestoRetenido'], 2, '.', ''),
                'totalImpuestoTrasladado'=>number_format($detalles['totalImpuestoTrasladado'], 2, '.', '')
            );

        return $json;
    }

    public function deleteDetalles(array $options)
    {
        $id = $options['id'];
        $repository = new FacturaDetailsTempRepository();
        $currentData = $repository->getById($id);

        if ($repository->delete($id)) {
            $response = true;
            $msj = 'Producto eliminado correctamente.';
        } else {
            $response = null;
            $msj = "No se pudo eliminar producto. Intente nuevamente.";
        }

        $facturaDetalles = $this->getFacturaDetalles($currentData['token_form']);
        $detalles = $this->listFacturaDetalles($facturaDetalles);

        $json = array(
            'response' => true,
            'facturaDetalles' => $detalles['facturaDetalles'],
            'totalItems'=>number_format($detalles['totalItems'], 2),
            'totalSubtotal'=>number_format($detalles['totalSubtotal'], 2, '.', ''),
            'totalDescuento'=>number_format($detalles['totalDescuento'], 2, '.', ''),
            'grandSubtotal'=>number_format($detalles['totalSubtotal'] - $detalles['totalDescuento'], 2, '.', ''),
            'total'=>number_format($detalles['total'], 2, '.', ''),
            'stringImpuestos'=>$detalles['stringImpuestos'],
            'totalImpuestoRetenido'=>number_format($detalles['totalImpuestoRetenido'], 2, '.', ''),
            'totalImpuestoTrasladado'=>number_format($detalles['totalImpuestoTrasladado'], 2, '.', '')
            );
        return $json;
    }

    public function getProductoInfo($options)
    {
        $repo = new ProductoRepository();
        $data = $repo->getById($options['id_producto']);

        return array(
            'response'=>true,
            'precioUnitario'=>$data['precio_unitario'],
            'descuento'=>$data['descuento'],
            'ivaDesglozado'=>$data['impuestos_incluidos']
        );
    }

    public function setListaUuidByCliente($options)
    {
        $factura = new FacturaRepository();

        $result = $factura->getListUUIDByCliente($options['cliente']) ;
        $list = "";
        foreach ($result as $key => $value) {
            $list .= "<option value='".($key)."'>".($value)."</option>";
        }

        return array(
            'response'=>true,
            'uuids'=>$list
        );
    }

    public function timbrarFactura($options)
    {
        $factura = new FacturarRepository($options['id_factura'], 'Factura');
        $factura->_timbrar();
        return array('response'=>true);
    }

    public function cancelarFactura($options)
    {
        $factura = new FacturarRepository($options['id_factura'], 'Factura');
        $factura->_cancelar();

        return array('response' => true);
    }

    public function getDataInvoice($options)
    {
        $idInvoice = $options['idInvoice'];

        $invoice = new FacturaRepository();
        $invoice->setOptions($invoice->getById($idInvoice));

        $customer = new ClienteRepository();
        $customerData = $customer->getById($invoice->getIdCliente());

        //pudin
        $settings = new EmpresaRepository();
        $email_message = $settings->getById('1');
        ////////////////////////
        return array(
            'response'=>true,
            'email'=>$customerData['email'],
            'email2' =>$customerData['email2'],
            'subject'=>'Factura '.$invoice->getNumFactura(),
            //'messageMail'=>'Revisar factura adjunta.'
            'messageMail'=> $email_message['email_message_factura'] //pudin
        );
    }

    public function sendInvoiceToMail($options)
    {
        $data = array();
        foreach ($options['options'] as $row) {
            $data[$row['name']] = $row['value'];
        }

        $invoice = new FacturaRepository();
        $invoice->setOptions($invoice->getById($data['id_invoice']));
        $invoice->setId($data['id_invoice']);
        $invoice->crearPDF();

        $sucursal = new SucursalRepository();
        $sucursal->setOptions($sucursal->getById($invoice->getSucursal()));

        //pudin
        $settings = new EmpresaRepository();
        $email_message = $settings->getById('1');
        ////////////////////////

        try {
            $emailer = new Emailer();
			$emailer->setConfig();
            $emailer->sendEmail(array(
                'to'=>$data['to'],
                'cc'=>$data['cc'],
                'subject'=>$data['subject'],
                'from_title'=>$sucursal->getNombre(),
                'message'=>$data['message'].$email_message['email_publicidad'],
                'attachment'=>$invoice->archivoZipPath
            ));
            //Pudin
            $factura_enviado = new FacturaRepository();
            $factura_enviado->updateEnviadoFactura($data['id_invoice']);

            $this->flashmessenger->addMessage(array('success'=>'Genial!! La Factura se envio correctamente.'));
            return array(
                'response'=>true,
                'msg'=>$this->flashmessenger->getMessageString()
            );
        } catch (Exception $ex) {
            $this->flashmessenger->addMsg(array('danger'=>'Oops =(. Algo salio mal al tratar de enviar la Factura. Intenta nuevamente'));
            return array(
                'response'=>null,
                'msg'=>$this->flashmessenger->getMessageString()
            );
        }
    }

    /*CUENTA DE GASTOS*/
    public function setCuentaDeGastosDetalles(array $options)
    {
        $data = array();
        foreach ($options['options'] as $row) {
            $data[$row['name']] = $row['value'];
        }

        $options = $data;
        $producto = $this->getProductById($options['cg_id_producto']);
        if ($producto) {
            $data = array(
                'idDetailTemp'=>$options['cg_idDetailTemp'],
                'id_producto'=>$producto['id'],
                'nombre'=>$producto['nombre'],
                'descripcion'=>$options['cg_descripcion'],
                'precio_unitario'=>$options['cg_precio_unitario']
                );

            $this->insertCuentaDeGastosDetalle($data);
            $facturaDetalles = $this->getCuentaDeGastosDetalles();
            $detalles = $this->listCuentaDeGastosDetalles($facturaDetalles);

            $json = array(
                'response' => true,
                'cuentaDeGastosDetalles' => $detalles['cuentaDeGastosDetalles'],
                'total'=>number_format($detalles['total'], 2, '.', '')
            );

            return $json;
        } else {
            $this->flashmessenger->addMessage(array('info'=>$this->_getTranslation('Producto no registrado.')));
            return $json = array(
                'response'=>null,
                'message'=>$this->flashmessenger->getMessageString());
        }
    }

    public function listCuentaDeGastosDetalles($detalles)
    {
        $listDetalles = "";
        $total = 0;

        foreach ($detalles as $detalle) {
            $id = $detalle['id'];
            unset($detalle['id']);
            $subtotal = 0;

            $array = json_encode($detalle);
            $total += $detalle['cg_precio_unitario'];

            $listDetalles .= "<tr>
                <td class='text-left'>
                    <a class='btn btn-sm btn-default' onclick='setCuentaDeGastosDetallesToEdit($array);'><i class='fa fa-pencil'></i></a>
                    <a class='btn btn-sm btn-danger' onclick='deleteCuentaDeGastosDetalles($id);'><i class='fa fa-trash'></i></a>
                </td>
                <td class='text-center'>".$detalle['codigo']."</td>
                <td>".$detalle['nombre']."<br/>".$detalle['cg_descripcion']."</td>
                <td class='text-right'>".number_format($detalle['cg_precio_unitario'], 2)."</td>
                </tr>";
        }

        return array('cuentaDeGastosDetalles'=>$listDetalles,
                     'total'=>$total,
                     'message'=>$this->flashmessenger->getMessageString()
            );
    }

    public function getListCuentaDeGastosDetalles()
    {
        $facturaDetalles = $this->getCuentaDeGastosDetalles();
        $detalles = $this->listCuentaDeGastosDetalles($facturaDetalles);

        $json = array(
            'response' => true,
            'cuentaDeGastosDetalles' => $detalles['cuentaDeGastosDetalles'],
            'total'=>number_format($detalles['total'], 2, '.', '')
        );

        return $json;
    }

    public function deleteCuentaDeGastosDetalles(array $options)
    {
        $id = $options['id'];
        $repository = new FacturaDetailsTempRepository();

        if ($repository->deleteCuentaDeGastos($id)) {
            $response = true;
            $msj = 'Producto eliminado correctamente.';
        } else {
            $response = null;
            $msj = "No se pudo eliminar producto. Intente nuevamente.";
        }

        $facturaDetalles = $this->getCuentaDeGastosDetalles();
        $detalles = $this->listCuentaDeGastosDetalles($facturaDetalles);

        $json = array(
            'response' => true,
            'cuentaDeGastosDetalles' => $detalles['cuentaDeGastosDetalles'],
            'total'=>number_format($detalles['total'], 2, '.', '')
        );
        return $json;
    }

    /*END CUENTA DE GASTOS*/

    public function getTotalFactura($options)
    {
        $facturaRecord = new FacturaRepository();
        $facturaData = $facturaRecord->getFacturaPorRangoFecha($options['start'], $options['end']);

        $string = '';
        $totalSales = 0;
        $chartData = array();
        if ($facturaData) {
            foreach ($facturaData as $factura) {
                $totalSales += $factura['total_sales'];
                $monthData[$factura['mes']] = $factura['total_sales'];
                $grandData[$factura['yearRow']] = $monthData;
                $chartData[$factura['yearRow']] = number_format($factura['total_sales'], 2, '.', '');
                $string .= "<tr>";
                $string .= "<td class='text-center'>{$factura['yearRow']}</td>";
                $string .= "<td class='text-right'>$".number_format($factura['total_sales'], 2)."</td>";
                $string .= "</tr>";
            }
            //echo "<pre>";var_dump($grandData);echo "</pre>";exit;
            return array(
                'response'=>true,
                'caption'=>$this->_getTranslation('Facturas')." ".$this->_getTranslation('del')." ".$options['start']." ".$this->_getTranslation('al')." ".$options['end'],
                'salesData'=>$string,
                'totalSales'=>number_format($totalSales, 2, '.', ''),
                'chartData'=>$grandData,
                'otherData'=>$chartData
            );
        }

        return array('response'=>false);
    }

    public function delteFacturaFile(array $file)
    {
        $fileDelete = $file['fileDelete'];
        $fileDelete = explode("/", $fileDelete);
        $fileInvoice = $fileDelete[8];

        define("RAIZ", $_SERVER['DOCUMENT_ROOT'].'/app/resources/docs/adjuntos/facturas/');
        $target_path = RAIZ.$fileInvoice;
        if (unlink($target_path)) {
            $response = true;
            $msj = 'Archivo eliminado correctamente.';
        } else {
            $response = true;
            $msj = 'Archivo no eliminado.';
            /*if (is_null($fileDelete))
            {
                $response = false;
                $msj = 'Archivo no eliminado.';
            }*/
        }

        $json = array(
            'response' => true
        );
        return $json;
    }

    public function getCustomerMethodPayment($options)
    {
        $vendor = $options['customer'];
        $date = $options['date'];
        $dueDate = $date;

        $repoVendor = new ClienteRepository();
        $dataVendor = $repoVendor->getById($vendor);

        if ($date !== '' && !is_null($date)) {
            $tools = new Tools();
            $date = $tools->setFormatDateToDB($date);

            $terms = new PaymentTermRepository();
            $termsData = $terms->getById($dataVendor['payment_terms']);


            $dueDate = $this->getDueDate($date, $termsData['days']);
            $dueDate = $tools->setFormatDateToForm($dueDate);
        }

        return array(
            'response'=>true,
            'payment_terms'=>$termsData['id'],
            'due_date'=>$dueDate
        );
    }

    public function pagarDesdeFactura($options)
    {
        try {
            $form = new PagoForm();
            $options['monto'] = $this->parseFloat($options['monto']);
            $form->populate($options);

            if($options['saldo_pendiente_factura'] < $options['monto']) {
                throw new Exception('El monto no puede ser mayor que el de la factura a pagar.');
            }

            if ($form->isValid()) {
                $pagoRepo = new PagoRepository();
                $pagoRepo->setOptions($options);
                $dataToSave = $pagoRepo->getOptions();
                $dataToSave['adjuntos'] = $_FILES['adjuntos'];
                $dataToSave['pago'] = [
                    $options['id_factura'] => $this->parseFloat($options['monto']),
                ];

                if ($pagoRepo->save($dataToSave)) {
                    $this->flashmessenger->addMessage([
                        'success' => 'El pago fue registrado de forma satisfactoria'
                    ]);
                    return [
                        'response' => true,
                        'id_pago' => $pagoRepo->getLastInsertId(),
                        'id_factura' => $options['id_factura'],
                        'message' => $this->flashmessenger->getMessageString(),
                    ];
                }
            } else {
                return [
                    'response' => false,
                    'message' => $this->flashmessenger->getMessageString(),
                    'errors' => $form->getNameElementWithError(),
                ];
            }
        } catch (Exception $exc) {
            $this->flashmessenger->addMessage([
                'danger' => $exc->getMessage(),
            ]);
            return [
                'response' => false,
                'message' => $this->flashmessenger->getMessageString(),
            ];
        }
    }
    public function timbrarPagoDesdeFactura($options) {
        try {
            $pago = new PagoRepository();
            $detalles = $pago->getDetallesByIdPago($options['id_pago']);

            foreach ($detalles as $detalle) {
                if ($detalle['id_factura'] != $options['id_factura']) {
                    throw new Exception("No puedes timbrar un pago que no ha sido asignado a esta factura");
                }
            }


            $pago = new PagoTimbrarRepository($options['id_pago']);
            if(!$pago->_timbrar()) {
                throw new Exception('Problema para timbrar el pago');
            }

            $this->flashmessenger->addMessage([
                'success' => 'El pago ha sido timbrado de forma correcta.',
            ]);
            return [
                'response' => true,
                'message' => $this->flashmessenger->getMessageString(),
            ];
        } catch (Exception $ex) {
            $this->flashmessenger->addMessage([
                'danger' => $ex->getMessage(),
            ]);
            return [
                'reponse' => false,
                'message' => $this->flashmessenger->getMessageString(),
            ];
        }
    }

    public function uploadFileOnly($options) {
        $repo = new FacturaRepository();
        $options['adjunto'] = $_FILES;

        $repo->saveFiles($_FILES, $options['id']);

        $this->flashmessenger->addMessage([
            'success' => 'El archivo ha sido cargado correctamente'
        ]);

        return [
            'response' => true
        ];
    }
}
