<?php
class NotaCreditoAjax extends NotaCreditoRepository
{
    public function __construct()
    {
        parent::__construct();
    }

    public function getResponse($request, $options)
    {
        return $this->$request($options);
    }

    public function setNotaCreditoDetalles(array $options)
    {
        $data = array();
        foreach ($options['options'] as $row) {
            $data[$row['name']] = $row['value'];
        }
        
        $options = $data;
        $producto = $this->getProductById($options['id_producto']);
        if ($producto) {
            $data = array(
                'idDetailTemp'=>$options['idDetailTemp'],
                'id_producto'=>$producto['id'],
                'nombre'=>$producto['nombre'],
                'descripcion'=>$options['descripcion'],
                'cantidad'=>$options['cantidad'],
                'precio_unitario'=>$options['precio_unitario'],
                'descuento_detalle'=>$options['descuento_detalle'],
                'impuestos_incluidos'=>$producto['impuestos_incluidos'],
                'impuestos'=>$producto['impuestos'],
                'token_form'=>$options['token_form'],
                );
            //var_dump($options,$data);exit;
            $this->insertDetalle($data);
            $facturaDetalles = $this->getFacturaDetalles($data['token_form']);
            $detalles = $this->listFacturaDetalles($facturaDetalles);
            
            
            $json = array(
                'response' => true,
                'facturaDetalles' => $detalles['facturaDetalles'],
                'totalItems'=>number_format($detalles['totalItems'], 2),
                'totalSubtotal'=>number_format($detalles['totalSubtotal'], 2, '.', ''),
                'totalDescuento'=>number_format($detalles['totalDescuento'], 2, '.', ''),
                'grandSubtotal'=>number_format($detalles['totalSubtotal'] - $detalles['totalDescuento'], 2, '.', ''),
                'total'=>number_format($detalles['total'], 2, '.', ''),
                'stringImpuestos'=>$detalles['stringImpuestos'],
                'totalImpuestoRetenido'=>number_format($detalles['totalImpuestoRetenido'], 2, '.', ''),
                'totalImpuestoTrasladado'=>number_format($detalles['totalImpuestoTrasladado'], 2, '.', ''),
            );
            
            return $json;
        } else {
            $this->flashmessenger->addMessage(array('info'=>$this->_getTranslation('Producto no registrado.')));
            return $json = array(
                'response'=>null,
                'message'=>$this->flashmessenger->getMessageString());
        }
    }
    
    public function listFacturaDetalles($detalles, $status = null)
    {
        $listDetalles = "";
        $cantidadItems = 0;
        $subtotal = 0;
        $totalSubtotal = 0;
        $totalGrandSubtotal = 0;
        $totalDescuento = 0;
        
        if ($status == '3') {
            $disabled = 'disabled';
        }
        
        $stringImpuestos = '';
        $totalImpuestoTrasladado = 0;
        $totalImpuestoRetenido = 0;
        $impuestosAplicables = array('Trasladable'=>array(),'Retenible'=>array());
        $id = null;
        
        foreach ($detalles as $detalle) {
            $id = $detalle['id'];
            unset($detalle['id']);
            $subtotal = 0;
            
            $array = json_encode($detalle);
            $cantidadItems += $detalle['cantidad'];
            
            $totalSubtotal += $detalle['cantidad'] * $detalle['precio_unitario'];
            $totalDescuento += $detalle['descuento_monto'];
            $totalGrandSubtotal += $detalle['importe']; #Ya este importe ya se desglozo los impuestos y resto descuento

            if ($detalle['impuestos_aplicables'] != '') {
                $impuestos = unserialize($detalle['impuestos_aplicables']);
                foreach ($impuestos as $tipo =>  $impuesto) {
                    foreach ($impuesto as $idImpuesto =>$impuestoInfo) {
                        if (key_exists($idImpuesto, $impuestosAplicables[$tipo])) {
                            $impuestosAplicables[$tipo][$idImpuesto]['Importe'] += number_format($impuestoInfo['Importe'], 2, '.', '');
                        } else {
                            $impuestosAplicables[$tipo][$idImpuesto]['Importe'] = number_format($impuestoInfo['Importe'], 2, '.', '');
                            $impuestosAplicables[$tipo][$idImpuesto]['nombre'] = $impuestoInfo['nombre'];
                            $impuestosAplicables[$tipo][$idImpuesto]['descripcion'] = $impuestoInfo['descripcion'];
                            $impuestosAplicables[$tipo][$idImpuesto]['Impuesto'] = $impuestoInfo['Impuesto'];
                            $impuestosAplicables[$tipo][$idImpuesto]['TipoFactor'] = $impuestoInfo['TipoFactor'];
                            $impuestosAplicables[$tipo][$idImpuesto]['TasaOCuota'] = $impuestoInfo['TasaOCuota'];
                        }
                    }
                }
            }
            
            $listDetalles .= "<tr>  
                <td class='text-left'>                       
                    <a class='btn btn-sm btn-primary' onclick='setNotaCreditoDetallesToEdit($array);'><i class='fa fa-pencil'></i></a>
                    <a class='btn btn-sm btn-danger' onclick='deleteDetallesNotaCredito($id);'><i class='fa fa-trash'></i></a>
                </td>  
                <td class='text-center'>".$detalle['codigo']."</td>                    
                <td>".$detalle['nombre']."<br/>".$detalle['descripcion']."</td> 
                <td class='text-right'>".number_format($detalle['cantidad'], 2)."</td>
                <td class='text-center'>".utf8_encode($detalle['umName'])."</td>
                <td class='text-right'>".number_format($detalle['precio_unitario'], 2)."</td>
                <td class='text-right'>".number_format($detalle['descuento_detalle'], 2)."</td>
                <td class='text-right'>".number_format($detalle['importe'], 2)."</td>
                </tr>";
        }
        
        if (count($impuestosAplicables['Retenible']) > 0) {
            foreach ($impuestosAplicables['Retenible'] as $impuestoAplicable) {
                $totalImpuestoRetenido +=  $impuestoAplicable['Importe'];
                $stringImpuestos .= "<div class='col-xs-8 col-md-8 text-right'>{$impuestoAplicable['descripcion']}</div>";
                $stringImpuestos .= "<div class='col-xs-4 col-md-4 text-right p-r-0'>-".number_format($impuestoAplicable['Importe'], 2)."</div>";
            }
        }
        
        if (count($impuestosAplicables['Trasladable']) > 0) {
            foreach ($impuestosAplicables['Trasladable'] as $impuestoAplicable) {
                $totalImpuestoTrasladado +=  $impuestoAplicable['Importe'];
                $stringImpuestos .= "<div class='col-xs-8 col-md-8 text-right'>{$impuestoAplicable['descripcion']}</div>";
                $stringImpuestos .= "<div class='col-xs-4 col-md-4 text-right p-r-0'>".number_format($impuestoAplicable['Importe'], 2)."</div>";
            }
        }
        
        $total = $totalGrandSubtotal - $totalImpuestoRetenido + $totalImpuestoTrasladado;
        $_SESSION['detalles_impuestos_aplicables'] = '';
        $_SESSION['detalles_impuestos_aplicables'] = serialize($impuestosAplicables);
            
        return array('facturaDetalles'=>$listDetalles,
                     'totalItems'=>$cantidadItems,
                     'totalSubtotal'=>$totalSubtotal,
                     'totalDescuento'=>$totalDescuento,
                     'grandSubtotal'=>$totalGrandSubtotal,
                     'total'=>$total,
                     'stringImpuestos'=>$stringImpuestos,
                     'totalImpuestoRetenido'=>$totalImpuestoRetenido,
                     'totalImpuestoTrasladado'=>$totalImpuestoTrasladado,
                     'message'=>$this->flashmessenger->getMessageString(),
                     'idDetailTemp'=>$id //Siempre debe existir solo un producto para Nota de credito
            );
    }
    
    public function getListNotaCreditoDetalles($status = null, $tokenForm)
    {
        $facturaDetalles = $this->getFacturaDetalles($tokenForm);
        $detalles = $this->listFacturaDetalles($facturaDetalles, $status);
        
        $json = array(
            'response' => true,
            'facturaDetalles' => $detalles['facturaDetalles'],
            'totalItems'=>number_format($detalles['totalItems'], 2),
            'totalSubtotal'=>number_format($detalles['totalSubtotal'], 2, '.', ''),
            'totalDescuento'=>number_format($detalles['totalDescuento'], 2, '.', ''),
            'grandSubtotal'=>number_format($detalles['totalSubtotal'] - $detalles['totalDescuento'], 2, '.', ''),
            'total'=>number_format($detalles['total'], 2, '.', ''),
            'stringImpuestos'=>$detalles['stringImpuestos'],
            'totalImpuestoRetenido'=>number_format($detalles['totalImpuestoRetenido'], 2, '.', ''),
            'totalImpuestoTrasladado'=>number_format($detalles['totalImpuestoTrasladado'], 2, '.', ''),
            //'idDetailTemp'=>$detalles['idDetailTemp'] //Siempre debe existir solo un producto para Nota de credito
        );

        return $json;
    }

    public function deleteDetalles(array $options)
    {
        $id = $options['id'];
        $repository = new NotaCreditoDetailsTempRepository();
        $token = $repository->getById($id);
        
        if ($repository->delete($id)) {
            $response = true;
            $msj = 'Producto eliminado correctamente.';
        } else {
            $response = null;
            $msj = "No se pudo eliminar producto. Intente nuevamente.";
        }
        
        $facturaDetalles = $this->getFacturaDetalles($token['token_form']);
        $detalles = $this->listFacturaDetalles($facturaDetalles);
        
        $json = array(
            'response' => true,
            'facturaDetalles' => $detalles['facturaDetalles'],
            'totalItems'=>number_format($detalles['totalItems'], 2),
            'totalSubtotal'=>number_format($detalles['totalSubtotal'], 2, '.', ''),
            'totalDescuento'=>number_format($detalles['totalDescuento'], 2, '.', ''),
            'grandSubtotal'=>number_format($detalles['totalSubtotal'] - $detalles['totalDescuento'], 2, '.', ''),
            'total'=>number_format($detalles['total'], 2, '.', ''),
            'stringImpuestos'=>$detalles['stringImpuestos'],
            'totalImpuestoRetenido'=>number_format($detalles['totalImpuestoRetenido'], 2, '.', ''),
            'totalImpuestoTrasladado'=>number_format($detalles['totalImpuestoTrasladado'], 2, '.', '')
            );
        return $json;
    }
    
    public function getProductoInfo($options)
    {
        $repo = new ProductoRepository();
        $data = $repo->getById($options['id_producto']);
        return array(
            'response'=>true,
            'precioUnitario'=>$data['precio_unitario'],
            'descuento'=>$data['descuento'],
            'ivaDesglozado'=>$data['impuestos_incluidos']
        );
    }
    
    public function setListaUuidByCliente($options)
    {
        $factura = new FacturaRepository();
        
        $result = $factura->getListUUIDByCliente($options['cliente']) ;
        $list = "";
        foreach ($result as $key => $value) {
            $list .= "<option value='".($key)."'>".($value)."</option>";
        }
       
        return array(
            'response'=>true,
            'uuids'=>$list
        );
    }
    
    public function timbrarNotaCredito($options)
    {
        $factura = new FacturarRepository($options['id_nota_credito'], 'NotaCredito');
        $factura->_timbrar();
        return array('response'=>true);
    }
    
    public function cancelarNotaCredito($options)
    {
        $factura = new FacturarRepository($options['id_factura'], 'NotaCredito');
        $factura->_cancelar();

        return array('response' => true);
    }
    
    public function getDataNotaCredito($options)
    {
        $idInvoice = $options['id_nota_credito'];
        
        $invoice = new NotaCreditoRepository();
        $invoice->setOptions($invoice->getById($idInvoice));
        
        $customer = new ClienteRepository();
        $customerData = $customer->getById($invoice->getIdCliente());
        
        //pudin
        $settings = new EmpresaRepository();
        $email_message = $settings->getById('1');
        ////////////////
        return array(
            'response'=>true,
            'email'=>$customerData['email'],
            'email2' =>$customerData['email2'],
            'subject'=>'Nota de credito '.$invoice->getNumFactura(),
            //'messageMail'=>'Revisar Nota de credito adjunta.'
            'messageMail'=>$email_message['email_message_factura'] //pudin
        );
    }
    
    public function sendNotaCreditoToMail($options)
    {
        $data = array();
        foreach ($options['options'] as $row) {
            $data[$row['name']] = $row['value'];
        }
        
        $invoice = new NotaCreditoRepository();
        $invoice->setOptions($invoice->getById($data['id_invoice']));
        $invoice->setId($data['id_invoice']);
        $invoice->crearPDF();
        //pudin
        $settings = new EmpresaRepository();
        $email_message = $settings->getById('1');
        ////////////////////////
        $sucursal = new SucursalRepository();
        $sucursal->setOptions($sucursal->getById($invoice->getSucursal()));
       
        try {
            $emailer = new Emailer();
            $emailer->sendEmail(array(
                'to'=>$data['to'],
                'cc'=>$data['cc'],
                'subject'=>$data['subject'],
                'from_title'=>$sucursal->getNombre(),
                'message'=>$data['message'].$email_message['email_publicidad'],
                'attachment'=>$invoice->archivoZipPath
            ));

            //Pudin
            $factura_enviado = new NotaCreditoRepository();
            $factura_enviado->updateEnviadoNC($data['id_invoice']);
            $this->flashmessenger->addMessage(array('success'=>'Genial!! Su Documento se envio correctamente.'));
            return array(
                'response'=>true,
                'msg'=>$this->flashmessenger->getMessageString()
            );
        } catch (Exception $ex) {
            $this->flashmessenger->addMsg(array('danger'=>'Oops =(. Algo salio mal al tratar de enviar el Documento. Intenta nuevamente'));
            return array(
                'response'=>null,
                'msg'=>$this->flashmessenger->getMessageString()
            );
        }
    }

    public function pagarDesdeNotaDeCredito($options) {
        
    }
}
