<?php
/**
 * Description of Ajax
 *
 * @author carlos
 */

class PagoAjax extends PagoRepository
{
    #estaba extends a entity
    public function getResponse($request, $options)
    {
        return $this->$request($options);
    }

    public function _getTranslation($text)
    {
        $translator = new Translator();
        return $translator->_getTranslation($text);
    }

    public function getListFacturasByCliente($options)
    {
        //  var_dump($options); exit;
        if ($options['cliente'] === null) {
            return null;
        }
        if (isset($options['cliente']) && trim($options['cliente'])=='') {
            return array('response'=>true,'listFacturas'=>"");
        }

        $entity = new FacturaRepository();

        #facturas con saldo pendiente
        $result = $entity->getListFacturaByCliente(array('cliente'=>$options['cliente']));
        //  var_dump($result); exit;
        if ($result) {
            $string = '';

            #imprimie las facturas pendientes y las facturas liquidadas (las liquidadas se ocultan)
            foreach ($result as $row) {
                $id = $row['id'];
                $flagToPrint = 'factura';
                if ($row['tipo_documento']=='CG') {
                    $flagToPrint = 'cuenta_de_gastos';
                }

                #Esto aplica para cuando se edita un pago, y se elimina una factura de Facturas a pagar.
                #$row[saldo_pendiente] trae el saldoPendiente y se suma los pagosParciales
                #Estos tr permanece oculto en FacturasPendientes Hasta que se elimina esta factura de Facturas a pagar.
                if (isset($_SESSION['pagosOriginales']) && key_exists($row['id'], $_SESSION['pagosOriginales'])) {
                    $row['saldo_pendiente'] += $_SESSION['pagosOriginales'][$row['id']]['montoPago'];
                }
                $entity->setOptions(array('serie'=>$row['serie'],'folio'=>$row['folio']));
                $string .= "<tr id='addInvoice_{$id}'>";
                $string .= "<td class='text-center'><a  href=\"#\" onclick=\"javascript: void window.open('Factura.php?action=import&flag={$flagToPrint}&id={$id}','','width=700,height=500,status=1,scrollbars=1,resizable=1')\">{$entity->getNumFactura()}</a></td>";
                $string .= "<td class='text-center'>{$row['clienteName']}</td>";
                $string .= "<td class='text-center'>{$row['fecha']}</td>";
                $string .= "<td class='text-right'>".number_format($row['total'], 2)."</td>";
                $string .= "<td class='text-right'>".number_format($row['saldo_pendiente'], 2)."</td>";
                $string .= "<td class='text-center'>"
                        . "<label' onclick=\"addInvoiceToPayment('{$id}')\" class='btn btn-sm btn-success' style='width:50px;padding:2px 4px'>"
                        . "<span class='fa fa-check fa-lg'></span>"
                        . "</label>"
                        . "</td>";
                $string .= "</tr>";
            }
        } else {
            $string = "<tr id='default' ><td style='text-align:center' colspan='8'>".$this->_getTranslation('No hay facturas pendientes para Cliente seleccionado.')."</tr></td>";
        }

        #imprime las facturas que se pagaron
        if (isset($_SESSION['facturasLiquidadas']) && count($_SESSION['facturasLiquidadas'])>0) {
            foreach ($_SESSION['facturasLiquidadas'] as $row) {
                $id = $row['idFactura'];
                $string .= "<tr id='addInvoice_{$id}'>";
                $string .= "<td  class='text-center'>{$row['serie']}{$row['folio']}</td>";
                $string .= "<td  class='text-center'>{$row['clienteName']}</td>";
                $string .= "<td  class='text-center'>{$row['fecha']}</td>";
                $string .= "<td  class='text-right'>".number_format($row['montoFactura'], 2)."</td>";
                $string .= "<td  class='text-right'>".number_format($row['saldoPendiente'], 2)."</td>";
                $string .= "<td class='text-center'>"
                            . "<label onclick=\"addInvoiceToPayment('{$id}')\" class='btn btn-sm btn-success' style='width:50px;padding:2px 4px'>"
                            . "<span class='fa fa-check fa-lg'></span>"
                            . "</label>"
                            . "</td>"
                            . "</tr>";
            }
        }

        return array(
                'response'=>true,
                'listFacturas'=>$string);
    }

    public function addInvoiceToPayment($options)
    {
        $idFactura = $options['idFactura'];
        $montoTotalPago = $options['montoTotalPago'];
        $sumPagos = $options['sumPagos'];

        $entity = new FacturaRepository();
        $facturaData = $entity->getById($idFactura);

        if ($facturaData) {
            $form = new PagoForm();
            $form->addItem($idFactura);

            //$_SESSION['pagosOriginales'] creada en Controller Pago
            if (isset($_SESSION['pagosOriginales']) && key_exists($idFactura, $_SESSION['pagosOriginales'])) {
                $facturaData['saldo_pendiente'] += $_SESSION['pagosOriginales'][$idFactura]['montoPago'];
            }

            if ($montoTotalPago > $sumPagos) {
                $disponible = $montoTotalPago - $sumPagos;
                if ($disponible >= $facturaData['saldo_pendiente']) {
                    $form->setValueToElement(number_format(round($facturaData['saldo_pendiente'], 2), 2, '.', ''), "pago[$idFactura]");
                }
                if ($disponible < $facturaData['saldo_pendiente']) {
                    $form->setValueToElement(number_format(round($disponible, 2), 2, '.', ''), "pago[$idFactura]");
                }
            }

            $element = $form->getElementString("pago[$idFactura]");
            $string = null;

            $string .= "<tr id='deleteInvoice_{$idFactura}'>";
            $string .= "<td>"
                    ."<a class='btn btn-sm btn-danger' onclick=\"deleteInvoiceFromPayment('{$idFactura}')\" ><i class='fa fa-trash'></i></a>"
                    . ""
                    . "</td>";
            $string .= "<td>{$facturaData['serie']}{$facturaData['folio']}</td>";
            $string .= "<td>{$facturaData['clienteName']}</td>";
            $string .= "<td>{$facturaData['fecha']}</td>";
            $string .= "<td style='text-align:right'>".number_format($facturaData['total'], 2)."</td>";
            $string .= "<td style='text-align:right'>".number_format($facturaData['saldo_pendiente'], 2)."</td>";
            $string .= "<td class='col-md-2' style='text-align:right'>$element</td>";
            $string .= "</tr>";
        }

        return array(
            'response'=>true,
            'factura'=>$string
        );
    }

    public function timbrarPago($options)
    {
        $pago = new PagoTimbrarRepository($options['id_pago']);
        $pago->_timbrar();

        return array('response'=>true);
    }

    public function cancelarPago($options)
    {
        $pago = new PagoTimbrarRepository($options['id_pago']);
        $pago->_cancelar();

        return array('response'=>true);
    }

    public function getDataInvoice($options)
    {
        $idInvoice = $options['idInvoice'];
        $invoice = new PagoRepository();
        $invoice->setOptions($invoice->getById($idInvoice));

        //Pudin
        $customer = new ClienteRepository();
        $customerData = $customer->getById($invoice->getIdCliente());

        $settings = new EmpresaRepository();
        $email_message = $settings->getById('1');
        ////////////////

        return array(
            'response' => true,
            'email' =>  $invoice->getClienteEmail(),
            'email2' =>  $invoice->getClienteEmail2(), //pudin
            'subject' => 'Pago ' . $invoice->getNumPago(),
            //'messageMail' => 'Revisar Pago adjunto.'
            'messageMail'=>$email_message['email_message_pago']
        );
    }

    public function sendInvoiceToMail($options)
    {
        $data = array();

        foreach ($options['options'] as $row) {
            $data[$row['name']] = $row['value'];
        }
        $invoice = new PagoRepository();
        $invoice->setOptions($invoice->getById($data['id_invoice']));
        $invoice->setId($data['id_invoice']);
        $invoice->crearPDF();
        $zipFile = $invoice->crearZip();
        $sucursal = new SucursalRepository();
        $sucursal->setOptions($sucursal->getById(1));
        //pudin
        $settings = new EmpresaRepository();
        $email_message = $settings->getById('1');
        ////////////////////////
        try {
            $emailer = new Emailer();

            $emailer->sendEmail(array(
                'to' => $data['to'],
                'cc' => $data['cc'],
                'subject' => $data['subject'],
                'from_title' => $sucursal->getNombre(),
                'message' => $data['message'].$email_message['email_publicidad'],
                'attachment' => $zipFile
            ));

            $this->flashmessenger->addMessage(array('success' => 'Genial!! El Pago se envio correctamente.'));
            //pudin
            $pago_enviado = new PagoRepository();
            $pago_enviado->updateEnviadoPago($data['id_invoice']);
            ///////////////////////
            return array(
                'response' => true,
                'msg' => $this->flashmessenger->getMessageString()
            );
        } catch (Exception $ex) {
            $this->flashmessenger->addMsg(array('danger' => 'Oops =(. Algo salio mal al tratar de enviar el Pago. Intenta nuevamente'));

            return array(
                'response' => null,
                'msg' => $this->flashmessenger->getMessageString()
            );
        }
    }

    public function getDataBancoOrdenantes($options)
    {
        $IdC = $options['id_cliente'];
        $Cliente = new ClienteRepository();
        $result = $Cliente->getListCuentasBancariasByIdCliente($IdC);

        $list = "<option value='0'>Seleccionar una opcion...</option>";
        if ($result) {
            foreach ($result as $key => $value) {
                $list .= "<option value='" . ($key) . "'>" . ($value) . "</option>";
            }
        }

        return array(
            'response' => true,
            'bancos' => $list,
        );
    }

    public function formaDePagoRequiereBanco($options)
    {
        $pagoEntity = new PagoRepository();
        $result = $pagoEntity->formaDePagoRequiereBanco($options['forma_de_pago']);

        if ($result) {
            return array('response'=>true);
        }

        return array('response'=>false);
    }

    public function deleteAttachment($options) {
        try {
            $filename = $options['filename'];
            if(file_exists(ROOT.$filename)) {
                if(unlink(ROOT.$filename)) {
                    $this->flashmessenger->addMessage([
                        'success' => 'El archivo ha sido eliminado correctamente.'
                    ]);
                    return [
                        'response' => true,
                        'message' => $this->flashmessenger->getMessageString(),
                    ];
                }
            } else {
                throw new Exception('No existe el archivo, favor de refrescar la pagina, para ver los cambios.');
            }
        } catch (Exception $ex) {
            $this->flashmessenger->addMessage([
                'danger' => $ex->getMessage(),
            ]);
            return [
                'response' => false,
                'message' => $this->flashmessenger->getMessageString(),
            ];
        }
    }

    public function getFacturaDetails($options) {
        $idFactura = $options['idFactura'];

        $factura = new FacturaRepository();
        $data = $factura->getById($idFactura);

        return [
            'response' => true,
            'data' => $data,
        ];

    }

    public function getNotaDetails($options) {
        $idNota = $options['idNotaDeCredito'];

        $nota = new NotaCreditoRepository();
        $data = $nota->getById($idNota);

        return [
            'response' => true,
            'data' => $data,
        ];

    }
    public function getListCuentaBancariasAsArray($options)
    {
        $cuentaRepo = new ClienteRepository();
        $data = $cuentaRepo->getCuentasBancariasByIdCliente($options['id_cliente']);

        if (!empty($data)) {
            return [
                'response'=>true,
                'data'=>$data
            ];
        } else {
            return [
                'response' => false,
            ];
        }
    }
}
