<?php
class ProductoAjax extends ProductoRepository
{
    public $flashmessenger = null;

    public function __construct()
    {
        if (!$this->flashmessenger instanceof FlashMessenger) {
            $this->flashmessenger = new FlashMessenger();
        }
    }

    public function getResponse($request, $options)
    {
        return $this->$request($options);
    }

    public function _getTranslation($text)
    {
        $translator = new Translator();
        return $translator->_getTranslation($text);
    }

    public function getTranslation($options)
    {
        $msj = $options['msj'];

        return array(
            'response'=>true,
            'translation'=>$this->_getTranslation($msj)
                );
    }

    public function getDataToEdit($options)
    {
        $colegioRepo = new ProductoRepository();
        $data = $colegioRepo->getById($options['id']);
        $data['action'] = 'edit';

        return array(
            'response'=>true,
            'userData'=>$data
        );
    }

    public function deleteProducto($options)
    {
        $colegioRepo = new ProductoRepository();
        if (!$colegioRepo->isUsedInRecord($options['id'])) {
            if ($colegioRepo->delete($options['id'])) {
                $this->flashmessenger->addMessage(array('success'=>'El producto fue elimino satisfactoriamente.'));
            }
        } else {
            $message = 'Este producto no puede ser eliminada, esta siendo utilizado en almenos un registro.';
            $this->flashmessenger->addMessage(array('info'=>$message));
        }

        return array(
            'response'=>true
        );
    }

    public function getProductListBySearchTerm($options) {
        $repo = new ProductoRepository();

        if(empty($options['search']) || strlen($options['search']) < 3)
            return [];

        $products = $repo->getProductosLike($options['search']);

        return $products;
    }

    public function getListProduct($options)
    {
        $db_admin = new ProductoRepository();
        $item = $options['item'];
        $items = $db_admin->getListaProductosSAT($item);

        $array = array();
        if ($items) {
            foreach ($items as $item) {
                $array[] = array(
                    'value'=>$item['clave'],
                    'label'=> utf8_decode($item['descripcion']),
                );
            }
        }
        //var_dump($array);exit;
        return array(
            'response'=>true,
            'products'=>$array
        );
    }

    public function getDefaultDataProduct($options)
    {
        $repo = new ProductoRepository();
        $data = $repo->getById($options['product']);
        return array(
            'response'=>true,
            'value'=>$data['value'],
            'label'=>$data['label'],
        );
    }
}
