<?php
/**
 * Description of Ajax
 *
 * @author carlos
 */
class ReporteAjax extends EntityRepository
{
    public $flashmessenger = null;
    
    public function __construct()
    {
        if (!$this->flashmessenger instanceof FlashMessenger) {
            $this->flashmessenger = new FlashMessenger();
        }
    }
    
    public function getResponse($request, $options)
    {
        return $this->$request($options);
    }
    
    public function _getTranslation($text)
    {
        $translator = new Translator();
        return $translator->_getTranslation($text);
    }
    
    public function getTranslation($options)
    {
        $msj = $options['msj'];
        
        return array(
            'response'=>true,
            'translation'=>$this->_getTranslation($msj)
                );
    }
    
    public function getFiltersReport($options)
    {
        $form = new ReporteForm();
        
        return array(
            'response'=>true,
            'filters'=>$form->getStringFiltersForm($options['report'])
        );
    }
}
