<?php
class UsuarioAjax extends UsuarioRepository
{
    public $flashmessenger = null;

    public function __construct()
    {
        if (!$this->flashmessenger instanceof FlashMessenger) {
            $this->flashmessenger = new FlashMessenger();
        }
    }

    public function getResponse($request, $options)
    {
        return $this->$request($options);
    }

    public function _getTranslation($text)
    {
        $translator = new Translator();
        return $translator->_getTranslation($text);
    }

    public function getTranslation($options)
    {
        $msj = $options['msj'];

        return array(
            'response'=>true,
            'translation'=>$this->_getTranslation($msj)
                );
    }

    public function getDataToEdit($options)
    {
        $colegioRepo = new UsuarioRepository();
        $data = $colegioRepo->getById($options['id']);
        $data['action'] = 'edit';

        unset($data['contrasena']);

        return array(
            'response'=>true,
            'userData'=>$data
        );
    }

    public function deleteUsuario($options)
    {
        $colegioRepo = new UsuarioRepository();
        if (!$colegioRepo->isUsedInRecord($options['id'])) {
            if ($colegioRepo->delete($options['id'])) {
                $this->flashmessenger->addMessage(array('success'=>'El usuario fue eliminado satisfactoriamente.'));
            }
        } else {
            $message = 'Este usuario no puede ser eliminado, esta siendo utilizado en almenos un registro.';
            $this->flashmessenger->addMessage(array('info'=>$message));
        }

        return array(
            'response'=>true
        );
    }
}
