<?php
$controller = 'Cliente';
$action = '';
if (isset($_POST['action'])) {
    $action = $_POST['action'];
    if (isset($_POST['id'])) {
        $id = $_POST['id'];
    }
} elseif (isset($_GET['action'])) {
    $action = $_GET['action'];
    if (isset($_GET['id'])) {
        $id = $_GET['id'];
    }
}
include $_SERVER["DOCUMENT_ROOT"].'/app/include/bootstrap.php';

$_form_cliente = new ClienteForm();
$_cliente = new ClienteRepository();
$_listClientes = $_cliente->getListClientes();

switch ($action) {
    case 'insert':
        $_form_cliente->populate($_POST);
        if ($_form_cliente->isValid()) {
            $_cliente->setOptions($_POST);
            $result = $_cliente->save($_cliente->getOptions());
            if ($result) {
                $flashmessenger->addMessage(array('success'=>'Genial !! El Cliente se registro exitosamente.'));
                header('Location: Cliente.php');
            } else {
                $flashmessenger->addMessage(array('danger'=>'Error. Intenta nuevamente o contacta a tu proveedor de sistemas.'));
            }
        } else {
            $_noValid = true;
            $flashmessenger->addMessage(array('danger'=>'Faltan campos o datos incorrectos.'));
            $vista = 'Cliente.php';
            include $root.'/View/Template.php';
        }
        break;

    case 'edit':
        if ($_GET) {
            $_clienteData = $_cliente->getById($id);
        }
        if ($_POST) {
            $_clienteData = $_POST;
        }

        $_form_cliente->setActionController('edit');
        $_form_cliente->setId($id);
        $_form_cliente->populate($_clienteData);

        if (isset($_POST['id'])) {
            if ($_form_cliente->isValid()) {
                $_cliente->setOptions($_clienteData);
                $result = $_cliente->update($id, $_cliente->getOptions()); //no tengo id porque viene de post
                if ($result) {
                    $flashmessenger->addMessage(array('success'=>'Estupendo !! El Cliente se actualizo exitosamente.'));
                    header("Location: Cliente.php");
                } else {
                    $flashmessenger->addMessage(array('danger'=>'Error. Intenta nuevamente o contacta a tu proveedor de sistemas.'));
                }
            } else {
                $_noValid = true;
                $vista = 'Cliente.php';
                include $root . '/View/Template.php';
            }
        } else {
            $vista = 'Cliente.php';
            include $root . '/View/Template.php';
        }
        break;

    case 'delete':
        if (!$_cliente->isUsedInRecord($id)) {
            if ($_cliente->delete($id)) {
                $flashmessenger->addMessage(array('success'=>'Hecho !! El Cliente fue eliminado satisfactoriamente.'));
            }
        } else {
            $message = 'Hola !! este Cliente no puede ser eliminado, esta siendo utilizado en almenos un registro.';
            $flashmessenger->addMessage(array('info'=>$message));
        }
        header('Location: Cliente.php');
        break;

    case 'ajax':
        $ajaxCliente = new ClienteAjax();
        $data = [];
        if(isset($_POST['request']))
            $data = $_POST;
        elseif(isset($_GET['request']))
            $data = $_GET;
        $json = $ajaxCliente->getResponse($data['request'], $data);
        echo json_encode($json);
        break;

    default:
        $vista = 'Cliente.php';
        include $root.'/View/Template.php';
}
