<?php
$controller = 'CuentaBancaria';
$action = '';
if (isset($_POST['action'])) {
    $action = $_POST['action'];
    if (isset($_POST['id'])) {
        $id = $_POST['id'];
    }
} elseif (isset($_GET['action'])) {
    $action = $_GET['action'];
    if (isset($_GET['id'])) {
        $id = $_GET['id'];
    }
}
include $_SERVER["DOCUMENT_ROOT"].'/app/include/bootstrap.php';

$form_Cliente = new CuentaBancariaForm();
$_cuentaBancaria = new CuentaBancariaRepository();
$_listCuentaBancarias = $_cuentaBancaria->getListCuentasBancarias();

switch ($action) {
    case 'insert':
        $form_Cliente->populate($_POST);
        if ($form_Cliente->isValid()) {
            $_cuentaBancaria->setOptions($_POST);
            $result = $_cuentaBancaria->save($_cuentaBancaria->getOptions());
            if ($result) {
                $flashmessenger->addMessage(array('success'=>'Cuenta Bancaria registrada exitosamente.'));
                header('Location: CuentaBancaria.php');
            } else {
                $flashmessenger->addMessage(array('danger'=>'Error. Intenta nuevamente o contacta a tu proveedor de sistemas.'));
            }
        } else {
            $_noValid = true;
            $vista = 'CuentaBancaria.php';
            include $root.'/View/Template.php';
        }
        break;
   
    case 'edit':
        if ($_GET) {
            $_cuentaBancariaData = $_cuentaBancaria->getById($id);
        }
        if ($_POST) {
            $_cuentaBancariaData = $_POST;
        }
        
        $form_Cliente->setActionController('edit');
        $form_Cliente->setId($id);
        $form_Cliente->populate($_cuentaBancariaData);
        
        if (isset($_POST['id'])) {
            if ($form_Cliente->isValid()) {
                $_cuentaBancaria->setOptions($_cuentaBancariaData);
                $result = $_cuentaBancaria->update($id, $_cuentaBancaria->getOptions()); //no tengo id porque viene de post
                if ($result) {
                    $flashmessenger->addMessage(array('success'=>'Cuenta bancaria actualizado exitosamente.'));
                    header("Location: CuentaBancaria.php");
                } else {
                    $flashmessenger->addMessage(array('danger'=>'Error. Intenta nuevamente o contacta a tu proveedor de sistemas.'));
                }
            } else {
                $_noValid = true;
                $vista = 'CuentaBancaria.php';
                include $root . '/View/Template.php';
            }
        } else {
            $vista = 'CuentaBancaria.php';
            include $root . '/View/Template.php';
        }
        break;
    
    case 'delete':
        if (!$_cuentaBancaria->isUsedInRecord($id)) {
            if ($_cuentaBancaria->delete($id)) {
                $flashmessenger->addMessage(array('success'=>'Cuenta Bancaria eliminada satisfactoriamente.'));
            }
        } else {
            $message = 'Esta Cuenta Bancaria no puede ser eliminada, esta siendo utilizado en almenos un registro.';
            $flashmessenger->addMessage(array('info'=>$message));
        }
       header("Location: CuentaBancaria.php");
        break;
        
    case 'ajax':
        $ajaxLocation = new CuentaBancariaAjax();
        $json = $ajaxLocation->getResponse($_POST['request'], $_POST);
        echo json_encode($json);
    break;
    
    default:

        $vista = 'CuentaBancaria.php';
        include $root.'/View/Template.php';
}
