<?php
$controller = 'Empresa';
$action = '';
if (isset($_POST['action'])) {
    $action = $_POST['action'];
    if (isset($_POST['id'])) {
        $id = $_POST['id'];
    }
} elseif (isset($_GET['action'])) {
    $action = $_GET['action'];
    if (isset($_GET['id'])) {
        $id = $_GET['id'];
    }
}
include $_SERVER["DOCUMENT_ROOT"].'/app/include/bootstrap.php';

#Es para asegurar que solo se puede editar empresa con id = 1;
$action = 'edit';
$id = '1';

$form = new EmpresaForm();
$_empresa = new EmpresaRepository();
$_empresa->setOptions($_empresa->getById($id));
$_listEmpresas = $_empresa->getListEmpresas();

switch ($action) {
    case 'insert':
        $form->populate($_POST);
        if ($form->isValid()) {
            $_empresa->setOptions($_POST);
            $_empresa->setImage($_FILES['logo']);
            $result = $_empresa->save($_empresa->getOptions());
            if ($result) {
                $flashmessenger->addMessage(array('success'=>'Genial !! El Empresa se registro exitosamente.'));
                header('Location: Empresa.php');
            } else {
                $flashmessenger->addMessage(array('danger'=>'Error. Intenta nuevamente o contacta a tu proveedor de sistemas.'));
            }
        } else {
            $vista = 'Empresa.php';
            include $root.'/View/Template.php';
        }
        break;
   
    case 'edit':
        $_empresaData = $_empresa->getById($id);
        if ($_GET) {
            $_empresaData = $_empresa->getById($id);
        }
        if ($_POST) {
            $_empresaData = $_POST;
        }
        $settingsRepo = new SettingsRepository();
        $_empresaData['plantilla_factura_pdf'] = $settingsRepo->_get('plantilla_factura_pdf');
        
        $form->setActionController('edit');
        $form->setId($id);
        $form->populate($_empresaData);
        
        if (isset($_POST['id'])) {
            if ($form->isValid()) {
                $_empresaData['archivos'] = $_FILES;
                $_empresa->setOptions($_empresaData);
                $_empresa->setImage($_FILES['logo']);
                $result = $_empresa->update($id, $_empresa->getOptions()); //no tengo id porque viene de post
                if ($result) {

                    $settingsRepo = new SettingsRepository();
                    $settingsRepo->updateKey('plantilla_factura_pdf', $_empresaData['template_selection'], null, 'settings');

                    $flashmessenger->addMessage(array('success'=>'Estupendo !! El Empresa se actualizo exitosamente.'));
                    header("Location: Empresa.php?action=edit&id=$id");
                } else {
                    $flashmessenger->addMessage(array('danger'=>'Error. Intenta nuevamente o contacta a tu proveedor de sistemas.'));
                }
            } else {
                $vista = 'Empresa.php';
                include $root . '/View/Template.php';
            }
        } else {
            $vista = 'Empresa.php';
            include $root . '/View/Template.php';
        }
        break;
    
    case 'delete':
        if (!$_empresa->isUsedInRecord($id)) {
            if ($_empresa->delete($id)) {
                $flashmessenger->addMessage(array('success'=>'Hecho !! El Empresa fue eliminada satisfactoriamente.'));
            }
        } else {
            $message = 'Hola !! este Empresa no puede ser eliminado, esta siendo utilizado en almenos un registro.';
            $flashmessenger->addMessage(array('info'=>$message));
        }
        header('Location: Empresa.php');
        break;
        
     case 'ajax':
        $ajaxEmpresa = new EmpresaAjax();
        $json = $ajaxEmpresa->getResponse($_POST['request'], $_POST);
        
        echo json_encode($json);
        break;
    
    default:
        $vista = 'Empresa.php';
        include $root.'/View/Template.php';
}
