<?php

use Spipu\Html2Pdf\Html2Pdf;

$controller = 'Factura';
$action = '';
if (isset($_POST['action'])) {
    $action = $_POST['action'];
    if (isset($_POST['id'])) {
        $id = $_POST['id'];
    }
} elseif (isset($_GET['action'])) {
    $action = $_GET['action'];
    if (isset($_GET['id'])) {
        $id = $_GET['id'];
    }
}

include $_SERVER["DOCUMENT_ROOT"] . '/app/include/bootstrap.php';

$form = new FacturaForm();
$factura = new FacturaRepository();

$settings = new SettingsRepository();
$_cuentaDeGastosActiva = $settings->_get('habilitar_cuenta_de_gastos');

switch ($action) {
    case 'insert':
        $form->setTokenForm($_POST['token_form']);
        $_POST['adjunto'] = $_FILES;
        if (isset($_POST['uuid_relacionados'])) {
            $_POST['uuid_relacionados'] = $form->prepareUuidFromPOST($_POST['uuid_relacionados']);
        }
        if (isset($_POST['uuid_relacionados_otros'])) {
            $_POST['uuid_relacionados_otros'] = $form->prepareUuidFromPOST($_POST['uuid_relacionados_otros']);
        }

        $clientId = isset($_POST['id_cliente']) ? $_POST['id_cliente']:null;
        $clienteRepo = new ClienteRepository();
        $clientes = $clienteRepo->getListSelectClientes($clientId);

        $form->setPropiedad('id_cliente', [
            'multiOptions' => $clientes,
        ]);

        $form->populate($_POST);
        if ($form->isValid()) {
            $factura->setOptions($_POST);
            if ($factura->save($factura->getOptions())) {
                $facturaNo = $factura->getLastInsertId();
                $flashmessenger->addMessage(array(
                    "success" => $_translator->_getTranslation("Factura") . " #$facturaNo " . $_translator->_getTranslation("registrada exitosamente.")
                ));

                header("Location: Factura.php?action=edit&id=$facturaNo");
            } else {
                $vista = 'Factura.php';
                include $root . '/View/Template.php';
            }
        } else {
            $vista = 'Factura.php';
            include $root . '/View/Template.php';
        }
        break;

    case 'list':
        $searchFilter = null;
        if (isset($_POST['search'])) {
            $searchFilter = $_POST;
        }
        $_listFactura = $factura->getListFacturas($searchFilter);

        $vista = 'FacturaList.php';
        include $root . '/View/Template.php';
        break;

    case 'import':
        switch ($_GET['flag']) {
            case 'factura':
                $template = $settings->_get('plantilla_factura_pdf');
                $template = (!empty($template)) ? $template : 'FacturaPDF';

                // ob_start();
                // require_once ROOT . "/View/plantillas_facturas/{$template}.php";
                // $htmlStr = ob_get_clean();

                // $html = new \Spipu\Html2Pdf\Html2Pdf('P', 'LETTER', 'en');
                // $html->writeHTML($htmlStr);
                // $html->output();
                // echo $htmlStr; exit;
                $pdf = new $template($_GET['id']);
                break;

            case 'cuenta_de_gastos':
                $pdf = new CuentaDeGastosPDF($_GET['id']);
                break;
        }
        break;

    case 'descargar':
        try {
            $factura = new FacturaRepository();
            $factura->setOptions($factura->getById($_GET['idFactura']));
            $factura->setId($_GET['idFactura']);
            $factura->crearPDF();
            $factura->descargarZip();
        } catch (Exception $e) {
            $flashmessenger->addMessage([
                'danger' => $e->getMessage()
            ]);
        }

        header('Location: Factura.php?action=list');
        break;
    case 'copy':
        $id = $_GET['reference_id'];
        $facturaData = $factura->getById($id);
        $facturaData['uuid_relacionados'] = $form->prepareUuidFromGET($facturaData['uuid_relacionados']);
        $facturaData['uuid_relacionados_otros'] = $form->prepareUuidFromGET($facturaData['uuid_relacionados_otros']);
        $factura->crearTablaDetallesForUser();
        $factura->setFacturaDetallesById($id, $form->getTokenForm());
        $factura->setCuentaDeGastosDetallesById($id);

        $form->setActionController('insert');
        $form->setId($id);
        $form->populate($facturaData);

        $vista = 'Factura.php';
        include $root . '/View/Template.php';
        break;
    case 'edit':
        if ($_GET) {
            $facturaData = $factura->getById($id);
            $facturaData['uuid_relacionados'] = $form->prepareUuidFromGET($facturaData['uuid_relacionados']);
            $facturaData['uuid_relacionados_otros'] = $form->prepareUuidFromGET($facturaData['uuid_relacionados_otros']);
            $factura->crearTablaDetallesForUser();
            $factura->setFacturaDetallesById($id, $form->getTokenForm());
            $factura->setCuentaDeGastosDetallesById($id);
        }
        if ($_POST) {
            $facturaData = $_POST;
            if (isset($_POST['uuid_relacionados'])) {
                $_POST['uuid_relacionados'] = $form->prepareUuidFromPOST($_POST['uuid_relacionados']);
            }
            if (isset($_POST['uuid_relacionados_otros'])) {
                $_POST['uuid_relacionados_otros'] = $form->prepareUuidFromPOST($_POST['uuid_relacionados_otros']);
            }
            $form->setTokenForm($_POST['token_form']);
        }


        $idCliente = isset($_POST['id_cliente']) ? $_POST['id_cliente']:$facturaData['id_cliente'];
        $clientRepo = new ClienteRepository();
        $clientList = $clientRepo->getListSelectClientes($idCliente);

        $form->setActionController('edit');
        $form->setId($id);
        $form->setPropiedad('id_cliente', [
            'multiOptions' => $clientList,
        ]);
        $form->populate($facturaData);

        $_esCuentaDeGastos = null;
        if ($facturaData['tipo_documento'] == 'CG') {
            $_esCuentaDeGastos = true;
        }

        $_disabled = null;
        if ((isset($facturaData['status']) && $facturaData['status'] != '1') || $_esCuentaDeGastos == true) {
            $form->deleteElement('terminar');
            $form->deleteElement('buscar');
            $form->deleteElement('buscar_cg');
            $form->addElement(array('type' => 'hidden', 'name' => 'terminar'));
            $form->addElement(array('type' => 'hidden', 'name' => 'buscar'));
            $form->addElement(array('type' => 'hidden', 'name' => 'buscar_cg'));
            $form->disabledAllElements();
            $form->enabledElement(['adjunto[]']);
            $_disabled = true;
        }

        if (isset($_POST['id'])) {
            if ($form->isValid()) {
                $facturaData['adjunto'] = $_FILES;
                $factura->setOptions($facturaData);
                $result = $factura->update($id, $factura->getOptions()); //no tengo id porque viene de post
                if ($result) {
                    $flashmessenger->addMessage(array('success' => 'Factura actualizada exitosamente.'));
                    header("Location: Factura.php?action=edit&id=$id");
                } else {
                    $vista = 'Factura.php';
                    include $root . '/View/Template.php';
                }
            } else {
                $vista = 'Factura.php';
                include $root . '/View/Template.php';
            }
        } else {
            $factura->setOptions($facturaData);
            $vista = 'Factura.php';
            include $root . '/View/Template.php';
        }
        break;

    case 'delete':
        try {
            if ($factura->delete($id)) :
                header("Location: Factura.php?action=list");
            else :
                header("Location: Factura.php?action=edit&id={$id}");
            endif;
        } catch (Exception $ex) {
            $flashmessenger->addMessage(['danger' => $ex->getMessage()]);
            header("Location: Factura.php?action=edit&id={$id}");
        }

        break;
    case 'ajax':
        $ajaxFactura = new FacturaAjax();
        $json = $ajaxFactura->getResponse($_POST['request'], $_POST);

        echo json_encode($json);
        break;

    default:
        $factura->crearTablaDetallesForUser();
        $vista = 'Factura.php';
        include $root . '/View/Template.php';
        break;
}
