<?php
$controller = 'NotaCredito';
$action = '';
if (isset($_POST['action'])) {
    $action = $_POST['action'];
    if (isset($_POST['id'])) {
        $id = $_POST['id'];
    }
} elseif (isset($_GET['action'])) {
    $action = $_GET['action'];
    if (isset($_GET['id'])) {
        $id = $_GET['id'];
    }
}

include $_SERVER["DOCUMENT_ROOT"].'/app/include/bootstrap.php';

$form = new NotaCreditoForm();
$factura = new NotaCreditoRepository();

$settings = new SettingsRepository();
$_cuentaDeGastosActiva = $settings->_get('habilitar_cuenta_de_gastos');

switch ($action) {
    case 'insert':
        $form->setTokenForm($_POST['token_form']);
        if (isset($_POST['uuid_relacionados'])) {
            $_POST['uuid_relacionados'] = $form->prepareUuidFromPOST($_POST['uuid_relacionados']);
        }
        if (isset($_POST['uuid_relacionados_otros'])) {
            $_POST['uuid_relacionados_otros'] = $form->prepareUuidFromPOST($_POST['uuid_relacionados_otros']);
        }

        $clientId = isset($_POST['id_cliente']) ? $_POST['id_cliente']:null;
        $clienteRepo = new ClienteRepository();
        $clientes = $clienteRepo->getListSelectClientes($clientId);

        $form->setPropiedad('id_cliente', [
            'multiOptions' => $clientes,
        ]);

        $form->populate($_POST);
        if ($form->isValid()) {
            $factura->setOptions($_POST);
            if ($factura->save($factura->getOptions())) {
                $facturaNo = $factura->getLastInsertId();
                $flashmessenger->addMessage(array(
                    "success"=>$_translator->_getTranslation("Nota de credito")." #$facturaNo ".$_translator->_getTranslation("registrada exitosamente.")));

                header("Location: NotaCredito.php?action=edit&id=$facturaNo");
            } else {
                $vista = 'NotaCredito.php';
                include $root . '/View/Template.php';
            }
        } else {
            $vista = 'NotaCredito.php';
            include $root . '/View/Template.php';
        }
        break;

    case 'list':
        $searchFilter = null;
        if (isset($_POST['search'])) {
            $searchFilter = $_POST;
        }
        $_listNotaCredito = $factura->getListNotasCredito($searchFilter);

        $vista = 'NotaCreditoList.php';
        include $root . '/View/Template.php';
        break;

    case 'import':
        switch ($_GET['flag']) {
            case 'nota_de_credito':
                $pdf = new NotaCreditoPDF($_GET['id']);
                break;
        }
        break;

     case 'descargar':
            $factura = new NotaCreditoRepository();
            $factura->setOptions($factura->getById($_GET['idNotaCredito']));
            $factura->setId($_GET['idNotaCredito']);
            $factura->crearPDF();
            $factura->descargarZip();
            header('Location: NotaCredito.php?action=list');
        break;

    case 'edit':
        if ($_GET) {
            $requstData = $_GET;
            $facturaData = $factura->getById($id);
            $factura->setNotaCreditoDetallesById($id, $form->getTokenForm());
            $facturaData['uuid_relacionados'] = $form->prepareUuidFromGET($facturaData['uuid_relacionados']);
            $facturaData['uuid_relacionados_otros'] = $form->prepareUuidFromGET($facturaData['uuid_relacionados_otros']);
        }
        if ($_POST) {
            $facturaData = $_POST;
            if (isset($_POST['uuid_relacionados'])) {
                $_POST['uuid_relacionados'] = $form->prepareUuidFromPOST($_POST['uuid_relacionados']);
                $form->setTokenForm($_POST['token_form']);
            }
            if (isset($_POST['uuid_relacionados_otros'])) {
                $_POST['uuid_relacionados_otros'] = $form->prepareUuidFromPOST($_POST['uuid_relacionados_otros']);
                $form->setTokenForm($_POST['token_form']);
            }
        }

        $idCliente = isset($_POST['id_cliente']) ? $_POST['id_cliente']:$facturaData['id_cliente'];
        $clientRepo = new ClienteRepository();
        $clientList = $clientRepo->getListSelectClientes($idCliente);

        $form->setActionController('edit');
        $form->setId($id);
        $form->setPropiedad('id_cliente', [
            'multiOptions' => $clientList,
        ]);
        $form->populate($facturaData);

        $_disabled = null;
        if ((isset($facturaData['status']) && $facturaData['status'] != '1')) {
            $form->deleteElement('terminar');
            $form->deleteElement('buscar');
            $form->addElement(array('type'=>'hidden','name'=>'terminar'));
            $form->addElement(array('type'=>'hidden','name'=>'buscar'));
            $form->disabledAllElements();
            $_disabled = true;
        }

        if (isset($_POST['id'])) {
            if ($form->isValid()) {
                $factura->setOptions($facturaData);
                $result = $factura->update($id, $factura->getOptions()); //no tengo id porque viene de post
                if ($result) {
                    $flashmessenger->addMessage(array('success'=>'Nota de credito actualizada exitosamente.'));
                    header("Location: NotaCredito.php?action=edit&id=$id");
                } else {
                    $vista = 'NotaCredito.php';
                    include $root . '/View/Template.php';
                }
            } else {
                $vista = 'NotaCredito.php';
                include $root . '/View/Template.php';
            }
        } else {
            $factura->setOptions($facturaData);
            $vista = 'NotaCredito.php';
            include $root . '/View/Template.php';
        }
        break;


    case 'delete':
        try {
            if($factura->delete($id)):
                header("Location: NotaCredito.php?action=list");
            else:
                header("Location: NotaCredito.php?action=edit&id={$id}");
            endif;
        } catch (Exception $ex) {
            $flashmessenger->addMessage(['danger' => $ex->getMessage()]);
            header("Location: NotaCredito.php?action=edit&id={$id}");
        }
        break;

    case 'ajax':
        $ajaxNotaCredito = new NotaCreditoAjax();
        $json = $ajaxNotaCredito->getResponse($_POST['request'], $_POST);

        echo json_encode($json);
        break;

    default:
        $factura->crearTablaDetallesForUser();
        $vista = 'NotaCredito.php';
        include $root.'/View/Template.php';
        break;
}
