<?php
$controller = 'Pago';
$action = '';

if (isset($_POST['action'])) {
    $action = $_POST['action'];
    if (isset($_POST['id'])) {
        $id = $_POST['id'];
    }
} elseif (isset($_GET['action'])) {
    $action = $_GET['action'];
    if (isset($_GET['id'])) {
        $id = $_GET['id'];
    }
}

include $_SERVER["DOCUMENT_ROOT"].'/app/include/bootstrap.php';

$form = new PagoForm();
$pago = new PagoRepository();

switch ($action) {
    case 'insert':
        $form->setActionController('insert');
        $form->populate($_POST);
        
        if (isset($_POST['pago'])) {
            $_facturas = $_POST['pago'];
            $form->setFacturasAPagar($_facturas);
            $_listFacturas = true;
        }

       if ($form->isValid()) {
           $options = $pago->setOptions($_POST);
           $options = $pago->getOptions();
           $options['pago'] = $_POST['pago'];

           if ($_POST['suma_de_pagos'] < $_POST['monto']) {
               $flashmessenger->addMessage(array('info'=>'Suma de pagos debe ser igual al monto de pago.'));
               $vista = 'Pago.php';
               include $root.'/View/Template.php';
               break;
           }

           $options['adjuntos'] = $_FILES['adjuntos'];
           if ($pago->save($options)) {
               $flashmessenger->addMessage(array('success'=>'Pago registrado exitosamente.'));
               $lastInsert= $pago->getLastInsertId();
               header("Location: Pago.php?action=edit&id=$lastInsert");
           }
       } else {
           $vista = 'Pago.php';
           include $root.'/View/Template.php';
       }
        break;

    case 'edit':
        if ($_POST) {
            $data = $_POST;
            $data['suma_de_pagos'] = $data['monto'];
        }

        if ($_GET) {
            $data = $pago->getDataToEdit($id);
            $_SESSION['facturasLiquidadas'] = $data['facturasLiquidadas'];
            $_SESSION['pagosOriginales'] = $data['pagosOriginales'];
            $data = $data['data'];
            if (isset($data['monto'])) {
                $data['suma_de_pagos'] = $data['monto'];
                $data['monto_original'] = $data['monto'];
            }
        }

        $form->setActionController('edit');
        $form->populate($data);
        $form->setId($id);

        if ($data['status']==2) {
            $form->disabledAllElements();
        }

        if (isset($data['pago'])) {
            $_facturas = $data['pago'];
            $form->setFacturasAPagar($_facturas);
            $_listFacturas = true;
        }

        if (isset($_POST['send'])) {
            if ($form->isValid()) {
                $dataPago = $pago->getOptions($pago->setOptions($_POST));
                $dataPago['pago'] = $data['pago'];
                if ($_POST['suma_de_pagos'] < $_POST['monto']) {
                    $flashmessenger->addMessage(array('info'=>'Suma de pagos debe ser igual al monto de pago.'));
                    $vista = 'Pago.php';
                    include $root.'/View/Template.php';
                    break;
                }

                $dataPago['adjuntos'] = $_FILES['adjuntos'];
                if ($pago->updateMultiple($id, $dataPago)) {
                    $flashmessenger->addMessage(array('success'=>'Pago actualizados exitosamente.'));
                    header("Location: Pago.php?action=edit&id=$id");
                }
            } else {
                $vista = 'Pago.php';
                include $root.'/View/Template.php';
            }
        } else {
            $pago->setOptions($data);
            $vista = 'Pago.php';
            include $root.'/View/Template.php';
        }
        break;

    case 'list':
            $searchFilter = [];
            if (isset($_POST['search'])) {
                $searchFilter = $_POST;
            }
            if(isset($_GET['factura_id'])) {
                $searchFilter['factura_id'] = $_GET['factura_id'];
                $_factura = new FacturaRepository();
                $_factura = $_factura->getById($_GET['factura_id']);
            }
            $_listPagos = $pago->getListPagos($searchFilter);

            $vista = 'PagoList.php';
            include $root.'/View/Template.php';
        break;
        
    case 'delete':
            try {
                if($pago->delete($id)):
                    header("Location: Pago.php?action=list");
                else:
                    header("Location: Pago.php?action=edit&id={$id}");
                endif;
            } catch (Exception $ex) {
                $flashmessenger->addMessage(['danger' => $ex->getMessage()]);
                header("Location: Pago.php?action=edit&id={$id}");
            }
           
        break;

    case 'ajax':
        $ajaxPago = new PagoAjax();
        $json = $ajaxPago->getResponse($_POST['request'], $_POST);

        echo json_encode($json);
        break;

    case 'import':
        switch ($_GET['flag']) {
            case 'pdf':
                $pdf = new PagoPDF($_GET['id']);
                break;
        }
        break;

     case 'descargar':
            $pago = new PagoRepository();
            $pago->setOptions($pago->getById($_GET['idPago']));
            $pago->setId($_GET['idPago']);
            $pago->crearPDF();
            $pago->descargarZip();
            header('Location: Pago.php?action=list');
        break;

    case 'excel':
        switch ($_GET['flag']) {
            case 'search':
                $pago->resultSearchToExcel($_GET);
                break;
        }

        break;

    default:

        unset($_SESSION['facturasLiquidadas']);
        unset($_SESSION['pagosOriginales']);

        $form->setActionController('insert');
        $vista = 'Pago.php';
        include $root.'/View/Template.php';
        break;
}
