<?php
$controller = 'Payment';
$action = '';

if (isset($_POST['action'])) {
    $action = $_POST['action'];
    if (isset($_POST['id'])) {
        $id = $_POST['id'];
    }
} elseif (isset($_GET['action'])) {
    $action = $_GET['action'];
    if (isset($_GET['id'])) {
        $id = $_GET['id'];
    }
}

include $_SERVER["DOCUMENT_ROOT"].'/app/include/bootstrap.php';

$form = new PagoForm();
$pago = new PagoRepository();

switch ($action) {
    case 'insert':
        $form->setActionController('insert');
        $form->populate($_POST);
        
        if (isset($_POST['pago'])) {
            $_facturas = $_POST['pago'];
            $form->setFacturasAPagar($_facturas);
            $_listFacturas = true;
        }

       if ($form->isValid()) {
           $options = $pago->setOptions($_POST);
           $options = $pago->getOptions();
           $options['pago'] = $_POST['pago'];

           if ($_POST['suma_de_pagos'] < $_POST['monto']) {
               $flashmessenger->addMessage(array('info'=>'Suma de pagos debe ser igual al monto de pago.'));
               $vista = 'Pago.php';
               include $root.'/View/Template.php';
               break;
           }

           if ($pago->save($options)) {
               $flashmessenger->addMessage(array('success'=>'Pago registrado exitosamente.'));
               $lastInsert= $pago->getLastInsertId();
               header("Location: Payment.php?action=edit&id=$lastInsert");
           }
       } else {
           $vista = 'Pago.php';
           include $root.'/View/Template.php';
       }
        break;

    case 'edit':
        if ($_POST) {
            $data = $_POST;
            $data['suma_de_pagos'] = $data['monto'];
        }

        if ($_GET) {
            $data = $pago->getDataToEdit($id);
            $storeIds = $data['storeId'];
            $_SESSION['facturasLiquidadas'] = $data['facturasLiquidadas'];
            $_SESSION['pagosOriginales'] = $data['pagosOriginales'];
            $data = $data['data'];
            $data['suma_de_pagos'] = $data['monto'];
            $data['monto_original'] = $data['monto'];
        }
        
        if ($login->getRole() != '1') {
            foreach ($storeIds as $storeId) {
                if (!in_array($storeId, $login->getStoreArray())) {
                    header("Location: Payment.php?action=list");
                    exit;
                }
            }
        }

        $form->setActionController('edit');
        $form->populate($data);
        $form->setId($id);

        if ($data['status']==2) {
            $form->disabledAllElements();
        }

        if (isset($data['pago'])) {
            $_facturas = $data['pago'];
            $form->setFacturasAPagar($_facturas);
            $_listFacturas = true;
        }

        if (isset($_POST['send'])) {
            if ($form->isValid()) {
                $dataPago = $pago->getOptions($pago->setOptions($_POST));
                $dataPago['pago'] = $data['pago'];
                if ($_POST['suma_de_pagos'] < $_POST['monto']) {
                    $flashmessenger->addMessage(array('info'=>'Suma de pagos debe ser igual al monto de pago.'));
                    $vista = 'Pago.php';
                    include $root.'/View/Template.php';
                    break;
                }

                if ($pago->updateMultiple($id, $dataPago)) {
                    $flashmessenger->addMessage(array('success'=>'Pago actualizados exitosamente.'));
                    header("Location: Payment.php?action=edit&id=$id");
                }
            } else {
                $vista = 'Pago.php';
                include $root.'/View/Template.php';
            }
        } else {
            $pago->setOptions($data);
            $vista = 'Pago.php';
            include $root.'/View/Template.php';
        }
        break;

    case 'list':
            $searchFilter = null;
            if (isset($_POST['search'])) {
                $searchFilter = $_POST;
            }
            $_listPagos = $pago->getListPagos($searchFilter);

            $vista = 'PagoList.php';
            include $root.'/View/Template.php';
        break;
        
    case 'delete':
            $rs = $pago->delete($id);
            if ($rs || !$rs) {
                header("Location: Payment.php?action=list");
            }
           
        break;

    case 'ajax':
        $ajaxPago = new PagoAjax();
        $json = $ajaxPago->getResponse($_POST['request'], $_POST);

        echo json_encode($json);
        break;

    case 'import':
        switch ($_GET['flag']) {
            case 'pdf':
                $pdf = new PagoPDF($_GET['id']);
                break;
        }
        break;

     case 'descargar':
            $pago = new PagoEntity();
            $pago->setOptions($pago->getById($_GET['idPago']));
            $pago->setId($_GET['idPago']);
            $pago->crearPDF();
            $pago->descargarZip();
            header('Location: Payment.php?action=list');
        break;

    case 'excel':
        switch ($_GET['flag']) {
            case 'search':
                $pago->resultSearchToExcel($_GET);
                break;
        }

        break;

    default:

        unset($_SESSION['facturasLiquidadas']);
        unset($_SESSION['pagosOriginales']);

        $form->setActionController('insert');
        $vista = 'Pago.php';
        include $root.'/View/Template.php';
        break;
}
