<?php

class FacturaPDF
{
    private $pathfFileCreated = null;

    public function __construct($idFactura, $createFile = null)
    {
        $factura = new FacturaRepository();
        $factura->setOptions($factura->getById($idFactura));
        $factura->setId($idFactura);

        // $filename = PATH_SAT_DOCS . $factura->getSucursal() . "/temp-pdf/Factura-" . $factura->getSerie() . "-" . $factura->getFolio() . ".pdf";
        // if (file_exists($filename)) {
        //     header("Content-type:application/pdf");
        //     header("Content-Disposition:inline;filename='$filename");
        //     readfile($filename);
        //     return;
        // }

        $cliente = new ClienteRepository();
        $cliente->setOptions($cliente->getById($factura->getIdCliente()));

        $empresa = new EmpresaRepository();
        $empresa->setOptions($empresa->getById(1));

        $sucursal = new SucursalRepository();
        $sucursal->setOptions($sucursal->getById($factura->getSucursal()));

        //Modifique metodo AddPage para qe ricibiera un tercer parametro, dicho parametro contiene el texto para a marca de agua.
        // para crear la marca de agua agregue las funciones Header y RotatedText en pdf.php
        $pdf = new PDF();

        if ($factura->getStatus() == '3') {
            $pdf->AddPage('', '', 'Cancelada');
        } else {
            $pdf->AddPage('', '');
        }

        $pdf->SetFillColor(51, 153, 255);
        $pdf->SetY(7);

        switch ($factura->getVersionCFDI()) {
            case '3.2':
                $pdf->SetFont('Arial', '', '14');
                $pdf->SetTextColor(255);
                $pdf->SetFillColor(51, 153, 255);
                $pdf->SetX(0);
                $pdf->Cell(80, 10, "FACTURA " . $factura->getNumFactura(), '0', 0, 'R', true);
                $pdf->Cell(10, 10, "", '', 0, 'C'); //<== margin left
                $pdf->SetTextColor(0);
                $pdf->Cell(110, 10, $empresa->getNombre(), 'L', 1, 'R');
                $pdf->SetX(0);
                $pdf->SetFont('Arial', '', '12');
                $pdf->Cell(80, 7, 'FECHA ' . $factura->getFechaFactura(), '', 0, 'R');
                $pdf->Cell(10, 7, "", '', 0, 'C'); //<== margin left
                $pdf->SetFont('Arial', '', '12');
                $pdf->cell(110, 3, $empresa->getPaginaWeb(), 'L', 1, 'R');

                $pdf->Ln(1);
                $pdf->SetFont('Arial', '', '8');
                $pdf->SetTextColor(0);

                $direccion = $empresa->getRFC();
                $direccion .= "\n" . utf8_decode($empresa->getCalleNum());
                $direccion .= "\n" . utf8_decode($empresa->getColonia()) . ' ' . $empresa->getCodigoPostal();
                $direccion .= "\n" . utf8_decode($empresa->getCiudad()) . ', ' . utf8_decode($empresa->getEstado());
                $direccion .= "\n" . $empresa->getTelefono();
                $pdf->Cell(190, 28, $direccion, '0', 1, 'R');

                $pdf->SetFont('Arial', 'B', '8');
                $pdf->cell(100, 4, 'FACTURADO A:', '', 0, 'L');
                $pdf->Cell(20, 4, "", '', 0, 'C'); //<== margin left
                $pdf->cell(98, 4, 'EXPEDIDO EN:', '', 1, 'L');

                $pdf->SetFont('Arial', '', '8');
                $pdf->Cell(120, 4, utf8_decode($cliente->getRazonSocial()), '0', 0, 'L');
                $pdf->Cell(80, 4, utf8_decode($sucursal->getNombre()), '0', 1, 'L');

                $pdf->Cell(120, 4, $cliente->getRFC(), '0', 0, 'L');
                $pdf->Cell(80, 4, utf8_decode($sucursal->getCalle()) . " " . $sucursal->getNumExterior() . " " . $sucursal->getNumInterior(), '0', 1, 'L');

                $pdf->Cell(120, 4, utf8_decode($cliente->getCalle()) . " " . $cliente->getNumExterior() . " " . $cliente->getNumInterior(), '0', 0, 'L');
                $pdf->Cell(80, 4, utf8_decode($sucursal->getColonia()) . " " . $sucursal->getCodigoPostal(), '0', 1, 'L');

                $pdf->Cell(120, 4, utf8_decode($cliente->getColonia()) . " " . $cliente->getCodigoPostal(), '0', 0, 'L');
                $pdf->Cell(80, 4, utf8_decode($sucursal->getCiudad()) . " " . $sucursal->getEstado(), '0', 1, 'L');

                $pdf->Cell(80, 4, utf8_decode($cliente->getCiudad()) . " " . $cliente->getEstado(), '0', 1, 'L');
                //exit;
                $pdf->Ln(5);
                $pdf->SetFont('Arial', 'B', '8');
                $pdf->Cell(20, 4, "CANTIDAD", 'B', 0, 'C');
                $pdf->Cell(20, 4, "UNIDAD", 'B', 0, 'C');
                $pdf->Cell(110, 4, "DESCRIPCION", 'B', 0, 'L');
                $pdf->Cell(20, 4, "MONTO", 'B', 0, 'R');
                $pdf->Cell(20, 4, "TOTAL", 'B', 1, 'R');

                $pdf->SetFont('Arial', '', '8');
                $conceptos = $factura->getConceptos();

                if ($conceptos) {
                    foreach ($conceptos as $concepto) {
                        $pdf->Cell(20, 7, $concepto['cantidad'], '0', 0, 'C');
                        $pdf->Cell(20, 7, $concepto['unidad'], '0', 0, 'C');
                        $pdf->Cell(110, 7, utf8_decode($concepto['descripcion']), '0', 0, 'L');
                        $pdf->Cell(20, 7, '$' . number_format($concepto['valorUnitario'], 2), '0', 0, 'R');
                        $pdf->Cell(20, 7, '$' . number_format($concepto['importe'], 2), '0', 1, 'R');
                    }
                }

                $datosComprobante = $factura->getDatosComprobante();
                $pdf->SetFont('Arial', 'B', '8');
                $pdf->Cell(170, 4, 'SUBTOTAL', 'T', 0, 'R');
                $pdf->SetFont('Arial', '', '8');
                $pdf->Cell(20, 4, '$' . number_format($datosComprobante['subTotal'], 2), 'T', 1, 'R');

                /* IMPUESTOS */
                $impuestosAplicables = $factura->getImpuestosAplicables();
                if (count($impuestosAplicables['Retenible']) > 0) {
                    foreach ($impuestosAplicables['Retenible'] as $impuestoAplicable) {
                        $pdf->Cell(170, 4, $impuestoAplicable['nombre'], '0', 0, 'R');
                        $pdf->SetFont('Arial', '', '8');
                        $pdf->Cell(20, 4, '$' . number_format($impuestoAplicable['monto'], 2), '0', 1, 'R');
                    }
                }

                if (count($impuestosAplicables['Trasladable']) > 0) {
                    foreach ($impuestosAplicables['Trasladable'] as $impuestoAplicable) {
                        $pdf->Cell(170, 4, $impuestoAplicable['nombre'], '0', 0, 'R');
                        $pdf->SetFont('Arial', '', '8');
                        $pdf->Cell(20, 4, '$' . number_format($impuestoAplicable['monto'], 2), '0', 1, 'R');
                    }
                }
                /* FIN IMPUESTOS*/

                $pdf->SetFont('Arial', 'B', '8');
                $pdf->Cell(170, 4, 'TOTAL', 'T', 0, 'R');
                $pdf->SetFont('Arial', '', '8');
                $pdf->Cell(20, 4, '$' . number_format($datosComprobante['total'], 2), 'T', 1, 'R');

                $pdf->SetFont('Arial', 'B', '8');
                $pdf->Cell(35, 4, 'METODO DE PAGO:', '0', 0, 'L');

                $pagoConTarjeta = null;
                $salto = 1;
                if ($factura->getMetodoDePago() == '04') {
                    $salto = 0;
                    $pagoConTarjeta = true;
                }

                $pdf->SetFont('Arial', '', '8');
                $pdf->Cell(40, 4, $factura->getMetodoDePagoNombre(), '0', $salto, 'L');

                if ($pagoConTarjeta) {
                    $pdf->SetFont('Arial', 'B', '8');
                    $pdf->Cell(25, 4, 'NUM DE CUENTA:', '0', 0, 'L');
                    $pdf->SetFont('Arial', '', '8');
                    $pdf->Cell(25, 4, $factura->getNumCuentaPago(), '0', 1, 'L');
                }

                $pdf->SetFont('Arial', 'B', '8');
                $pdf->Cell(35, 4, 'IMPORTE CON LETRA:', '0', 0, 'L');
                $numeroALetra = new NumeroALetra();
                $pdf->SetFont('Arial', '', '8');
                $pdf->Cell(135, 4, $numeroALetra->numALetras($datosComprobante['total']), '0', 1, 'L');

                if (trim($factura->getComentarios()) != '') {
                    $msgArray = explode("<br />", nl2br($factura->getComentarios()));
                    $msg = "";

                    foreach ($msgArray as $line) {
                        $msg .= $line . "\n";
                    }

                    $pdf->SetFont('Arial', '', '8');
                    $pdf->Cell(190, 15, $msg, 'TB', 1, 'L');

                    $pdf->ln(2);
                }

                //Crear codigo
                if (!is_dir(PATH_SAT_DOCS . $factura->getSucursal() . "/temp-qr/")) {
                    mkdir(PATH_SAT_DOCS . $factura->getSucursal() . "/temp-qr/", 0777, true);
                }
                $yQrcode = $pdf->GetY();
                \PHPQRCode\QRcode::png('?re=' . $empresa->getRFC() . '&rr=' . $cliente->getRFC() . '&tt=' . $factura->getTotalParaCodigoQR() . '&id=' . $factura->getUUID(), PATH_SAT_DOCS . $factura->getSucursal() . "/temp-qr/qrCode" . $factura->getSerie() . "-" . $factura->getFolio() . ".png", 'Q', 3); // creates file
                $pdf->Image(PATH_SAT_DOCS . $factura->getSucursal() . "/temp-qr/qrCode" . $factura->getSerie() . "-" . $factura->getFolio() . ".png", 10, $yQrcode, 30, 0);

                $pdf->ln(5);
                break;
            case '3.3':
                $logoBytes = $sucursal->getLogo();
                $logo = null;
                $image_type = "png";
                if (is_null($logoBytes)) {
                    $logo = base64_encode(file_get_contents(dirname(__FILE__) . "/../../app/resources/docs/1.png"));
                } else {
                    $logo = base64_encode($logoBytes);
                    $image_type = explode("/", $sucursal->getImageType())[1];
                }
                $pic = 'data://text/plain;base64,' . $logo;
                $pdf->Image($pic, 20, 5, 35, 30, $image_type);

                $pdf->SetFont('Arial', '', '10');
                $pdf->SetTextColor(0);
                $pdf->Cell(190, 10, $empresa->getNombre() . "\n" . $empresa->getPaginaWeb(), '0', 1, 'R');

                $pdf->SetFont('Arial', '', '6');
                $direccion = $empresa->getRFC();
                $direccion .= "\n" . $empresa->getRegimenFiscal() . " - " . $empresa->getRegimenFiscalNombre();
                $direccion .= "\n" . utf8_decode($empresa->getCalleNum());
                $direccion .= "\n" . utf8_decode($empresa->getColonia()) . ' ' . $empresa->getCodigoPostal();
                $direccion .= "\n" . utf8_decode($empresa->getCiudad()) . ', ' . utf8_decode($empresa->getEstado());
                $direccion .= "\n" . $empresa->getTelefono();
                $pdf->Cell(190, 15, $direccion, '0', 1, 'R');

                $pdf->ln(5);
                $pdf->SetFont('Arial', '', '10');
                $pdf->SetTextColor(255);
                $pdf->SetDrawColor(51, 153, 255);
                //$pdf->SetDrawColor(0);
                $pdf->SetX(0);
                $pdf->Cell(60, 2, '', '1', 1, 'R', true);
                $pdf->SetX(0);
                $pdf->Cell(60, 5, "FACTURA " . $factura->getNumFactura(), '1', 1, 'R', true);
                $pdf->SetTextColor(255);
                $pdf->SetX(0);
                $pdf->SetFont('Arial', '', '7');
                $pdf->Cell(60, 3, 'Tipo de comprobante: ' . $factura->getTipoComprobante() . " - " . $factura->getTipoComprobanteNombre(), '1', 1, 'R', true);
                $pdf->SetX(0);
                //$pdf->Cell(0,2, '', '1',1, 'R',true);

                $pdf->SetFont('Arial', '', '10');
                $pdf->SetTextColor(0);
                $pdf->SetX(0);
                $pdf->Cell(60, 2, '', '', 1, 'L');
                $pdf->Cell(0, 6, 'FECHA ' . $factura->getFechaFactura(), '', 1, 'L');
                // $pdf->Cell(60, 6, 'FECHA VENCIMIENTO ' . $factura->getFechaVencimiento(), '', 1, 'L');

                $pdf->Ln(1);
                $pdf->SetTextColor(0);
                $pdf->SetDrawColor(0);
                $pdf->SetFont('Arial', 'B', '8');
                $pdf->cell(100, 4, 'FACTURADO A:', '', 0, 'L');
                $pdf->Cell(20, 4, "", '', 0, 'C'); //<== margin left
                $pdf->cell(98, 4, 'EXPEDIDO EN:', '', 1, 'L');

                $pdf->SetFont('Arial', '', '7');
                $pdf->Cell(120, 4, $cliente->getRazonSocial(), '0', 0, 'L');
                $pdf->Cell(80, 4, utf8_decode($sucursal->getNombre()), '0', 1, 'L');

                $pdf->Cell(120, 4, $cliente->getRFC(), '0', 0, 'L');
                $pdf->Cell(80, 4, utf8_decode($sucursal->getCalle()) . " " . $sucursal->getNumExterior() . " " . $sucursal->getNumInterior(), '0', 1, 'L');

                $pdf->Cell(120, 4, "USO CFDI: " . $factura->getUsoCFDI() . " - " . $factura->getUsoCFDINombre(), '0', 0, 'L');
                $pdf->Cell(80, 4, utf8_decode($sucursal->getColonia()) . " " . $sucursal->getCodigoPostal(), '0', 1, 'L');

                $pdf->Cell(120, 4, utf8_decode($cliente->getCalle()) . " " . $cliente->getNumExterior() . " " . $cliente->getNumInterior(), '0', 0, 'L');
                $pdf->Cell(80, 4, utf8_decode($sucursal->getCiudad()) . " " . $sucursal->getEstado(), '0', 1, 'L');

                $pdf->Cell(120, 4, utf8_decode($cliente->getColonia()) . " " . $cliente->getCodigoPostal(), '0', 1, 'L');
                $pdf->Cell(80, 4, utf8_decode($cliente->getCiudad()) . " " . $cliente->getEstado(), '0', 1, 'L');
                //exit;
                $pdf->Ln(2);
                $pdf->SetFont('Arial', 'B', '5');
                $pdf->Cell(10, 5, "Cant", 'B', 0, 'L');
                $pdf->Cell(10, 5, "Clave SAT\nUnidad", 'B', 0, 'C');
                $pdf->Cell(10, 5, "Clave SAT\nProd/Ser", 'B', 0, 'C');
                $pdf->Cell(65, 5, "Concepto", 'B', 0, 'L');
                $pdf->Cell(15, 5, "Valor unit.", 'B', 0, 'R');
                $pdf->Cell(15, 5, "Importe", 'B', 0, 'R');
                $pdf->Cell(8, 5, "", 'B', 0, 'C');//$pdf->Cell(8, 5, "Descto.", 'B', 0, 'C');
                $pdf->Cell(15, 5, "Base", 'B', 0, 'C');
                $pdf->Cell(10, 5, "Impuesto", 'B', 0, 'C');
                $pdf->Cell(8, 5, "Tipo\nFactor", 'B', 0, 'C');
                $pdf->Cell(8, 5, "Tipo\nTasa", 'B', 0, 'C');
                $pdf->Cell(15, 5, "Importe", 'B', 1, 'R');

                $pdf->SetFont('Arial', '', '6');
                $conceptos = $factura->getConceptos();
                $yVariable = 12;
                $hVariable = 2;
                $wVaribale = 12; //TENIA 10
                if ($conceptos) {
                    foreach ($conceptos as $concepto) {
                        $x = $pdf->GetX();
                        $y = $pdf->GetY();
                        $yOrigin = $y;

                        //var_dump($concepto); exit;
                        // $concepto['ImpuestosAplicables']['Trasladable'][] = $concepto['ImpuestosAplicables']['Trasladable'][0];
                        // $concepto['ImpuestosAplicables']['Trasladable'][] = $concepto['ImpuestosAplicables']['Trasladable'][0];
                        // $concepto['ImpuestosAplicables']['Trasladable'][] = $concepto['ImpuestosAplicables']['Trasladable'][0];
                        // $concepto['ImpuestosAplicables']['Trasladable'][] = $concepto['ImpuestosAplicables']['Trasladable'][0];
                        // $concepto['ImpuestosAplicables']['Retenible'][] = $concepto['ImpuestosAplicables']['Trasladable'][0];
                        // $concepto['ImpuestosAplicables']['Retenible'][] = $concepto['ImpuestosAplicables']['Trasladable'][0];
                        // $concepto['Descripcion'] = "FLETE PEDIMENTO DE IMPORTACION # 1003886,1003885,1003881,1003876,1003886,1003885,1003881,1003876";
                        // $concepto['Descripcion'] .= $concepto['Descripcion'];
                        $impuestosLength = count($concepto['ImpuestosAplicables']['Trasladable']) + count($concepto['ImpuestosAplicables']['Retenible']);
                        $yImpuestos =  $impuestosLength * 7;
                        $chunkDescSize = 45;
                        $yDesc = strlen($concepto['Descripcion']) / .65 / $yVariable;

                        $descLines = ceil($yDesc / $yVariable);
                        if ($descLines * $yVariable >= $yImpuestos) {
                            $yDesc = $descLines * $yVariable;
                        } else {
                            $yDesc = $yImpuestos;
                        }
                        $chunks = explode(' ', utf8_decode(strtoupper($concepto['Descripcion'])));

                        //var_dump($yDesc);
                        $pdf->SetXY($x + $wVaribale, $y);
                        //$pdf->SetXY(40, $y);
                        //$pdf->Multicell(90, 7, htmlentities($concepto['Descripcion']), 'B','L');
                        //$pdf->Multicell($wVaribale, $yDesc,"", null, 'B', 'L');

                        $accum = [];
                        $specialY = $y+$hVariable;
                        for ($i = 0; $i < count($chunks); $i++) {
                            $accum[] = $chunks[$i];

                            if ($this->getChunksLength($accum) > ceil($chunkDescSize)) {
                                $lastChunk = array_pop($accum);
                                if ($lastChunk < $chunkDescSize) {
                                    $i--;
                                    $pdf->Text(42, $specialY, join(' ', $accum));
                                } else {
                                    $pdf->Text(42, $specialY, join(' ', $accum));
                                    $specialY+=2;
                                    $pdf->Text(42, $specialY, $lastChunk);
                                }
                                $specialY+=2;
                                $accum = [];


                            }

                            if (count($chunks) == $i+1) {
                                $pdf->Text(42, $specialY, join(' ', $accum));
                                $accum = [];
                            }
                        }



                        // $yDesc = $pdf->GetY() - $y;

                        // var_dump($yDesc); exit;

                        $pdf->SetXY($x, $y);
                        $pdf->Multicell(10, $yDesc,"" ,null, 'B', 'C');
                        $pdf->Text(13, $y + $hVariable, number_format($concepto['Cantidad'], 2));
                        $pdf->SetXY($x += 15, $y);

                        $pdf->Multicell(10, $yDesc,"" ,null, 'B', 'C');
                        $pdf->Text(23, $y + $hVariable, $concepto['ClaveUnidad']);
                        $pdf->SetXY($x += 15, $y);

                        $pdf->Multicell(10, $yDesc,"" ,null, 'B', 'C');
                        $pdf->Text(30, $y + $hVariable, $concepto['ClaveProdServ']);
                        $pdf->SetXY($x += 60, $y);

                        $pdf->Multicell(15, $yDesc,"" ,null, 'B', 'R');
                        $pdf->Text(110, $y + $hVariable, '$' . number_format($concepto['ValorUnitario'], 2));
                        $pdf->SetXY($x += 15, $y);

                        $pdf->Multicell(15, $yDesc,"" ,null, 'B', 'R');
                        $pdf->Text(125, $y + $hVariable, '$' . number_format($concepto['Importe'], 2));
                        $pdf->SetXY($x += 15, $y);

                        //var_dump($concepto); exit;
                        if (isset($concepto['ImpuestosAplicables'])) {
                            $x = $pdf->GetX();
                            $xOrigin = $x;
                            $itemLastY = $yDesc - $impuestosLength * $yVariable;
                            $itemY = 7;
                            foreach ($concepto['ImpuestosAplicables'] as $impuesto) {
                                $border = null;
                                $i = 1;
                                foreach ($impuesto as $itemImpuesto) {
                                    if ($i >= $impuestosLength && $itemLastY == 0) {
                                        $border = null;
                                    }
                                    $y = $pdf->GetY();
                                    $x = $pdf->GetX();
                                    if (isset($itemImpuesto['Descuento'])) {
                                        //$pdf->Multicell(8, $hVariable, $itemImpuesto['Descuento'],$border, 'B', 'R');
                                    } else {
                                        //$pdf->Multicell(8, $hVariable, "-", $border, 'C');
                                    }
                                    $pdf->SetXY($x += 8, $y);


                                    $pdf->Multicell(15, $hVariable+1, '$' .number_format($itemImpuesto['Base'], 2), $border, 'R');
                                    $pdf->SetXY($x += 15, $y);

                                    $pdf->Multicell(15, $hVariable+1, $itemImpuesto['Impuesto'], $border, 'C');
                                    $pdf->SetXY($x += 15, $y);

                                    $pdf->Multicell(8, $hVariable+1, $itemImpuesto['TipoFactor'], $border, 'R');
                                    $pdf->SetXY($x += 8, $y);

                                    $pdf->Multicell(8, $hVariable+1, number_format($itemImpuesto['TasaOCuota'], 2), $border, 'R');
                                    $pdf->SetXY($x += 8, $y);

                                    $pdf->Multicell(15, $hVariable+1, '$' . number_format($itemImpuesto['Importe'], 2), $border, 'R');

                                    $pdf->SetXY($xOrigin, $y + $hVariable);

                                    if ($i >= $impuestosLength && $itemLastY != 0) {
                                        $y = $pdf->GetY();
                                        $x = $pdf->GetX();
                                        $pdf->Multicell(8, $itemLastY,null ,null, 'B', 'R');
                                        $pdf->SetXY($x += 8, $y);
                                        $pdf->Multicell(15, $itemLastY,null , null, 'B', 'R');
                                        $pdf->SetXY($x += 15, $y);
                                        $pdf->Multicell(15, $itemLastY, null ,null, 'B', 'R');
                                        $pdf->SetXY($x += 15, $y);
                                        $pdf->Multicell(8, $itemLastY, null ,null, 'B', 'R');
                                        $pdf->SetXY($x += 8, $y);
                                        $pdf->Multicell(8, $itemLastY, null ,null, 'B', 'R');
                                        $pdf->SetXY($x += 8, $y);
                                        $pdf->Multicell(15, $itemLastY,null , null, 'B', 'R');
                                        $pdf->SetXY($x += 15, $y);
                                    }
                                    $i++;
                                }
                            }
                            $pdf->SetY(($yOrigin + $yDesc)*0.95);
                            //$pdf->SetY($yOrigin);
                        }
                        $x = $pdf->GetX();

                        if ($y > 250) {
                            $pdf->addPage('P');
                            $pdf->SetFont('Arial', 'B', '6');
                            $pdf->Cell(15, 5, "CANTIDAD", 'B', 0, 'C');
                            $pdf->Cell(15, 5, "CLAVE SAT\nUNIDAD", 'B', 0, 'C');
                            $pdf->Cell(15, 5, "CLAVE SAT\nPROD/SER", 'B', 0, 'C');
                            $pdf->Cell(45, 5, "DESCRIPCION", 'B', 0, 'L');
                            $pdf->Cell(15, 5, "VALOR UNIT.", 'B', 0, 'R');
                            $pdf->Cell(15, 5, "IMPORTE", 'B', 0, 'R');
                            $pdf->Cell(8, 5, "DCTO.", 'B', 0, 'C');
                            $pdf->Cell(15, 5, "BASE", 'B', 0, 'C');
                            $pdf->Cell(15, 5, "IMPUESTO", 'B', 0, 'C');
                            $pdf->Cell(8, 5, "TIPO\nFACTOR", 'B', 0, 'C');
                            $pdf->Cell(8, 5, "TIPO\nTASA", 'B', 0, 'C');
                            $pdf->Cell(15, 5, "IMPORTE", 'B', 1, 'R');

                            $pdf->SetFont('Arial', '', '6');
                            $x = $pdf->GetX();
                            $y = $pdf->GetY();
                        }
                    }
                }

                $datosComprobante = $factura->getDatosComprobante();
                $pdf->SetFont('Arial', 'B', '6');
                $pdf->Cell(170, 4, 'SUBTOTAL', 'T', 0, 'R');
                $pdf->SetFont('Arial', '', '6');
                $pdf->Cell(20, 4, '$' . number_format($datosComprobante['SubTotal'], 2), 'T', 1, 'R');

                /* IMPUESTOS */
                $impuestosAplicables = $factura->getImpuestosAplicables();
                if (count($impuestosAplicables['Retenible']) > 0) {
                    foreach ($impuestosAplicables['Retenible'] as $impuestoAplicable) {
                        $pdf->Cell(170, 2, $impuestoAplicable['descripcion'], '0', 0, 'R');
                        $pdf->SetFont('Arial', '', '6');
                        $pdf->Cell(20, 2, '$' . number_format($impuestoAplicable['Importe'], 2), '0', 1, 'R');
                    }
                }

                if (count($impuestosAplicables['Trasladable']) > 0) {
                    foreach ($impuestosAplicables['Trasladable'] as $impuestoAplicable) {
                        $pdf->Cell(170, 4, $impuestoAplicable['descripcion'], '0', 0, 'R');
                        $pdf->SetFont('Arial', '', '6');
                        $pdf->Cell(20, 4, '$' . number_format($impuestoAplicable['Importe'], 2), '0', 1, 'R');
                    }
                }
                /* FIN IMPUESTOS*/

                $pdf->SetFont('Arial', 'B', '6');
                $pdf->Cell(170, 4, 'TOTAL', 'T', 0, 'R');
                $pdf->SetFont('Arial', '', '6');
                $pdf->Cell(20, 4, '$' . number_format($datosComprobante['Total'], 2), 'T', 1, 'R');

                $pdf->SetFont('Arial', 'B', '6');
                $pdf->Cell(35, 4, 'METODO DE PAGO:', '0', 0, 'L');
                $pdf->SetFont('Arial', '', '6');
                $pdf->Cell(135, 4, $factura->getMetodoDePago() . " - " . $factura->getMetodoDePagoNombre(), '0', 1, 'L');

                $pdf->SetFont('Arial', 'B', '6');
                $pdf->Cell(35, 4, 'FORMA DE PAGO:', '0', 0, 'L');

                $pagoConTarjeta = null;
                $salto = 1;
                if ($factura->getFormaDePago() == '04') {
                    $salto = 0;
                    $pagoConTarjeta = true;
                }

                $pdf->SetFont('Arial', '', '6');
                $pdf->Cell(135, 4, $factura->getFormaDePago() . " - " . utf8_decode($factura->getFormaDePagoNombre()), '0', $salto, 'L');

                if ($pagoConTarjeta) {
                    $pdf->SetFont('Arial', 'B', '6');
                    $pdf->Cell(25, 4, 'NUM DE CUENTA:', '0', 0, 'L');
                    $pdf->SetFont('Arial', '', '8');
                    $pdf->Cell(25, 4, $factura->getNumCuentaPago(), '0', 1, 'L');
                }

                $pdf->SetFont('Arial', 'B', '6');
                $pdf->Cell(35, 4, 'IMPORTE CON LETRA:', '0', 0, 'L');
                $numeroALetra = new NumeroALetra();
                $pdf->SetFont('Arial', '', '6');
                $pdf->Cell(135, 4, $numeroALetra->numALetras($datosComprobante['Total']), '0', 1, 'L');

                $pdf->SetFont('Arial', 'B', '6');
                $pdf->Cell(35, 4, 'MONEDA:', '0', 0, 'L');
                $pdf->SetFont('Arial', '', '6');
                $pdf->Cell(135, 4, $factura->getMoneda() . " - " . $factura->getMonedaNombre(), '0', 1, 'L');

                $pdf->SetFont('Arial', 'B', '6');
                $pdf->Cell(35, 4, 'CFDI RELACIONADOS:', '0', 1, 'L');
                $pdf->SetFont('Arial', '', '6');

                if ($factura->getUUIDsRelacionados()) {
                    $pdf->MultiCell(160, 5,$factura->getUUIDsRelacionados(), 'TB', 1);
                    $pdf->ln(2);
                }

                if (trim($factura->getComentarios()) != '') {
                    $pdf->SetFont('Arial', 'BU', '8');
                    $pdf->MultiCell(190, 5, "Comentarios:", "T");
                    $pdf->SetFont('Arial', '', '7');
                    $pdf->MultiCell(190, 5, $factura->getComentarios(), 'B', 1);
                    $pdf->ln(2);
                }

                $pdf->ln(1);
                $pdf->SetFont('Arial', 'B', '6');
                $pdf->Cell(190, 3, 'Este documento es una representacion impresa de un CFDI', '0', 1, 'C');
                $pdf->SetFont('Arial', '', '6');
                $pdf->Cell(190, 3, 'Version del comprobante: 3.3', 'B', 1, 'C');
                $pdf->ln(1);

                //Crear codigo
                if (!is_dir(PATH_SAT_DOCS . $factura->getSucursal() . "/temp-qr/")) {
                    mkdir(PATH_SAT_DOCS . $factura->getSucursal() . "/temp-qr/", 0777, true);
                }
                $yQrcode = $pdf->GetY();
                QRcode::png('?re='.$empresa->getRFC().'&rr='.$cliente->getRFC().'&tt='.$factura->getTotalParaCodigoQR().'&id='.$factura->getUUID(), PATH_SAT_DOCS.$factura->getSucursal()."/temp-qr/qrCode".$factura->getSerie()."-".$factura->getFolio().".png", 'Q', 3); // creates file
                $pdf->Image(PATH_SAT_DOCS.$factura->getSucursal()."/temp-qr/qrCode".$factura->getSerie()."-".$factura->getFolio().".png", 10, $yQrcode, 30, 0);

                $pdf->ln(1);
                break;
        }

        $pdf->SetFont('Arial', '', '6');
        $pdf->Cell(40, 6, '', '0', 0, 'L'); // left margin
        $pdf->Cell(40, 6, 'Folio fiscal:', '0', 0, 'R');
        $pdf->Cell(80, 6, $factura->getUUID(), '0', 1, 'L');

        $pdf->Cell(40, 6, '', '0', 0, 'L'); // left margin
        $pdf->Cell(40, 6, 'Serie del certificado del emisor:', '0', 0, 'R');
        $pdf->Cell(80, 6, $empresa->getNumCertificado(), '0', 1, 'L');

        $pdf->Cell(40, 6, '', '0', 0, 'L'); // left margin
        $pdf->Cell(40, 6, 'Serie cel certificado del SAT:', '0', 0, 'R');
        $pdf->Cell(80, 6, $factura->getNumCertificadoSAT(), '0', 1, 'L');

        $pdf->Cell(40, 6, '', '0', 0, 'L'); // left margin
        $pdf->Cell(40, 6, 'Fecha y hora de certificacion:', '0', 0, 'R');
        $pdf->Cell(80, 6, $factura->getFechaTimbrado(), '0', 0, 'L');

        $pdf->ln(10);
        $pdf->Cell(170, 3, 'Sello digital del CFDI', 'B', 1, 'L'); // left margin
        $pdf->MultiCell(170, 3, $factura->getSelloCFDI(), '0', 1);

        $pdf->Cell(170, 3, 'Sello del SAT', 'B', 1, 'L'); // left margin
        $pdf->MultiCell(170, 3, $factura->getSelloSAT(), '0', 1);

        $pdf->Cell(170, 3, 'Cadena original del complemento de certificacion digital del SAT', 'B', 1, 'L'); // left margin
        $pdf->MultiCell(170, 3, $factura->getCadenaOriginalSAT(), '0', 1);

        $idFacturaCuentaDeGastos = $factura->existCuentaDeGastos($idFactura);
        if ($idFacturaCuentaDeGastos) {
            $cuentaDeGastos = $factura->getFacturaDetallesSaved($idFacturaCuentaDeGastos);
            if ($cuentaDeGastos) {
                $totalCuentaDeGastos = 0;
                $pdf->Ln(2);
                //$pdf->SetFillColor(200,250,200);
                //$pdf->SetDrawColor(0,0,255);
                //$pdf->SetTextColor(0,255,0);
                $pdf->SetFont('Arial', 'B', '6');
                $pdf->Cell(150, 3, "GASTOS POR CUENTA DEL CLIENTE", 'B', 1, 'C');
                $pdf->Cell(135, 3, "DESCRIPCION", 'B', 0, 'L');
                $pdf->Cell(15, 3, "TOTAL", 'B', 1, 'R');

                $pdf->SetFont('Arial', '', '6');
                foreach ($cuentaDeGastos as $gasto) {
                    $totalCuentaDeGastos += $gasto['precio_unitario'];
                    $pdf->Cell(135, 7, $gasto['nombre'] . "\n" . $gasto['descripcion'], 'B', 0, 'L');
                    $pdf->Cell(15, 7, "$" . number_format($gasto['precio_unitario'], 2), 'B', 1, 'R');
                }


                $pdf->SetFont('Arial', 'B', '6');
                $pdf->Cell(135, 5, "TOTAL CUENTA DE GASTOS", '', 0, 'R');

                $pdf->SetFont('Arial', '', '6');
                $pdf->Cell(15, 5, "$" . number_format($totalCuentaDeGastos, 2), '', 1, 'R');

                $pdf->SetFont('Arial', 'B', '6');
                $pdf->Cell(135, 5, "GRAN TOTAL DE FACTURA", '', 0, 'R');

                $pdf->SetFont('Arial', '', '6');
                $pdf->Cell(15, 5, "$" . number_format($datosComprobante['Total'] + $totalCuentaDeGastos, 2), '', 1, 'R');

                $num2letra = new NumeroALetra();
                $granTotalLetra = $num2letra->numALetras($datosComprobante['Total'] + $totalCuentaDeGastos);

                $pdf->SetFont('Arial', 'B', '6');
                $pdf->Cell(35, 5, "IMPORTE CON LETRA: ", '', 0, 'L');

                $pdf->SetFont('Arial', '', '6');
                $pdf->Cell(180, 5, $granTotalLetra, '', 1, 'L');
            }
        }


        if ($createFile) {
            if (!is_dir(PATH_SAT_DOCS . $factura->getSucursal() . "/temp-pdf/")) {
                mkdir(PATH_SAT_DOCS . $factura->getSucursal() . "/temp-pdf/", 0777, true);
            }
            $pdf->Output(PATH_SAT_DOCS . $factura->getSucursal() . "/temp-pdf/Factura-" . $factura->getSerie() . "-" . $factura->getFolio() . ".pdf", "F");
            $this->pathfFileCreated = PATH_SAT_DOCS . $factura->getSucursal() . "/temp-pdf/Factura-" . $factura->getSerie() . "-" . $factura->getFolio() . ".pdf";
        } else {
            $pdf->Output();
        }
    }

    public function getChunksLength($chunks)
    {
        $accum = 0;
        foreach ($chunks as $chunk) {
            $accum += strlen($chunk);
        }

        return $accum;
    }

    public function getPathFileCreated()
    {
        return $this->pathfFileCreated;
    }
}
