<?php
class NotaCreditoPDF
{
    private $pathfFileCreated = null;
    public function __construct($idFactura, $createFile = null)
    {
        $factura = new NotaCreditoRepository();
        $factura->setOptions($factura->getById($idFactura));
        $factura->setId($idFactura);
        
        $cliente = new ClienteRepository();
        $cliente->setOptions($cliente->getById($factura->getIdCliente()));
        
        $empresa = new EmpresaRepository();
        $empresa->setOptions($empresa->getById(1));
        
        $sucursal = new SucursalRepository();
        $sucursal->setOptions($sucursal->getById($factura->getSucursal()));
        
        //Modifique metodo AddPage para qe ricibiera un tercer parametro, dicho parametro contiene el texto para a marca de agua.
        // para crear la marca de agua agregue las funciones Header y RotatedText en pdf.php
        $pdf = new PDF();
        if ($factura->getStatus() =='3') {
            $pdf->AddPage('', '', 'Cancelada');
        } else {
            $pdf->AddPage('', '');
        }

        $pdf->SetFillColor(51, 153, 255);
        $pdf->SetY(7);
        
        switch ($factura->getVersionCFDI()) {
            case '3.2':
                $pdf->SetFont('Arial', '', '14');
                $pdf->SetTextColor(255);
                $pdf->SetFillColor(51, 153, 255);
                $pdf->SetX(0);
                    $pdf->Cell(80, 10, "NOTA DE CREDITO ".$factura->getNumFactura(), '0', 0, 'R', true);
                $pdf->Cell(10, 10, "", '', 0, 'C'); //<== margin left
                $pdf->SetTextColor(0);
                $pdf->Cell(110, 10, $empresa->getNombre(), 'L', 1, 'R');
                $pdf->SetX(0);
                $pdf->SetFont('Arial', '', '12');
                $pdf->Cell(80, 7, 'FECHA '.$factura->getFechaFactura(), '', 0, 'R');
                $pdf->Cell(10, 7, "", '', 0, 'C'); //<== margin left
                $pdf->SetFont('Arial', '', '12');
                $pdf->cell(110, 3, $empresa->getPaginaWeb(), 'L', 1, 'R');

                $pdf->Ln(1);
                $pdf->SetFont('Arial', '', '8');
                $pdf->SetTextColor(0);

                $direccion = $empresa->getRFC();
                $direccion .="\n".utf8_decode($empresa->getCalleNum());
                $direccion .= "\n".utf8_decode($empresa->getColonia()).' '.$empresa->getCodigoPostal();
                $direccion .= "\n".utf8_decode($empresa->getCiudad()).', '.utf8_decode($empresa->getEstado());
                $direccion .= "\n".$empresa->getTelefono();
                $pdf->Cell(190, 28, $direccion, '0', 1, 'R');

                $pdf->SetFont('Arial', 'B', '8');
                $pdf->cell(100, 4, 'CLIENTE:', '', 0, 'L');
                $pdf->Cell(20, 4, "", '', 0, 'C'); //<== margin left
                $pdf->cell(98, 4, 'EXPEDIDO EN:', '', 1, 'L');

                $pdf->SetFont('Arial', '', '8');
                $pdf->Cell(120, 4, utf8_decode($cliente->getRazonSocial()), '0', 0, 'L');
                $pdf->Cell(80, 4, utf8_decode($sucursal->getNombre()), '0', 1, 'L');

                $pdf->Cell(120, 4, $cliente->getRFC(), '0', 0, 'L');
                $pdf->Cell(80, 4, utf8_decode($sucursal->getCalle())." ".$sucursal->getNumExterior()." ".$sucursal->getNumInterior(), '0', 1, 'L');

                $pdf->Cell(120, 4, utf8_decode($cliente->getCalle())." ".$cliente->getNumExterior()." ".$cliente->getNumInterior(), '0', 0, 'L');
                $pdf->Cell(80, 4, utf8_decode($sucursal->getColonia())." ".$sucursal->getCodigoPostal(), '0', 1, 'L');

                $pdf->Cell(120, 4, utf8_decode($cliente->getColonia())." ".$cliente->getCodigoPostal(), '0', 0, 'L');
                $pdf->Cell(80, 4, utf8_decode($sucursal->getCiudad())." ".$sucursal->getEstado(), '0', 1, 'L');

                $pdf->Cell(80, 4, utf8_decode($cliente->getCiudad())." ".$cliente->getEstado(), '0', 1, 'L');
                //exit;
                $pdf->Ln(5);
                $pdf->SetFont('Arial', 'B', '8');
                $pdf->Cell(20, 4, "CANTIDAD", 'B', 0, 'C');
                $pdf->Cell(20, 4, "UNIDAD", 'B', 0, 'C');
                $pdf->Cell(110, 4, "DESCRIPCION", 'B', 0, 'L');
                $pdf->Cell(20, 4, "MONTO", 'B', 0, 'R');
                $pdf->Cell(20, 4, "TOTAL", 'B', 1, 'R');

                $pdf->SetFont('Arial', '', '8');
                $conceptos = $factura->getConceptos();

                if ($conceptos) {
                    foreach ($conceptos as $concepto) {
                        $pdf->Cell(20, 7, $concepto['cantidad'], '0', 0, 'C');
                        $pdf->Cell(20, 7, $concepto['unidad'], '0', 0, 'C');
                        $pdf->Cell(110, 7, htmlentities($concepto['descripcion']), '0', 0, 'L');
                        $pdf->Cell(20, 7, '$'.number_format($concepto['valorUnitario'], 2), '0', 0, 'R');
                        $pdf->Cell(20, 7, '$'.number_format($concepto['importe'], 2), '0', 1, 'R');
                    }
                }

                $datosComprobante = $factura->getDatosComprobante();
                $pdf->SetFont('Arial', 'B', '8');
                $pdf->Cell(170, 4, 'SUBTOTAL', 'T', 0, 'R');
                $pdf->SetFont('Arial', '', '8');
                $pdf->Cell(20, 4, '$'.number_format($datosComprobante['subTotal'], 2), 'T', 1, 'R');

                /* IMPUESTOS */
                $impuestosAplicables = $factura->getImpuestosAplicables();
                if (count($impuestosAplicables['Retenible']) > 0) {
                    foreach ($impuestosAplicables['Retenible'] as $impuestoAplicable) {
                        $pdf->Cell(170, 4, $impuestoAplicable['nombre'], '0', 0, 'R');
                        $pdf->SetFont('Arial', '', '8');
                        $pdf->Cell(20, 4, '$'.number_format($impuestoAplicable['monto'], 2), '0', 1, 'R');
                    }
                }

                if (count($impuestosAplicables['Trasladable']) > 0) {
                    foreach ($impuestosAplicables['Trasladable'] as $impuestoAplicable) {
                        $pdf->Cell(170, 4, $impuestoAplicable['nombre'], '0', 0, 'R');
                        $pdf->SetFont('Arial', '', '8');
                        $pdf->Cell(20, 4, '$'.number_format($impuestoAplicable['monto'], 2), '0', 1, 'R');
                    }
                }
                /* FIN IMPUESTOS*/

                $pdf->SetFont('Arial', 'B', '8');
                $pdf->Cell(170, 4, 'TOTAL', 'T', 0, 'R');
                $pdf->SetFont('Arial', '', '8');
                $pdf->Cell(20, 4, '$'.number_format($datosComprobante['total'], 2), 'T', 1, 'R');

                $pdf->SetFont('Arial', 'B', '8');
                $pdf->Cell(35, 4, 'METODO DE PAGO:', '0', 0, 'L');

                $pagoConTarjeta = null;
                $salto = 1;
                if ($factura->getMetodoDePago() == '04') {
                    $salto = 0;
                    $pagoConTarjeta = true;
                }

                $pdf->SetFont('Arial', '', '8');
                $pdf->Cell(40, 4, $factura->getMetodoDePagoNombre(), '0', $salto, 'L');

                if ($pagoConTarjeta) {
                    $pdf->SetFont('Arial', 'B', '8');
                    $pdf->Cell(25, 4, 'NUM DE CUENTA:', '0', 0, 'L');
                    $pdf->SetFont('Arial', '', '8');
                    $pdf->Cell(25, 4, $factura->getNumCuentaPago(), '0', 1, 'L');
                }

                $pdf->SetFont('Arial', 'B', '8');
                $pdf->Cell(35, 4, 'IMPORTE CON LETRA:', '0', 0, 'L');
                $numeroALetra = new NumeroALetra();
                $pdf->SetFont('Arial', '', '8');
                $pdf->Cell(135, 4, $numeroALetra->numALetras($datosComprobante['total']), '0', 1, 'L');
                
                if (trim($factura->getComentarios()) != '') {
                    $msgArray = explode("<br />", nl2br($factura->getComentarios()));
                    $msg = "";

                    foreach ($msgArray as $line) {
                        $msg .= $line."\n";
                    }

                    $pdf->SetFont('Arial', '', '8');
                    $pdf->Cell(190, 15, $msg, 'TB', 1, 'L');

                    $pdf->ln(2);
                }

                //Crear codigo
                if (!is_dir(PATH_SAT_DOCS.$factura->getSucursal()."/temp-qr/")) {
                    mkdir(PATH_SAT_DOCS.$factura->getSucursal()."/temp-qr/", 0777, true);
                }
                $yQrcode = $pdf->GetY();
                \PHPQRCode\QRcode::png('?re='.$empresa->getRFC().'&rr='.$cliente->getRFC().'&tt='.$factura->getTotalParaCodigoQR().'&id='.$factura->getUUID(), PATH_SAT_DOCS.$factura->getSucursal()."/temp-qr/qrCode".$factura->getSerie()."-".$factura->getFolio().".png", 'Q', 3); // creates file
                $pdf->Image(PATH_SAT_DOCS.$factura->getSucursal()."/temp-qr/qrCode".$factura->getSerie()."-".$factura->getFolio().".png", 10, $yQrcode, 30, 0);

                $pdf->ln(5);
                break;
            case '3.3':
                $pic = 'data://text/plain;base64,' . base64_encode($sucursal->getLogo());
                // extract dimensions from image $info = getimagesize($pic);
                $image_type = explode("/", $sucursal->getImageType());
                $pdf->Image($pic, 20, 5, 35, 30, $image_type[1]);

                $pdf->SetFont('Arial', '', '12');
                $pdf->SetTextColor(0);
                $pdf->Cell(190, 10, $empresa->getNombre()."\n".$empresa->getPaginaWeb(), '0', 1, 'R');

                $pdf->SetFont('Arial', '', '7');
                $direccion = $empresa->getRFC();
                $direccion .= "\n".$empresa->getRegimenFiscal()." - ".$empresa->getRegimenFiscalNombre();
                $direccion .="\n".utf8_decode($empresa->getCalleNum());
                $direccion .= "\n".utf8_decode($empresa->getColonia()).' '.$empresa->getCodigoPostal();
                $direccion .= "\n".utf8_decode($empresa->getCiudad()).', '.utf8_decode($empresa->getEstado());
                $direccion .= "\n".$empresa->getTelefono();
                $pdf->Cell(190, 15, $direccion, '0', 1, 'R');

                $pdf->ln(5);
                $pdf->SetFont('Arial', '', '12');
                $pdf->SetTextColor(255);
                $pdf->SetDrawColor(51, 153, 255);
                //$pdf->SetDrawColor(0);
                $pdf->SetX(0);
                $pdf->Cell(60, 2, '', '1', 1, 'R', true);
                $pdf->SetX(0);
                $pdf->Cell(60, 5, "NOTA DE CREDITO ".$factura->getNumFactura(), '1', 1, 'R', true);
                $pdf->SetTextColor(255);
                $pdf->SetX(0);
                $pdf->SetFont('Arial', '', '7');
                $pdf->Cell(60, 3, 'Tipo de comprobante: '.$factura->getTipoComprobante()." - ".$factura->getTipoComprobanteNombre(), '1', 1, 'R', true);
                $pdf->SetX(0);
                $pdf->Cell(60, 2, '', '1', 1, 'R', true);
                $pdf->SetFont('Arial', '', '10');
                $pdf->SetTextColor(0);
                $pdf->SetX(0);
                $pdf->Cell(60, 6, 'FECHA '.$factura->getFechaFactura(), '', 1, 'R');

                $pdf->Ln(1);
                $pdf->SetTextColor(0);
                $pdf->SetDrawColor(0);
                $pdf->SetFont('Arial', 'B', '8');
                $pdf->cell(100, 4, 'CLIENTE:', '', 0, 'L');
                $pdf->Cell(20, 4, "", '', 0, 'C'); //<== margin left
                $pdf->cell(98, 4, 'EXPEDIDO EN:', '', 1, 'L');

                $pdf->SetFont('Arial', '', '7');
                $pdf->Cell(120, 4, $cliente->getRazonSocial(), '0', 0, 'L');
                $pdf->Cell(80, 4, utf8_decode($sucursal->getNombre()), '0', 1, 'L');

                $pdf->Cell(120, 4, $cliente->getRFC(), '0', 0, 'L');
                $pdf->Cell(80, 4, utf8_decode($sucursal->getCalle())." ".$sucursal->getNumExterior()." ".$sucursal->getNumInterior(), '0', 1, 'L');

                $pdf->Cell(120, 4, "USO CFDI: ".$factura->getUsoCFDI()." - ".$factura->getUsoCFDINombre(), '0', 0, 'L');
                $pdf->Cell(80, 4, utf8_decode($sucursal->getColonia())." ".$sucursal->getCodigoPostal(), '0', 1, 'L');

                $pdf->Cell(120, 4, utf8_decode($cliente->getCalle())." ".$cliente->getNumExterior()." ".$cliente->getNumInterior(), '0', 0, 'L');
                $pdf->Cell(80, 4, utf8_decode($sucursal->getCiudad())." ".$sucursal->getEstado(), '0', 1, 'L');

                $pdf->Cell(120, 4, utf8_decode($cliente->getColonia())." ".$cliente->getCodigoPostal(), '0', 1, 'L');
                $pdf->Cell(80, 4, utf8_decode($cliente->getCiudad())." ".$cliente->getEstado(), '0', 1, 'L');
                //exit;
                $pdf->Ln(8);
                $pdf->SetFont('Arial', 'B', '6');
                $pdf->Cell(15, 5, "CANTIDAD", 'B', 0, 'C');
                $pdf->Cell(20, 5, "CLAVE SAT\nUNIDAD", 'B', 0, 'C');
                $pdf->Cell(20, 5, "CLAVE SAT\nPROD/SER", 'B', 0, 'C');
                $pdf->Cell(90, 5, "DESCRIPCION", 'B', 0, 'L');
                $pdf->Cell(20, 5, "VALOR UNIT.", 'B', 0, 'R');
                $pdf->Cell(25, 5, "IMPORTE", 'B', 1, 'R');

                $pdf->SetFont('Arial', '', '6');
                $conceptos = $factura->getConceptos();

                if ($conceptos) {
                    foreach ($conceptos as $concepto) {
                        $x = $pdf->GetX();
                        $y = $pdf->GetY();
                        
                        $pdf->SetXY($x + 55, $y);
                        $pdf->Multicell(90, 7, htmlentities($concepto['Descripcion']), 'B', 'L');
                        
                        $yDesc = $pdf->GetY() - $y;
                        
                        $pdf->SetXY($x, $y);
                        $pdf->Multicell(15, $yDesc, $concepto['Cantidad'], 'B', 'C');

                        $pdf->SetXY($x + 15, $y);
                        $pdf->Multicell(20, $yDesc, $concepto['ClaveUnidad'], 'B', 'C');

                        $pdf->SetXY($x + 35, $y);
                        $pdf->Multicell(20, $yDesc, $concepto['ClaveProdServ'], 'B', 'C');

                        $pdf->SetXY($x + 145, $y);
                        $pdf->Multicell(20, $yDesc, '$'.number_format($concepto['ValorUnitario'], 2), 'B', 'R');

                        $pdf->SetXY($x + 165, $y);
                        $pdf->Multicell(25, $yDesc, '$'.number_format($concepto['Importe'], 2), 'B', 'R');
                        
                        if ($y > 250) {
                            $pdf->addPage('P');
                            $pdf->SetFont('Arial', 'B', '6');
                            $pdf->Cell(15, 5, "CANTIDAD", 'B', 0, 'C');
                            $pdf->Cell(20, 5, "CLAVE SAT\nUNIDAD", 'B', 0, 'C');
                            $pdf->Cell(20, 5, "CLAVE SAT\nPROD/SER", 'B', 0, 'C');
                            $pdf->Cell(90, 5, "DESCRIPCION", 'B', 0, 'L');
                            $pdf->Cell(20, 5, "VALOR UNIT.", 'B', 0, 'R');
                            $pdf->Cell(25, 5, "IMPORTE", 'B', 1, 'R');

                            $pdf->SetFont('Arial', '', '6');
                            $x = $pdf->GetX();
                            $y = $pdf->GetY();
                        }
                    }
                }

                $datosComprobante = $factura->getDatosComprobante();
                $pdf->SetFont('Arial', 'B', '6');
                $pdf->Cell(170, 4, 'SUBTOTAL', 'T', 0, 'R');
                $pdf->SetFont('Arial', '', '6');
                $pdf->Cell(20, 4, '$'.number_format($datosComprobante['SubTotal'], 2), 'T', 1, 'R');

                /* IMPUESTOS */
                $impuestosAplicables = $factura->getImpuestosAplicables();
                if (count($impuestosAplicables['Retenible']) > 0) {
                    foreach ($impuestosAplicables['Retenible'] as $impuestoAplicable) {
                        $pdf->Cell(170, 4, $impuestoAplicable['descripcion'], '0', 0, 'R');
                        $pdf->SetFont('Arial', '', '6');
                        $pdf->Cell(20, 4, '$'.number_format($impuestoAplicable['Importe'], 2), '0', 1, 'R');
                    }
                }

                if (count($impuestosAplicables['Trasladable']) > 0) {
                    foreach ($impuestosAplicables['Trasladable'] as $impuestoAplicable) {
                        $pdf->Cell(170, 4, $impuestoAplicable['descripcion'], '0', 0, 'R');
                        $pdf->SetFont('Arial', '', '6');
                        $pdf->Cell(20, 4, '$'.number_format($impuestoAplicable['Importe'], 2), '0', 1, 'R');
                    }
                }
                /* FIN IMPUESTOS*/

                $pdf->SetFont('Arial', 'B', '6');
                $pdf->Cell(170, 4, 'TOTAL', 'T', 0, 'R');
                $pdf->SetFont('Arial', '', '6');
                $pdf->Cell(20, 4, '$'.number_format($datosComprobante['Total'], 2), 'T', 1, 'R');

                $pdf->SetFont('Arial', 'B', '6');
                $pdf->Cell(35, 4, 'METODO DE PAGO:', '0', 0, 'L');
                $pdf->SetFont('Arial', '', '6');
                $pdf->Cell(135, 4, $factura->getMetodoDePago()." - ".$factura->getMetodoDePagoNombre(), '0', 1, 'L');

                $pdf->SetFont('Arial', 'B', '6');
                $pdf->Cell(35, 4, 'FORMA DE PAGO:', '0', 0, 'L');

                $pagoConTarjeta = null;
                $salto = 1;
                if ($factura->getFormaDePago() == '04') {
                    $salto = 0;
                    $pagoConTarjeta = true;
                }

                $pdf->SetFont('Arial', '', '6');
                $pdf->Cell(135, 4, $factura->getFormaDePago()." - ".utf8_decode($factura->getFormaDePagoNombre()), '0', $salto, 'L');

                if ($pagoConTarjeta) {
                    $pdf->SetFont('Arial', 'B', '6');
                    $pdf->Cell(25, 4, 'NUM DE CUENTA:', '0', 0, 'L');
                    $pdf->SetFont('Arial', '', '8');
                    $pdf->Cell(25, 4, $factura->getNumCuentaPago(), '0', 1, 'L');
                }

                $pdf->SetFont('Arial', 'B', '6');
                $pdf->Cell(35, 4, 'IMPORTE CON LETRA:', '0', 0, 'L');
                $numeroALetra = new NumeroALetra();
                $pdf->SetFont('Arial', '', '6');
                $pdf->Cell(135, 4, $numeroALetra->numALetras($datosComprobante['Total']), '0', 1, 'L');

                $pdf->SetFont('Arial', 'B', '6');
                $pdf->Cell(35, 4, 'MONEDA:', '0', 0, 'L');
                $pdf->SetFont('Arial', '', '6');
                $pdf->Cell(135, 4, $factura->getMoneda()." - ".$factura->getMonedaNombre(), '0', 1, 'L');
                
                $pdf->SetFont('Arial', 'B', '6');
                $pdf->Cell(35, 4, 'CFDI RELACIONADOS:', '0', 1, 'L');
                $pdf->SetFont('Arial', '', '6');
                
                if ($factura->getCFDIRelacionados()) {
                    $pdf->MultiCell(160, 5, implode(',', $factura->getCFDIRelacionados()), 'TB', 1);
                    $pdf->ln(2);
                }
                
                if (trim($factura->getComentarios()) != '') {
                    $pdf->MultiCell(160, 5, ($factura->getComentarios()), 'TB', 1);
                    $pdf->ln(2);
                }

                $pdf->ln(1);
                $pdf->SetFont('Arial', 'B', '6');
                $pdf->Cell(190, 3, 'Este documento es una representacion impresa de un CFDI', '0', 1, 'C');
                $pdf->SetFont('Arial', '', '6');
                $pdf->Cell(190, 3, 'Version del comprobante: 3.3', 'B', 1, 'C');
                $pdf->ln(1);

                //Crear codigo
                if (!is_dir(PATH_SAT_DOCS.$factura->getSucursal()."/temp-qr/")) {
                    mkdir(PATH_SAT_DOCS.$factura->getSucursal()."/temp-qr/", 0777, true);
                }
                $yQrcode = $pdf->GetY();
                //QRcode::png('?re='.$empresa->getRFC().'&rr='.$cliente->getRFC().'&tt='.$factura->getTotalParaCodigoQR().'&id='.$factura->getUUID(),PATH_SAT_DOCS.$factura->getSucursal()."/temp-qr/qrCode".$factura->getSerie()."-".$factura->getFolio().".png",'Q',3); // creates file
                //$pdf->Image(PATH_SAT_DOCS.$factura->getSucursal()."/temp-qr/qrCode".$factura->getSerie()."-".$factura->getFolio().".png",10,$yQrcode,30,0);

                $pdf->ln(1);
                break;
        }
        
        $pdf->SetFont('Arial', '', '6');
        $pdf->Cell(40, 6, '', '0', 0, 'L');// left margin
        $pdf->Cell(23, 6, 'Folio fiscal:', '0', 0, 'R');
        $pdf->Cell(80, 6, $factura->getUUID(), '0', 1, 'L');
        
        $pdf->Cell(40, 6, '', '0', 0, 'L');// left margin
        $pdf->Cell(42, 6, 'Serie del certificado del emisor:', '0', 0, 'R');
        $pdf->Cell(80, 6, $empresa->getNumCertificado(), '0', 1, 'L');
        
        $pdf->Cell(40, 6, '', '0', 0, 'L');// left margin
        $pdf->Cell(40, 6, 'Serie cel certificado del SAT:', '0', 0, 'R');
        $pdf->Cell(80, 6, $factura->getNumCertificadoSAT(), '0', 1, 'L');
        
        $pdf->Cell(40, 6, '', '0', 0, 'L');// left margin
        $pdf->Cell(41, 6, 'Fecha y hora de certificacion:', '0', 0, 'R');
        $pdf->Cell(80, 6, $factura->getFechaTimbrado(), '0', 0, 'L');
        
        $pdf->ln(10);
        $pdf->Cell(170, 3, 'Sello digital del CFDI', 'B', 1, 'L');// left margin
        $pdf->MultiCell(170, 3, $factura->getSelloCFDI(), '0', 1);
        
        $pdf->Cell(170, 3, 'Sello del SAT', 'B', 1, 'L');// left margin
        $pdf->MultiCell(170, 3, $factura->getSelloSAT(), '0', 1);
        
        $pdf->Cell(170, 3, 'Cadena original del complemento de certificacion digital del SAT', 'B', 1, 'L');// left margin
        $pdf->MultiCell(170, 3, $factura->getCadenaOriginalSAT(), '0', 1);
        if ($createFile) {
            if (!is_dir(PATH_SAT_DOCS.$factura->getSucursal()."/temp-pdf/")) {
                mkdir(PATH_SAT_DOCS.$factura->getSucursal()."/temp-pdf/", 0777, true);
            }
            $pdf->Output(PATH_SAT_DOCS.$factura->getSucursal()."/temp-pdf/NotaCredito-".$factura->getSerie()."-".$factura->getFolio().".pdf", "F");
            $this->pathfFileCreated = PATH_SAT_DOCS.$factura->getSucursal()."/temp-pdf/NotaCredito-".$factura->getSerie()."-".$factura->getFolio().".pdf";
        } else {
            $pdf->Output();
        }
    }
    
    public function getPathFileCreated()
    {
        return $this->pathfFileCreated;
    }
}
