<?php
class PagoPDF
{
    private $pathfFileCreated = null;
    public function __construct($idPago, $createFile = null)
    {
        $pago = new PagoRepository();
        $pago->setOptions($pago->getById($idPago));
        $pago->setId($idPago);

        $cliente = new ClienteRepository();
        $cliente->setOptions($cliente->getById($pago->getCliente()));

        $empresa = new EmpresaRepository();
        $empresa->setOptions($empresa->getById(1));

        //Modifique metodo AddPage para qe ricibiera un tercer parametro, dicho parametro contiene el texto para a marca de agua.
        // para crear la marca de agua agregue las funciones Header y RotatedText en pdf.php
        $pdf = new PDF();
        if ($pago->getStatus() =='3') {
            $pdf->AddPage('', '', 'Cancelado');
        } else {
            $pdf->AddPage('', '');
        }

        $pdf->SetFillColor(51, 153, 255);
        $pdf->SetY(7);
        $pic = 'data://text/plain;base64,' . base64_encode($empresa->getLogo());
        // extract dimensions from image $info = getimagesize($pic);
        $image_type = explode("/", $empresa->getImageType());
        $pdf->Image($pic, 20, 5, 35, 30, $image_type[1]);

        $pdf->SetFont('Arial', '', '12');
        $pdf->SetTextColor(0);
        $pdf->Cell(190, 10, $empresa->getNombre()."\n".$empresa->getPaginaWeb(), '0', 1, 'R');

        $pdf->SetFont('Arial', '', '7');
        $direccion = $empresa->getRFC();
        $direccion .= "\n".$empresa->getRegimenFiscal()." - ".$empresa->getRegimenFiscalNombre();
        $direccion .="\n".utf8_decode($empresa->getCalleNum());
        $direccion .= "\n".utf8_decode($empresa->getColonia()).' '.$empresa->getCodigoPostal();
        $direccion .= "\n".utf8_decode($empresa->getCiudad()).', '.utf8_decode($empresa->getEstado());
        $direccion .= "\n".$empresa->getTelefono();
        $pdf->Cell(190, 15, $direccion, '0', 1, 'R');

        $pdf->ln(5);
        $pdf->SetFont('Arial', '', '12');
        $pdf->SetTextColor(255);
        $pdf->SetDrawColor(51, 153, 255);
        //$pdf->SetDrawColor(0);
        $pdf->SetX(0);
        $pdf->Cell(60, 2, '', '1', 1, 'R', true);
        $pdf->SetX(0);
        $pdf->Cell(60, 5, "PAGO ".$pago->getNumPago(), '1', 1, 'R', true);
        $pdf->SetTextColor(255);
        $pdf->SetX(0);
        $pdf->SetFont('Arial', '', '7');
        $pdf->Cell(60, 3, 'Tipo de comprobante: '.$pago->getTipoComprobante()." - ".$pago->getTipoComprobanteNombre(), '1', 1, 'R', true);
        $pdf->SetX(0);
        $pdf->Cell(60, 2, '', '1', 1, 'R', true);
        $pdf->SetFont('Arial', '', '10');
        $pdf->SetTextColor(0);
        $pdf->SetX(0);
        $pdf->Cell(60, 6, 'FECHA '.$pago->getFechaPago(), '', 1, 'R');

        $pdf->Ln(1);
        $pdf->SetTextColor(0);
        $pdf->SetDrawColor(0);
        $pdf->SetFont('Arial', 'B', '8');
        $pdf->cell(100, 4, 'FACTURADO A:', '', 0, 'L');
        $pdf->Cell(20, 4, "", '', 0, 'C'); //<== margin left
        $pdf->cell(98, 4, 'EXPEDIDO EN:', '', 1, 'L');

        $pdf->SetFont('Arial', '', '7');
        $pdf->Cell(120, 4, $cliente->getRazonSocial(), '0', 0, 'L');
        $pdf->Cell(80, 4, utf8_decode($empresa->getNombre()), '0', 1, 'L');

        $pdf->Cell(120, 4, $cliente->getRFC(), '0', 0, 'L');
        $pdf->Cell(80, 4, utf8_decode($empresa->getCalle())." ".$empresa->getNumExterior()." ".$empresa->getNumInterior(), '0', 1, 'L');

        $pdf->Cell(120, 4, "USO CFDI: ".$pago->getUsoCFDI()." - ".$pago->getUsoCFDINombre(), '0', 0, 'L');
        $pdf->Cell(80, 4, utf8_decode($empresa->getColonia())." ".$empresa->getCodigoPostal(), '0', 1, 'L');

        $pdf->Cell(120, 4, utf8_decode($cliente->getCalle())." ".$cliente->getNumExterior()." ".$cliente->getNumInterior(), '0', 0, 'L');
        $pdf->Cell(80, 4, utf8_decode($empresa->getCiudad())." ".$empresa->getEstado(), '0', 1, 'L');

        $pdf->Cell(120, 4, utf8_decode($cliente->getColonia())." ".$cliente->getCodigoPostal(), '0', 1, 'L');

        $pdf->ln(4);
        $pdf->SetFont('Arial', 'B', '8');
        $pdf->cell(90, 4, 'BANCO ORDENANTE', 'B', 0, 'L');
        $dataBancoOrdenante = $pago->getDataBancoOrdenante();
        $dataCuentaOrdenante = $pago->getDataCuentaBancariaOrdenante();

        $pdf->SetFont('Arial', 'B', '8');
        $pdf->cell(100, 4, 'BANCO BENEFICIARIO', 'B', 1, 'L');
        $dataBancoBeneficiario = $pago->getDataBanco();
        $dataCuentaBancaria = $pago->getDataCuentaBancaria();

        $pdf->ln(1);
        $pdf->SetFont('Arial', 'B', '6');
        $pdf->Cell(30, 4, 'RFC:', '0', 0, 'L');
        $pdf->SetFont('Arial', '', '6');
        $pdf->Cell(60, 4, $dataBancoOrdenante['rfc'], '0', 0, 'L');

        $pdf->SetFont('Arial', 'B', '6');
        $pdf->Cell(30, 4, 'RFC:', '0', 0, 'L');
        $pdf->SetFont('Arial', '', '6');
        $pdf->Cell(60, 4, $dataBancoBeneficiario['rfc'], '0', 1, 'L');

        $pdf->SetFont('Arial', 'B', '6');
        $pdf->Cell(30, 4, 'CUENTA:', '0', 0, 'L');
        $pdf->SetFont('Arial', '', '6');
        $pdf->Cell(60, 4, $dataCuentaOrdenante['cuenta'], '0', 0, 'L');

        $pdf->SetFont('Arial', 'B', '6');
        $pdf->Cell(30, 4, 'CUENTA:', '0', 0, 'L');
        $pdf->SetFont('Arial', '', '6');
        $pdf->Cell(60, 4, $dataCuentaBancaria['cuenta'], '0', 1, 'L');

        $pdf->SetFont('Arial', 'B', '6');
        $pdf->Cell(30, 4, 'NOMBRE:', '0', 0, 'L');
        $pdf->SetFont('Arial', '', '6');
        $pdf->Cell(60, 4, $dataBancoOrdenante['descripcion'], '0', 0, 'L');

        $pdf->SetFont('Arial', 'B', '6');
        $pdf->Cell(30, 4, 'NOMBRE:', '0', 0, 'L');
        $pdf->SetFont('Arial', '', '6');
        $pdf->Cell(60, 4, $dataBancoBeneficiario['descripcion'], '0', 1, 'L');

        $pdf->ln(4);
        $pdf->SetFont('Arial', 'B', '8');
        $pdf->cell(190, 4, 'INFORMACION DEL PAGO', 'B', 1, 'L');

        $pdf->ln(1);
        $pdf->SetFont('Arial', 'B', '6');
        $pdf->Cell(30, 4, 'FORMA DE PAGO:', '0', 0, 'L');
        $pdf->SetFont('Arial', '', '6');
        $pdf->Cell(60, 4, $pago->getFormaDePago()." - ".$pago->getFormaDePagoNombre(), '0', 0, 'L');

        $pdf->SetFont('Arial', 'B', '6');
        $pdf->Cell(30, 4, 'MONEDA:', '0', 0, 'L');
        $pdf->SetFont('Arial', '', '6');
        $pdf->Cell(60, 4, $pago->getMoneda()." - ".$pago->getMonedaNombre(), '0', 1, 'L');

        $pdf->SetFont('Arial', 'B', '6');
        $pdf->Cell(30, 4, 'MONTO:', '0', 0, 'L');
        $pdf->SetFont('Arial', '', '6');
        $pdf->Cell(60, 4, number_format($pago->getMonto(), 2), '0', 0, 'L');

        $pdf->SetFont('Arial', 'B', '6');
        $pdf->Cell(30, 4, 'NUM. DE OPERACION:', '0', 0, 'L');
        $pdf->SetFont('Arial', '', '6');
        $pdf->Cell(60, 4, $pago->getNumOperacion(), '0', 1, 'L');

        $pdf->SetFont('Arial', 'B', '6');
        $pdf->Cell(30, 4, 'IMPORTE CON LETRA:', '0', 0, 'L');
        $numeroALetra = new NumeroALetra();
        $pdf->SetFont('Arial', '', '6');
        $pdf->Cell(60, 4, $numeroALetra->numALetras($pago->getMonto()), '0', 1, 'L');

        /*
        if(trim($pago->getComentarios()) != ''){
            $pdf->MultiCell(160, 5, nl2br($pago->getComentarios()),'TB',1);
            $pdf->ln(2);
        }  */

        $pdf->ln(4);
        $pdf->SetFont('Arial', 'B', '8');
        $pdf->cell(190, 4, 'DOCUMENTOS PAGADOS', 'B', 1, 'L');
        $pdf->SetFont('Arial', 'B', '6');
        $pdf->Cell(55, 4, "UUID", 'B', 0, 'C');
        $pdf->Cell(15, 4, "SERIE", 'B', 0, 'C');
        $pdf->Cell(15, 4, "FOLIO", 'B', 0, 'C');
        $pdf->Cell(15, 4, "MONEDA", 'B', 0, 'C');
        $pdf->Cell(30, 4, "TIPO DE CAMBIO", 'B', 0, 'C');
        $pdf->Cell(30, 4, "METODO DE PAGO", 'B', 0, 'C');
        $pdf->Cell(30, 4, "MONTO", 'B', 1, 'C');

        $detallesPago = $pago->getDetallesByIdPago($idPago);
        $pdf->SetFont('Arial', '', '6');
        foreach ($detallesPago as $detalle) {
            $pdf->Cell(55, 4, $detalle['uuid'], 'B', 0, 'C');
            $pdf->Cell(15, 4, $detalle['serie'], 'B', 0, 'C');
            $pdf->Cell(15, 4, $detalle['folio'], 'B', 0, 'C');
            $pdf->Cell(15, 4, $detalle['moneda'], 'B', 0, 'C');
            $pdf->Cell(30, 4, number_format($detalle['tipo_de_cambio'], 2), 'B', 0, 'C');
            $pdf->Cell(30, 4, $detalle['metodo_de_pago'], 'B', 0, 'C');
            $pdf->Cell(30, 4, number_format($detalle['monto'], 2), 'B', 1, 'C');
        }

        $pdf->ln(5);
        $pdf->SetFont('Arial', 'B', '6');
        $pdf->Cell(190, 3, 'Este documento es una representacion impresa de un CFDI', '0', 1, 'C');
        $pdf->SetFont('Arial', '', '6');
        $pdf->Cell(190, 3, 'Version del comprobante: 3.3', 'B', 1, 'C');
        $pdf->ln(1);

        //Crear codigo
        if (!is_dir(PATH_SAT_DOCS.$pago->getSucursal()."/Pagos/temp-qr/")) {
            mkdir(PATH_SAT_DOCS.$pago->getSucursal()."/Pagos/temp-qr/", 0777, true);
        }
        $yQrcode = $pdf->GetY();
        \PHPQRCode\QRcode::png('?re='.$empresa->getRFC().'&rr='.$cliente->getRFC().'&tt='.$pago->getTotalParaCodigoQR().'&id='.$pago->getUUID(), PATH_SAT_DOCS.$pago->getSucursal()."/Pagos/temp-qr/qrCode".$pago->getSerie()."-".$pago->getFolio().".png", 'Q', 3); // creates file
        $pdf->Image(PATH_SAT_DOCS.$pago->getSucursal()."/Pagos/temp-qr/qrCode".$pago->getSerie()."-".$pago->getFolio().".png", 10, $yQrcode, 30, 0);

        $pdf->ln(5);



        $pdf->SetFont('Arial', '', '7');
        $pdf->Cell(40, 6, '', '0', 0, 'L');// left margin
        $pdf->Cell(40, 6, 'Folio fiscal:', '0', 0, 'R');
        $pdf->Cell(80, 6, $pago->getUUID(), '0', 1, 'L');

        $pdf->Cell(40, 6, '', '0', 0, 'L');// left margin
        $pdf->Cell(40, 6, 'Serie del certificado del emisor:', '0', 0, 'R');
        $pdf->Cell(80, 6, $empresa->getNumCertificado(), '0', 1, 'L');

        $pdf->Cell(40, 6, '', '0', 0, 'L');// left margin
        $pdf->Cell(40, 6, 'Serie cel certificado del SAT:', '0', 0, 'R');
        $pdf->Cell(80, 6, $pago->getNumCertificadoSAT(), '0', 1, 'L');

        $pdf->Cell(40, 6, '', '0', 0, 'L');// left margin
        $pdf->Cell(40, 6, 'Fecha y hora de certificacion:', '0', 0, 'R');
        $pdf->Cell(80, 6, $pago->getFechaTimbrado(), '0', 0, 'L');

        $pdf->ln(10);
        $pdf->Cell(170, 5, 'Sello digital del CFDI', 'B', 1, 'L');// left margin
        $pdf->MultiCell(170, 5, $pago->getSelloCFDI(), '0', 1);

        $pdf->Cell(170, 5, 'Sello del SAT', 'B', 1, 'L');// left margin
        $pdf->MultiCell(170, 5, $pago->getSelloSAT(), '0', 1);

        $pdf->Cell(170, 5, 'Cadena original del complemento de certificacion digital del SAT', 'B', 1, 'L');// left margin
        $pdf->MultiCell(170, 5, $pago->getCadenaOriginalSAT(), '0', 1);

        if ($createFile) {
            if (!is_dir(PATH_SAT_DOCS."1/Pagos/temp-pdf/")) {
                mkdir(PATH_SAT_DOCS."1/Pagos/temp-pdf/", 0777, true);
            }
            $pdf->Output(PATH_SAT_DOCS."1/Pagos/temp-pdf/Pago-".$pago->getSerie()."-".$pago->getFolio().".pdf", "F");
            $this->pathfFileCreated = PATH_SAT_DOCS.$pago->getSucursal()."1/Pagos/temp-pdf/Pago-".$pago->getSerie()."-".$pago->getFolio().".pdf";
        } else {
            $pdf->Output();
        }
    }

    public function getPathFileCreated()
    {
        return $this->pathfFileCreated;
    }
}
