<?php
$controller = 'Sucursal';
$action = '';
if (isset($_POST['action'])) {
    $action = $_POST['action'];
    if (isset($_POST['id'])) {
        $id = $_POST['id'];
    }
} elseif (isset($_GET['action'])) {
    $action = $_GET['action'];
    if (isset($_GET['id'])) {
        $id = $_GET['id'];
    }
}
include $_SERVER["DOCUMENT_ROOT"].'/app/include/bootstrap.php';

$form = new SucursalForm();
$_sucursal = new SucursalRepository();
$_listSucursals = $_sucursal->getListSucursales();

switch ($action) {
    case 'insert':
        $form->populate($_POST);
        if ($form->isValid()) {
            $_sucursal->setOptions($_POST);
            $_sucursal->setImage($_FILES['logo']);
            $result = $_sucursal->save($_sucursal->getOptions());
            if ($result) {
                $flashmessenger->addMessage(array('success'=>'Genial !! La Sucursal se registro exitosamente.'));
                header('Location: Sucursal.php');
            } else {
                $flashmessenger->addMessage(array('danger'=>'Error. Intenta nuevamente o contacta a tu proveedor de sistemas.'));
                $vista = 'Sucursal.php';
                include $root.'/View/Template.php';
            }
        } else {
            $_noValid = true;
            $vista = 'Sucursal.php';
            include $root.'/View/Template.php';
        }
        break;
   
    case 'edit':
        if ($_GET) {
            $_sucursalData = $_sucursal->getById($id);
        }
        if ($_POST) {
            $_sucursalData = $_POST;
        }
        
        $form->setActionController('edit');
        $form->setId($id);
        $form->populate($_sucursalData);
        
        if (isset($_POST['id'])) {
            if ($form->isValid()) {
                $_sucursalData['archivos'] = $_FILES;
                $_sucursal->setOptions($_sucursalData);
                $_sucursal->setImage($_FILES['logo']);
                $result = $_sucursal->update($id, $_sucursal->getOptions()); //no tengo id porque viene de post
                if ($result) {
                    $flashmessenger->addMessage(array('success'=>'Estupendo !! La Sucursal se actualizo exitosamente.'));
                    header("Location: Sucursal.php");
                } else {
                    $flashmessenger->addMessage(array('danger'=>'Error. Intenta nuevamente o contacta a tu proveedor de sistemas.'));
                    $vista = 'Sucursal.php';
                    include $root.'/View/Template.php';
                }
            } else {
                $_noValid = true;
                $vista = 'Sucursal.php';
                include $root . '/View/Template.php';
            }
        } else {
            $vista = 'Sucursal.php';
            include $root . '/View/Template.php';
        }
        break;
    
    case 'delete':
        if (!$_sucursal->isUsedInRecord($id)) {
            if ($_sucursal->delete($id)) {
                $flashmessenger->addMessage(array('success'=>'Hecho !! La Sucursal fue eliminada satisfactoriamente.'));
            }
        } else {
            $message = 'Hola !! este Sucursal no puede ser eliminado, esta siendo utilizado en almenos un registro.';
            $flashmessenger->addMessage(array('info'=>$message));
        }
        header('Location: Sucursal.php');
        break;
    
    case 'ajax':
        $ajaxEmpresa = new SucursalAjax();
        $json = $ajaxEmpresa->getResponse($_POST['request'], $_POST);
        
        echo json_encode($json);
        break;
    
    default:
        $vista = 'Sucursal.php';
        include $root.'/View/Template.php';
}
