<?php
/**
 * Description of DatosFiscalesDestinatario
 *
 * @author carlos
 */

class ClienteEntity Extends ClienteRepository{
    private $options = array(
        'codigo'=>null,
        'razon_social'=>null,
        'rfc'=>null,
        'calle'=>null,
        'numero_exterior'=>null,
        'numero_interior'=>null,
        'colonia'=>null,
        'ciudad'=>null,
        'estado'=>null,
        'pais'=>'MEXICO',
        'codigo_postal'=>null,
        'nombre_contacto'=>null,
        'telefono'=>null,
        'email'=>null,
        'comentarios'=>null,
    );
    
    public function __construct($idAlumno = null) {
        if($idAlumno){
            $this->setOptions($this->getByIdAlumno($idAlumno));
        }
    }
    
    public function setOptions($data){
      foreach ($this->options as $option => $value){
          if(isset($data[$option])){
            $this->options[$option] = $data[$option];
          }
      }
      if(isset($data['id'])){$this->setId($data['id']);}
    }
  
    public function getOptions(){
        return $this->options;
    }
    
    public function getNombre(){
        //return $this->options['nombre'];
    }
    
    public function getRazonSocial(){
        return $this->options['razon_social'];
    }
    
    public function getRFC(){
        return $this->options['rfc'];
    }
    
    public function getCalle(){
        return $this->options['calle'];
    }
    
    public function getNumExterior(){
        return $this->options['numero_exterior'];
    }
    
    public function getNumInterior(){
        return $this->options['numero_interior'];
    }
    
    public function getCalleNum(){
        $direccion = $this->getCalle().' '.$this->getNumExterior();
        if(trim($this->getNumInterior())!=''){$direccion .= ' No. INT. '.$this->getNumInterior();}        
        return $direccion;
    }
    
    public function getColonia(){
        return $this->options['colonia'];
    }
    
    public function getCiudad(){
        return $this->options['ciudad'];
    }
    
    public function getEstado(){
        return $this->options['estado'];
    }
    
    public function getCodigoPostal(){
        return $this->options['codigo_postal'];
    }
    
    public function getTable(){
        return $this->table;
    }
    
   public function pagination($pag){
      $paginacion = new Paginacion($pag);
      $paginacion->setQueryString("SELECT * FROM grupos");
      $paginacion->setLayout(new Tradicional(2));
      
      return $paginacion;
  }

}
