<?php
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

class ClienteRepository extends EntityRepository
{
    private $table = 'clientes';

    private $options = array(
        'codigo' => null,
        'razon_social' => null,
        'rfc' => null,
        'calle' => null,
        'numero_exterior' => null,
        'numero_interior' => null,
        'colonia' => null,
        'ciudad' => null,
        'estado' => null,
        'pais' => 'MEXICO',
        'codigo_postal' => null,
        'nombre_contacto' => null,
        'telefono' => null,
        'payment_terms' => null,
        'email' => null,
        'email2' => null, //pudin
        'comentarios' => null,
    );

    private $options_aux = array(
        'estadoNombre' => null
    );

    public function __construct($idAlumno = null)
    {
        if ($idAlumno) {
            $this->setOptions($this->getByIdAlumno($idAlumno));
        }
    }

    public function setOptions($data)
    {
        foreach ($this->options as $option => $value) {
            if (isset($data[$option])) {
                $this->options[$option] = $data[$option];
            }
        }

        foreach ($this->options_aux as $option => $value) {
            if (isset($data[$option])) {
                $this->options_aux[$option] = $data[$option];
            }
        }

        if (isset($data['id'])) {
            $this->setId($data['id']);
        }
    }

    public function getOptions()
    {
        return $this->options;
    }

    public function getNombre()
    {
        //return $this->options['nombre'];
    }

    public function getRazonSocial()
    {
        return $this->options['razon_social'];
    }

    public function getRFC()
    {
        return $this->options['rfc'];
    }

    public function getCalle()
    {
        return $this->options['calle'];
    }

    public function getNumExterior()
    {
        return $this->options['numero_exterior'];
    }

    public function getNumInterior()
    {
        return $this->options['numero_interior'];
    }

    public function getCalleNum()
    {
        $direccion = $this->getCalle() . ' ' . $this->getNumExterior();
        if (trim($this->getNumInterior()) != '') {
            $direccion .= ' No. INT. ' . $this->getNumInterior();
        }
        return $direccion;
    }

    public function getColonia()
    {
        return $this->options['colonia'];
    }

    public function getCiudad()
    {
        return $this->options['ciudad'];
    }

    public function getEstado()
    {
        return $this->options['estado'];
    }

    public function getEstadoNombre()
    {
        return $this->options_aux['estadoNombre'];
    }

    public function getCodigoPostal()
    {
        return $this->options['codigo_postal'];
    }

    public function getTable()
    {
        return $this->table;
    }

    public function pagination($pag)
    {
        $paginacion = new Paginacion($pag);
        $paginacion->setQueryString("SELECT * FROM grupos");
        $paginacion->setLayout(new Tradicional(2));

        return $paginacion;
    }

    public function save(array $data, $table = null)
    {
        $data['rfc'] = trim(strtoupper($data['rfc']));
        $data['razon_social'] = trim(strtoupper($data['razon_social']));
        $data['calle'] = trim(strtoupper($data['calle']));
        $data['numero_interior'] = trim(strtoupper($data['numero_interior']));
        $data['numero_exterior'] = trim(strtoupper($data['numero_exterior']));
        $data['colonia'] = trim(strtoupper($data['colonia']));
        unset($data['id'], $data['modificaciones']);

        foreach ($data as $key => $value) {
            $data[$key] = trim($value);
        }

        return parent::save($data, $this->table);
    }

    public function delete($id, $table = null)
    {
        return parent::delete($id, $this->table);
    }

    public function update($id, $data, $table = null)
    {
        $data['rfc'] = trim(strtoupper($data['rfc']));
        $data['razon_social'] = trim(strtoupper($data['razon_social']));
        $data['calle'] = trim(strtoupper($data['calle']));
        $data['numero_interior'] = trim(strtoupper($data['numero_interior']));
        $data['numero_exterior'] = trim(strtoupper($data['numero_exterior']));
        $data['colonia'] = trim(strtoupper($data['colonia']));

        foreach ($data as $key => $value) {
            $data[$key] = trim($value);
        }

        return parent::update($id, $data, $this->table);
    }

    public function getById($id, $table = null, $selectAux = null)
    {
        return parent::getById($id, $this->table, $selectAux);
    }

    public function getByIdAlumno($idAlumno)
    {
        $query = "SELECT * FROM datos_fiscales_destinatario WHERE id_alumno = '$idAlumno' LIMIT 1";
        $result = $this->query($query);

        if ($result->num_rows > 0) {
            $result =  $this->resultToArray($result);
            return $result[0];
        }
        return null;
    }

    public function isUsedInRecord($id, array $buscarEn = null, $andWhere = null)
    {
        return parent::isUsedInRecord($id, array('clientes' => 'id', 'facturas' => 'id_cliente', 'notas_de_credito' => 'id_cliente', 'pagos' => 'cliente'));
    }

    public function getListSelectClientes($clientId = null)
    {
        $select = " SELECT * FROM clientes ";

        if(!empty($clientId)) {
            $select .= " WHERE id = {$clientId} ";
        }

        $result = $this->query($select);

        if ($result) {
            $array = array();
            while ($row = $result->fetch_assoc()) {
                $array[$row['id']] = $row['codigo'].' - '.$row['razon_social'];
            }
            return $array;
        }
        return null;
    }

    public function getListClientes()
    {
        $select = "SELECT *,fxGetPaymentTermDays(payment_terms) as terminosPago FROM clientes ";
        $result = $this->query($select);

        if ($result) {
            return $this->resultToArray($result);
        }
        return null;
    }


    public function existeRFC($rfc, $idEditando = null)
    {
        $settings = new SettingsRepository();
        if ($settings->isRFCGenerico($rfc)) {
            return null;
        }

        $andId = null;
        if ($idEditando) {
            $andId = " AND id != '$idEditando'";
        }
        $rfc = trim(strtoupper($rfc));

        $query = "SELECT * FROM $this->table WHERE UPPER(rfc) = '$rfc' $andId";
        $result = $this->query($query);

        if ($result->num_rows > 0) {
            return true;
        }
        return null;
    }

    public function getDomiciliosFiscalesByRFC($rfc)
    {
        $query = "SELECT "
            . "id,"
            . "razon_social,"
            . "codigo_postal,"
            . "pais,"
            . "estado,"
            . "ciudad,"
            . "colonia,"
            . "calle,"
            . "numero_interior,"
            . "numero_exterior "
            . " FROM clientes WHERE lower(rfc) = lower('$rfc')";

        $result = $this->query($query);

        if ($result->num_rows > 0) {
            return $this->resultToArray($result);
        }
        return null;
    }

    public function saveCuentaBancaria(array $data)
    {
        $data['id_cliente'] = $data['id_cliente'];
        $data['banco'] = $data['banco'];
        $data['cuenta'] = trim($data['cuenta']);
        $data['status'] = $data['status'];
        //echo 'Save';exit;
        return parent::save($data, 'cuentas_bancarias_cliente');
        //mandar el array con las cuentas bancarias
    }

    public function updateCuentaBancaria($id, $data)
    {
        $data['id_cliente'] = $data['id_cliente'];
        $data['banco'] = $data['banco'];
        $data['cuenta'] = trim($data['cuenta']);
        $data['status'] = $data['status'];

        foreach ($data as $key => $value) {
            $data[$key] = trim($value);
        }
        return parent::update($id, $data, 'cuentas_bancarias_cliente');
    }

    public function getCuentasBancariasByIdCliente($idCliente)
    {
        $query = "SELECT *,"
            . " fxGetBancoName(banco) as bancoName , "
            . " fxGetStatusName(status, 'CuentaBancaria') as SatusName "
            . " FROM cuentas_bancarias_cliente WHERE id_cliente = '$idCliente'";

        $result = $this->query($query);

        if ($result->num_rows > 0) {
            return $this->resultToArray($result);
        }

        return null;
    }

    public function getCuentasBancariasById($id)
    {
        $query = "SELECT *,"
            . " fxGetBancoName(banco) as bancoName , "
            . " fxGetStatusName(status, 'CuentaBancaria') as SatusName "
            . " FROM cuentas_bancarias_cliente WHERE id = '$id'";

        $result = $this->query($query);
        if ($result->num_rows > 0) {
            $set = $this->resultToArray($result);
            return $set[0];
        }
        return null;
    }

    public function getDataBancoByIdCuentaBancariaSat($id)
    {
        $dataCuentaBancaria = $this->getCuentasBancariasById($id);

        $db_admin = new DBAdminEntityRepository();
        $query = "SELECT * FROM sat_c_bancos WHERE clave = '{$dataCuentaBancaria['banco']}'";
        $result = $db_admin->query($query);

        if ($result->num_rows > 0) {
            $result = $this->resultToArray($result);
            return $result[0];
        }
        return null;
    }

    public function deleteCuentaBancaria($id)
    {
        return parent::delete($id, 'cuentas_bancarias_cliente');
    }

    public function getListCuentasBancariasByIdCliente($idCliente)
    {
        $query = "SELECT *, "
            . " fxGetBancoName(banco) as bancoName ,"
            . " fxGetStatusName(status, 'CuentaBancaria') as SatusName "
            . " FROM cuentas_bancarias_cliente WHERE id_cliente = '$idCliente' and status = 1";
        $result = $this->query($query);

        if ($result) {
            $array = array();
            while ($row = $result->fetch_object()) {
                $array[$row->id] = $row->bancoName . ' - ' . $row->cuenta;
            }
            return $array;
        }
        return null;
    }

    public function getClientsSelect()
    {
        $query = "SELECT * FROM clientes";
        $result = $this->query($query);

        if ($result->num_rows > 0) {
            $array = array();
            foreach ($result as $status) {
                $array[$status['id']] = $status['razon_social'];
            }
            return $array;
        }
        return null;
    }

    public function getListSelectClientes2()
    {
        $query = "SELECT id,razon_social,telefono "
            . "FROM $this->table "
            . "WHERE 1 = 1 "
            . "ORDER BY razon_social ASC";
        $result = $this->query($query);

        if ($result->num_rows > 0) {
            $array = array();
            while ($row = $result->fetch_object()) {
                $array[$row->id] = $row->telefono . ' - ' . $row->razon_social;
            }
            return $array;
        }

        return null;
    }

    public function getByRFC($rfc)
    {
        $query = "SELECT GROUP_CONCAT(id)as id FROM $this->table WHERE rfc = '{$rfc}'";
        $result = $this->query($query);

        if ($result->num_rows > 0) {
            $result = $result->fetch_object();
            return $result->id;
        }
    }

    public function getTopCustomers()
    {
        $this->query("SET @row_number = 0");
        $query = " SELECT "
            . "   * "
            . " FROM "
            . "   ( "
            . "     SELECT "
            . "       (@row_number := @row_number + 1) AS rnk, "
            . "       a.* "
            . "     FROM "
            . "       ( "
            . "         SELECT "
            . "           IFNULL(a.razon_social, 'N/A') AS cliente, "
            . "           ROUND( "
            . "             sum(a.total), "
            . "             2 "
            . "           ) AS total_facturado, "
            . "           ROUND( "
            . "             SUM(a.saldo_pendiente), "
            . "             2 "
            . "           ) AS saldo_pendiente, "
            . "           ROUND( "
            . "             SUM(a.saldo_pendiente), "
            . "             2 "
            . "           )/ ROUND( "
            . "             sum(a.total), "
            . "             2 "
            . "           ) AS percentage, "
            . "           CASE WHEN 100 - ROUND ( "
            . "             SUM(a.saldo_pendiente), "
            . "             2 "
            . "           )/ ROUND( "
            . "             sum(a.total), "
            . "             2 "
            . "           ) * 100 >= fxGetIntegerSetting ('top_customers_expected') THEN 'success' WHEN 100 - ROUND ( "
            . "             SUM(a.saldo_pendiente), "
            . "             2 "
            . "           )/ ROUND( "
            . "             sum(a.total), "
            . "             2 "
            . "           ) * 100 BETWEEN fxGetIntegerSetting ('top_customers_danger_start') "
            . "           AND fxGetIntegerSetting ('top_customers_warning_start') THEN 'danger' WHEN 100 - ROUND ( "
            . "             SUM(a.saldo_pendiente), "
            . "             2 "
            . "           )/ ROUND( "
            . "             sum(a.total), "
            . "             2 "
            . "           ) * 100 BETWEEN fxGetIntegerSetting ('top_customers_warning_start') "
            . "           AND fxGetIntegerSetting ('top_customers_info_start') THEN 'warning' WHEN 100 - ROUND ( "
            . "             SUM(a.saldo_pendiente), "
            . "             2 "
            . "           )/ ROUND( "
            . "             sum(a.total), "
            . "             2 "
            . "           ) * 100 BETWEEN fxGetIntegerSetting ('top_customers_info_start') "
            . "           AND fxGetIntegerSetting ('top_customers_expected') THEN 'info' END AS `status` "
            . "         FROM "
            . "           ( "
            . "             SELECT "
            . "               c.razon_social, "
            . "               nc.saldo_pendiente, "
            . "               nc.total "
            . "             FROM "
            . "               notas_de_credito nc "
            . "               LEFT JOIN clientes c ON c.id = nc.id_cliente "
            . "             WHERE "
            . "               nc.creado_fecha > SUBDATE( "
            . "                 CURDATE(), "
            . "                 INTERVAL fxGetIntegerSetting ( "
            . "                   'top_customers_number_of_months' "
            . "                 ) MONTH "
            . "               ) "
            . "             UNION "
            . "             SELECT "
            . "               c.razon_social, "
            . "               f.saldo_pendiente, "
            . "               f.total "
            . "             FROM "
            . "               facturas f "
            . "               LEFT JOIN clientes c ON c.id = f.id_cliente "
            . "             WHERE "
            . "               f.creado_fecha > SUBDATE( "
            . "                 CURDATE(), "
            . "                 INTERVAL fxGetIntegerSetting ( "
            . "                   'top_customers_number_of_months' "
            . "                 ) MONTH "
            . "               ) and f.tipo_documento <> 'CG' "
            . "           ) a "
            . "         GROUP BY "
            . "           a.razon_social "
            . "         ORDER BY "
            . "           saldo_pendiente DESC "
            . "       ) a "
            . "   ) a "
            . " WHERE "
            . "   a.rnk <= fxGetIntegerSetting ('top_customers_list_size') ";

        $result = $this->query($query);

        if ($result->num_rows > 0) {
            return $this->resultToArray($result);
        }

        return [];
    }

    public function searchByTerm($searchTerm, $columns = " * ")
    {
        $columnsEsc = mysqli_escape_string(DataBase::getInstance(), $columns);
        $searchTermEsc = mysqli_escape_string(DataBase::getInstance(), $searchTerm);
        $query = " SELECT {$columnsEsc} FROM clientes WHERE razon_social LIKE '%{$searchTermEsc}%' ";

        $result = $this->query($query);

        if ($result->num_rows > 0) {
            return $this->resultToArray($result);
        }

        return [];
    }
}
