<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

class CuentaBancariaRepository extends EntityRepository
{
    private $table = 'cuentas_bancarias';
    
    private $options = array(
        'banco'=>null,
        'cuenta'=>null,
        'clabe_interbancaria'=>null,
        'status'=>null,
    );
    
    public function setOptions($data)
    {
        foreach ($this->options as $option => $value) {
            if (isset($data[$option])) {
                $this->options[$option] = $data[$option];
            }
        }
    }
  
    public function getOptions()
    {
        return $this->options;
    }
    
    public function getCuenta()
    {
        return $this->options['cuenta'];
    }
    
    public function getCLABE()
    {
        return $this->options['clabe_interbancaria'];
    }
    
    public function getBanco()
    {
        return $this->options['banco'];
    }
    
    public function getTable()
    {
        return $this->table;
    }

    public function save(array $data, $table = null)
    {
        return parent::save($data, $this->table);
    }
    
    public function delete($id, $table = null)
    {
        return parent::delete($id, $this->table);
    }

    public function update($id, $data, $table = null)
    {
        return parent::update($id, $data, $this->table);
    }

    public function getById($id, $table = null, $selectAux = null)
    {
        return parent::getById($id, $this->table, $selectAux);
    }

    public function isUsedInRecord($id, array $buscarEn = null, $andWhere = null)
    {
        return parent::isUsedInRecord($id, array(
            'pagos' => 'cuenta_bancaria'));
    }
    
    public function getListSelectCuentasBancarias()
    {
        $select = "SELECT *,fxGetBancoName(banco)as bancoName FROM $this->table ";
        $result = $this->query($select);

        if ($result) {
            $array = array();
            while ($row = $result->fetch_assoc()) {
                $array[$row['id']] = $row['bancoName'].' - '.$row['cuenta'];
            }
            return $array;
        }
        return null;
    }
    
    public function getListCuentasBancarias()
    {
        $select = "SELECT *,"
                . "fxGetBancoName(banco) as bancoName,"
                . "fxGetStatusName(status,'CuentaBancaria') as statusName "
                . "FROM $this->table ";
        
        $result = $this->query($select);

        if ($result) {
            return $this->resultToArray($result);
        }
        return null;
    }
    
    public function getListStatus()
    {
        $query = "SELECT * FROM status_codigos WHERE operacion = 'CuentaBancaria'";
        $result = $this->query($query);
        
        if ($result->num_rows > 0) {
            $array = array();
            foreach ($result as $status) {
                $array[$status['id']] = $status['status'];
            }
            return $array;
        }
        return null;
    }
    
    public function getListSelectBancos()
    {
        $db_admin = new DBAdminEntityRepository();
        $select = "SELECT * FROM sat_c_bancos ";
        $result = $db_admin->query($select);

        if ($result) {
            $array = array();
            while ($row = $result->fetch_assoc()) {
                $array[$row['clave']] = $row['descripcion'];
            }
            return $array;
        }
        return null;
    }
    
    public function getDataBancoByIdCuentaBancaria($id)
    {
        $dataCuentaBancaria = $this->getById($id);
        
        $db_admin = new DBAdminEntityRepository();
        $query = "SELECT * FROM sat_c_bancos WHERE clave = '{$dataCuentaBancaria['banco']}'";
        $result = $db_admin->query($query);
        
        if ($result->num_rows > 0) {
            $result = $this->resultToArray($result);
            return $result[0];
        }
        return null;
    }
}
