<?php
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

class EmpresaRepository extends EntityRepository
{
    private $table = 'empresa';
    private $certificado = null;
    private $no_certificado = null;
    private $fi_certificado = '0000-00-00';
    private $ff_certificado = '0000-00-00';
    private $image = null;
    private $options_files = array(
        'allowedExtensions'=>array('key','cer'),
        'maxFileSizeAllowed'=>1000000,
        'pathToSave'=>PATH_SAT_DOCS
    );
    
    public $flashmessenger = null;
    
    private $options = array(
        'nombre'=>null,
        'razon_social'=>null,
        'rfc'=>null,
        'regimen_fiscal'=>null,
        'no_certificado'=>null,
        'fi_certificado'=>null,
        'ff_certificado'=>null,
        'certificado'=>null,
        'calle'=>null,
        'numero_exterior'=>null,
        'numero_interior'=>null,
        'colonia'=>null,
        'ciudad'=>null,
        'estado'=>null,
        'pais'=>'MEXICO',
        'codigo_postal'=>null,
        'nombre_contacto'=>null,
        'telefono'=>null,
        'email'=>null,
        'pagina_web'=>null,
        'serie_de_facturacion'=>null,
        'serie_de_notas_de_credito'=>null,
        'serie_de_pago'=>null,
        'serie_de_cuenta_de_gastos'=>null,
        'rango_de_facturacion'=>null,
        'archivos'=>null,
        'contrasena'=>null,
        //pudin
        'email_message_factura'=>null,
        'email_message_pago'=>null
    );
    
    private $options_aux = array(
        'logo'=>null,
        'image_type'=>null,
        'regimenFiscalName'=>null
    );
    
    public function setOptions($data)
    {
        foreach ($this->options as $option => $value) {
            if (isset($data[$option])) {
                $this->options[$option] = $data[$option];
            }
        }
        foreach ($this->options_aux as $option => $value) {
            if (isset($data[$option])) {
                $this->options_aux[$option] = $data[$option];
            }
        }
    }
  
    public function getOptions()
    {
        return $this->options;
    }
    
    public function getEmailMessageFactura()
    {
        return $this->options['email_message_factura'];
    }
    
    public function getNombre()
    {
        return $this->options['razon_social'];
    }
    
    public function getLogo()
    {
        return $this->options_aux['logo'];
    }
    
    public function getImageType()
    {
        return $this->options_aux['image_type'];
    }
    
    public function getRazonSocial()
    {
        return $this->options['racon_social'];
    }
    
    public function getRFC()
    {
        return $this->options['rfc'];
    }
    
    public function getRegimenFiscal()
    {
        return $this->options['regimen_fiscal'];
    }
    
    public function getRegimenFiscalNombre()
    {
        return $this->options_aux['regimenFiscalName'];
    }
    
    public function getNumCertificado()
    {
        return $this->options['no_certificado'];
    }
    
    public function getFechaInicioCertificado()
    {
        return $this->options['fi_certificado'];
    }
    
    public function getFechaVigenciaCertificado()
    {
        return $this->options['ff_certificado'];
    }
    
    public function getCalle()
    {
        return $this->options['calle'];
    }
    
    public function getNumExterior()
    {
        return $this->options['numero_exterior'];
    }
    
    public function getNumInterior()
    {
        return $this->options['numero_interior'];
    }
    
    public function getCalleNum()
    {
        $direccion = $this->getCalle().' '.$this->getNumExterior();
        if (trim($this->getNumInterior())!='') {
            $direccion .= ' No. INT. '.$this->getNumInterior();
        }
        return $direccion;
    }
    
    public function getColonia()
    {
        return $this->options['colonia'];
    }
    
    public function getCiudad()
    {
        return $this->options['ciudad'];
    }
    
    public function getEstado()
    {
        return $this->options['estado'];
    }
    
    public function getCodigoPostal()
    {
        return $this->options['codigo_postal'];
    }
    
    public function getPaginaWeb()
    {
        return $this->options['pagina_web'];
    }
    
    public function getTelefono()
    {
        return $this->options['telefono'];
    }
    
    public function getTable()
    {
        return $this->table;
    }
    
    public function __construct()
    {
        if (!$this->flashmessenger instanceof FlashMessenger) {
            $this->flashmessenger = new FlashMessenger();
        }
    }
    
    public function setImage($image)
    {
        $this->image = $image;
    }

    public function save(array $data, $table = null)
    {
        unset($data['no_certificado'],$data['fi_certificado'],$data['ff_certificado'],$data['certificado']);
        $data['nombre'] = trim(strtoupper($data['nombre']));
        $data['rfc'] = trim(strtoupper($data['rfc']));
        $data['razon_social'] = trim(strtoupper($data['razon_social']));
        $data['calle'] = trim(($data['calle']));
        $data['numero_interior'] = trim(($data['numero_interior']));
        $data['numero_exterior'] = trim(($data['numero_exterior']));
        $data['colonia'] = trim(($data['colonia']));
        
        $archivos = $data['archivos'];
        $contrasena = $data['contrasena'];
        unset($data['archivos'],$data['contrasena']);
        
        $this->startTransaction();
        $rs = parent::save($data, $this->table);
        
        if ($rs) {
            if ($archivos['file_cer']['name']!='') {
                $this->saveFiles($archivos, $data['rfc'], $contrasena);
                $this->updateInfoCertificados(1);
            }
            
            $sucursalEntity = new SucursalRepository();
            $sucursalEntity->setOptions($this->getById(1));
            $sucursalEntity->setImage($this->image);
            #$rs = $sucursalEntity->save($sucursalEntity->getOptions());
            
            # No ocupo save de SucursalEntity; para no generar nuevamente los archivos SAT
            # Solamente requiero guardar el registro de la BD, los archivos ya se generaron en al momento de guardar la empresa.
            $rs = parent::save($sucursalEntity->getOptions(), 'sucursales');
            
            if ($rs) {
                $sucursalEntity->saveImage(1);
                $this->commit();
                return true;
            }
        }
        $this->rollback();
        return true;
    }
    
    public function update($id, $data, $table = null)
    {
        unset($data['no_certificado'],$data['fi_certificado'],$data['ff_certificado'],$data['certificado']);
        $data['nombre'] = trim(strtoupper($data['nombre']));
        $data['rfc'] = trim(strtoupper($data['rfc']));
        $data['razon_social'] = trim(strtoupper($data['razon_social']));
        $data['calle'] = trim(($data['calle']));
        $data['numero_interior'] = trim(($data['numero_interior']));
        $data['numero_exterior'] = trim(($data['numero_exterior']));
        $data['colonia'] = trim(($data['colonia']));
        
        $archivos = $data['archivos'];
        $contrasena = $data['contrasena'];
        unset($data['archivos'],$data['contrasena']);

        $this->startTransaction();
        $rs = parent::update($id, $data, $this->table);
       
        if ($rs) {
            if ($archivos['file_cer']['name']!='') {
                if (!is_dir($this->options_files['pathToSave'].$data['rfc']."/1/")) {
                    mkdir($this->options_files['pathToSave'].$data['rfc']."/1/", 0777, true);
                }
                $this->saveFiles($archivos, $data['rfc'], $contrasena);
                $this->updateInfoCertificados($id);
            }
           
            $sucursalEntity = new SucursalRepository();
            $dataSucursal = $this->getById($id);
            $dataSucursal['status'] = '1';
            $sucursalEntity->setOptions($dataSucursal);
            $sucursalEntity->setImage($this->image);
            
            # No ocupo update de SucursalEntity; para no generar nuevamente los archivos SAT
            # Solamente requiero actualizar el registro de la BD, los archivos ya se generaron en al momento de editar la empresa.
            $dataSucursal = $sucursalEntity->getOptions();
            unset($dataSucursal['archivos'],$dataSucursal['contrasena']);
            // echo "<pre>";var_dump($dataSucursal);exit;echo "</pre>";
            $rs = parent::update($id, $dataSucursal, 'sucursales');

            if ($rs) {
                $sucursalEntity->saveImage($id);
                $login = new Login();
                $login->addPropiertieLogged(array('rfc'=>$data['rfc']));
                $this->commit();
                return true;
            }
        }
        $this->rollback();
        return null;
    }
    
    public function delete($id, $table = null)
    {
        return parent::delete($id, $this->table);
    }
    
    public function saveFiles($files, $rfc, $pass)
    {
        $file = new UploadFile();
        $file->setAllowedExtensions($this->options_files['allowedExtensions']);
        $file->setMaxFileSizeAllowed($this->options_files['maxFileSizeAllowed']);
     
        $file->setTempFolder($this->options_files['pathToSave'].$rfc."/1/");
   
        $rsUpload = $file->uploadFile($files['file_key'], null, 'keyPem');
        $rsUpload = $file->uploadFile($files['file_cer'], null, 'certificado');

        if (!$rsUpload) {
            $this->flashmessenger->addMessage(array('info'=>$file->getMessageError()));
            return null;
        }
        //echo $file->getTempFolder()."<=";exit;
        $certificados = new Certificados($file->getTempFolder());
        $rsCer = $certificados->generaCerPem('certificado.cer');
        $rsKey = $certificados->generaKeyPem('keyPem.key', $pass);
        
        if ($rsCer !== null && $rsKey !== null) {
            if ($certificados->pareja()) {
                $this->no_certificado = $certificados->getSerialCert();
                $this->fi_certificado = $certificados->getFechaInicio();
                $this->ff_certificado = $certificados->getFechaVigencia();
                $this->certificado = $certificados->getStringCertificado('certificado.cer');
            } else {
                $this->no_certificado = '';
                $this->fi_certificado = '0000-00-00';
                $this->ff_certificado = '0000-00-00';
                $this->certificado = '';
            }
            return true;
        }
        return null;
    }
    
    public function updateInfoCertificados($id)
    {
        $fields = array(
            'no_certificado'=>$this->no_certificado,
            'fi_certificado'=>$this->fi_certificado,
            'ff_certificado'=>$this->ff_certificado,
            'certificado'=>$this->certificado,
        );
        
        return parent::update($id, $fields, $this->table);
    }

    public function getById($id, $table = null, $selectAux = null)
    {
        #Para empresa siempre asignamos la id_sucursal = 1
        $query = "SELECT "
                 . "s.*,"
                 . "fxGetRegimenFiscalName(regimen_fiscal)as regimenFiscalName,"
                 . "l.image as logo,"
                 . "l.type as image_type "
                . "FROM empresa s LEFT JOIN logos l ON s.id = l.id_sucursal "
                . "WHERE s.id = '$id' ";
        $result = $this->query($query);
        
        if ($result->num_rows > 0) {
            $result = $this->resultToArray($result);
            return $result[0];
        }
        return null;
    }

    public function isUsedInRecord($id, array $buscarEn = null, $andWhere = null)
    {
        return null;
        return parent::isUsedInRecord($id, array('alumos' => 'idGrupo'));
    }

    public function getListSelectEmpresas()
    {
        $select = "SELECT * FROM empresa ";
        $result = $this->query($select);

        if ($result) {
            $array = array();
            while ($row = $result->fetch_assoc()) {
                $array[$row['id']] = $row['nombre'].' - '.$row['rfc'];
            }
            return $array;
        }
        return null;
    }
    
    public function getListEmpresas()
    {
        $select = "SELECT * FROM empresa ";
        $result = $this->query($select);

        if ($result) {
            return $this->resultToArray($result);
        }
        return null;
    }
    
        
    public function existeRFC($rfc, $idEditando = null)
    {
        $andId = null;
        if ($idEditando) {
            $andId = " AND id != '$idEditando'";
        }
        
        $rfc = trim(strtoupper($rfc));
        $query = "SELECT * FROM $this->table WHERE UPPER(rfc) = '$rfc' $andId";
        $result = $this->query($query);
        
        if ($result->num_rows > 0) {
            return true;
        }
        
        return null;
    }
        
    public function getListEstados()
    {
        $db_admin = new DBAdminEntityRepository();
        $query = "SELECT * FROM estados ORDER BY id ASC";
        $result = $db_admin->query($query);
        
        if ($result) {
            $array = array();
            while ($row = $result->fetch_object()) {
                $array[$row->id] = $row->nombre;
            }
            
            return $array;
        }
        
        return null;
    }
    
    public function getListPaises()
    {
        $db_admin = new DBAdminEntityRepository();
        $query = "SELECT * FROM sat_c_pais ORDER BY id ASC";
        $result = $db_admin->query($query);
        
        if ($result) {
            $array = array();
            while ($row = $result->fetch_object()) {
                $array[$row->id] = $row->descripcion;
            }
            
            return $array;
        }
        
        return null;
    }
    
    public function getListSelectCodigosPostales($estado = null)
    {
        $db_admin = new DBAdminEntityRepository();
        
        if ($estado != null) {
            $estado = " AND estado = '$estado' ";
        }
        
        $query = "SELECT * FROM codigos_postales WHERE 1=1 $estado ";
        $result = $db_admin->query($query);
        
        if ($result) {
            $array = array();
            while ($row = $result->fetch_object()) {
                $array[$row->cp] = $row->cp;
            }
            return $array;
        }
        
        return null;
    }
    
        
    public function getListSelectMunicipios($estado = null)
    {
        $db_admin = new DBAdminEntityRepository();
        
        if ($estado != null && $estado != null) {
            $estado = " AND estado = '$estado' ";
        }
        
        $query = "SELECT * FROM municipios WHERE 1=1 $estado ";
        $result = $db_admin->query($query);
        
        if ($result) {
            $array = array();
            while ($row = $result->fetch_object()) {
                $array[$row->descripcion] = $row->descripcion;
            }
            
            return $array;
        }
        
        return null;
    }
    
    public function getListSelectColonias($codigoPostal = null)
    {
        $db_admin = new DBAdminEntityRepository();
        
        if ($codigoPostal != null && $codigoPostal != '') {
            $codigoPostal = " AND codigo_postal = '$codigoPostal' ";
        }
        
        $query = "SELECT * FROM colonias WHERE 1=1 $codigoPostal ";
        $result = $db_admin->query($query);
        
        if ($result) {
            $array = array();
            while ($row = $result->fetch_object()) {
                $array[$row->descripcion] = $row->descripcion;
            }
            
            return $array;
        }
        
        return null;
    }
    
    public function getListaRegimenFiscal()
    {
        $db_admin = new DBAdminEntityRepository();
        $query = "SELECT * FROM sat_c_regimenfiscal";
        $result = $db_admin->query($query);
        
        if ($result) {
            $array = array();
            while ($row = $result->fetch_object()) {
                $array[$row->clave] = $row->descripcion;
            }
            
            return $array;
        }
        
        return null;
    }
    
    public function getListSelectSerieDeFacturacion()
    {
        $query = "SELECT * FROM facturas_series_folios WHERE 1=1 AND status = 1 AND tipo = 'Facturas' ";
        $result = $this->query($query);
        
        if ($result) {
            $array = array();
            while ($row = $result->fetch_object()) {
                $array[$row->id] = "Serie ".$row->serie." - Del folio ".$row->folio_inicio." al ".$row->folio_fin;
            }
            
            return $array;
        }
        
        return null;
    }
    
    public function getListSelectSerieDeNotasDeCredito()
    {
        $query = "SELECT * FROM facturas_series_folios WHERE 1=1 AND status = 1 AND tipo = 'notas_de_credito' ";
        $result = $this->query($query);
        
        if ($result) {
            $array = array();
            while ($row = $result->fetch_object()) {
                $array[$row->id] = "Serie ".$row->serie." - Del folio ".$row->folio_inicio." al ".$row->folio_fin;
            }
            
            return $array;
        }
        
        return null;
    }
    
    public function getListSelectSerieDePagos()
    {
        $query = "SELECT * FROM facturas_series_folios WHERE 1=1 AND status = 1 AND tipo = 'Pagos' ";
        $result = $this->query($query);
        
        if ($result) {
            $array = array();
            while ($row = $result->fetch_object()) {
                $array[$row->id] = "Serie ".$row->serie." - Del folio ".$row->folio_inicio." al ".$row->folio_fin;
            }
            
            return $array;
        }
        
        return null;
    }
    
    public function getListSelectSerieDeCuentaDeGastos()
    {
        $query = "SELECT * FROM facturas_series_folios WHERE 1=1 AND status = 1 AND tipo = 'cuenta_de_gastos' ";
        $result = $this->query($query);
        
        if ($result) {
            $array = array();
            while ($row = $result->fetch_object()) {
                $array[$row->id] = "Serie ".$row->serie." - Del folio ".$row->folio_inicio." al ".$row->folio_fin;
            }
            
            return $array;
        }
        
        return null;
    }
    
    public function getListSelectRangosDeFacturacion()
    {
        $query = "SELECT * FROM rangos_de_facturacion WHERE 1=1 ";
        $result = $this->query($query);
        
        if ($result) {
            $array = array();
            while ($row = $result->fetch_object()) {
                $array[$row->id] = $row->descripcion;
            }
            return $array;
        }
        return null;
    }
}
