<?php
class FacturaDetailsTempRepository extends EntityRepository
{
    private $table = 'factura_detalles_';
    private $table_cg = 'cuenta_de_gastos_detalles_';
    
    private $options = array(
        'token_form'=>null,
        'id_factura' => null,
        'id_producto' => null,
        'nombre'=>null,
        'cantidad'=>null,
        'precio_unitario'=>null,
        'descuento_detalle'=>null,
        'impuestos_incluidos'=>null
     );
    
    public function setOptions($data)
    {
        foreach ($this->options as $option => $value) {
            if (isset($data[$option])) {
                $this->options[$option] = $data[$option];
            }
        }
    }

    public function getOptions()
    {
        return $this->options;
    }
    
    public function __construct()
    {
        $login = new Login();
        $this->table = $this->table.$login->getId();
        $this->table_cg = $this->table_cg  .$login->getId();
    }
    // Guarda en temporal
    public function save(array $data, $table = null)
    {
        if (trim($data['descuento_detalle']) == '') {
            $data['descuento_detalle'] = 0;
        }
        
        if (isset($data['idDetailTemp']) && trim($data['idDetailTemp'])!= '') {
            $result = $this->getById($data['idDetailTemp']);
            if ($result) {
                $id = $data['idDetailTemp'];
                unset($data['idDetailTemp']);
                parent::delete($id, $this->table);
            }
        }
        unset($data['idDetailTemp']);
        $repo = new FacturaRepository();
        $impuestosLista = $repo->getListImpuestos();
        $impuestos = trim($data['impuestos']);
        $impuestosAplicables = array('Trasladable'=>array(),'Retenible'=>array());
        
        #calcular precio_unitario sin impuestos
        if ($impuestos != '') {
            $impuestos = explode(',', $data['impuestos']);
            if ($data['impuestos_incluidos'] == 'Si') {
                $precioUnitConImpuesto = $data['precio_unitario'];
                foreach ($impuestos as $key =>$value) {
                    $impuestoInfo = $impuestosLista[$value];
                    $porcentaje = 1 + $impuestoInfo['tasa_cuota']/100;
                    $precioUnitSinImpuesto = $precioUnitConImpuesto/$porcentaje;
                    $data['precio_unitario'] -= $precioUnitSinImpuesto * $impuestoInfo['tasa_cuota']/100;
                    #$detalle['precio_unitario'] = $precioUnitSinImpuesto;
                }
            }
        }
        
        #Descontar de precio_unitario descuento si existe.
        $subtotal = ($data['precio_unitario'] * $data['cantidad']);
        $descuento = $subtotal * ($data['descuento_detalle']/100);
        $data['descuento_monto'] = $descuento;
        $data['importe'] = $subtotal - $descuento;
        
        if ($impuestos != '') {
            foreach ($impuestos as $key =>$value) {
                $impuestoInfo = $impuestosLista[$value];
                switch ($impuestoInfo['tipo_factor']) {
                    case 'Tasa':
                        $montoImpuesto = $data['importe'] * $impuestoInfo['tasa_cuota']/100;
                        break;

                    case 'Cuota':
                        $montoImpuesto = $data['cantidad'] * $impuestoInfo['tasa_cuota'];
                        break;
                }


                if (key_exists($value, $impuestosAplicables[$impuestoInfo['tipo']])) {
                    $impuestosAplicables[$impuestoInfo['tipo']][$value]['Importe'] += number_format($montoImpuesto, 2, '.', '');
                } else {
                    $impuestosAplicables[$impuestoInfo['tipo']][$value]['Importe'] = number_format($montoImpuesto, 2, '.', '');
                    $impuestosAplicables[$impuestoInfo['tipo']][$value]['nombre'] = $impuestoInfo['impuesto'];
                    $impuestosAplicables[$impuestoInfo['tipo']][$value]['descripcion'] = $impuestoInfo['descripcion'];
                    $impuestosAplicables[$impuestoInfo['tipo']][$value]['Base'] = $data['importe'];
                    $impuestosAplicables[$impuestoInfo['tipo']][$value]['Impuesto'] = $impuestoInfo['clave'];
                    $impuestosAplicables[$impuestoInfo['tipo']][$value]['TipoFactor'] = $impuestoInfo['tipo_factor'];
                    $impuestosAplicables[$impuestoInfo['tipo']][$value]['TasaOCuota'] = $impuestoInfo['tasa_cuota'];
                }
            }
        }
        
        $data['impuestos_aplicables'] = serialize($impuestosAplicables);
        return parent::save($data, $this->table);
    }
    
    // Guarda en tabla comprasdetalles
    public function saveDetalles($idCompra, $tokenForm)
    {
        $query = "SELECT * FROM $this->table WHERE token_form = '$tokenForm'";
        $result = $this->query($query);
        if ($result->num_rows > 0) {
            $result = $this->resultToArray($result);
            
            foreach ($result as $data) {
                unset($data['id'], $data['id_detail'], $data['token_form']);
                $data['id_factura'] = $idCompra;
                
                parent::save($data, 'facturas_detalles');
            }
        }

        return true;
    }
    
    public function updateDetalles($idFactura, $tokenForm)
    {
        $query = "SELECT id FROM facturas_detalles WHERE id_factura = '$idFactura'";
        $result = $this->query($query);
        $detallesOrigin = null;
        if ($result->num_rows > 0) {
            $detallesOrigin = $this->resultToArray($result);
        }
        
        $query = "SELECT * FROM $this->table WHERE token_form = '$tokenForm'";
        $result = $this->query($query);
        
        if ($result->num_rows > 0) {
            $idsDetalles = array();
        
            $result = $this->resultToArray($result);
            foreach ($result as $data) {
                $idDetalle = $data['id_detail'];
                unset($data['id'], $data['id_detail'], $data['token_form']);
                $data['id_factura'] = $idFactura;
              
                if (!$idDetalle) {
                    parent::save($data, 'facturas_detalles');
                } else {
                    #contiene los idDetalles de la compra original que se mantendran, lo que no esten aqui se eliminaran.
                    $idsDetalles[] = $idDetalle;
                    parent::update($idDetalle, $data, 'facturas_detalles');
                }
            }
        }

        #Se eliminan ids de tabla comprasdetalls que ya no estan en $idsDetalles (este array contiene los ids que permanececieron en la compra despues del update)
        if ($detallesOrigin) {
            foreach ($detallesOrigin as $detalle) {
                if (!in_array($detalle['id'], $idsDetalles)) {
                    parent::delete($detalle['id'], 'facturas_detalles');
                }
            }
        }
        return true;
    }
    
    public function delete($id, $table = null)
    {
        return parent::delete($id, $this->table);
    }
    
    public function truncate($tokenForm)
    {
        $query = "DELETE FROM ".$this->table." WHERE token_form = '$tokenForm'";
        $result = $this->query($query);
        
        if ($result) {
            return true;
        }
        
        return null;
    }
    
    public function truncateIfIsEditInfo()
    {
        $query = "SELECT id_factura FROM .".$this->table." LIMIT 1";
        $result = $this->query($query);
        
        if ($result->num_rows > 0) {
            $result = $result->fetch_object();
            if ($result->id_factura !=null || $result->id_factura != '') {
                $this->truncate();
                return true;
            }
        }
        
        return null;
    }
    
    public function drop()
    {
        $query = "DROP TABLE ".$this->table;
        $result = $this->query($query);
        
        if ($result) {
            return true;
        }
        return null;
    }
    
    public function setStoreInDetailsById($idFactura, $tokenForm)
    {
        $query = "INSERT INTO ".$this->table." (id_detail,token_form,id_factura,id_producto,nombre,descripcion,cantidad,precio_unitario,descuento_detalle,descuento_monto,importe,impuestos_incluidos,impuestos,impuestos_aplicables)
                    SELECT id,'$tokenForm',id_factura,id_producto,nombre,descripcion,cantidad,precio_unitario,descuento_detalle,descuento_monto,importe,impuestos_incluidos,impuestos,impuestos_aplicables
                    FROM facturas_detalles 
                    WHERE id_factura = '$idFactura'";
        
        $result = $this->query($query);
        if ($result) {
            return true;
        }
        
        return null;
    }

    public function update($id, $data, $table = null)
    {
        if (isset($data['id_factura'])) {
            if ($data['id_factura']=='' || !$data['id_factura']) {
                unset($data['id_factura']);
            }
        }

        return parent::update($id, $data, $this->table);
    }

    public function getById($id, $table = null, $selectAux = null)
    {
        return parent::getById($id, $this->table, $selectAux);
    }
    
    /* CUENTA DE GASTOS */
    public function saveCuentaDeGastos(array $data, $table = null)
    {
        if (isset($data['idDetailTemp']) && trim($data['idDetailTemp'])!= '') {
            $result = $this->getByIdCG($data['idDetailTemp']);
            if ($result) {
                $id = $data['idDetailTemp'];
                unset($data['idDetailTemp']);
                parent::delete($id, $this->table_cg);
            }
        }
        
        unset($data['idDetailTemp']);
        return parent::save($data, $this->table_cg);
    }
    
    // Guarda en tabla comprasdetalles
    public function saveCuentaDeGastosDetalles($idFactura)
    {
        $query = "SELECT * FROM $this->table_cg";
        $result = $this->query($query);
        if ($result->num_rows > 0) {
            $result = $this->resultToArray($result);
            
            foreach ($result as $data) {
                unset($data['id']);
                unset($data['id_detail']);
                $data['id_factura'] = $idFactura;
                $data['cantidad'] = 1;
                
                parent::save($data, 'facturas_detalles');
            }
        }
        return true;
    }
    
    public function updateCuentaDeGastosDetalles($idFacturaCuentaDeGastos)
    {
        //Uso uuid para relaciona la Factura de CG con su Factura Original
        $query = "SELECT id FROM facturas_detalles d WHERE id_factura = '$idFacturaCuentaDeGastos'";
        $result = $this->query($query);
        $detallesOrigin = null;
        if ($result->num_rows > 0) {
            $detallesOrigin = $this->resultToArray($result);
        }
        
        $query = "SELECT * FROM $this->table_cg";
        $result = $this->query($query);
        
        if ($result->num_rows > 0) {
            $idsDetalles = array();
        
            $result = $this->resultToArray($result);
            foreach ($result as $data) {
                $idDetalle = $data['id_detail'];
                unset($data['id']);
                unset($data['id_detail']);
                $data['id_factura'] = $idFacturaCuentaDeGastos;
              
                if (!$idDetalle) {
                    parent::save($data, 'facturas_detalles');
                } else {
                    #contiene los idDetalles de la compra original que se mantendran, lo que no esten aqui se eliminaran.
                    $idsDetalles[] = $idDetalle;
                    parent::update($idDetalle, $data, 'facturas_detalles');
                }
            }
        } else {
            parent::delete($idFacturaCuentaDeGastos, 'facturas');
            parent::query("DELETE  FROM facturas_detalles WHERE id_factura = '$idFacturaCuentaDeGastos'");
        }

        #Se eliminan ids de tabla comprasdetalls que ya no estan en $idsDetalles (este array contiene los ids que permanececieron en la compra despues del update)
        if ($detallesOrigin) {
            foreach ($detallesOrigin as $detalle) {
                if (!in_array($detalle['id'], $idsDetalles)) {
                    parent::delete($detalle['id'], 'facturas_detalles');
                }
            }
        }
        return true;
    }
    
    public function deleteCuentaDeGastos($id, $table = null)
    {
        return parent::delete($id, $this->table_cg);
    }
    
    public function truncateCuentaDeGastosIfIsEditInfo()
    {
        $query = "SELECT id_factura FROM .".$this->table_cg." LIMIT 1";
        $result = $this->query($query);
        
        if ($result->num_rows > 0) {
            $result = $result->fetch_object();
            if ($result->id_factura !=null || $result->id_factura != '') {
                $this->truncate();
                return true;
            }
        }
        
        return null;
    }
    
    public function truncateCuentaDeGastos()
    {
        $query = "TRUNCATE ".$this->table_cg;
        $result = $this->query($query);
        
        if ($result) {
            return true;
        }
        
        return null;
    }
    
    public function dropCuentaDeGastos()
    {
        $query = "DROP TABLE ".$this->table_cg;
        $result = $this->query($query);
        
        if ($result) {
            return true;
        }
        return null;
    }
    
    public function setCuentaDeGastosDetailsById($idFactura)
    {
        $query = "SELECT id FROM facturas where uuid = '$idFactura'";
        $result = $this->query($query);
        
        if ($result->num_rows > 0) {
            $result = $result->fetch_object();
            $idFactura = $result->id;
            
            $this->query("TRUNCATE ".$this->table_cg);
            $query = "INSERT INTO ".$this->table_cg." (id_detail,id_factura,id_producto,nombre,descripcion,precio_unitario)
                        SELECT id,id_factura,id_producto,nombre,descripcion,precio_unitario
                        FROM facturas_detalles 
                        WHERE id_factura = '$idFactura'";

            $result = $this->query($query);
            if ($result) {
                return true;
            }
        }
        
        return null;
    }
    
    public function getByIdCG($id, $table = null, $selectAux = null)
    {
        return parent::getById($id, $this->table_cg, $selectAux);
    }
    
    public function existenRegistros()
    {
        $query = "SELECT * FROM $this->table_cg";
        $result = $this->query($query);
        
        if ($result->num_rows > 0) {
            return true;
        }
        return null;
    }
    
    /* EN CUENTA DE GASTOS*/
}
