<?php

/**

 * Description of Ciclo

 *

 * @author carlos

 */
class FacturaEntity Extends FacturaRepository{

    private $options = array(

        'sucursal'=>null,

        'id_cliente'=>null,                

        'rfc_receptor'=>null,

        'tipo_documento'=>null,

        'serie'=>null, #varchar(25)

        'folio'=>null, #int

        'forma_de_pago'=>null, #varchar(100)

        'metodo_de_pago'=>null, #carchar(50) Ejemplo: Efectivo-Cheque-Tarjeta

        'num_cuenta_pago'=>null,

        'condiciones_de_pago'=>null,

        'tipo_relacion'=>null,

        'uso_cfdi'=>null,

        'uuid_relacionados'=>null,

        'uuid_relacionados_otros'=>null,

        'moneda'=>null,

        'tipo_de_cambio'=>null,

        'subtotal'=>null, #double

        'descuento'=>null,

        'total'=>null,

        'iva_tasa'=>null,    

        'total_impuestos_trasladados'=>null,

        'total_impuestos_retenidos'=>null,

        'detalles_impuestos_aplicables'=>null,

        'comentarios'=>null,

        'datos_comprobante'=>null,

        'datos_emisor'=>null,

        'datos_receptor'=>null,

        'datos_conceptos'=>null,

        'uuid'=>null,

        'certificado_sat'=>null,

        'fecha_timbrado'=>null,

        'sello_sat'=>null,

        'cadena_original_sat'=>null,

        'sello_cfdi'=>null,

        'status'=>null,

        'version_cfdi'=>null,
        
        'saldo_pendiente'=>null # se añade para igualar el total a el campo de saldo_pendiente
    );

    private $options_aux = array(

        'saldoPendiente'=>null,

        'comprobanteName'=>null,

        'formaName'=>null,        

        'metodoName'=>null,

        'monedaName'=>null,

        'usoCFDIName'=>null,

        'uuid_relacionados_y_otros_uuid_relacionados'=>null

    );


    public function setOptions($data){

      foreach ($this->options as $option => $value){

          if(isset($data[$option])){
            $this->options[$option] = $data[$option];

          }

      }

      foreach ($this->options_aux as $option => $value){

          if(isset($data[$option])){

            $this->options_aux[$option] = $data[$option];

          }

      }

    }

    public function getOptions(){

        return $this->options;

    }

    

    public function getStatus(){

        return $this->options['status'];

    }

    

    public function getVersionCFDI(){

        return $this->options['version_cfdi'];

    }


    public function getSucursal(){

        return $this->options['sucursal'];

    }

    

    public function getIdCliente(){

        return $this->options['id_cliente'];

    }

     public function getSaldoPendiente(){

        return $this->options['saldo_pendiente'];

    }

    public function getTipoComprobante(){

        return $this->options['tipo_documento'];

    }

    

    public function getTipoComprobanteNombre(){

        return $this->options_aux['comprobanteName'];

    }

    public function getFormaDePago(){

        return $this->options['forma_de_pago'];

    }

    

    public function getFormaDePagoNombre(){

        return $this->options_aux['formaName'];

    }

    

    public function getCondicionesDePago(){

        return $this->options['condiciones_de_pago'];

    }
  

    public function getSubTotal(){

        return $this->options['subtotal'];

    }
   

    public function getDescuento(){

        return $this->options['descuento'];

    }

    

    public function getImpuestosAplicables(){

        return unserialize($this->options['detalles_impuestos_aplicables']);

    }

    

    public function getMoneda(){

        return $this->options['moneda'];

    }

    

    public function getMonedaNombre(){

        return $this->options_aux['monedaName'];

    }

    

    public function getTipoDeCambio(){

        return $this->options['tipo_de_cambio'];

    }

    

     public function getNumCuenta(){

        return $this->options['num_cuenta_pago'];

    }

    

    public function getUsoCFDI(){

        return $this->options['uso_cfdi'];

    }
    
    public function getUsoCFDINombre(){

        return $this->options_aux['usoCFDIName'];

    }

    

    public function getTipoRelacion(){

        return $this->options['tipo_relacion'];

    }

    

    public function getUUIDsRelacionados(){

         return $this->options['uuid_relacionados'];

    }

    

    public function getCFDIRelacionados(){

       $uudis = $this->options_aux['uuid_relacionados_y_otros_uuid_relacionados'];

       $uudis = trim($uudis,',');

       

       if(trim($uudis) == ','){return null;}

       if(trim($uudis) != ''){return explode(',', $uudis);}    

       

       return null;

    }

    

    public function getSerie(){

        return $this->options['serie'];

    }

    

    public function getFolio(){

        return str_pad($this->options['folio'], 5, "0", STR_PAD_LEFT); 

    }

    

    public function getNumFactura(){

        $numFactura = '';

        if(trim($this->getSerie())!=''){

            $numFactura .= $this->getSerie()."-";

        }

        

        return $numFactura .=$this->getFolio();

    }

    

    public function getTotal(){

        return $this->options['total'];

    }

    

    public function getTotalParaCodigoQR(){

        $total = explode('.', $this->getTotal());

        $entero = str_pad($total[0], 10, "0", STR_PAD_LEFT); 

        $decimal = str_pad($total[1], 6, "0", STR_PAD_LEFT); 

        

        return $entero.".".$decimal;

    }

    

    public function getMetodoDePago(){

        return $this->options['metodo_de_pago'];

    }

    

    public function getMetodoDePagoNombre(){

        if($this->getVersionCFDI()=='3.3'){

            return $this->options_aux['metodoName'];

        }elseif($this->getVersionCFDI()=='3.2'){

            return $this->options_aux['formaName'];

        }

        

    }

    

    public function getNumCuentaPago(){

        $comprobante = $this->getDatosComprobante();

        return $comprobante['NumCtaPago'];

    }

    

    public function getFechaTimbrado(){

       return $this->options['fecha_timbrado'];

    }

    

    public function getFechaFactura(){

        $fecha = substr($this->getFechaTimbrado(), 0, 10);

        $fecha = strftime('%d/%m/%Y',  strtotime($fecha));

        

        $hora = substr($this->getFechaTimbrado(), 11, 8);

        return $fecha ." ".$hora;

    }

    

    public function getComentarios(){

        return $this->options['comentarios'];

    }

    

    public function getDatosComprobante(){

        return unserialize($this->options['datos_comprobante']);

    }

    

    public function getDatosReceptor(){

        return unserialize($this->options['datos_receptor']);

    }

    

    public function getConceptos(){

        return unserialize($this->options['datos_conceptos']);

    }   

    

    

    public function getUUID(){

        return $this->options['uuid'];

    }

    

    public function getSelloCFDI(){

        return $this->options['sello_cfdi'];

    }

    

    public function getSelloSAT(){

        return $this->options['sello_sat'];

    }

    

    public function getCadenaOriginalSAT(){

        return $this->options['cadena_original_sat'];

    }

    

    public function getNumCertificadoSAT(){

        return $this->options['certificado_sat'];

    }

    

    

    public function getTable(){

        return $this->table;

    }

    

    public function crearPDF(){

        $pdf = new FacturaPDF($this->getId(),true);

        $this->facturaPDF = $pdf->getPathFileCreated();

    }

    

    public function crearZip(){

        $zipfile = new zipfile();
        $this->archivoZip = "Factura-".$this->getNumFactura().".zip";        

        $empresa = new EmpresaRepository();
        $empresa->setOptions($empresa->getById(1));
        

        $zipfile->add_file(implode("",file($this->facturaPDF)),$this->getNumFactura().".pdf");
        $zipfile->add_file(implode("",file(ROOT."app/resources/docs/sat/".$empresa->getRFC()."/".$this->getSucursal()."/Timbre-".$this->getNumFactura().".xml")),$this->getNumFactura().".xml");
        

        $fd = fopen (ROOT."app/resources/docs/sat/".$empresa->getRFC()."/".$this->getSucursal()."/temp-pdf/".$this->archivoZip, "wb");

        $out = fwrite ($fd, $zipfile->file());

        fclose ($fd);

        

        return ROOT."app/resources/docs/sat/".$empresa->getRFC()."/".$this->getSucursal()."/temp-pdf/".$this->archivoZip;

    }

    

    public function descargarZip(){    

        $file = $this->crearZip();

        $fileName = $this->getRutaArchivoZip();



        header("Content-type: application/octet-stream");

        header("Content-disposition: attachment; filename=$fileName");

        // leemos el archivo creado

       

        readfile($file);

    }

    

    public function getRutaArchivoZip(){

        return $this->archivoZip;

    }

}

