<?php
class FacturaRepository extends EntityRepository
{
    private $table = 'facturas';
    public $flashmessenger = null;

    private $options = array(
        'sucursal' => null,
        'id_cliente' => null,
        'rfc_receptor' => null,
        'tipo_documento' => null,
        'serie' => null, #varchar(25)
        'folio' => null, #int
        'forma_de_pago' => null, #varchar(100)
        'metodo_de_pago' => null, #carchar(50) Ejemplo: Efectivo-Cheque-Tarjeta
        'num_cuenta_pago' => null,
        'condiciones_de_pago' => null,
        'tipo_relacion' => null,
        'uso_cfdi' => null,
        'uuid_relacionados' => null,
        'uuid_relacionados_otros' => null,
        'moneda' => null,
        'tipo_de_cambio' => null,
        'subtotal' => null, #double
        'descuento' => null,
        'total' => null,
        'iva_tasa' => null,
        'total_impuestos_trasladados' => null,
        'total_impuestos_retenidos' => null,
        'detalles_impuestos_aplicables' => null,
        'comentarios' => null,
        'datos_comprobante' => null,
        'datos_emisor' => null,
        'datos_receptor' => null,
        'datos_conceptos' => null,
        'uuid' => null,
        'certificado_sat' => null,
        'fecha_timbrado' => null,
        'sello_sat' => null,
        'cadena_original_sat' => null,
        'sello_cfdi' => null,
        'status' => null,
        'date' => null,
        'due_date' => null,
        'payment_terms' => null,
        'version_cfdi' => null,
        'saldo_pendiente' => null, # se añade para igualar el total a el campo de saldo_pendiente
        'total_cuenta_de_gastos' => null, /*Auxiliar para generar Factura de Cuenta de Gastos*/
        'adjunto' => null
    );

    private $options_aux = array(
        'saldoPendiente' => null,
        'comprobanteName' => null,
        'formaName' => null,
        'metodoName' => null,
        'monedaName' => null,
        'usoCFDIName' => null,
        'uuid_relacionados_y_otros_uuid_relacionados' => null,
        'token_form' => null #Se popula con setOption desde Controller, con post de formulario
    );

    private $options_files = array(
        'allowedExtensions' => array('pdf'),
        'maxFileSizeAllowed' => 1000000,
        'pathToSave' => PATH_FACTURAS
    );

    public function setOptions($data)
    {
        foreach ($this->options as $option => $value) {
            if (isset($data[$option])) {
                $this->options[$option] = $data[$option];
            }
        }

        foreach ($this->options_aux as $option => $value) {
            if (isset($data[$option])) {
                $this->options_aux[$option] = $data[$option];
            }
        }
    }

    public function getOptions()
    {
        return $this->options;
    }

    public function getStatus()
    {
        return $this->options['status'];
    }

    public function getVersionCFDI()
    {
        return $this->options['version_cfdi'];
    }

    public function getSucursal()
    {
        return $this->options['sucursal'];
    }

    public function getIdCliente()
    {
        return $this->options['id_cliente'];
    }

    public function getSaldoPendiente()
    {
        return $this->options['saldo_pendiente'];
    }

    public function getTipoComprobante()
    {
        return $this->options['tipo_documento'];
    }

    public function getTipoComprobanteNombre()
    {
        return $this->options_aux['comprobanteName'];
    }

    public function getFormaDePago()
    {
        return $this->options['forma_de_pago'];
    }

    public function getFormaDePagoNombre()
    {
        return $this->options_aux['formaName'];
    }

    public function getCondicionesDePago()
    {
        return $this->options['condiciones_de_pago'];
    }

    public function getSubTotal()
    {
        return $this->options['subtotal'];
    }

    public function getDescuento()
    {
        return $this->options['descuento'];
    }

    public function getImpuestosAplicables()
    {
        return unserialize($this->options['detalles_impuestos_aplicables']);
    }

    public function getMoneda()
    {
        return $this->options['moneda'];
    }

    public function getMonedaNombre()
    {
        return $this->options_aux['monedaName'];
    }

    public function getTipoDeCambio()
    {
        return $this->options['tipo_de_cambio'];
    }

    public function getNumCuenta()
    {
        return $this->options['num_cuenta_pago'];
    }

    public function getFechaVencimiento()
    {
        return $this->options['due_date'];
    }

    public function getUsoCFDI()
    {
        return $this->options['uso_cfdi'];
    }

    public function getUsoCFDINombre()
    {
        return $this->options_aux['usoCFDIName'];
    }

    public function getTipoRelacion()
    {
        return $this->options['tipo_relacion'];
    }

    public function getUUIDsRelacionados()
    {
        return $this->options['uuid_relacionados'];
    }

    public function getCFDIRelacionados()
    {
        $uudis = $this->options_aux['uuid_relacionados_y_otros_uuid_relacionados'];
        $uudis = trim($uudis, ',');

        if (trim($uudis) == ',') {
            return null;
        }
        if (trim($uudis) != '') {
            return explode(',', $uudis);
        }

        return null;
    }

    public function getSerie()
    {
        return $this->options['serie'];
    }

    public function getFolio()
    {
        return str_pad($this->options['folio'], 5, "0", STR_PAD_LEFT);
    }

    public function getNumFactura()
    {
        $numFactura = '';
        if (trim($this->getSerie()) != '') {
            $numFactura .= $this->getSerie() . "-";
        }
        return $numFactura .= $this->getFolio();
    }

    public function getTotal()
    {
        return $this->options['total'];
    }

    public function getTotalParaCodigoQR()
    {
        $total = explode('.', number_format($this->getTotal(), 2));
        $entero = str_pad($total[0], 10, "0", STR_PAD_LEFT);
        $decimal = str_pad($total[1], 6, "0", STR_PAD_LEFT);

        return $entero . "." . $decimal;
    }

    public function getMetodoDePago()
    {
        return $this->options['metodo_de_pago'];
    }

    public function getMetodoDePagoNombre()
    {
        if ($this->getVersionCFDI() == '3.3') {
            return $this->options_aux['metodoName'];
        } elseif ($this->getVersionCFDI() == '3.2') {
            return $this->options_aux['formaName'];
        }
    }

    public function getNumCuentaPago()
    {
        $comprobante = $this->getDatosComprobante();
        return $comprobante['NumCtaPago'];
    }

    public function getFechaTimbrado()
    {
        return $this->options['fecha_timbrado'];
    }

    public function getFechaFactura()
    {
        $fecha = substr($this->getFechaTimbrado(), 0, 10);
        $fecha = strftime('%d/%m/%Y', strtotime($fecha));

        $hora = substr($this->getFechaTimbrado(), 11, 8);
        return $fecha . " " . $hora;
    }

    public function getComentarios()
    {
        return $this->options['comentarios'];
    }

    public function getDatosComprobante()
    {
        return unserialize($this->options['datos_comprobante']);
    }

    public function getDatosReceptor()
    {
        return unserialize($this->options['datos_receptor']);
    }

    public function getDatosEmisor()
    {
        return unserialize($this->options['datos_emisor']);
    }

    public function getConceptos()
    {
        return unserialize($this->options['datos_conceptos']);
    }

    public function getUUID()
    {
        return $this->options['uuid'];
    }

    public function getSelloCFDI()
    {
        return $this->options['sello_cfdi'];
    }

    public function getSelloSAT()
    {
        return $this->options['sello_sat'];
    }

    public function getCadenaOriginalSAT()
    {
        return $this->options['cadena_original_sat'];
    }

    public function getTokenForm()
    {
        return $this->options_aux['token_form'];
    }

    public function getNumCertificadoSAT()
    {
        return $this->options['certificado_sat'];
    }

    public function getTable()
    {
        return $this->table;
    }

    public function crearPDF()
    {
        if ($this->getTipoComprobante() == 'CG') {
            $pdf = new CuentaDeGastosPDF($this->getId(), true);
            $this->facturaPDF = $pdf->getPathFileCreated();
            $this->crearZipCuentaDeGastos();
        } else {
            $filename = PATH_SAT_DOCS . $this->getSucursal() . "/temp-pdf/Factura-" . $this->getSerie() . "-" . $this->getFolio() . ".pdf";
            if (file_exists($filename)) {
                $this->facturaPDF = $filename;
            } else {
                $pdf = new FacturaPDF($this->getId(), true);
                $this->facturaPDF = $pdf->getPathFileCreated();
            }
            $this->crearZip();
        }
    }

    public function reObtenerXmlTimbrado($filename)
    {
        if (empty($this->getUUID())) {
            throw new Exception('Invalid UUID');
        }

        $settings = new SettingsRepository();
        $tipoTimbrado = $settings->_get('tipo_timbrado');
        $serverURL = $settings->_get($tipoTimbrado . '_timbrado_serverURL');
        $usuarioTimbrado = $settings->_get($tipoTimbrado . '_timbrado_usuario');
        $metodoALlamar = $settings->_get('timbrado_consulta_metodoALlamar');

        $params = array();
        $params['usuarioIntegrador'] = $usuarioTimbrado;
        $params['rfcEmisor'] = $this->getDatosEmisor()['Emisor']['Rfc'];
        $params['folioUUID'] = $this->getUUID();

        $client = new SoapClient($serverURL, $params);
        $response = $client->__soapCall($metodoALlamar, array('parameters' => $params));

        /* Obtenemos resultado del response */
        $xmlTimbrado = $response->ObtieneCFDIResult->anyType[3];
        $descripcionResultado = $response->ObtieneCFDIResult->anyType[2];
        $numeroExcepcion = $response->ObtieneCFDIResult->anyType[1];

        if ($numeroExcepcion == "0") {
            /* El comprobante fue timbrado correctamente */
            /* Guardamos comprobante timbrado */
            file_put_contents($filename, $xmlTimbrado);
            return true;
            /* Guardamos codigo qr */
            //file_put_contents('C:\Users\Andres\Desktop\codigoQr.jpg', $codigoQr);

            /* Guardamos cadena original del complemento de certificacion del SAT */
            //file_put_contents('C:\Users\Andres\Desktop\cadenaOriginal.txt', $cadenaOriginal);
        } else {
            #Produccion
            //throw new Exception('Oopss!!. Algo salio mal durante el proceso de facturacion.<br/> Contacta a tu proveedor del servicio para mas informacion.');
            #Develop
            #$numeroExcepcion.'=>'.$descripcionResultado
            throw new Exception($descripcionResultado);
        }
    }

    public function crearZip()
    {
        $xmlFileName = PATH_SAT_DOCS . DIRECTORY_SEPARATOR . $this->getSucursal() . DIRECTORY_SEPARATOR . 'Timbre-' . $this->getNumFactura() . '.xml';
        if (!file_exists($xmlFileName)) {
            $this->reObtenerXmlTimbrado($xmlFileName);
        }

        $zipfile = new zipfile();
        $this->archivoZipName = "Factura-" . $this->getNumFactura() . ".zip";

        $empresa = new EmpresaRepository();
        $empresa->setOptions($empresa->getById(1));

        $zipfile->add_file(implode("", file($this->facturaPDF)), $this->getNumFactura() . ".pdf");
        $zipfile->add_file(implode("", file($xmlFileName)), $this->getNumFactura() . ".xml");

        $fd = fopen(PATH_SAT_DOCS . "/" . $this->getSucursal() . "/temp-pdf/" . $this->archivoZipName, "wb");
        $out = fwrite($fd, $zipfile->file());
        fclose($fd);

        $this->archivoZipPath = PATH_SAT_DOCS . "/" . $this->getSucursal() . "/temp-pdf/" . $this->archivoZipName;
    }

    public function crearZipCuentaDeGastos()
    {
        $zipfile = new zipfile();
        $this->archivoZipName = "Factura-" . $this->getNumFactura() . ".zip";

        $empresa = new EmpresaRepository();
        $empresa->setOptions($empresa->getById(1));

        $zipfile->add_file(implode("", file($this->facturaPDF)), $this->getNumFactura() . ".pdf");

        $fd = fopen(PATH_SAT_DOCS . "/" . $this->getSucursal() . "/temp-pdf/" . $this->archivoZipName, "wb");
        $out = fwrite($fd, $zipfile->file());
        fclose($fd);

        $this->archivoZipPath = PATH_SAT_DOCS . "/" . $this->getSucursal() . "/temp-pdf/" . $this->archivoZipName;
    }

    public function descargarZip()
    {
        $filePahth = $this->getRutaArchivoZip();

        header("Content-type: application/octet-stream");
        header("Content-disposition: attachment; filename={$this->archivoZipName}");
        // leemos el archivo creado

        readfile($filePahth);
    }

    public function getRutaArchivoZip()
    {
        return $this->archivoZipPath;
    }

    public function __construct()
    {
        if (!$this->flashmessenger instanceof FlashMessenger) {
            $this->flashmessenger = new FlashMessenger();
        }
    }

    public function _getTranslation($text)
    {
        return $this->flashmessenger->_getTranslation($text);
    }

    public function saveFiles($files, $pref1)
    {
        $file = new UploadFile();
        $file->setAllowedExtensions($this->options_files['allowedExtensions']);
        $file->setMaxFileSizeAllowed($this->options_files['maxFileSizeAllowed']);
        $file->setTempFolder($this->options_files['pathToSave']);
        $rsUpload = $file->uploadMultipleFile($files['adjunto'], $pref1);
        if (!$rsUpload) {
            $this->flashmessenger->addMessage(array('info' => $file->getMessageError()));
            return null;
        }
        return true;
    }

    public function save(array $data, $table = null)
    {
        $tools = new Tools();
        $settings = new SettingsRepository();
        $data['version_cfdi'] = $settings->_get('version_cfdi');
        $data['status'] = '1';
        if (is_array($data['uuid_relacionados'])) {
            $data['uuid_relacionados'] = implode(',', $data['uuid_relacionados']);
        }
        if (is_array($data['uuid_relacionados_otros'])) {
            $data['uuid_relacionados_otros'] = implode(',', $data['uuid_relacionados_otros']);
        }
        if (trim($data['folio']) == '' || $data['folio'] == null) {
            unset($data['folio']);
        }
        if (trim($data['subtotal']) == '' || $data['subtotal'] == null) {
            unset($data['subtotal']);
        }
        if (trim($data['descuento']) == '' || $data['descuento'] == null) {
            unset($data['descuento']);
        }
        if (trim($data['total']) == '' || $data['total'] == null) {
            unset($data['total']);
        }
        if (trim($data['total_cuenta_de_gastos']) == '' || $data['total_cuenta_de_gastos'] == null) {
            $data['total_cuenta_de_gastos'] = '0';
        }
        if (trim($data['iva_tasa']) == '' || $data['iva_tasa'] == null) {
            unset($data['iva_tasa']);
        }
        $data['detalles_impuestos_aplicables'] = $_SESSION['detalles_impuestos_aplicables'];
        $data['saldo_pendiente'] = $data['total'];
        $data['date'] = $tools->setFormatDateToDB($data['date']);
        $data['due_date'] = $tools->setFormatDateToDB($data['due_date']);

        $invoice_file = $data['adjunto'];

        $saveData = $data;
        unset($saveData['total_cuenta_de_gastos'], $saveData['adjunto']);

        $this->startTransaction();
        $rs = parent::save($saveData, $this->table);

        $facturaDetallesTemp = new FacturaDetailsTempRepository();
        $idFactura = $this->getInsertId();
        $this->setLastInsertId($idFactura); //Para utilizarlo en el Controller action insert

        if ($rs) {
            if ($facturaDetallesTemp->saveDetalles($idFactura, $this->getTokenForm())) {
                $settings = new SettingsRepository();

                if (isset($invoice_file['adjunto']['name'][0]) && $invoice_file['adjunto']['name'][0] != '') {
                    $this->saveFiles($invoice_file, $idFactura);
                }

                if ($settings->_get('habilitar_cuenta_de_gastos') == '1') {
                    if (!$this->saveCuentaDeGastos($data, $idFactura)) {
                        $this->rollback();
                        return null;
                    }
                }

                $this->commit();
                $facturaDetallesTemp->truncate($this->getTokenForm());
                return true;
            }
        }

        $this->rollback();
        $this->flashmessenger->addMessage(array(
            'error' => $this->_getTranslation('Error. Intenta nuevamente o contacta a tu proveedor de sistemas.')
        ));

        return null;
    }

    public function update($id, $data, $table = null)
    {
        unset($data['status'], $data['version_cfdi']);
        if (is_array($data['uuid_relacionados'])) {
            $data['uuid_relacionados'] = implode(',', $data['uuid_relacionados']);
        }
        if (is_array($data['uuid_relacionados_otros'])) {
            $data['uuid_relacionados_otros'] = implode(',', $data['uuid_relacionados_otros']);
        }
        if (trim($data['folio']) == '' || $data['folio'] == null) {
            unset($data['folio']);
        }
        if (trim($data['subtotal']) == '' || $data['subtotal'] == null) {
            unset($data['subtotal']);
        }
        if (trim($data['descuento']) == '' || $data['descuento'] == null) {
            unset($data['descuento']);
        }
        if (trim($data['total']) == '' || $data['total'] == null) {
            unset($data['total']);
        }
        if (trim($data['total_cuenta_de_gastos']) == '' || $data['total_cuenta_de_gastos'] == null) {
            $data['total_cuenta_de_gastos'] = '0';
        }
        if (trim($data['iva_tasa']) == '' || $data['iva_tasa'] == null) {
            unset($data['iva_tasa']);
        }
        $data['detalles_impuestos_aplicables'] = $_SESSION['detalles_impuestos_aplicables'];
        $data['saldo_pendiente'] = $data['total'];
        $tools = new Tools();
        $data['date'] = $tools->setFormatDateToDB($data['date']);
        $data['due_date'] = $tools->setFormatDateToDB($data['due_date']);

        $invoice_file = $data['adjunto'];
        $this->startTransaction();
        $updateData = $data;
        unset($updateData['total_cuenta_de_gastos'], $updateData['adjunto']);

        $result = parent::update($id, $updateData, $this->table);

        if ($result) {
            $repository = new FacturaDetailsTempRepository();
            if ($repository->updateDetalles($id, $this->getTokenForm())) {
                /*CUENTA DE GASTOS*/
                $settings = new SettingsRepository();

                if (isset($invoice_file['adjunto']['name'][0]) && $invoice_file['adjunto']['name'][0] != '') {
                    $this->saveFiles($invoice_file, $id);
                }

                if ($settings->_get('habilitar_cuenta_de_gastos') == '1') {
                    $idFacturaCuentaDeGastos = $this->existCuentaDeGastos($id);
                    if ($idFacturaCuentaDeGastos) {
                        if (!$this->updateCuentaDeGastos($data, $idFacturaCuentaDeGastos)) {
                            $this->rollback();
                            return null;
                        }
                    } else {
                        if (!$this->saveCuentaDeGastos($data, $id)) {
                            $this->rollback();
                            return null;
                        }
                    }
                }
                /*END CUENTA DE GASTOS*/

                $this->commit();
                $repository->truncate($this->getTokenForm());
                return true;
            }
        }

        $this->rollback();
        return null;
    }

    public function updateString($fields, $where, $table = null)
    {
        return parent::updateString($fields, $where, $this->table);
    }

    public function delete($id, $table = null)
    {
        $data = $this->getById($id);
        $idFacturaCuentaDeGasto = $this->existCuentaDeGastos($id);

        #status = 1 (Sin Timbrar)
        #Se elimina de la BD
        if ($data['status'] == '1') {
            if (parent::delete($id, $this->table)) {
                parent::query("DELETE  FROM facturas_detalles WHERE id_factura = '$id'");

                /*Eliminar cuenta de cuenta de gastos si existe*/
                if ($idFacturaCuentaDeGasto) {
                    parent::delete($idFacturaCuentaDeGasto, $this->table);
                    parent::query("DELETE  FROM facturas_detalles WHERE id_factura = '$idFacturaCuentaDeGasto'");
                }

                $this->flashmessenger->addMessage(array('success' => $this->_getTranslation('Genial !!. La Factura fue eliminada correctamente.')));
                return true;
            } else {
                throw new Exception('Opps !!. Algo salio mal al intentar eliminar la Factura.<br/>Intente nuevamente.');
            }
        } elseif ($data['status'] == '2') {
            if (parent::update($id, array('status' => '3', 'saldo_pendiente' => '0'), $this->table)) { //pudin

                /*Eliminar cuenta de cuenta de gastos si existe*/
                parent::query("UPDATE facturas SET status = '3' WHERE id = '$idFacturaCuentaDeGasto'");

                $this->flashmessenger->addMessage(array('success' => $this->_getTranslation('Genial !!. La Factura fue cancelada correctamente.')));
                return false;
            } else {
                throw new Exception('Opps !!. Algo salio mal al intentar cancelar la Factura.<br/>Intente nuevamente.');
            }
        }

        throw new Exception('La factura ya esta cancelada');
    }

    public function getById($id, $table = null, $selectAux = null)
    {
        $select = "SELECT *, "
            . "fxGetClienteName(id_cliente)as clienteName,"
            . "DATE_FORMAT(convert(substring(fecha_timbrado,1,10),date),'%d/%m/%Y')as fecha,"
            . "CONCAT(IFNULL(uuid_relacionados,''), ',' ,IFNULL(uuid_relacionados_otros,''))as uuid_relacionados_y_otros_uuid_relacionados,"
            . "fxGetTipoDeComprobanteName(tipo_documento)as comprobanteName, "
            . "DATE_FORMAT(due_date,'%m/%d/%Y')as due_date,"
            . "fxGetFormaDePagoName(forma_de_pago)as formaName, "
            . "fxGetMetodoDePagoName(metodo_de_pago)as metodoName, "
            . "fxGetMonedaName(moneda)as monedaName, "
            . "fxGetUsoCFDIName(uso_cfdi)as usoCFDIName, "
            . "subtotal,"
            . "descuento,"
            . "total,"
            . "fxGetStatusName(status,'Factura')as statusName, "
            . "fxGetUserName(creado_por) as userName "
            . "FROM $this->table "
            . "WHERE id = '$id'";

        $result = $this->query($select);

        if ($result->num_rows > 0) {
            $data = $this->resultToArray($result)[0];
            $idFacturaCuentaDeGastos = $this->existCuentaDeGastos($id);
            if ($idFacturaCuentaDeGastos) {
                $cuentaDeGastosData = parent::getById($idFacturaCuentaDeGastos, $this->table);
                $data['total_cuenta_de_gastos'] = $cuentaDeGastosData['total'];
            }
            return $data;
        }

        return false;
    }

    public function isUsedInRecord($id, array $buscarEn = null, $andWhere = null)
    {
        return null;
    }

    public function savePdfAsFile($idFactura)
    {
        $settings = new SettingsRepository();
        $template = $settings->_get('plantilla_factura_pdf');
        $template = (!empty($template)) ? $template : 'FacturaPDF';

        $pdf = new $template($idFactura, true);
    }

    public function guardarDatosTimbrado($data, $idFactura)
    {
        if ($this->updateString($data, " id = " . $idFactura)) {
            $idFacturaCuentaGasto = $this->existCuentaDeGastos($idFactura);
            if ($idFacturaCuentaGasto) {
                $entity = new FacturaRepository();
                $entity->setOptions($entity->getById($idFactura));
                /*Update cuenta de gastos*/
                parent::update($idFacturaCuentaGasto, array('folio' => $entity->getFolio(), 'fecha_timbrado' => $entity->getFechaTimbrado()), $this->table);
            }

            $this->savePdfAsFile($idFactura);

            return true;
        }
        return null;
    }

    public function crearTablaDetallesForUser()
    {
        $login = new Login();

        $query = "CREATE TABLE IF NOT EXISTS factura_detalles_" . $login->getId() . "
                 (
                    `token_form` char(50) NOT NULL,
                    `id` int(11) NOT NULL AUTO_INCREMENT,
                    `id_detail` int(11) NULL,
                    `id_factura` int(11) NULL,
                    `id_producto` int(11) NOT NULL,
                    `nombre` varchar(255) NOT NULL,
                    `descripcion` text NULL,
                    `cantidad` double NOT NULL,
                    `precio_unitario` double NOT NULL,
                    `descuento_detalle` double NULL,
                    `descuento_monto` double  NULL,
                    `importe` double NULL,
                    `impuestos_incluidos` varchar(255)  NULL,
                    `impuestos` varchar(50)  NULL,
                    `impuestos_aplicables` TEXT  NULL,
                    PRIMARY KEY (`id`)
                 )ENGINE=InnoDB DEFAULT CHARSET=utf8;";

        $result = $this->query($query);

        $query = "DROP TABLE IF EXISTS cuenta_de_gastos_detalles_" . $login->getId();
        $this->query($query);

        $query = "CREATE TABLE IF NOT EXISTS cuenta_de_gastos_detalles_" . $login->getId() . "
                 (  `id` int(11) NOT NULL AUTO_INCREMENT,
                    `id_detail` int(11) NULL,
                    `id_factura` int(11) NULL,
                    `id_producto` int(11) NOT NULL,
                    `nombre` varchar(255) NOT NULL,
                    `descripcion` text NULL,
                    `precio_unitario` double NOT NULL,
                    PRIMARY KEY (`id`)
                 )ENGINE=InnoDB DEFAULT CHARSET=utf8;";

        $result = $this->query($query);
    }

    public function insertDetalle($data)
    {
        $facturaDetallesTemp = new FacturaDetailsTempRepository();
        return $facturaDetallesTemp->save($data);
    }
    public function getFacturaDetalles($token_form)
    {
        $login = new Login();
        $query = "SELECT v.*,
                    fxGetUMDescription(p.unidad_de_medida) as umName,
                    v.id as idDetailTemp,
                    p.codigo,
                    p.impuestos
                  FROM factura_detalles_" . $login->getId() . " v LEFT JOIN productos p
                  ON v.id_producto = p.id
                  WHERE token_form = '$token_form'
                  ORDER BY v.id";
        $result = $this->query($query);

        if ($result) {
            $result = $this->resultToArray($result);
            return $result;
        }

        return null;
    }

    public function getFacturaDetallesSaved($id)
    {
        $query = "SELECT c.*,
                    p.unidad_de_medida as um,
                    p.sat_producto_clave,
                    p.sat_producto_descripcion,
                    fxGetUMDescription(p.unidad_de_medida) as umName,
                    c.id as idDetailTemp,
                    p.codigo,
                    p.impuestos,
                    p.impuestos_incluidos
                    FROM facturas_detalles c LEFT JOIN productos p ON c.id_producto = p.id
                    WHERE c.id_factura = '$id'";
        $result = $this->query($query);

        if ($result) {
            $result = $this->resultToArray($result);
            return $result;
        }
        return null;
    }

    public function setFacturaDetallesById($idFactura, $tokenForm)
    {
        $repository = new FacturaDetailsTempRepository();
        return $repository->setStoreInDetailsById($idFactura, $tokenForm);
    }

    public function truncateIfIsEditInfo()
    {
        $repository = new FacturaDetailsTempRepository();
        $repository->truncateIfIsEditInfo();
    }

    public function getProductById($idProducto)
    {
        $query = "SELECT * FROM productos WHERE id = '$idProducto' LIMIT 1";
        $result = $this->query($query);

        if ($result->num_rows > 0) {
            $result = $this->resultToArray($result);
            return $result[0];
        }
        return null;
    }

    public function getListFacturas($options = null)
    {
        $vendorInvoice = null;
        $status = null;
        $limit = null;
        $date = null;
        $folio = null;
        $serie = null;

        //echo "<pre>";var_dump($options);echo "</pre>";exit;

        if ($options) {
            $date = $this->createFilterFecha($options, 'f.creado_fecha');
            if (isset($options['id_cliente'])) {
                if (is_array($options['id_cliente']) && count($options['id_cliente']) > 0) {
                    $customerIds = implode(',', $options['id_cliente']);
                    $vendorInvoice = " AND find_in_set(f.id_cliente,'{$customerIds}')";
                } else {
                    if (trim($options['id_cliente']) != '') {
                        $vendorInvoice = " AND find_in_set(f.id_cliente,'{$options['customer_id']}')";
                    }
                }
            }
            $statuses = join("','", $options['status']);
            if (isset($options['status']) && $options['status'] != '') {
                $status = " AND status IN('{$statuses}') ";
            } else {
                $status = "";
            }

            if (isset($options['folio']) && $options['folio'] != '') {
                $folio = " AND folio ='{$options['folio']}' ";
            } else {
                $folio = "";
            }

            if (isset($options['serie']) && $options['serie'] != '') {
                $serie = " AND serie ='{$options['serie']}' ";
            } else {
                $serie = "";
            }

            if (
                is_null($date)
                && is_null($vendorInvoice)
                && is_null($status)
            ) {
                $limit = " LIMIT 300";
            }
        } else {
            $limit = " limit 300";
        }

        $query = "SELECT f.*,
                c.rfc,
                c.razon_social,
                fxGetUserName(f.creado_por) AS creado_por_nombre,
                fxGetUserName(f.ultima_mod_por) AS ultima_mod_por_nombre,
                IF(f.status= 1,DATE_FORMAT(f.creado_fecha,'%d/%m/%Y'),DATE_FORMAT(convert(substring(f.fecha_timbrado,1,10),date),'%d/%m/%Y'))as fecha,
                fxGetStatusName(f.`status`,'Factura')as statusName
                FROM facturas f
                LEFT JOIN facturas_detalles d ON f.id = d.id_factura
                LEFT JOIN clientes c ON f.id_cliente = c.id
                WHERE  1=1
                $vendorInvoice
                $date
                $status
                $folio
                $serie
                AND (f.creado_por != '100' OR (f.creado_por = '100' AND f.status = '2'))
                GROUP BY f.id
                ORDER BY f.id DESC $limit";

        // echo $query; exit;

        $result = $this->query($query);

        if ($result->num_rows > 0) {
            return $this->resultToArray($result);
        }

        return null;
    }
    public function getListStatus()
    {
        $query = "SELECT * FROM status_codigos WHERE operacion = 'Factura'";
        $result = $this->query($query);

        if ($result->num_rows > 0) {
            $array = array();
            foreach ($result as $status) {
                $array[$status['id']] = $status['status'];
            }
            return $array;
        }
        return null;
    }


    public function getListFacturaByCliente($options)
    {
        $idCliente =  $options['cliente'];

        /*PARA MAVYL*/
        $idsClientes = '';
        $clienteRepo = new ClienteRepository();
        $clienteData = $clienteRepo->getById($idCliente);
        if ($clienteData['rfc'] == 'KME720626GS6') {
            $idsClientes = $clienteRepo->getByRFC($clienteData['rfc']);
            $idsClientes = " OR find_in_set(id_cliente,'$idsClientes')";
        }

        $query = "SELECT f.*,
                fxGetClienteName(f.id_cliente)as clienteName,
                DATE_FORMAT(convert(substring(f.fecha_timbrado,1,10),date),'%d/%m/%Y')as fecha
                FROM facturas f
                LEFT JOIN facturas_detalles d ON f.id = d.id_factura
                WHERE  1=1
                AND (status = '2' || tipo_documento = 'CG')
                AND saldo_pendiente > '0'
                AND (id_cliente = '$idCliente' $idsClientes) "
            . "GROUP BY f.id "
            . "ORDER BY f.id ASC";

        $result = $this->query($query);

        if ($result->num_rows > 0) {
            return $this->resultToArray($result);
        }
        return null;
    }

    public function getListSelectMetodosPago()
    {
        $db_admin = new DBAdminEntityRepository();
        $query = "SELECT * FROM metodos_de_pago WHERE status = '1' ORDER BY id ASC";
        $result = $db_admin->query($query);

        if ($result->num_rows > 0) {
            $array = array();
            while ($row = $result->fetch_object()) {
                $array[$row->id] = $row->metodo;
            }
            return $array;
        }
        return null;
    }

    public function getListSelectFormasPago()
    {
        $db_admin = new DBAdminEntityRepository();
        $query = "SELECT * FROM formas_de_pago WHERE status = '1' ORDER BY id ASC";
        $result = $db_admin->query($query);

        if ($result->num_rows > 0) {
            $array = array();
            while ($row = $result->fetch_object()) {
                $array[$row->codigo] = "{$row->codigo} - {$row->forma}";
            }
            return $array;
        }

        return null;
    }



    public function getListTiposDeComprobante()
    {
        $db_admin = new DBAdminEntityRepository();
        $query = "SELECT * FROM tipos_de_comprobante WHERE status = '1' ORDER BY comprobante ASC";
        $result = $db_admin->query($query);

        if ($result->num_rows > 0) {
            $array = array();
            while ($row = $result->fetch_object()) {
                $array[$row->comprobante] = $row->comprobante;
            }

            return $array;
        }
        return null;
    }



    public function getListMoneda()
    {
        $db_admin = new DBAdminEntityRepository();
        $query = "SELECT * FROM monedas ORDER BY display_order IS NULL, display_order asc";

        $result = $db_admin->query($query);

        if ($result->num_rows > 0) {
            $array = array();
            while ($row = $result->fetch_object()) {
                $array[$row->moneda] = $row->moneda . ' - ' . $row->descripcion;
            }
            return $array;
        }
        return null;
    }



    public function getListTipoRelacion()
    {
        $db_admin = new DBAdminEntityRepository();
        $query = "SELECT * FROM sat_c_tiporelacion ORDER BY clave ASC";
        $result = $db_admin->query($query);

        if ($result->num_rows > 0) {
            $array = array();
            while ($row = $result->fetch_object()) {
                $array[$row->clave] = $row->descripcion;
            }
            return $array;
        }
        return null;
    }



    public function getListUsoCFDI()
    {
        $db_admin = new DBAdminEntityRepository();
        $query = "SELECT * FROM sat_c_usocfdi ORDER BY clave ASC";
        $result = $db_admin->query($query);

        if ($result->num_rows > 0) {
            $array = array();
            while ($row = $result->fetch_object()) {
                $array[$row->clave] = $row->descripcion;
            }
            return $array;
        }
        return null;
    }



    public function getListImpuestos()
    {
        $query = "SELECT * FROM impuestos ORDER BY id ASC";
        $result = $this->query($query);

        if ($result->num_rows > 0) {
            $impuestos = array();
            foreach ($this->resultToArray($result) as $impuesto) {
                $impuestos[$impuesto['id']] = $impuesto;
            }
            return $impuestos;
        }
        return null;
    }



    public function esRangoDeFacturacionValido($idSucursal, $total)
    {
        $query = "SELECT r.minimo,r.maximo,IF($total >= minimo AND $total <= maximo,'si','no')as rangoValido "
            . "FROM rangos_de_facturacion r, sucursales s "
            . "WHERE r.id = s.rango_de_facturacion "
            . "AND s.id = '$idSucursal' ";

        $result = $this->query($query);
        if ($result) {
            return $result = $result->fetch_object();
        }
    }

    public function getListUUIDByCliente($cliente = null)
    {
        $query = "SELECT CONCAT(serie,folio)as factura,uuid FROM facturas where id_cliente = '$cliente' AND status = 3 ORDER BY id ASC";

        $result = $this->query($query);

        if ($result->num_rows > 0) {
            $array = array();
            foreach ($this->resultToArray($result) as $row) {
                #$array[$row['uuid']] = $row['factura']." - ".$row['uuid'];
                $array[$row['uuid']] = $row['factura'];
            }
            return $array;
        }
        return null;
    }

    public function setSaldoPendiente($idFactura)
    {
        $query = "UPDATE $this->table SET saldo_pendiente = fxGetSaldoPendienteFactura($idFactura) "
            . "WHERE id = '$idFactura' ";

        $result = $this->query($query);

        if ($result) {
            return true;
        }
        return null;
    }

    /* CUENTA DE GASTOS*/
    public function insertCuentaDeGastosDetalle($data)
    {
        $facturaDetallesTemp = new FacturaDetailsTempRepository();
        return $facturaDetallesTemp->saveCuentaDeGastos($data);
    }

    public function getCuentaDeGastosDetalles()
    {
        $login = new Login();
        $query = "SELECT
                    p.codigo,
                    p.nombre,
                    v.id,
                    v.id as cg_idDetailTemp,
                    v.id_producto as cg_id_producto,
                    v.descripcion as cg_descripcion,
                    v.precio_unitario as cg_precio_unitario
                  FROM cuenta_de_gastos_detalles_" . $login->getId() . " v LEFT JOIN productos p
                  ON v.id_producto = p.id
                  ORDER BY v.id";
        $result = $this->query($query);

        if ($result) {
            $result = $this->resultToArray($result);
            return $result;
        }

        return null;
    }

    public function setCuentaDeGastosDetallesById($idFactura)
    {
        $repository = new FacturaDetailsTempRepository();
        return $repository->setCuentaDeGastosDetailsById($idFactura);
    }

    public function saveCuentaDeGastos($data, $idFactura)
    {
        $facturaDetallesTemp = new FacturaDetailsTempRepository();
        if ($facturaDetallesTemp->existenRegistros() == null) {
            return true;
        }

        $repoSucursal = new SucursalRepository();
        $sucursalData = $repoSucursal->getById($data['sucursal']);

        /*CREA UNA FACTURA PARA CUENTA DE GASTOS REGISTRADOS */
        $login  = new Login();
        $settings = new SettingsRepository();
        $facturaData = array(
            'version_cfdi' => $settings->_get('version_cfdi'),
            'tipo_documento' => 'CG',
            'serie' => $sucursalData['serieCuentaDeGastosName'],
            'sucursal' => $data['sucursal'],
            'id_cliente' => $data['id_cliente'],
            'forma_de_pago' => '01',
            'metodo_de_pago' => 'PUE',
            'moneda' => 'MXN',
            'tipo_de_cambio' => 1,
            'uso_cfdi' => 'G03',
            'subtotal' => $data['total_cuenta_de_gastos'],
            'descuento' => 0,
            'total' => $data['total_cuenta_de_gastos'],
            'saldo_pendiente' => $data['total_cuenta_de_gastos'],
            'uuid' => $idFactura, //Este campo lo utilizare para relacionar las Facturas CG (tipo_documento = CG (Cuenta de gastos)) con su Factura principal
            'status' => '4',
            'creado_por' => $login->getId(),
            'creado_fecha' => date('Y-m-d h:m:s')
        );

        $result = parent::save($facturaData, $this->table);
        if ($result) {
            if (!$facturaDetallesTemp->saveCuentaDeGastosDetalles($this->getInsertId())) {
                return null;
            }
            return true;
        }

        return null;
    }

    public function updateCuentaDeGastos($data, $idFacturaCuentaDeGastos)
    {
        $updateFactura = array(
            'subtotal' => $data['total_cuenta_de_gastos'],
            'descuento' => 0,
            'total' => $data['total_cuenta_de_gastos'],
            'saldo_pendiente' => $data['total_cuenta_de_gastos'],
        );

        if (parent::update($idFacturaCuentaDeGastos, $updateFactura, $this->table)) {
            $facturaDetallesTemp = new FacturaDetailsTempRepository();
            return $facturaDetallesTemp->updateCuentaDeGastosDetalles($idFacturaCuentaDeGastos);
        }
        return null;
    }

    public function existCuentaDeGastos($idFactura)
    {
        $query = "SELECT * FROM $this->table WHERE uuid = '$idFactura'";
        $result = $this->query($query);

        if ($result->num_rows > 0) {
            $result = $result->fetch_object();
            return $result->id;
        }
        return null;
    }

    /* END CUENTA DE GASTOS*/
    public function createFilterFecha($options, $campoFecha = null)
    {
        if (!isset($options['startDate']) && !isset($options['endDate'])) {
            return null;
        }
        $fechaInicio = $options['startDate'];
        $fechaFin = $options['endDate'];
        $fecha = null;
        $tools = new Tools();
        if ($fechaInicio != null) {
            $fechaInicio = $tools->setFormatDateToDBFacturas($fechaInicio);
            if ($fechaFin != null) {
                $fechaFin = $tools->setFormatDateToDBFacturas($fechaFin);

                $fecha .= " AND (convert(substring({$campoFecha},1,10),date) BETWEEN '{$fechaInicio}' AND '{$fechaFin}' ";
                if ($campoFecha) {
                    $fecha .= " OR $campoFecha BETWEEN '{$fechaInicio}' AND '{$fechaFin}' ) ";
                }
            } else {
                $fecha .= " AND (convert(substring({$campoFecha},1,10),date) BETWEEN '{$fechaInicio}' AND '{$fechaInicio}' ";
                if ($campoFecha) {
                    $fecha .= " OR $campoFecha BETWEEN '{$fechaInicio}' AND '{$fechaInicio}') ";
                }
            }
        } elseif ($fechaFin != null) {
            $fecha .= " AND (convert(substring({$campoFecha},1,10),date) BETWEEN '{$fechaFin}' AND '{$fechaFin}' ";
            if ($campoFecha) {
                $fecha .= " OR $campoFecha BETWEEN '{$fechaFin}' AND '{$fechaFin}') ";
            }
        }
        //var_dump($fecha);exit;
        return $fecha;
    }

    public function getNextNumParcialidad($idFactura)
    {
        $query = "select count(num_parcialidad) as actual from pagos_detalle as d"
            . " join pagos as p on p.id = d.id_pago where d.id_factura   = '$idFactura' and p.status != 3 ";

        $result = $this->query($query);
        if ($result) {
            $result = $result->fetch_object();
            $actual = $result->actual;

            if ($actual > 0) {
                $actual = $actual + 1;
                return $actual;
            } else {
                $actual = 1;
                return $actual;
            }
        }
        return null;
    }

    //Pudin
    public function updateEnviadoFactura($idFactura)
    {
        $query = "UPDATE facturas SET enviado = 1 WHERE id = '$idFactura'";
        $result = $this->query($query);
    }

    public function getFacturaPorRangoFecha($fecha_inicio = null, $fecha_fin = null)
    {
        $fecha = "";
        $fecha = $this->createFilterFecha(array('fechaInicio' => $fecha_inicio, 'fechaFin' => $fecha_fin));
        $query = "SELECT
            SUM(total) as total_sales,
            MONTHNAME(fecha_timbrado) as mes,
            YEAR(fecha_timbrado) as yearRow
            FROM facturas
            WHERE 1=1 AND STATUS = 2 $fecha
            GROUP BY MONTH(fecha_timbrado), YEAR(fecha_timbrado)";

        $result = $this->query($query);

        if ($result) {
            $result = $this->resultToArray($result);
            return $result;
        }

        return null;
    }

    public function getListFiles($id)
    {
        if ($id) {
            $file = PATH_FACTURAS;
            $alt = "/app/resources/docs/adjuntos/facturas/";
            if (file_exists($file)) {
                $directorio = dir($file);

                while ($archivo = $directorio->read()) {
                    if ($archivo != "__" . $id) {
                        if (strtolower(substr($archivo, -3) == "pdf")) {
                            $file_s = explode(".", $archivo);
                            $file_s = $file_s[0];
                            $nombre = explode('+', $file_s);
                            $prefijo = $id . "+___+" . $nombre[2] . "+___+" . $nombre[4];
                            $pos = strpos($file_s, $prefijo);

                            if ($pos === false) {
                                //echo "La cadena '$file_s' no fue encontrada en la cadena '$prefijo'";
                            } else {
                                $file_s = explode("_", $file_s);
                                echo "<ul style='padding: 0px;' class='breadcrumb list-group-horizontal'>
                                      <li class='list-inline text-right' style='padding-right:10px;'>
                                        <a class='text-right' href='" . $alt . $archivo . "' target='_blank'>" . $file_s[3] . "</a>
                                        <a class='invoiceFile' data-filedelete='" . ROOT_HOST . $alt . $archivo . "' style='padding: 0px 5px 0px 5px;'>
                                            <i id='trash' class='fa fa-trash fa-lg text-danger'></i>
                                            </a>
                                            <span>/</span>
                                      </li>

                                    </ul>";
                            }
                        }
                    }
                }
            }
        }
    }

    public function getDueDate($date, $creditDays)
    {
        $query = "SELECT DATE_ADD('{$date}',INTERVAL $creditDays DAY)as due_date";
        $result = $this->query($query);

        if ($result) {
            $result = $result->fetch_object();
            return $result->due_date;
        }
        return '';
    }
    public function getFacturasPorFecha(array $options)
    {
        if ($options['cliente'] != null) {
            $cliente = implode(',', $options['cliente']);
        }
        $options['startDate'] = $options['fechaInicio'];
        $options['endDate'] = $options['fechaFin'];

        $fecha = $this->createFilterFecha($options, 'fecha_timbrado_solo_fecha');
        $sucursal = $options['sucursal'] ? " AND sucursal = {$options['sucursal']} " : null;
        $cliente = $options['cliente'] ? " AND find_in_set(v.id_cliente,'$cliente') " : null;
        $serie = !empty($options['serie']) ? " AND upper(v.serie) = '{$options['serie']}' " : null;

        $folio = $this->getBetweenCondition($options['folio_below_limit'], $options['folio_up_limit'], 'v.folio');
        $importe = $this->getBetweenCondition($options['importe_below_limit'], $options['importe_up_limit'], 'v.subtotal');
        $iva = $this->getBetweenCondition($options['iva_total_below_limit'], $options['iva_total_up_limit'], 'v.total_impuestos_trasladados');

        $saldo_pendiente = (isset($options['saldo_pendiente']) && !empty($options['saldo_pendiente'])) ? " AND v.saldo_pendiente > 0 " : null;
        $rfc = (!empty($options['rfc'])) ? " AND v.rfc_receptor = '{$options['rfc']}' " : null;


        $query = "SELECT
        max( pd.creado_fecha ) as ultimo_pago,
        v.*,
        fxGetStatusName ( v.STATUS, 'Factura' ) AS statusName,
        fxGetSucursalName ( v.sucursal ) AS sucursalName,
        c.razon_social,
        pt.`name` as payment_term
    FROM
        view_facturas_timbradas v
        LEFT JOIN ( SELECT id_pago, id_factura, creado_fecha FROM pagos_detalle pd ORDER BY creado_fecha ) pd ON pd.id_factura = v.id
        left join payment_terms pt on pt.id = v.payment_terms
        INNER JOIN clientes c ON c.id = v.id_cliente
            WHERE 1=1 $fecha
            $sucursal
            $cliente
            $serie
            $folio
            $importe
            $iva
            $saldo_pendiente
            $rfc
            GROUP BY
                v.id
            ORDER BY serie ASC,folio DESC";

            // echo $query; exit;

        $result = $this->query($query);

        if ($result->num_rows > 0) {
            $result = $this->resultToArray($result);

            $ventasGeneradas = 0;

            $ventasMonto = 0;



            foreach ($result as $row) {
                $ventasGeneradas++;

                $ventasMonto += $row['total'];
            }

            return array(

                'data' => $result,

                'ventasGeneradas' => $ventasGeneradas,

                'ventasMonto' => number_format($ventasMonto, 2)

            );
        } else {
            return array(array('Resultado'), array('No se encontraron resultados.'));
        }
    }

    private function getBetweenCondition($below, $up, $column)
    {
        if (empty($below) && empty($up))
            return null;

        $str = " AND ( ";
        if (!empty($below)) {
            $below = (float)$below;
            $str .= " {$column} >= {$below} AND ";
        }

        if (!empty($up)) {
            $up = (float)$up;
            $str .= " {$column} <= {$up} AND ";
        }
        $str = rtrim($str, "AND ");
        $str .= " ) ";

        return $str;
    }


    public function getEstadoDeCuenta(array $options)
    {
        if ($options['cliente'] != null) {
            $cliente = implode(',', $options['cliente']);
        }
        $fecha['startDate'] = $options['fechaInicio'];
        $fecha['endDate'] = $options['fechaFin'];
        $fecha = $this->createFilterFecha($fecha, " v.fecha_timbrado ");
        $cliente = $options['cliente'] ? " AND find_in_set(v.id_cliente,'$cliente') " : null;

        $query = "SELECT
            c.id as id_cliente,
            c.codigo,
            c.rfc,
            c.razon_social,
            c.nombre_contacto,
            c.telefono,
            c.email,
            v.tipo_de_cambio,
            v.fecha_timbrado,
            DATE_FORMAT(convert(substring(substr(v.fecha_timbrado,1,10),1,10),date),'%d/%m/%Y') as fecha,
            v.id as id_factura,
            v.serie,
            v.folio,
            v.total,
            v.saldo_pendiente,
            v.uuid,
	v.tipo_documento,
	v.subtotal,v.descuento,
            fxGetStatusName(v.`status`,'Factura')as statusName,
            fxGetSucursalName(v.sucursal) as sucursalName
            from facturas v
            join clientes as c on v.id_cliente = c.id
            WHERE
            (v.status = 2 OR v.tipo_documento = 'CG')
            $fecha
            $cliente
            ORDER BY v.serie ASC,v.folio DESC ";

            //echo $query; exit;


        $result = $this->query($query);

        if ($result->num_rows > 0) {
            $saldosIniciales = array();
            $result = $this->resultToArray($result);
            $estadoDeCuena = array();
            $repoPagos = new PagoRepository();

            if ($options['saldoInicial'] != null) {
                $saldosIniciales = $this->getSaldoInicial(array('fechaInicio' => $options['fechaInicio'], 'cliente' => $options['cliente']));
            }

            foreach ($result as $row) {
                $datosCliente = array(
                    'nombre' => $row['razon_social'],
                    'rfc' => $row['rfc'],
                    'contacto' => $row['nombre_contacto'],
                    'telefono' => $row['telefono'],
                    'email' => $row['email'],
                );
                unset($row['nombre'], $row['rfc'], $row['contacto'], $row['telefono'], $row['email']);

                $pagos = $repoPagos->getPagosByIdFactura($row['id_factura']);
                $row['pagos'] = $pagos;
                $estadoDeCuena[$row['id_cliente']]['datosCliente'] = $datosCliente;
                $estadoDeCuena[$row['id_cliente']]['facturas'][$row['id_factura']] = $row;

                if (key_exists($row['id_cliente'], $saldosIniciales)) {
                    $estadoDeCuena[$row['id_cliente']]['saldoInicial'] = $saldosIniciales[$row['id_cliente']];
                } else {
                    $estadoDeCuena[$row['id_cliente']]['saldoInicial'] = 0;
                }
            }

            return array(
                'data' => $estadoDeCuena,
            );
        } else {
            return null;
        }
        return null;
    }

    public function getFacturasDetalles(array $options)
    {
        if ($options['cliente'] != null) {
            $cliente = implode(',', $options['cliente']);
        }
        $fecha['startDate'] = $options['fechaInicio'];
        $fecha['endDate'] = $options['fechaFin'];
        $fecha = $this->createFilterFecha($fecha, 'f.fecha_timbrado');
        $sucursal = $options['sucursal'] ? " AND f.sucursal = {$options['sucursal']} " : null;
        $cliente = $options['cliente'] ? " AND find_in_set(f.id_cliente,'$cliente') " : null;

        $dbAdminName = DB_ADMIN_NAME;

        $query = "SELECT
            p.codigo,
            f.tipo_documento,
            fxGetUMDescription(fd.id_producto) as unidadMedida,
            f.total as total,
            f.id AS idFactura,
            f.moneda,
            fxGetMonedaName(f.moneda) as tipoMoneda,
            fxGetClienteName(f.id_cliente) AS clienteNombre,
            fxGetStatusName(f.status,'Factura')as statusName,
            fxGetSucursalName(f.sucursal) as sucursalName,
            DATE_FORMAT(convert(substring(substr(f.fecha_timbrado,1,10),1,10),date),'%d/%m/%Y') as fecha,
            DATE_FORMAT(f.creado_fecha,'%d/%m/%Y') as creado_fecha2,
            f.id as id_factura,
            f.serie,
            f.folio,
            f.total,
            fd.*,
            fd.nombre as nombreProducto,
            c.id as id_cliente,
            c.codigo,
            c.rfc,
            c.razon_social,
            c.nombre_contacto,
            c.telefono,
            c.email,
	f.moneda,
	p.sat_producto_clave,
	p.unidad_de_medida as clave_unidad_medida,
	um.descripcion as unidad_de_medida_desc,
	f.tipo_de_cambio
            FROM facturas_detalles fd LEFT JOIN facturas f ON f.id = fd.id_factura
            join clientes as c on f.id_cliente = c.id
            join productos p ON p.id = fd.id_producto
	left join {$dbAdminName}.monedas m on m.moneda = f.moneda
	left join {$dbAdminName}.unidades_de_medida um on um.clave = p.unidad_de_medida
            where 1=1 and
           (f.status = 2 OR f.tipo_documento = 'CG')
            $cliente
            $fecha
            $sucursal
            GROUP BY fd.id
            ORDER BY fxGetClienteName(f.id_cliente)  ASC,f.id";
            // echo $query; exit;

        $result = $this->query($query);

        if ($result->num_rows > 0) {
            $result = $this->resultToArray($result);
            $estadoDeCuena = array();

            $diferentesImpuestosAplicados = array();
            foreach ($result as $row) {
                if ($row['tipo_documento'] == 'CG') {
                    $row['fecha'] = $row['creado_fecha'];
                }

                $datosCliente = array(
                    'nombre' => $row['razon_social'],
                    'rfc' => $row['rfc'],
                    'contacto' => $row['nombre_contacto'],
                    'telefono' => $row['telefono'],
                    'email' => $row['email'],
                );
                unset($row['nombre'], $row['rfc'], $row['contacto'], $row['telefono'], $row['email']);

                $estadoDeCuena[$row['id_cliente']]['datosCliente'] = $datosCliente;
                $impuestos = unserialize($row['impuestos_aplicables']);

                $impuestosArray = array();

                if (isset($impuestos['Trasladable']) && count($impuestos['Trasladable']) > 0) {
                    foreach ($impuestos['Trasladable'] as $impuesto) {
                        $impuestosArray[$impuesto['descripcion']] = $impuesto['Importe'];
                        $diferentesImpuestosAplicados[$impuesto['descripcion']] = $impuesto['descripcion'];
                    }
                }

                if (isset($impuestos['Retenible']) && count($impuestos['Retenible']) > 0) {
                    foreach ($impuestos['Retenible'] as $impuesto) {
                        $impuestosArray[$impuesto['descripcion']] = $impuesto['Importe'];
                        $diferentesImpuestosAplicados[$impuesto['descripcion']] = $impuesto['descripcion'];
                    }
                }
                $row['impuestos'] = $impuestosArray;
                $estadoDeCuena[$row['id_cliente']]['facturas'][$row['id_factura']] = $row;
            }

            return array(
                'data' => $estadoDeCuena,
                'diferentesImpuestosAplicados' => $diferentesImpuestosAplicados,
            );
        } else {
            return null;
        }
        return null;
    }

    public function getFacturasDetallesExcel(array $options)
    {
        if ($options['cliente'] != null) {
            $cliente = implode(',', $options['cliente']);
        }
        $start = (isset($options['fechaInicio'])) ? $options['fechaInicio'] : null;
        $end = (isset($options['fechaFin'])) ? $options['fechaFin'] : null;
        $fecha = "";
        $tools = new Tools();
        if ($start) {
            $start = $tools->setFormatDateToDBFacturas($start);
            $fecha .= " AND CONVERT(SUBSTRING(f.fecha_timbrado, 1, 10), date) > '{$start}' ";
        }
        if ($end) {
            $end = $tools->setFormatDateToDBFacturas($end);
            $fecha .= " AND CONVERT(SUBSTRING(f.fecha_timbrado, 1, 10), date) <= '{$end}' ";
        }


        $sucursal = $options['sucursal'] ? " AND f.sucursal = {$options['sucursal']} " : null;
        $cliente = $options['cliente'] ? " AND find_in_set(f.id_cliente,'$cliente') " : null;

        $query = "SELECT
            fxGetClienteName(f.id_cliente) AS clienteNombre,
            concat_ws('', f.serie, f.folio) as noFactura,
            DATE_FORMAT(f.creado_fecha,'%d/%m/%Y') as creado_fecha2,
            p.codigo,
            p.nombre as nombreProducto,
            fd.cantidad,
            fxGetUMDescription(fd.id_producto) as unidadMedida,
            fd.importe,
            fd.descuento_monto,
            fd.impuestos,
            f.id AS idFactura,
            fd.impuestos_aplicables,
            DATE_FORMAT(convert(substring(substr(f.fecha_timbrado,1,10),1,10),date),'%d/%m/%Y') as fecha,
            f.tipo_documento,
            f.creado_fecha,
            c.id as id_cliente,
            fd.id_factura,
            fd.*
            FROM facturas_detalles fd LEFT JOIN facturas f ON f.id = fd.id_factura
            join clientes as c on f.id_cliente = c.id
            join productos p ON p.id = fd.id_producto
            where 1=1 AND (f.status = 2 OR f.tipo_documento = 'CG')
            $cliente
            $fecha
            $cliente
            $sucursal
            GROUP BY fd.id
            ORDER BY fxGetClienteName(f.id_cliente)  ASC,f.id";

        $result = $this->query($query);

        if ($result->num_rows > 0) {
            $result = $this->resultToArray($result);
            $estadoDeCuenta = array();

            $diferentesImpuestosAplicados = array();
            foreach ($result as $row) {
                if ($row['tipo_documento'] == 'CG') {
                    $row['fecha'] = $row['creado_fecha'];
                }

                $impuestos = unserialize($row['impuestos_aplicables']);

                $impuestosArray = array();

                if (isset($impuestos['Trasladable']) && count($impuestos['Trasladable']) > 0) {
                    foreach ($impuestos['Trasladable'] as $impuesto) {
                        $impuestosArray[$impuesto['descripcion']] = $impuesto['Importe'];
                        $diferentesImpuestosAplicados[$impuesto['descripcion']] = $impuesto['descripcion'];
                    }
                }

                if (isset($impuestos['Retenible']) && count($impuestos['Retenible']) > 0) {
                    foreach ($impuestos['Retenible'] as $impuesto) {
                        $impuestosArray[$impuesto['descripcion']] = $impuesto['Importe'];
                        $diferentesImpuestosAplicados[$impuesto['descripcion']] = $impuesto['descripcion'];
                    }
                }
                $row['impuestos'] = $impuestosArray;
                $estadoDeCuenta[] = $row;
                //$estadoDeCuenta[$row['id_cliente']]['facturas'][$row['id_factura']] = $row;
            }

            return array(
                'data' => $estadoDeCuenta,
                'diferentesImpuestosAplicados' => $diferentesImpuestosAplicados,
            );
        } else {
            return null;
        }
        return null;
    }

    public function getSaldoInicial(array $options)
    {
        $tools = new Tools();
        $fecha = null;
        if ($options['cliente'] != null) {
            $cliente = implode(',', $options['cliente']);
        }

        $fechaInicioFormated = $tools->setFormatDateToDB($options['fechaInicio']);
        $fecha = "AND (convert(substring(substr(v.fecha_timbrado,1,10),1,10),date) < '$fechaInicioFormated') ";
        $cliente = $options['cliente'] ? " AND find_in_set(v.id_cliente,'$cliente') " : null;

        $query = "SELECT
            c.id as id_cliente,
            SUM(v.saldo_pendiente) as saldoInicial
            from facturas v
            join clientes as c on v.id_cliente = c.id
            WHERE
            v.saldo_pendiente != 0 AND
            (v.status = 2 OR v.tipo_documento = 'CG')
            $fecha
            $cliente
            GROUP BY c.id";


        $result = $this->query($query);

        $array = array();
        if ($result->num_rows > 0) {
            $result = $this->resultToArray($result);

            foreach ($result as $data) {
                $array[$data['id_cliente']] = $data['saldoInicial'];
            }
        }
        return $array;
    }

    public static function getAvailablePdfTemplates()
    {
        $path = "/public/app/img/templates_facturas/";
        $pattern = ROOT . $path . "*.png";

        $files = glob($pattern);
        $basefiles = [];

        for ($i = 0; $i < count($files); $basefiles[] = ['filename' => substr(basename($files[$i]), 0, -4), 'path' => $path . basename($files[$i++])]);

        return $basefiles;
    }

    public function getVentasPorAnyo()
    {
        $query = "SELECT \n".
                "  YEAR (f.creado_fecha) AS `year`, \n".
                "  MONTH (f.creado_fecha) AS `month`, \n".
                "  CONCAT(\n".
                "    YEAR (f.creado_fecha), \n".
                "    MONTH (f.creado_fecha)\n".
                "  ) AS `key`, \n".
                "  SUM(f.total) AS total_by_month \n".
                "FROM \n".
                "  facturas f \n".
                "WHERE \n".
                "  YEAR (f.creado_fecha) > YEAR (now()) - COALESCE (\n".
                "    fxGetIntegerSetting (\n".
                "      'ventas_totales_max_years_history'\n".
                "    ), \n".
                "    3\n".
                "  ) \n".
				"AND f.tipo_documento <> 'CG'\n".
                "GROUP BY \n".
                "  YEAR (f.creado_fecha), \n".
                "  MONTH (f.creado_fecha) \n".
                "ORDER BY \n".
                "  YEAR ASC, \n".
                "  MONTH ASC";

        $result = $this->query($query);
        $data = [];
        if ($result) {
            $data = $this->resultToArray($result);
        }
        $formattedData = [];

        foreach ($data as $row) {
            $formattedData[$row["key"]] = [
                'year' => $row["year"],
                'month' => $row["month"],
                'total_by_month' => $row["total_by_month"],
            ];
        }

        $currYear = null;
        $returnData = [];
        $index = -1;
        foreach ($formattedData as $value) {
            if ($value['year'] != $currYear) {
                $currYear = $value['year'];
                $index++;
            }
            $returnData[$index] = [
                "year" => $currYear,
            ];

            for ($i = 1; $i <= 12; $i++) {
                if (isset($formattedData[$currYear . $i])) {
                    $returnData[$index]["months"][$i - 1]["value"] = $formattedData[$currYear . $i]['total_by_month'];
                } else {
                    $returnData[$index]["months"][$i - 1]["value"] = 0;
                }
            }
        }

        // echo '<pre>';
        // print_r($returnData);
        // echo '</pre>';
        // exit;
        return $returnData;
    }
}
