<?php

/**

 * Description of FacturaEntity

 *

 * @author carlos

 */

class FacturarEntity Extends EntityRepository{

    public $flashmessenger = null;

    private $rutaParaGuardarXML = PATH_SAT_DOCS;

    private $conexionServicioTimbrado = null;

    private $archivoKeyPem = 'keyPem.key.pem';

    

    private $idFactura = null;

    private $serie = null;

    private $folio = null;

    private $comprobante = null;

    private $emisor = null;

    private $expedidoEn = null;

    private $receptor = null;  

 

    private $datosComprobante = array();

    private $datosCFDIRelacionados = array();

    private $datosEmisor = array();

    private $datosReceptor = array();

    private $datosConceptos = array();     

    private $datosImpuestos = array(
        'Retenciones'=>null,
        'Traslados'=>null
    );

    

    private $datosDefaultComprobante = array(
        'version'=>'3.3',
        'sello'=>null
    );
    

    /*Datos para conexion a servicio de timbrado.*/
    private $datosTimbrar = array();  
    

    public function __construct($idFactura) {

        if(!$this->flashmessenger instanceof FlashMessenger){

            $this->flashmessenger = new FlashMessenger();

        }     

        

         $this->idFactura = $idFactura;

    }

    

    public function _timbrar(){       

        try {

            $this->setDatosTimbrado();

            $this->setOptions();

            $this->prepararDatosComprobante();

            $this->prepararDatosCFDIRelacionados();

            $this->prepararDatosEmisor();

            $this->prepararDatosReceptor(); 

            $this->prepararConceptos();  

            $this->prepararImpuestos();  

            $this->crearXML();

            $this->timbrar();

            $this->guardarFactura();     

            

        } catch (Exception $exc) {

            $this->flashmessenger->addMessage(array('danger'=>$exc->getMessage()));

            return null;

        }

        $this->flashmessenger->addMessage(array('success'=>'Su factura ha sido timbrada correctamente.'));

        return true;

    }

    

    public function _cancelar(){

        $entity = new FacturaEntity();

        $facturaData = $entity->getById($this->idFactura);

        

        $this->serie = $facturaData['serie'];

        $this->folio = $facturaData['folio'];

        $this->uuid = $facturaData['uuid'];

        

        try {

            $this->setDatosCancelarTimbrado();

            $this->setOptions();

            $this->cancelar();

            //$this->guardarFactura();     

            

        } catch (Exception $exc) { 

            $this->flashmessenger->addMessage(array('danger'=>$exc->getMessage()));

            return null;

        }

        $this->flashmessenger->addMessage(array('success'=>'Genial!! su factura ha sido cancelada con exito.'));

        return true;

    }

    

    public function setOptions(){

      $factura = new FacturaEntity();      

      $factura->setOptions($factura->getById($this->getIdFactura()));

      $this->comprobante = $factura;

      

      $receptor = new ClienteEntity();

      $this->receptor = $receptor->getById($this->comprobante->getIdCliente());     

      

      $emisor = new EmpresaRepository();

      $this->emisor = $emisor->getById(1);        

      

      $expedidoEn = new SucursalEntity();

      $this->expedidoEn = $expedidoEn->getById($factura->getSucursal());    

    }

    

    public function setDatosTimbrado(){

        $settings = new SettingsEntity();

        $tipoConexion = 'production_'; # PRODUCTION

        #$tipoConexion = 'demo_'; # DEMO

        

        $this->datosTimbrar = array(

        'serverURL'=>$settings->_get($tipoConexion.'timbrado_serverURL'), 

        'serverScript'=>$settings->_get('timbrado_serverScript'),

        'metodoALlamar'=>$settings->_get('timbrado_metodoALlamar'),

        'timbraRequest'=>array(

            'timbraRequest'=>array(           

                'Usuario'=>$settings->_get($tipoConexion.'timbrado_usuario'), 

                'Password'=>$settings->_get($tipoConexion.'timbrado_contrasena'), 

                'XML'=>null)

        ));        

    }

    

    public function setDatosCancelarTimbrado(){

        $settings = new SettingsEntity();

        $tipoConexion = 'production_'; # PRODUCTION

        #$tipoConexion = 'demo_'; # DEMO

        

        $this->datosCancelar = array(

        'serverURL'=>$settings->_get($tipoConexion.'timbrado_serverURL'), 

        'serverScript'=>$settings->_get('timbrado_serverScript'),

        'metodoALlamar'=>$settings->_get('timbrado_cancelar_metodoALlamar'),

        'cancelacionRequest'=>array(

            'cancelacionRequest'=>array(           

                'Usuario'=>$settings->_get($tipoConexion.'timbrado_usuario'), 

                'Contrasena'=>$settings->_get($tipoConexion.'timbrado_contrasena'), 

                'UUID'=>$this->uuid)

        ));    

    }

    

    public function prepararDatosComprobante(){

        date_default_timezone_set("Mexico/General");

        $this->setSerieFolio();

       

        $this->datosComprobante = array(

            'Version'=>$this->datosDefaultComprobante['version'],      

            'Serie'=>$this->serie,

            'Folio'=>$this->folio,       

            'Fecha'=>date("Y-m-d")."T".date("H:i:s", (strtotime ("-2 minute"))),   

            'FormaPago'=>$this->comprobante->getFormaDePago(),  

            'NoCertificado'=>$this->getNoCertificado(),     

            //'CondicionesDePago'=>$this->comprobante->getCondicionesDePago(), #opcional 

            'CondicionesDePago'=>'CREDITO', #opcional 

            'SubTotal'=>number_format($this->comprobante->getSubTotal(),2,'.',''),

            //'Descuento'=>number_format($this->comprobante->getDescuento(),2,'.',''),

            'Moneda'=>$this->comprobante->getMoneda(),

            'TipoCambio'=>$this->comprobante->getTipoDeCambio(),

            'Total'=>number_format($this->comprobante->getTotal(),2,'.',''),

            'TipoDeComprobante'=>$this->comprobante->getTipoComprobante(),             

            'MetodoPago'=>$this->comprobante->getMetodoDePago(),

            'LugarExpedicion'=>$this->emisor['codigo_postal'],    

            #'Sello'=>$this->datosDefaultComprobante['sello'],

            'Certificado'=>$this->getCertificado(),       

            

        );

    }

    

    public function prepararDatosCFDIRelacionados(){

        $this->datosCFDIRelacionados = array(

            'TipoRelacion'=>$this->comprobante->getTipoRelacion(),

            'CFDIRelacionados'=>$this->comprobante->getCFDIRelacionados() # Es un array

        );

    }

    

    public function prepararDatosEmisor(){

        $this->datosEmisor = array(

            'Emisor'=>array(

                'Rfc'=>$this->emisor['rfc'],

                'Nombre'=>$this->emisor['razon_social'],

                'RegimenFiscal'=>$this->getRegimenFiscal()

            ));

    }  

    

    public function prepararDatosReceptor(){

        $this->datosReceptor = array(

        'Receptor'=>array(

            'Rfc'=>$this->receptor['rfc'],

            'Nombre'=>$this->receptor['razon_social'],

            //'ResidenciaFiscal'=>$this->receptor['pais'],

            //'NumRegIdTrib'=>$this->receptor['mum_reg_id_trib'],

            'UsoCFDI'=>$this->comprobante->getUsoCFDI()

        ));

    }

    

    public function prepararConceptos(){  

        foreach($this->comprobante->getFacturaDetallesSaved($this->getIdFactura()) as $concepto){            

             $impuestosAplicables = null;
            if($concepto['impuestos_aplicables'] != ''){
                $impuestosAplicables = array('Trasladable'=>array(),'Retencion'=>array());
                $impuestosAplicablesTemp = unserialize($concepto['impuestos_aplicables']); 
                foreach($impuestosAplicablesTemp as $tipo => $impuestos){
					
                    foreach($impuestos as $impuesto){
                        //$impuestonombre = 0;
                        unset($impuesto['nombre'],$impuesto['descripcion']);
                        if($impuesto['TipoFactor']=='Tasa'){$impuesto['TasaOCuota'] = number_format($impuesto['TasaOCuota']/100,6,'.','');}
                        $impuesto['Importe'] = number_format($impuesto['Importe'],2,'.','');
                        $impuesto['Base'] = number_format($impuesto['Base'],2,'.','');
                        array_push($impuestosAplicables[$tipo],$impuesto);
                    }              
                }
            }            

            

            $array = array(

                'ClaveProdServ'=>$concepto['sat_producto_clave'],                

                'NoIdentificacion'=>$concepto['codigo'],

                'Cantidad'=>number_format($concepto['cantidad'],6,'.',''), 

                'ClaveUnidad'=>$concepto['um'],

                'Unidad'=>$concepto['umName'],

                'Descripcion'=>$concepto['nombre']." ".$concepto['descripcion'],

                'ValorUnitario'=>number_format($concepto['precio_unitario'],6,'.',''),

                'Importe'=>  number_format($concepto['importe'],2,'.',''),

                //'Descuento'=>number_format($concepto['descuento_monto'],6,'.',''),

                'ImpuestosAplicables'=>$impuestosAplicables

            );       

            

             $this->datosConceptos[] = $array;

        }      

    }

    

    public function prepararImpuestos(){

        $impuestosAplicables = $this->comprobante->getImpuestosAplicables();

        $totalImpuestoRetenido = 0;

        $totalImpuestoTrasladado = 0;

        

        if(count($impuestosAplicables['Retenible']) > 0){

            foreach($impuestosAplicables['Retenible'] as $impuestoAplicable){

                $totalImpuestoRetenido +=  $impuestoAplicable['Importe'];

                $impuestoAplicable['Importe'] =  number_format($impuestoAplicable['Importe'],2,'.','');

                if($impuestoAplicable['TipoFactor']=='Tasa'){$impuestoAplicable['TasaOCuota'] = number_format($impuestoAplicable['TasaOCuota']/100,6,'.','');}

                $detallesImpuestosRetenidos[] = $impuestoAplicable;

            } 

            

            $this->datosImpuestos['Retenciones'] = array(

                    'totalImpuestosRetenidos'=>number_format($totalImpuestoRetenido,2,'.',''),

                    'detalles'=>$detallesImpuestosRetenidos

                );

        }

            

        if(count($impuestosAplicables['Trasladable']) > 0){

            foreach($impuestosAplicables['Trasladable'] as $impuestoAplicable){

                $totalImpuestoTrasladado +=  $impuestoAplicable['Importe'];

                $impuestoAplicable['Importe'] =  number_format($impuestoAplicable['Importe'],2,'.','');

                if($impuestoAplicable['TipoFactor']=='Tasa'){$impuestoAplicable['TasaOCuota'] = number_format($impuestoAplicable['TasaOCuota']/100,6,'.','');}

                $detallesImpuestosTrasladados[] = $impuestoAplicable;

            }

            

            $this->datosImpuestos['Traslados'] = array(

                    'totalImpuestosTrasladados'=>number_format($totalImpuestoTrasladado,2,'.',''),

                    'detalles'=>$detallesImpuestosTrasladados

                );

        }

    }   

   

    public function setSerieFolio(){

        #Toma la serie asignada para facturar y obtiene el folio siguiente si aun hay disponibles

        $id = $this->expedidoEn['serie_de_facturacion'];

        $query = "SELECT * FROM facturas_series_folios "

                . "WHERE id = '$id' "

                . "AND status = '1' "

                . "ORDER BY id ASC LIMIT 1";

        $result = $this->query($query);

        

        if($result->num_rows == 0){

            throw new Exception("No existen folios registrados para facturar.");

        }else{

            $result = $result->fetch_object();

            $folio_inicio = $result->folio_inicio;

            $folio_fin = $result->folio_fin;

            $serie = $result->serie;

        } 

        

        $query = "SELECT folio "

                . "FROM facturas "

                . "WHERE serie = '$serie'"

                . "AND status = '2' "

                . "ORDER BY folio DESC LIMIT 1";

        

        $result = $this->query($query);

        

        if($result->num_rows == 0){

            $folio = $folio_inicio;

        }else{

            $result = $result->fetch_object();

            $folio = $result->folio;

            $folio++;

        }

        

        if($folio > $folio_fin){

           #parar script y mandar mensaje "No existen folios registrados para facturar."

           throw new Exception("No existen folios registrados para facturar.");

        }

        

        $this->serie = $serie;

        $this->folio = $folio;        

    }    

    

    public function getRegimenFiscal(){

        if($this->expedidoEn['regimen_fiscal']!= ''){

            return $this->expedidoEn['certificado'];

        }

        

        return $this->emisor['regimen_fiscal'];

    } 

    

        

    public function getNoCertificado(){

        if($this->expedidoEn['certificado_independiente']== 'Si'){

            return $this->expedidoEn['no_certificado'];

        }

        

        return $this->emisor['no_certificado'];

    }

    

     public function getCertificado(){
        if($this->expedidoEn['certificado_independiente']== 'Si'){
            return str_replace(" ", "", $this->expedidoEn['certificado']);
        }
        return str_replace(" ", "", $this->emisor['certificado']);
    }      

    

    public function setSello(){

        $cadenaOriginal = "|";

        

        #Informacion general de comprobante

        $i = 0;

        $datosComprobante = $this->datosComprobante;

        foreach($datosComprobante as $key => $value){            

            $i++;

            if($i <= 15){

                if(trim($value) != ''){

                    $cadenaOriginal .= "|{$value}";

                }

            }            

        }

        

        #Informacion emisor

        foreach($this->datosEmisor['Emisor'] as $key => $value){

           if(trim($value) != ''){

               $cadenaOriginal .= "|{$value}";

            }

        }                              

        

        #Informacion receptor

        foreach($this->datosReceptor['Receptor'] as $key => $value){

            if(trim($value) != ''){

               $cadenaOriginal .= "|{$value}";

            }

        }               

        

         #Conceptos  

        foreach($this->datosConceptos as $concepto){

            foreach($concepto as $key => $value){

                if($key !== 'ImpuestosAplicables' && trim($value) != ''){                    

                    $value = trim($value);

                    $cadenaOriginal .= "|{$value}";

                }elseif($key === 'ImpuestosAplicables' && $value !== null){

                    $impuestos = $value;

                    if(key_exists('Trasladable', $impuestos)){

                        foreach($impuestos['Trasladable'] as $impuesto){

                            $cadenaOriginal .= "|{$impuesto['Base']}"; #Base    

                            $cadenaOriginal .= "|{$impuesto['Impuesto']}";  #Impuesto

                            $cadenaOriginal .= "|{$impuesto['TipoFactor']}"; #TipoFactor

                            $cadenaOriginal .= "|{$impuesto['TasaOCuota']}"; #TasaOCuota

                            $cadenaOriginal .= "|{$impuesto['Importe']}"; #Importe

                        }

                    }

                    if(key_exists('Retenible', $impuestos)){

                        foreach($impuestos['Retenible'] as $impuesto){

                            $cadenaOriginal .= "|{$impuesto['Base']}"; #Base    

                            $cadenaOriginal .= "|{$impuesto['Impuesto']}";  #Impuesto

                            $cadenaOriginal .= "|{$impuesto['TipoFactor']}"; #TipoFactor

                            $cadenaOriginal .= "|{$impuesto['TasaOCuota']}"; #TasaOCuota

                            $cadenaOriginal .= "|{$impuesto['Importe']}"; #Importe

                        }

                    }

                }

            }

        }           

        

       #Impuestos      

       #ImpuestosRetenciones



        if($this->datosImpuestos['Retenciones'] != null){

            $cadenaOriginal .= "|";

            foreach($this->datosImpuestos['Retenciones']['detalles'] as $retencion){

                $cadenaOriginal .= trim($retencion['Impuesto'])."|".trim($retencion['Importe'])."|";

            }

            $cadenaOriginal .= $this->datosImpuestos['Retenciones']['totalImpuestosRetenidos'];

        }       



        #ImpuestosTraslados

        if($this->datosImpuestos['Traslados'] != null){

            $cadenaOriginal .= "|";

            foreach($this->datosImpuestos['Traslados']['detalles'] as $retencion){

                $cadenaOriginal .= trim($retencion['Impuesto'])."|".trim($retencion['TipoFactor'])."|".trim($retencion['TasaOCuota'])."|".trim($retencion['Importe'])."|";

            }

            $cadenaOriginal .= $this->datosImpuestos['Traslados']['totalImpuestosTrasladados'];

        }       



        $cadenaOriginal .= "||";

        //echo $cadenaOriginal .= "||";exit;        

        /*

        ini_set('error_reporting', 0); 



         //ruta al archivo XML del CFDI

        $xmlFile = $this->getPathArchivoXML();



        // Ruta al archivo XSLT

        $xslFile = PATH_SAT_DOCS."cadenaOriginal_3.3.xslt"; 



        // Crear un objeto DOMDocument para cargar el CFDI

        $xml = new DOMDocument("1.0","UTF-8"); 

        // Cargar el CFDI

        $xml->load($xmlFile);



        // Crear un objeto DOMDocument para cargar el archivo de transformación XSLT

        $xsl = new DOMDocument();

        $xsl->load($xslFile);



        // Crear el procesador XSLT que nos generará la cadena original con base en las reglas descritas en el XSLT

        $proc = new XSLTProcessor;

        // Cargar las reglas de transformación desde el archivo XSLT.

        $proc->importStyleSheet($xsl);

        // Generar la cadena original y asignarla a una variable

        $cadenaOriginal = $proc->transformToXML($xml);



        echo $cadenaOriginal;exit;

    */

    

        $cadenaOriginal =  preg_replace ("/ +/"," ",$cadenaOriginal);

        $cadenaOriginal = utf8_encode($cadenaOriginal);

        //echo $cadenaOriginal;

       

        //Digestion SHA256, firmamos con nuestra clave y pasamos a base 64, requiere de openssl instalado

        date_default_timezone_set("Mexico/General");

        $archivosSAT = $this->getArchivosSAT();

        $keyPem = $archivosSAT['keyPem'];

      

        $fp = fopen($keyPem, "r");

        $priv_key = fread($fp, 8192);

        fclose($fp);		

        $pkeyid = openssl_get_privatekey($priv_key);



        openssl_sign($cadenaOriginal,$cadenaFirmada,$pkeyid,OPENSSL_ALGO_SHA256);

        $sello = base64_encode($cadenaFirmada);

        

        $this->datosComprobante['Sello'] = $sello;

        //$this->datosComprobante['Sello'] = "yR4iy2bb7AGg5wnnAvpzCPKcPPuTz87tCy0btAb49zaffJZQo4i7pf1kcOJxmAOYuHOV6cHHmUIM8/Z6nMHPQbrVTmWOYGKBzUWgBPHGcO8nNOIX5EosxeW4NYtsWFHqRRNEHP/qxqGsDdGg2rmc8eQdjI7wlqXEHGijKOxLDIxLkYA/Z7pUlgdlE5dswPEo+Z/DiYgz1LqLfhm5TBwPx842kmGkAgSm/zuYV9ZKs3cIm8yqDSQVda3QRAZjL1wph9/m3K7CclfGrrnGk9lzCOU6cBjfO5aK1nLK7ukVRS2Su3QLqbN4j/CuWWcWBv8UyuveW8BcOYHQY9zuZ8OezA==";

    }

    

    public function getOptions(){

        return $this->options;

    }

    public function getIdFactura(){

        return $this->idFactura;

    }

    

    public function getDatosComprobante(){

        return $this->datosComprobante;

    }

    

    public function getDatosEmisor(){

        return $this->datosEmisor;

    }

    

    public function getDatosCFDIRelacionados(){

        return $this->datosCFDIRelacionados;

    }

    

    public function getDatosReceptor(){

        return $this->datosReceptor;

    }

    

    public function getDatosConceptos(){

        return $this->datosConceptos;

    }   

    

    public function getDatosImpuestos(){

        return $this->datosImpuestos;

    }

    

    public function getNombreArchivo(){

        $folio = str_pad($this->folio, 5, "0", STR_PAD_LEFT); 

        $nombreArchivo = '';

        if(trim($this->serie)!=''){

            $nombreArchivo .= $this->serie."-";

        }

        

        return $nombreArchivo .= $folio;

    }

    

    public function getRutaParaGuardarXML(){
        return $this->rutaParaGuardarXML.$this->emisor['rfc']."/".$this->expedidoEn['id']."/";

    }

    

    public function getArchivosSAT(){        
        if($this->expedidoEn['certificado_independiente']== 'Si'){
        return array(
            'keyPem'=>PATH_SAT_DOCS.$this->emisor['rfc']."/".$this->expedidoEn['id']."/".$this->archivoKeyPem
          );

        }      

        /* 1 contiene la archivos de la empresa con lo que se debe facturar por default, cuando la empresa no tiene certificado propio*/

        return array(

                'keyPem'=>PATH_SAT_DOCS.$this->emisor['rfc']."/1/".$this->archivoKeyPem

              );       

    }

    

    public function getPathArchivoXML(){

        return $this->getRutaParaGuardarXML().$this->getNombreArchivo().".xml";

    }

    

    public function getArchivoXML(){

        return file_get_contents($this->getRutaParaGuardarXML().$this->getNombreArchivo().".xml");

    }

    

    public function setParametroXML(){
        $this->datosTimbrar['timbraRequest']['timbraRequest']['XML'] = $this->getArchivoXML();
        //$this->datosTimbrar['timbraRequest']['timbraRequest']['XML'] = '';
    }    

    public function crearXML(){    

        $crear_xml_factura = new crear_xml_factura();
        $crear_xml_factura->setDatosComprobante($this->getDatosComprobante());
        $crear_xml_factura->setDatosCFDIRelacionados($this->getDatosCFDIRelacionados());
        $crear_xml_factura->setDatosEmisor($this->getDatosEmisor());
        $crear_xml_factura->setDatosReceptor($this->getDatosReceptor());
        $crear_xml_factura->setDatosConceptos($this->getDatosConceptos());
        $crear_xml_factura->setDatosImpuestos($this->getDatosImpuestos());
        $crear_xml_factura->setArchivosSAT($this->getArchivosSAT());       

        $crear_xml_factura->crearXML($this->getRutaParaGuardarXML(),$this->getNombreArchivo());
    }    

   public function timbrar() {
       #Esta url es para activar el webservice de 'pruebas'
       # $ws = "https://cfdi33-pruebas.buzoncfdi.mx:1443/Timbrado.asmx?wsdl";
       
       
       $ws = "https://timbracfdi33.mx:1443/Timbrado.asmx?wsdl";
        $params = array();
        /* Nombre del usuario integrador asignado, para efecto de pruebas utilizaremos 'mvpNUXmQfK8=' */
        /*                                                                 el correcto es '+2quDlPcjMlY5g8xR/lmfg==' */
        $params['usuarioIntegrador'] = '+2quDlPcjMlY5g8xR/lmfg==';
        /* Comprobante en base 64 */
        $params['xmlComprobanteBase64'] = base64_encode($this->getArchivoXML());
        /* Id del comprobante, deberÃ¡ ser un identificador Ãºnico, para efecto del ejemplo se utilizarÃ¡ un numero aleatorio */
        $params['idComprobante'] = rand(5, 999999);

        $client = new SoapClient($ws, $params);
        $response = $client->__soapCall('TimbraCFDI', array('parameters' => $params));
        //var_dump($response);exit;
        /* Obtenemos resultado del response */
        $tipoExcepcion = $response->TimbraCFDIResult->anyType[0];
        $numeroExcepcion = $response->TimbraCFDIResult->anyType[1];
        $descripcionResultado = $response->TimbraCFDIResult->anyType[2];
        $xmlTimbrado = $response->TimbraCFDIResult->anyType[3];
        $codigoQr = $response->TimbraCFDIResult->anyType[4];
        $cadenaOriginal = $response->TimbraCFDIResult->anyType[5];

        if ($xmlTimbrado != '') {
            /* El comprobante fue timbrado correctamente */
            /* Guardamos comprobante timbrado */
            $this->guardarXMLTimbrado($xmlTimbrado);

            /* Guardamos codigo qr */
            //file_put_contents('C:\Users\Andres\Desktop\codigoQr.jpg', $codigoQr);

            /* Guardamos cadena original del complemento de certificacion del SAT */
            //file_put_contents('C:\Users\Andres\Desktop\cadenaOriginal.txt', $cadenaOriginal);
        } else {
            #Produccion                
            //throw new Exception('Oopss!!. Algo salio mal durante el proceso de facturacion.<br/> Contacta a tu proveedor del servicio para mas informacion.'); 
            #Develop 
            throw new Exception($descripcionResultado);
        }
    }

    public function cancelar(){        

        if($this->conectarConServicioCancelado()){ 
            $timbrado = $this->conexionServicioTimbrado->call(
                $this->datosCancelar['metodoALlamar'], 
                $this->datosCancelar['cancelacionrequest'],
                "uri:".$this->datosCancelar['serverURL']."/".$this->datosCancelar['serverScript'],
                "uri:".$this->datosCancelar['serverURL']."/".$this->datosCancelar['serverScript']."/".$this->datosCancelar['metodoALlamar']
            );    

            //var_dump($timbrado);exit;

            if ($timbrado['CancelaTFDV33Result']['CancelacionCorrecta'] == "true") {
               $this->guardarXMLTimbradoCancelado($timbrado['CancelaTFDV33Result']['AcuseCancelacion']);
            }else{                    
                #Produccion                
                #throw new Exception('Oopss!!. Algo salio mal durante el proceso de cancelacion.<br/> Contacta a tu proveedor del servicio para mas informacion.'); 
                #Develop 
                throw new Exception($timbrado['CancelaCFDIV33Result']['ErrorCancelacion']);
            }            
        }
    }    

    public function conectarConServicioTimbrado(){

        $link = $this->datosTimbrar['serverURL']."/".$this->datosTimbrar['serverScript']."?WSDL";

        $this->conexionServicioTimbrado = new nusoap_client($link, 'wsdl');

        

        $error = $this->conexionServicioTimbrado->getError();

        if ($error) { 

           #Produccion 

           #throw new Exception('Oopss!!. Algo salio mal durante el proceso de facturacion.<br/> Contacta a tu proveedor del servicio para mas informacion.');

           

           #Develop 

           throw new Exception($error);

        }

        return true;

    }

    

     public function conectarConServicioCancelado(){

        $link = $this->datosCancelar['serverURL']."/".$this->datosCancelar['serverScript']."?WSDL";

        $this->conexionServicioTimbrado = new nusoap_client($link, 'wsdl');

        

        $error = $this->conexionServicioTimbrado->getError();

        if ($error) { 

           #Produccion 

           #throw new Exception('Oopss!!. Algo salio mal durante el proceso de facturacion.<br/> Contacta a tu proveedor del servicio para mas informacion.');

           

           #Develop 

           throw new Exception($error);

        } 

        return true;

    }

    

    public function guardarXMLTimbrado($xmlTimbrado){

        file_put_contents($this->getRutaParaGuardarXML()."/Timbre-".$this->getNombreArchivo().".xml", $xmlTimbrado);  

    }  

    

    public function getXMLTimbrado(){

        return $this->getRutaParaGuardarXML()."/Timbre-".$this->getNombreArchivo().".xml";

    }

    

    public function guardarXMLTimbradoCancelado($xmlCancelado){

        file_put_contents($this->getRutaParaGuardarXML()."/Cancelacion-".$this->getNombreArchivo().".xml", $xmlCancelado);  

    }  

    

    public function getXMLTimbradoCancelado(){

        return $this->getRutaParaGuardarXML()."/Cancelacion-".$this->getNombreArchivo().".xml";

    }

    

    public function guardarFactura(){

        #Leer xml timbrado

        $xml = simplexml_load_file($this->getXMLTimbrado());

        #$xml = simplexml_load_file( $this->getRutaParaGuardarXML()."/Timbre-A-00001.xml");

        $cfdi = $xml->getNamespaces(true);

        $xml->registerXPathNamespace("c", $cfdi["tfd"]);

        $attribute = $xml->xpath("//c:TimbreFiscalDigital");



        #Obtener atributos de xml timbrado

        $version = $attribute[0]->attributes()->version;

        $uuid = $attribute[0]->attributes()->UUID;

        $ftimbrado = $attribute[0]->attributes()->FechaTimbrado;

        $sellocfdi = $attribute[0]->attributes()->SelloCFD;

        $certificadosat = $attribute[0]->attributes()->NoCertificadoSAT;

        $ssat = $attribute[0]->attributes()->SelloSAT;



        $cadena_originalsat = "||".$version."|".$uuid."|".$ftimbrado."|".$sellocfdi."|".$certificadosat."||";

        

        $options = array(

            'serie'=>$this->serie,
            'folio'=>$this->folio, #int
            'rfc_receptor'=>$this->datosReceptor['Receptor']['Rfc'],
            'datos_comprobante'=>serialize($this->getDatosComprobante()),
            'datos_emisor'=>  serialize($this->getDatosEmisor()),
            'datos_receptor'=>  serialize($this->getDatosReceptor()),
            'datos_conceptos'=>  serialize($this->getDatosConceptos()),
            'uuid'=>$uuid,
            'certificado_sat'=>$certificadosat,
            'fecha_timbrado'=>$ftimbrado,
            'sello_sat'=>$ssat,
            'cadena_original_sat'=>$cadena_originalsat,
            'sello_cfdi'=>$sellocfdi,
            'status'=>'2'
        );        

        $factura = new FacturaEntity();
        $result = $factura->updateString($options," id = ".$this->getIdFactura());        

        if($result){            
            return true;
        }

        return null;
    } 

}