<?php
/**
 * Description of FacturaEntity
 * @author carlos
 */

class FacturarRepository extends EntityRepository
{
    public $flashmessenger = null;
    private $rutaParaGuardarXML = PATH_SAT_DOCS;
    private $archivoKeyPem = 'keyPem.key.pem';

    private $idFactura = null;
    private $tipoDocumento = null;
    private $serie = null;
    private $folio = null;
    private $comprobante = null;
    private $emisor = null;
    private $expedidoEn = null;
    private $receptor = null;

    private $datosComprobante = array();
    private $datosCFDIRelacionados = array();
    private $datosEmisor = array();
    private $datosReceptor = array();
    private $datosConceptos = array();
    private $datosImpuestos = array(
        'Retenciones'=>null,
        'Traslados'=>null
    );

    private $datosDefaultComprobante = array(
        'version'=>'3.3',
        'sello'=>null
    );

    #Datos para conexion a servicio de timbrado.
    private $datosTimbrar = array();

    public function __construct($idFactura, $tipoDocumento)
    {
        if (!$this->flashmessenger instanceof FlashMessenger) {
            $this->flashmessenger = new FlashMessenger();
        }
        $this->idFactura = $idFactura;
        $this->tipoDocumento = $tipoDocumento;
    }

    public function _timbrar()
    {
        try {
            $this->setOptions();
            $this->prepararDatosComprobante();
            $this->prepararDatosCFDIRelacionados();
            $this->prepararDatosEmisor();
            $this->prepararDatosReceptor();
            $this->prepararConceptos();
            $this->prepararImpuestos();
            $this->crearXML();
            $this->timbrar();
            $this->guardarFactura();

            $this->flashmessenger->addMessage(array('success'=>'Genial!! su Documento ha sido timbrado con exito.'));
            return true;
        } catch (Exception $exc) {
            $this->flashmessenger->addMessage(array('danger'=>$exc->getMessage()));
            return null;
        }
    }

    public function _cancelar()
    {
        try {
            $this->setOptions();
            $this->folio = $this->comprobante->getFolio();
            $this->serie = $this->comprobante->getSerie();
            $this->cancelar();

            $this->flashmessenger->addMessage(array('success'=>"Genial!! Su solicitud de cancelacion ha sido enviada al SAT. Para dar seguimiento favor de visitar la <a href='https://www.sat.gob.mx/home' target='_sat'>pagina del sat</a>"));
            return true;
        } catch (Exception $exc) {
            $this->flashmessenger->addMessage(array('danger'=>$exc->getMessage()));
            return null;
        }
    }

    public function setOptions()
    {
        if ($this->tipoDocumento === 'Factura') {
            $factura = new FacturaRepository();
        } elseif ($this->tipoDocumento === 'NotaCredito') {
            $factura = new NotaCreditoRepository();
        }

        $factura->setOptions($factura->getById($this->getIdFactura()));
        $this->comprobante = $factura;

        $receptor = new ClienteRepository();
        $this->receptor = $receptor->getById($this->comprobante->getIdCliente());

        $emisor = new EmpresaRepository();
        $this->emisor = $emisor->getById(1);


        $expedidoEn = new SucursalRepository();
        $this->expedidoEn = $expedidoEn->getById($factura->getSucursal());
    }

    public function prepararDatosComprobante()
    {
        date_default_timezone_set("Mexico/General");
        $this->setSerieFolio();

        $this->datosComprobante = array(
            'Version'=>$this->datosDefaultComprobante['version'],
            'Serie'=>$this->serie,
            'Folio'=>$this->folio,
            'Fecha'=>date("Y-m-d")."T".date("H:i:s", (strtotime("-2 minute"))),
            'FormaPago'=>$this->comprobante->getFormaDePago(),
            'NoCertificado'=>$this->getNoCertificado(),
            //'CondicionesDePago'=>$this->comprobante->getCondicionesDePago(), #opcional
            'CondicionesDePago'=>'CREDITO', #opcional
            'SubTotal'=>number_format($this->comprobante->getSubTotal(), 2, '.', ''),
            //'Descuento'=>number_format($this->comprobante->getDescuento(),2,'.',''),
            'Moneda'=>$this->comprobante->getMoneda(),
            'TipoCambio'=>$this->comprobante->getTipoDeCambio(),
            'Total'=>number_format($this->comprobante->getTotal(), 2, '.', ''),
            'TipoDeComprobante'=>$this->comprobante->getTipoComprobante(),
            'MetodoPago'=>$this->comprobante->getMetodoDePago(),
            'LugarExpedicion'=>$this->emisor['codigo_postal'],
            #'Sello'=>$this->datosDefaultComprobante['sello'],
            'Certificado'=>$this->getCertificado(),
        );
    }

    public function prepararDatosCFDIRelacionados()
    {
        $this->datosCFDIRelacionados = array(
            'TipoRelacion'=>$this->comprobante->getTipoRelacion(),
            'CFDIRelacionados'=>$this->comprobante->getCFDIRelacionados() # Es un array
        );
    }

    public function prepararDatosEmisor()
    {
        $this->datosEmisor = array(
            'Emisor'=>array(
                'Rfc'=>$this->emisor['rfc'],
                'Nombre'=>$this->emisor['razon_social'],
                'RegimenFiscal'=>$this->getRegimenFiscal()
            ));
    }

    public function prepararDatosReceptor()
    {
        $this->datosReceptor = array(
        'Receptor'=>array(
            'Rfc'=>$this->receptor['rfc'],
            'Nombre'=>$this->receptor['razon_social'],
            //'ResidenciaFiscal'=>$this->receptor['pais'],
            //'NumRegIdTrib'=>$this->receptor['mum_reg_id_trib'],
            'UsoCFDI'=>$this->comprobante->getUsoCFDI()
        ));
    }

    public function prepararConceptos()
    {
        foreach ($this->comprobante->getFacturaDetallesSaved($this->getIdFactura()) as $concepto) {
            $impuestosAplicables = null;
            if ($concepto['impuestos_aplicables'] != '') {
                $impuestosAplicables = array('Trasladable'=>array(),'Retenible'=>array());
                $impuestosAplicablesTemp = unserialize($concepto['impuestos_aplicables']);
                foreach ($impuestosAplicablesTemp as $tipo => $impuestos) {
                    foreach ($impuestos as $impuesto) {
                        //$impuestonombre = 0;
                        unset($impuesto['nombre'],$impuesto['descripcion']);
                        if ($impuesto['TipoFactor']=='Tasa') {
                            $impuesto['TasaOCuota'] = number_format($impuesto['TasaOCuota']/100, 6, '.', '');
                        }
                        $impuesto['Importe'] = number_format($impuesto['Importe'], 2, '.', '');
                        $impuesto['Base'] = number_format($impuesto['Base'], 2, '.', '');
                        array_push($impuestosAplicables[$tipo], $impuesto);
                    }
                }
            }

            $array = array(
                'ClaveProdServ'=>$concepto['sat_producto_clave'],
                'NoIdentificacion'=>$concepto['codigo'],
                'Cantidad'=>number_format($concepto['cantidad'], 6, '.', ''),
                'ClaveUnidad'=>$concepto['um'],
                'Unidad'=>$concepto['umName'],
                'Descripcion'=>$concepto['nombre']." ".$concepto['descripcion'],
                'ValorUnitario'=>number_format($concepto['precio_unitario'], 6, '.', ''),
                'Importe'=>  number_format($concepto['importe'], 2, '.', ''), //Importe al parecer debe der 'precio_unitario' cuando active descuento
                //'Descuento'=>number_format($concepto['descuento_monto'],6,'.',''),
                'ImpuestosAplicables'=>$impuestosAplicables
            );

            $this->datosConceptos[] = $array;
        }
    }

    public function prepararImpuestos()
    {
        $impuestosAplicables = $this->comprobante->getImpuestosAplicables();
        $totalImpuestoRetenido = 0;
        $totalImpuestoTrasladado = 0;

        if (count($impuestosAplicables['Retenible']) > 0) {
            foreach ($impuestosAplicables['Retenible'] as $impuestoAplicable) {
                $totalImpuestoRetenido +=  $impuestoAplicable['Importe'];
                $impuestoAplicable['Importe'] =  number_format($impuestoAplicable['Importe'], 2, '.', '');
                if ($impuestoAplicable['TipoFactor']=='Tasa') {
                    $impuestoAplicable['TasaOCuota'] = number_format($impuestoAplicable['TasaOCuota']/100, 6, '.', '');
                }
                $detallesImpuestosRetenidos[] = $impuestoAplicable;
            }

            $this->datosImpuestos['Retenciones'] = array(
                    'totalImpuestosRetenidos'=>number_format($totalImpuestoRetenido, 2, '.', ''),
                    'detalles'=>$detallesImpuestosRetenidos
                );
        }

        if (count($impuestosAplicables['Trasladable']) > 0) {
            foreach ($impuestosAplicables['Trasladable'] as $impuestoAplicable) {
                $totalImpuestoTrasladado +=  $impuestoAplicable['Importe'];
                $impuestoAplicable['Importe'] =  number_format($impuestoAplicable['Importe'], 2, '.', '');
                if ($impuestoAplicable['TipoFactor']=='Tasa') {
                    $impuestoAplicable['TasaOCuota'] = number_format($impuestoAplicable['TasaOCuota']/100, 6, '.', '');
                }
                $detallesImpuestosTrasladados[] = $impuestoAplicable;
            }

            $this->datosImpuestos['Traslados'] = array(
                    'totalImpuestosTrasladados'=>number_format($totalImpuestoTrasladado, 2, '.', ''),
                    'detalles'=>$detallesImpuestosTrasladados
                );
        }
    }

    public function setSerieFolio()
    {
        #Toma la serie asignada para facturar y obtiene el folio siguiente si aun hay disponibles
        if ($this->tipoDocumento == 'Factura') {
            $id = $this->expedidoEn['serie_de_facturacion'];
        } elseif ($this->tipoDocumento == 'NotaCredito') {
            $id = $this->expedidoEn['serie_de_notas_de_credito'];
        }

        $query = "SELECT * FROM facturas_series_folios "
                . "WHERE id = '$id' "
                . "AND status = '1' "
                . "ORDER BY id ASC LIMIT 1";

        $result = $this->query($query);

        if ($result->num_rows == 0) {
            throw new Exception("No existen folios registrados para facturar.");
        } else {
            $result = $result->fetch_object();
            $folio_inicio = $result->folio_inicio;
            $folio_fin = $result->folio_fin;
            $serie = $result->serie;
        }

        if ($this->tipoDocumento == 'Factura') {
            $tableName= 'facturas';
        } elseif ($this->tipoDocumento == 'NotaCredito') {
            $tableName= 'notas_de_credito';
        }

        #1 es sin Timbrar
        $query = "SELECT folio "
                . "FROM $tableName "
                . "WHERE serie = '$serie'"
                . "AND status != '1' "
                . "ORDER BY folio DESC LIMIT 1";

        $result = $this->query($query);

        if ($result->num_rows == 0) {
            $folio = $folio_inicio;
        } else {
            $result = $result->fetch_object();
            $folio = $result->folio;
            $folio++;
        }

        if ($folio > $folio_fin) {
            #parar script y mandar mensaje "No existen folios registrados para facturar."
            throw new Exception("No existen folios registrados para facturar.");
        }

        $this->serie = $serie;
        $this->folio = $folio;
    }

    public function getRegimenFiscal()
    {
        if (isset($this->expedidoEn['regimen_fiscal']) && $this->expedidoEn['regimen_fiscal']!= '') {
            return $this->expedidoEn['regimen_fiscal'];
        }

        return $this->emisor['regimen_fiscal'];
    }

    public function getNoCertificado()
    {
        if ($this->expedidoEn['certificado_independiente']== 'Si') {
            return $this->expedidoEn['no_certificado'];
        }
        return $this->emisor['no_certificado'];
    }

    public function getCertificado()
    {
        if ($this->expedidoEn['certificado_independiente']== 'Si') {
            return str_replace(" ", "", $this->expedidoEn['certificado']);
        }
        return str_replace(" ", "", $this->emisor['certificado']);
    }

    public function getOptions()
    {
        return $this->options;
    }

    public function getIdFactura()
    {
        return $this->idFactura;
    }

    public function getDatosComprobante()
    {
        return $this->datosComprobante;
    }

    public function getDatosEmisor()
    {
        return $this->datosEmisor;
    }

    public function getDatosCFDIRelacionados()
    {
        return $this->datosCFDIRelacionados;
    }

    public function getDatosReceptor()
    {
        return $this->datosReceptor;
    }

    public function getDatosConceptos()
    {
        return $this->datosConceptos;
    }

    public function getDatosImpuestos()
    {
        return $this->datosImpuestos;
    }

    public function getNombreArchivo()
    {
        $folio = str_pad($this->folio, 5, "0", STR_PAD_LEFT);
        $nombreArchivo = '';

        if (trim($this->serie)!='') {
            $nombreArchivo .= $this->serie."-";
        }

        return $nombreArchivo .= $folio;
    }

    public function getRutaParaGuardarXML()
    {
        return $this->rutaParaGuardarXML."/".$this->expedidoEn['id']."/";
    }

    public function getArchivosSAT()
    {
        if ($this->expedidoEn['certificado_independiente']== 'Si') {
            return array(
                    'keyPem'=>PATH_SAT_DOCS."/".$this->expedidoEn['id']."/".$this->archivoKeyPem
                  );
        }
        /* 1 contiene la archivos de la empresa con lo que se debe facturar por default, cuando la empresa no tiene certificado propio*/

        return array(
                'keyPem'=>PATH_SAT_DOCS."/1/".$this->archivoKeyPem
              );
    }

    public function getPathArchivoXML()
    {
        return $this->getRutaParaGuardarXML().$this->getNombreArchivo().".xml";
    }

    public function getArchivoXML()
    {
        return file_get_contents($this->getRutaParaGuardarXML().$this->getNombreArchivo().".xml");
    }

    public function setParametroXML()
    {
        $this->datosTimbrar['timbraRequest']['timbraRequest']['XML'] = $this->getArchivoXML();
        //$this->datosTimbrar['timbraRequest']['timbraRequest']['XML'] = '';
    }

    public function crearXML()
    {
        $crear_xml_factura = new crear_xml_factura();
        $crear_xml_factura->setDatosComprobante($this->getDatosComprobante());
        $crear_xml_factura->setDatosCFDIRelacionados($this->getDatosCFDIRelacionados());
        $crear_xml_factura->setDatosEmisor($this->getDatosEmisor());
        $crear_xml_factura->setDatosReceptor($this->getDatosReceptor());
        $crear_xml_factura->setDatosConceptos($this->getDatosConceptos());
        $crear_xml_factura->setDatosImpuestos($this->getDatosImpuestos());
        $crear_xml_factura->setArchivosSAT($this->getArchivosSAT());

        $crear_xml_factura->crearXML($this->getRutaParaGuardarXML(), $this->getNombreArchivo());
    }

    public function timbrar()
    {
        $settings = new SettingsRepository();
        $tipoTimbrado = $settings->_get('tipo_timbrado');
        $serverURL = $settings->_get($tipoTimbrado.'_timbrado_serverURL');
        $usuarioTimbrado = $settings->_get($tipoTimbrado.'_timbrado_usuario');
        $metodoALlamar = $settings->_get('timbrado_metodoALlamar');

        // echo $this->getArchivoXML(); exit;

        $params = array();
        $params['usuarioIntegrador'] = $usuarioTimbrado;
        /* Comprobante en base 64 */
        //$xml = $this->getArchivoXML();
        //echo $xml; exit;
        $params['xmlComprobanteBase64'] = base64_encode($this->getArchivoXML());
        /* Id del comprobante, deberÃ¡ ser un identificador Ãºnico, para efecto del ejemplo se utilizarÃ¡ un numero aleatorio */
        $params['idComprobante'] = rand(5, 999999);

        //$params['cache_wsdl'] = WSDL_CACHE_NONE;

        $client = new SoapClient($serverURL, $params);
        $response = $client->__soapCall($metodoALlamar, array('parameters' => $params));

        /* Obtenemos resultado del response */
        $tipoExcepcion = $response->TimbraCFDIResult->anyType[0];
        $numeroExcepcion = $response->TimbraCFDIResult->anyType[1];
        $descripcionResultado = $response->TimbraCFDIResult->anyType[2];
        $xmlTimbrado = $response->TimbraCFDIResult->anyType[3];
        $codigoQr = $response->TimbraCFDIResult->anyType[4];
        $cadenaOriginal = $response->TimbraCFDIResult->anyType[5];

        if ($numeroExcepcion == "0") {
            /* El comprobante fue timbrado correctamente */
            /* Guardamos comprobante timbrado */
            $this->guardarXMLTimbrado($xmlTimbrado);
            return true;
        /* Guardamos codigo qr */
            //file_put_contents('C:\Users\Andres\Desktop\codigoQr.jpg', $codigoQr);

            /* Guardamos cadena original del complemento de certificacion del SAT */
            //file_put_contents('C:\Users\Andres\Desktop\cadenaOriginal.txt', $cadenaOriginal);
        } else {
            #Produccion
            //throw new Exception('Oopss!!. Algo salio mal durante el proceso de facturacion.<br/> Contacta a tu proveedor del servicio para mas informacion.');
            #Develop
            #$numeroExcepcion.'=>'.$descripcionResultado
            throw new Exception($descripcionResultado);
        }
    }

    public function cancelar()
    {
        $settings = new SettingsRepository();
        $tipoTimbrado = $settings->_get('tipo_timbrado');
        $serverURL = $settings->_get($tipoTimbrado.'_timbrado_serverURL');
        $usuarioTimbrado = $settings->_get($tipoTimbrado.'_timbrado_usuario');
        $metodoALlamar = $settings->_get('timbrado_cancelar_metodoALlamar');
        $response = '';

        try {
            $params = array();
            $params['usuarioIntegrador'] = $usuarioTimbrado;
            $params['rfcEmisor'] = $this->emisor['rfc'];
            $params['folioUUID'] = $this->comprobante->getUUID();

            $context = stream_context_create(array(
                'ssl' => array(
                    // set some SSL/TLS specific options
                    'verify_peer' => false,
                    'verify_peer_name' => false,
                    'allow_self_signed' => true  //--> solamente true en ambiente de pruebas
                ),
                'http' => array(
                    'user_agent' => 'PHPSoapClient'
                )
            ));

            $options = array();
            $options['stream_context'] = $context;
            $options['cache_wsdl'] = WSDL_CACHE_MEMORY;
            $options['trace'] = true;

            #Cancelamos
            $client = new SoapClient($serverURL, $options);
            $response = $client->__soapCall($metodoALlamar, array('parameters' => $params));

            /* Obtenemos resultado del cancelacion */
            $tipoExcepcion = $response->CancelaCFDIResult->anyType[0];
            $numeroExcepcion = $response->CancelaCFDIResult->anyType[1];
            $descripcionResultado = $response->CancelaCFDIResult->anyType[2];

            if ($numeroExcepcion == "0") {
                #Actualizamos status de factura
                parent::update($this->getIdFactura(), array('status' => 3), 'facturas');
                return true;
            } else {
                throw new Exception($descripcionResultado);
            }
        } catch (SoapFault $fault) {
            throw new Exception("SOAPFault: " . $fault->faultcode . "-" . $fault->faultstring . "\n");
        }
    }

    public function getAcuseCancelacion()
    {
        $settings = new SettingsRepository();
        $tipoTimbrado = $settings->_get('tipo_timbrado');
        $serverURL = $settings->_get($tipoTimbrado.'_timbrado_serverURL');
        $usuarioTimbrado = $settings->_get($tipoTimbrado.'_timbrado_usuario');
        $metodoALlamar = $settings->_get('timbrado_cancelar_metodoALlamar');
        $response = '';

        try {
            $params = array();
            $params['usuarioIntegrador'] = $usuarioTimbrado;
            $params['rfcEmisor'] = $this->emisor['rfc'];
            $params['folioUUID'] = $this->comprobante->getUUID();

            $context = stream_context_create(array(
                'ssl' => array(
                    // set some SSL/TLS specific options
                    'verify_peer' => false,
                    'verify_peer_name' => false,
                    'allow_self_signed' => true  //--> solamente true en ambiente de pruebas
                ),
                'http' => array(
                    'user_agent' => 'PHPSoapClient'
                )
            ));

            $options = array();
            $options['stream_context'] = $context;
            $options['cache_wsdl'] = WSDL_CACHE_MEMORY;
            $options['trace'] = true;

            #Cancelamos
            $client = new SoapClient($serverURL, $options);
            $response = $client->__soapCall($metodoALlamar, array('parameters' => $params));

            /* Obtenemos resultado del cancelacion */
            $tipoExcepcion = $response->CancelaCFDIResult->anyType[0];
            $numeroExcepcion = $response->CancelaCFDIResult->anyType[1];
            $descripcionResultado = $response->CancelaCFDIResult->anyType[2];

            if ($numeroExcepcion == "0") {
                #Actualizamos status de factura
                parent::update($this->getIdFactura(), array('status' => 3), 'facturas');

                #Obtener Acuse
                $response = $client->__soapCall($metodoALlamar, array('parameters' => $params));

                $tipoExcepcion = $response->ObtieneCFDIResult->anyType[0];
                $numeroExcepcion = $response->ObtieneCFDIResult->anyType[1];
                $descripcionResultado = $response->ObtieneCFDIResult->anyType[2];
                $xmlTimbrado = $response->ObtieneCFDIResult->anyType[3];
                $codigoQr = $response->ObtieneCFDIResult->anyType[4];
                $cadenaOriginal = $response->ObtieneCFDIResult->anyType[5];

                if ($numeroExcepcion == "0") {
                    $this->guardarXMLTimbradoCancelado($xmlTimbrado);
                }

                throw new Exception($descripcionResultado);
            } else {
                throw new Exception($descripcionResultado);
            }
        } catch (SoapFault $fault) {
            throw new Exception("SOAPFault: " . $fault->faultcode . "-" . $fault->faultstring . "\n");
        }
    }

    public function guardarXMLTimbrado($xmlTimbrado)
    {
        file_put_contents($this->getRutaParaGuardarXML()."/Timbre-".$this->getNombreArchivo().".xml", $xmlTimbrado);
    }

    public function getXMLTimbrado()
    {
        return $this->getRutaParaGuardarXML()."/Timbre-".$this->getNombreArchivo().".xml";
    }

    public function guardarXMLTimbradoCancelado($xmlCancelado)
    {
        file_put_contents($this->getRutaParaGuardarXML()."/Cancelacion-".$this->getNombreArchivo().".xml", $xmlCancelado);
    }

    public function getXMLTimbradoCancelado()
    {
        return $this->getRutaParaGuardarXML()."/Cancelacion-".$this->getNombreArchivo().".xml";
    }

    public function guardarFactura()
    {
        #Leer xml timbrado
        $xml = simplexml_load_file($this->getXMLTimbrado());
        #$xml = simplexml_load_file( $this->getRutaParaGuardarXML()."/Timbre-A-00001.xml");
        $cfdi = $xml->getNamespaces(true);
        $xml->registerXPathNamespace("c", $cfdi["tfd"]);
        $attribute = $xml->xpath("//c:TimbreFiscalDigital");

        #Obtener atributos de xml timbrado
        $version = (string)$attribute[0]->attributes()->version;
        $uuid = (string)$attribute[0]->attributes()->UUID;
        $ftimbrado = (string)$attribute[0]->attributes()->FechaTimbrado;
        $sellocfdi = (string)$attribute[0]->attributes()->SelloCFD;
        $certificadosat = (string)$attribute[0]->attributes()->NoCertificadoSAT;
        $ssat = (string)$attribute[0]->attributes()->SelloSAT;

        $cadena_originalsat = "||".$version."|".$uuid."|".$ftimbrado."|".$sellocfdi."|".$certificadosat."||";

        $options = array(
            'serie'=>$this->serie,
            'folio'=>$this->folio, #int
            'iva_tasa'=>!isset($this->datosDefaultComprobante['iva_tasa']) ? 0:$this->datosDefaultComprobante['iva_tasa'],
            'rfc_receptor'=>$this->datosReceptor['Receptor']['Rfc'],
            'datos_comprobante'=>serialize($this->getDatosComprobante()),
            'datos_emisor'=>  serialize($this->getDatosEmisor()),
            'datos_receptor'=>  serialize($this->getDatosReceptor()),
            'datos_conceptos'=>  serialize($this->getDatosConceptos()),
            'uuid'=>$uuid,
            'certificado_sat'=>$certificadosat,
            'fecha_timbrado'=>$ftimbrado,
            'sello_sat'=>$ssat,
            'cadena_original_sat'=>$cadena_originalsat,
            'sello_cfdi'=>$sellocfdi,
            'status'=>'2'
        );

        if ($this->tipoDocumento === 'Factura') {
            $factura = new FacturaRepository();
        } elseif ($this->tipoDocumento === 'NotaCredito') {
            $factura = new NotaCreditoRepository();
        }

        $result = $factura->guardarDatosTimbrado($options, $this->getIdFactura());

        if ($result) {
            return true;
        }
        return null;
    }
}
