<?php

class HistoryRepository extends EntityRepository
{
    private $table = 'history';
    public $flashmessenger = null;
    
    public function __construct()
    {
        if (!$this->flashmessenger instanceof FlashMessenger) {
            $this->flashmessenger = new FlashMessenger();
        }
    }
    
    public function _getTranslation($text)
    {
        return $this->flashmessenger->_getTranslation($text);
    }
    
    private $options = array(
        'operation'=>null,
        'table'=>null,
        'parent_reference'=>null,
        'reference'=>null,
        'action'=>null,
        'id_pallet'=>null,
        'date_time'=>null,
        'user'=>null
    );
    
    private $history_tables = array(
        'manifest'=>array(
            'operation'=>'Manifest',
            'parent_reference'=>'parent_reference',
            'id_pallet'=>'id_pallet'),#Cuando no son detalles esta param no exite, se agrega asi, para que no marque error
         
        'manifest_details'=>array(
            'operation'=>'Manifest',
            'parent_reference'=>'id_manifest',
            'id_pallet'=>'id_pallet'),
         
        'receiving'=>array(
            'operation'=>'Receiving',
            'parent_reference'=>'parent_reference',
            'id_pallet'=>'id_pallet'),
         
        'receiving_details'=>array(
            'operation'=>'Receiving',
            'parent_reference'=>'id_receiving',
            'id_pallet'=>'id_pallet'),
         
        'shipping_request'=>array(
            'operation'=>'Shipping Request',
            'parent_reference'=>'parent_reference',
            'id_pallet'=>'id_pallet'),
         
        'shipping_request_details'=>array(
            'operation'=>'Shipping Request',
            'parent_reference'=>'id_shipping_request',
            'id_pallet'=>'id_pallet'),
         
        'manufacturing'=>array(
            'operation'=>'Manufacturing',
            'parent_reference'=>'parent_reference',
            'id_pallet'=>'id_pallet'),
         
        'manufacturing_inputs'=>array(
            'operation'=>'Manufacturing',
            'parent_reference'=>'id_manufacturing',
            'id_pallet'=>'id_pallet'),
         
        'manufacturing_outputs'=>array(
            'operation'=>'Manufacturing',
            'parent_reference'=>'id_manufacturing',
            'id_pallet'=>'id_pallet'),
         
        'manufacturing_outputs_pallets'=>array(
            'operation'=>'Manufacturing',
            'parent_reference'=>'id_manufacturing',
            'id_pallet'=>'id_pallet'),
         
         'shipping'=>array(
            'operation'=>'Shipping',
            'parent_reference'=>'parent_reference',
            'id_pallet'=>'id_pallet'),
         
        'shipping_details'=>array(
            'operation'=>'Shipping',
            'parent_reference'=>'id_shipping',
            'id_pallet'=>'id_pallet_inventory'),
    );
    
    public function setOptions($data)
    {
        foreach ($this->options as $option => $value) {
            if (isset($data[$option])) {
                $this->options[$option] = $data[$option];
            }
        }
    }
  
    public function getOptions()
    {
        return $this->options;
    }
    
    public function setHistoryInventory($options)
    {
        return $this->save($options);
    }
    
    
    public function setHistory($options)
    {
        if (!key_exists($options['table'], $this->history_tables)) {
            return true;
        }
        
        $params = $this->history_tables[$options['table']];
       
        $login = new Login();
        $data = $options['data'];
        if (!isset($data['parent_reference'])) {
            $data['parent_reference'] = '_NULL';
        }
        if (!isset($data['id_pallet'])) {
            $data['id_pallet'] = '_NULL';
        }
        if (!isset($options['modifications'])) {
            $options['modifications'] = '_NULL';
        }
       
        $array = array(
            'operation'=>$params['operation'],
            'table_name'=>$options['table'],
            'parent_reference'=>$data[$params['parent_reference']],
            'reference'=>$options['id'],
            'action'=>$options['action'],
            'id_pallet'=>$data[$params['id_pallet']],
            'date_time'=>date('Y-m-d h:i:s'),
            'user'=>$login->getId()
       );
      
        switch ($options['action']) {
          case 'insert':
              $array['modifications'] = serialize($options['data']);
              break;
          
          case 'update':
              if (is_null($options['modifications'])) {
                  return true;
              }
              $array['modifications'] = serialize($options['modifications']);
              break;
          
          case 'delete':
              $array['modifications'] = serialize($options['data']);
              break;
      }
       
        return $this->save($array);
    }
    
    public function save(array $data, $table = null)
    {
        foreach ($data as $field => $value) {
            if ($value === '' || $value === null) {
                $data[$field] = '_NULL';
            }
        }
        
        return parent::save($data, $this->table);
    }
    
    public function delete($id, $table = null)
    {
        return parent::delete($id, $this->table);
    }

    public function update($id, $data, $table = null)
    {
        return parent::update($id, $data, $this->table);
    }

    public function getById($id, $table = null, $selectAux = null)
    {
        return parent::getById($id, $this->table, $selectAux);
    }
}
