<?php
class NotaCreditoDetailsTempRepository extends EntityRepository
{
    private $table = 'notas_de_credito_detalles_';
    
    public function __construct()
    {
        $login = new Login();
        $this->table = $this->table.$login->getId();
    }
    // Guarda en temporal
    public function save(array $data, $table = null)
    {
        if (trim($data['descuento_detalle']) == '') {
            $data['descuento_detalle'] = 0;
        }
        if (isset($data['idDetailTemp']) && trim($data['idDetailTemp'])!= '') {
            $result = $this->getById($data['idDetailTemp']);
            if ($result) {
                $id = $data['idDetailTemp'];
                unset($data['idDetailTemp']);
                return parent::update($id, $data, $this->table);
            }
        }
        
        unset($data['idDetailTemp']);
        $repo = new FacturaRepository();
        $impuestosLista = $repo->getListImpuestos();
        $impuestos = trim($data['impuestos']);
        $impuestosAplicables = array('Trasladable'=>array(),'Retenible'=>array());
        
        #calcular precio_unitario sin impuestos
        if ($impuestos != '') {
            $impuestos = explode(',', $data['impuestos']);
            if ($data['impuestos_incluidos'] == 'Si') {
                $precioUnitConImpuesto = $data['precio_unitario'];
                foreach ($impuestos as $key =>$value) {
                    $impuestoInfo = $impuestosLista[$value];
                    $porcentaje = 1 + $impuestoInfo['tasa_cuota']/100;
                    $precioUnitSinImpuesto = $precioUnitConImpuesto/$porcentaje;
                    $data['precio_unitario'] -= $precioUnitSinImpuesto * $impuestoInfo['tasa_cuota']/100;
                    #$detalle['precio_unitario'] = $precioUnitSinImpuesto;
                }
            }
        }
        
        #Descontar de precio_unitario descuento si existe.
        $subtotal = ($data['precio_unitario'] * $data['cantidad']);
        $descuento = $subtotal * ($data['descuento_detalle']/100);
        $data['descuento_monto'] = $descuento;
        $data['importe'] = $subtotal - $descuento;
        
        if ($impuestos != '') {
            foreach ($impuestos as $key =>$value) {
                $impuestoInfo = $impuestosLista[$value];
                switch ($impuestoInfo['tipo_factor']) {
                    case 'Tasa':
                        $montoImpuesto = $data['importe'] * $impuestoInfo['tasa_cuota']/100;
                        break;

                    case 'Cuota':
                        $montoImpuesto = $data['cantidad'] * $impuestoInfo['tasa_cuota'];
                        break;
                }


                if (key_exists($value, $impuestosAplicables[$impuestoInfo['tipo']])) {
                    $impuestosAplicables[$impuestoInfo['tipo']][$value]['Importe'] += number_format($montoImpuesto, 2, '.', '');
                } else {
                    $impuestosAplicables[$impuestoInfo['tipo']][$value]['Importe'] = number_format($montoImpuesto, 2, '.', '');
                    $impuestosAplicables[$impuestoInfo['tipo']][$value]['nombre'] = $impuestoInfo['impuesto'];
                    $impuestosAplicables[$impuestoInfo['tipo']][$value]['descripcion'] = $impuestoInfo['descripcion'];
                    $impuestosAplicables[$impuestoInfo['tipo']][$value]['Base'] = $data['importe'];
                    $impuestosAplicables[$impuestoInfo['tipo']][$value]['Impuesto'] = $impuestoInfo['clave'];
                    $impuestosAplicables[$impuestoInfo['tipo']][$value]['TipoFactor'] = $impuestoInfo['tipo_factor'];
                    $impuestosAplicables[$impuestoInfo['tipo']][$value]['TasaOCuota'] = $impuestoInfo['tasa_cuota'];
                }
            }
        }
        $data['impuestos_aplicables'] = serialize($impuestosAplicables);
        return parent::save($data, $this->table);
    }
    
    // Guarda en tabla comprasdetalles
    public function saveDetalles($idCompra, $tokenForm)
    {
        $query = "SELECT * FROM $this->table WHERE token_form = '$tokenForm'";
        $result = $this->query($query);
        if ($result->num_rows > 0) {
            $result = $this->resultToArray($result);
            
            foreach ($result as $data) {
                unset($data['id'], $data['token_form'], $data['id_detail']);
                $data['id_factura'] = $idCompra;
                
                parent::save($data, 'notas_de_credito_detalles');
            }
        }

        return true;
    }
    
    public function updateDetalles($idFactura, $tokenForm)
    {
        $query = "SELECT id FROM notas_de_credito_detalles WHERE id_factura = '$idFactura'";
        $result = $this->query($query);
        $detallesOrigin = null;
        if ($result->num_rows > 0) {
            $detallesOrigin = $this->resultToArray($result);
        }
        
        $query = "SELECT * FROM $this->table WHERE token_form = '$tokenForm'";
        $result = $this->query($query);
        
        if ($result->num_rows > 0) {
            $idsDetalles = array();
        
            $result = $this->resultToArray($result);
            foreach ($result as $data) {
                $idDetalle = $data['id_detail'];
                unset($data['id'],$data['id_detail'], $data['token_form']);
                $data['id_factura'] = $idFactura;
              
                if (!$idDetalle) {
                    parent::save($data, 'notas_de_credito_detalles');
                } else {
                    #contiene los idDetalles de la compra original que se mantendran, lo que no esten aqui se eliminaran.
                    $idsDetalles[] = $idDetalle;
                    //var_dump($data);exit;
                    parent::update($idDetalle, $data, 'notas_de_credito_detalles');
                }
            }
        }

        #Se eliminan ids de tabla comprasdetalls que ya no estan en $idsDetalles (este array contiene los ids que permanececieron en la compra despues del update)
        if ($detallesOrigin) {
            foreach ($detallesOrigin as $detalle) {
                if (!in_array($detalle['id'], $idsDetalles)) {
                    parent::delete($detalle['id'], 'notas_de_credito_detalles');
                }
            }
        }
        return true;
    }
    
    public function delete($id, $table = null)
    {
        return parent::delete($id, $this->table);
    }
    
    public function truncateIfIsEditInfo()
    {
        $query = "SELECT id_factura FROM .".$this->table." LIMIT 1";
        $result = $this->query($query);
        
        if ($result->num_rows > 0) {
            $result = $result->fetch_object();
            if ($result->id_factura !=null || $result->id_factura != '') {
                $this->truncate();
                return true;
            }
        }
        
        return null;
    }
    
    public function truncate($tokenForm)
    {
        $query = "DELETE FROM ".$this->table." WHERE token_form = '$tokenForm'";
        $result = $this->query($query);
        
        if ($result) {
            return true;
        }
        
        return null;
    }
    
    
    public function setStoreInDetailsById($idFactura, $tokenForm)
    {
        $query = "INSERT INTO ".$this->table." (id_detail,token_form,id_factura,id_producto,nombre,descripcion,cantidad,precio_unitario,descuento_detalle,descuento_monto,importe,impuestos_incluidos,impuestos,impuestos_aplicables)
        SELECT id,'$tokenForm',id_factura,id_producto,nombre,descripcion,cantidad,precio_unitario,descuento_detalle,descuento_monto,importe,impuestos_incluidos,impuestos,impuestos_aplicables
        FROM notas_de_credito_detalles 
        WHERE id_factura = '$idFactura'";
        
        $result = $this->query($query);
        if ($result) {
            return true;
        }
        
        return null;
    }

    public function update($id, $data, $table = null)
    {
        if (isset($data['id_factura'])) {
            if ($data['id_factura']=='' || !$data['id_factura']) {
                unset($data['id_factura']);
            }
        }
        
        return parent::update($id, $data, $this->table);
    }

    public function getById($id, $table = null, $selectAux = null)
    {
        return parent::getById($id, $this->table, $selectAux);
    }
}
