<?php
class NotaCreditoRepository extends EntityRepository
{
    private $table = 'notas_de_credito';
    public $flashmessenger = null;
    
    private $options = array(
        'sucursal'=>null,
        'id_cliente'=>null,
        'rfc_receptor'=>null,
        'tipo_documento'=>null,
        'serie'=>null, #varchar(25)
        'folio'=>null, #int
        'forma_de_pago'=>null, #varchar(100)
        'metodo_de_pago'=>null, #carchar(50) Ejemplo: Efectivo-Cheque-Tarjeta
        'num_cuenta_pago'=>null,
        'condiciones_de_pago'=>null,
        'tipo_relacion'=>null,
        'uso_cfdi'=>null,
        'uuid_relacionados'=>null,
        'uuid_relacionados_otros'=>null,
        'moneda'=>null,
        'tipo_de_cambio'=>null,
        'subtotal'=>null, #double
        'descuento'=>null,
        'total'=>null,
        'iva_tasa'=>null,
        'total_impuestos_trasladados'=>null,
        'total_impuestos_retenidos'=>null,
        'detalles_impuestos_aplicables'=>null,
        'comentarios'=>null,
        'datos_comprobante'=>null,
        'datos_emisor'=>null,
        'datos_receptor'=>null,
        'datos_conceptos'=>null,
        'uuid'=>null,
        'certificado_sat'=>null,
        'fecha_timbrado'=>null,
        'sello_sat'=>null,
        'cadena_original_sat'=>null,
        'sello_cfdi'=>null,
        'status'=>null,
        'version_cfdi'=>null,
        'saldo_pendiente'=>null, # se añade para igualar el total a el campo de saldo_pendiente
        'total_cuenta_de_gastos'=>null, /*Auxiliar para generar Factura de Cuenta de Gastos*/
    );

    private $options_aux = array(
        'saldoPendiente'=>null,
        'comprobanteName'=>null,
        'formaName'=>null,
        'metodoName'=>null,
        'monedaName'=>null,
        'usoCFDIName'=>null,
        'uuid_relacionados_y_otros_uuid_relacionados'=>null,
        'token_form'=>null
    );

    public function setOptions($data)
    {
        foreach ($this->options as $option => $value) {
            if (isset($data[$option])) {
                $this->options[$option] = $data[$option];
            }
        }

        foreach ($this->options_aux as $option => $value) {
            if (isset($data[$option])) {
                $this->options_aux[$option] = $data[$option];
            }
        }
    }

    public function getOptions()
    {
        return $this->options;
    }

    public function getStatus()
    {
        return $this->options['status'];
    }
    
    public function getVersionCFDI()
    {
        return $this->options['version_cfdi'];
    }

    public function getSucursal()
    {
        return $this->options['sucursal'];
    }

    public function getIdCliente()
    {
        return $this->options['id_cliente'];
    }

    public function getSaldoPendiente()
    {
        return $this->options['saldo_pendiente'];
    }

    public function getTipoComprobante()
    {
        return $this->options['tipo_documento'];
    }

    public function getTipoComprobanteNombre()
    {
        return $this->options_aux['comprobanteName'];
    }

    public function getFormaDePago()
    {
        return $this->options['forma_de_pago'];
    }

    public function getFormaDePagoNombre()
    {
        return $this->options_aux['formaName'];
    }

    public function getCondicionesDePago()
    {
        return $this->options['condiciones_de_pago'];
    }
  
    public function getSubTotal()
    {
        return $this->options['subtotal'];
    }
   
    public function getDescuento()
    {
        return $this->options['descuento'];
    }

    public function getImpuestosAplicables()
    {
        return unserialize($this->options['detalles_impuestos_aplicables']);
    }

    public function getMoneda()
    {
        return $this->options['moneda'];
    }
  
    public function getMonedaNombre()
    {
        return $this->options_aux['monedaName'];
    }

    public function getTipoDeCambio()
    {
        return $this->options['tipo_de_cambio'];
    }

    public function getNumCuenta()
    {
        return $this->options['num_cuenta_pago'];
    }

    public function getUsoCFDI()
    {
        return $this->options['uso_cfdi'];
    }
    
    public function getUsoCFDINombre()
    {
        return $this->options_aux['usoCFDIName'];
    }

    public function getTipoRelacion()
    {
        return $this->options['tipo_relacion'];
    }

    public function getUUIDsRelacionados()
    {
        return $this->options['uuid_relacionados'];
    }
    
    public function getTokenForm()
    {
        return $this->options_aux['token_form'];
    }

    public function getCFDIRelacionados()
    {
        $uudis = $this->options_aux['uuid_relacionados_y_otros_uuid_relacionados'];
        $uudis = trim($uudis, ',');

        if (trim($uudis) == ',') {
            return null;
        }
        if (trim($uudis) != '') {
            return explode(',', $uudis);
        }
       
        return null;
    }

    public function getSerie()
    {
        return $this->options['serie'];
    }
   
    public function getFolio()
    {
        return str_pad($this->options['folio'], 5, "0", STR_PAD_LEFT);
    }

    public function getNumFactura()
    {
        $numFactura = '';
        if (trim($this->getSerie())!='') {
            $numFactura .= $this->getSerie()."-";
        }
        return $numFactura .=$this->getFolio();
    }
    
    public function getTotal()
    {
        return $this->options['total'];
    }

    public function getTotalParaCodigoQR()
    {
        $total = explode('.', number_format($this->getTotal(), 2));
        $entero = str_pad($total[0], 10, "0", STR_PAD_LEFT);
        $decimal = str_pad($total[1], 6, "0", STR_PAD_LEFT);

        return $entero.".".$decimal;
    }

    public function getMetodoDePago()
    {
        return $this->options['metodo_de_pago'];
    }

    public function getMetodoDePagoNombre()
    {
        if ($this->getVersionCFDI()=='3.3') {
            return $this->options_aux['metodoName'];
        } elseif ($this->getVersionCFDI()=='3.2') {
            return $this->options_aux['formaName'];
        }
    }

    public function getNumCuentaPago()
    {
        $comprobante = $this->getDatosComprobante();
        return $comprobante['NumCtaPago'];
    }

    public function getFechaTimbrado()
    {
        return $this->options['fecha_timbrado'];
    }

    public function getFechaFactura()
    {
        $fecha = substr($this->getFechaTimbrado(), 0, 10);
        $fecha = strftime('%d/%m/%Y', strtotime($fecha));

        $hora = substr($this->getFechaTimbrado(), 11, 8);
        return $fecha ." ".$hora;
    }

    public function getComentarios()
    {
        return $this->options['comentarios'];
    }

    public function getDatosComprobante()
    {
        return unserialize($this->options['datos_comprobante']);
    }

    public function getDatosReceptor()
    {
        return unserialize($this->options['datos_receptor']);
    }

    public function getConceptos()
    {
        return unserialize($this->options['datos_conceptos']);
    }
    
    public function getUUID()
    {
        return $this->options['uuid'];
    }

    public function getSelloCFDI()
    {
        return $this->options['sello_cfdi'];
    }

    public function getSelloSAT()
    {
        return $this->options['sello_sat'];
    }

    public function getCadenaOriginalSAT()
    {
        return $this->options['cadena_original_sat'];
    }

    public function getNumCertificadoSAT()
    {
        return $this->options['certificado_sat'];
    }

    public function getTable()
    {
        return $this->table;
    }

    public function crearPDF()
    {
        $pdf = new NotaCreditoPDF($this->getId(), true);
        $this->facturaPDF = $pdf->getPathFileCreated();
        $this->crearZip();
    }

    public function crearZip()
    {
        $zipfile = new zipfile();
        $this->archivoZipName = "NotaDeCredito-".$this->getNumFactura().".zip";

        $empresa = new EmpresaRepository();
        $empresa->setOptions($empresa->getById(1));

        $zipfile->add_file(implode("", file($this->facturaPDF)), $this->getNumFactura().".pdf");
        $zipfile->add_file(implode("", file(PATH_SAT_DOCS."/".$this->getSucursal()."/Timbre-".$this->getNumFactura().".xml")), $this->getNumFactura().".xml");

        $fd = fopen(PATH_SAT_DOCS."/".$this->getSucursal()."/temp-pdf/".$this->archivoZipName, "wb");
        $out = fwrite($fd, $zipfile->file());
        fclose($fd);

        $this->archivoZipPath = PATH_SAT_DOCS."/".$this->getSucursal()."/temp-pdf/".$this->archivoZipName;
    }
    
    public function crearZipCuentaDeGastos()
    {
        $zipfile = new zipfile();
        $this->archivoZipName = "NotaDeCredito-".$this->getNumFactura().".zip";

        $empresa = new EmpresaRepository();
        $empresa->setOptions($empresa->getById(1));

        $zipfile->add_file(implode("", file($this->facturaPDF)), $this->getNumFactura().".pdf");

        $fd = fopen(PATH_SAT_DOCS."/".$this->getSucursal()."/temp-pdf/".$this->archivoZipName, "wb");
        $out = fwrite($fd, $zipfile->file());
        fclose($fd);

        $this->archivoZipPath = PATH_SAT_DOCS."/".$this->getSucursal()."/temp-pdf/".$this->archivoZipName;
    }

    public function descargarZip()
    {
        $filePahth= $this->getRutaArchivoZip();
        header("Content-type: application/octet-stream");
        header("Content-disposition: attachment; filename={$this->archivoZipName}");
        // leemos el archivo creado
        readfile($filePahth);
    }

    public function getRutaArchivoZip()
    {
        return $this->archivoZipPath;
    }

    public function __construct()
    {
        if (!$this->flashmessenger instanceof FlashMessenger) {
            $this->flashmessenger = new FlashMessenger();
        }
    }

    public function _getTranslation($text)
    {
        return $this->flashmessenger->_getTranslation($text);
    }

    public function save(array $data, $table = null)
    {
        $settings = new SettingsRepository();
        $data['version_cfdi'] = $settings->_get('version_cfdi');
        $data['status'] = '1';
        if (is_array($data['uuid_relacionados'])) {
            $data['uuid_relacionados'] = implode(',', $data['uuid_relacionados']);
        }
        if (is_array($data['uuid_relacionados_otros'])) {
            $data['uuid_relacionados_otros'] = implode(',', $data['uuid_relacionados_otros']);
        }
        if (trim($data['folio']) == '' || $data['folio'] == null) {
            unset($data['folio']);
        }
        if (trim($data['subtotal']) == '' || $data['subtotal'] == null) {
            unset($data['subtotal']);
        }
        if (trim($data['descuento']) == '' || $data['descuento'] == null) {
            unset($data['descuento']);
        }
        if (trim($data['total']) == '' || $data['total'] == null) {
            unset($data['total']);
        }
        if (trim($data['total_cuenta_de_gastos']) == '' || $data['total_cuenta_de_gastos'] == null) {
            $data['total_cuenta_de_gastos'] = '0';
        }
        if (trim($data['iva_tasa']) == '' || $data['iva_tasa'] == null) {
            unset($data['iva_tasa']);
        }
        $data['detalles_impuestos_aplicables'] = $_SESSION['detalles_impuestos_aplicables'];
        $data['saldo_pendiente'] = $data['total'];
        
        $saveData = $data;
        unset($saveData['total_cuenta_de_gastos']);
        
        $this->startTransaction();
        parent::save($saveData, $this->table);

        $facturaDetallesTemp = new NotaCreditoDetailsTempRepository();
        $idFactura = $this->getInsertId();
        $this->setLastInsertId($idFactura);//Para utilizarlo en el Controller action insert
        
        if ($facturaDetallesTemp->saveDetalles($idFactura, $this->getTokenForm())) {
            $this->commit();
            $facturaDetallesTemp->truncate($this->getTokenForm());
            return true;
        }
        
        $this->rollback();
        $this->flashmessenger->addMessage(array(
            'error'=>$this->_getTranslation('Error. Intenta nuevamente o contacta a tu proveedor de sistemas.')));

        return null;
    }
   
    public function update($id, $data, $table = null)
    {
        unset($data['status'],$data['version_cfdi']);
        if (is_array($data['uuid_relacionados'])) {
            $data['uuid_relacionados'] = implode(',', $data['uuid_relacionados']);
        }
        if (is_array($data['uuid_relacionados_otros'])) {
            $data['uuid_relacionados_otros'] = implode(',', $data['uuid_relacionados_otros']);
        }
        if (trim($data['folio']) == '' || $data['folio'] == null) {
            unset($data['folio']);
        }
        if (trim($data['subtotal']) == '' || $data['subtotal'] == null) {
            unset($data['subtotal']);
        }
        if (trim($data['descuento']) == '' || $data['descuento'] == null) {
            unset($data['descuento']);
        }
        if (trim($data['total']) == '' || $data['total'] == null) {
            unset($data['total']);
        }
        if (trim($data['total_cuenta_de_gastos']) == '' || $data['total_cuenta_de_gastos'] == null) {
            $data['total_cuenta_de_gastos'] = '0';
        }
        if (trim($data['iva_tasa']) == '' || $data['iva_tasa'] == null) {
            unset($data['iva_tasa']);
        }
        $data['detalles_impuestos_aplicables'] = $_SESSION['detalles_impuestos_aplicables'];
        $data['saldo_pendiente'] = $data['total'];
        
        $this->startTransaction();
        $updateData = $data;
        unset($updateData['total_cuenta_de_gastos']);
        
        $result = parent::update($id, $updateData, $this->table);

        if ($result) {
            $repository = new NotaCreditoDetailsTempRepository();
            if ($repository->updateDetalles($id, $this->getTokenForm())) {
                $this->commit();
                $repository->truncate($this->getTokenForm());
                return true;
            }
        }

        $this->rollback();
        return null;
    }

    public function updateString($fields, $where, $table = null)
    {
        return parent::updateString($fields, $where, $this->table);
    }

    public function delete($id, $table = null)
    {
        $data = $this->getById($id);
        
        #status = 1 (Sin Timbrar)
        #Se elimina de la BD
        if ($data['status']== '1') {
            if (parent::delete($id, $this->table)) {
                parent::query("DELETE  FROM notas_de_credito_detalles WHERE id_factura = '$id'");
                $this->flashmessenger->addMessage(array('success'=>$this->_getTranslation('Genial !!. La Nota de credito fue eliminada correctamente.')));
                return true;
            } else {
                throw new Exception('Opps !!. Algo salio mal al intentar eliminar la Factura.<br/>Intente nuevamente.');
            }
        } elseif ($data['status'] == '2') {
            if (parent::update($id, array('status'=>'3'), $this->table)) {
                $this->flashmessenger->addMessage(array('success'=>$this->_getTranslation('Genial !!. La Nota de credito fue cancelada correctamente.')));
                return false;
            } else {
                throw new Exception('Opps !!. Algo salio mal al intentar cancelar la Nota de credito.<br/>Intente nuevamente.');
            }
        }
        
        throw new Exception('La nota de credito ya esta cancelada');
    }
    
    public function getById($id, $table = null, $selectAux = null)
    {
        $select = "SELECT *, "
                . "fxGetClienteName(id_cliente)as clienteName,"
                . "DATE_FORMAT(convert(substring(fecha_timbrado,1,10),date),'%d/%m/%Y')as fecha,"
                . "CONCAT(uuid_relacionados, ',' ,uuid_relacionados_otros)as uuid_relacionados_y_otros_uuid_relacionados,"
                . "fxGetTipoDeComprobanteName(tipo_documento)as comprobanteName, "
                . "fxGetFormaDePagoName(forma_de_pago)as formaName, "
                . "fxGetMetodoDePagoName(metodo_de_pago)as metodoName, "
                . "fxGetMonedaName(moneda)as monedaName, "
                . "fxGetUsoCFDIName(uso_cfdi)as usoCFDIName, "
                . "subtotal,"
                . "descuento,"
                . "total,"
                . "fxGetStatusName(status,'Factura')as statusName, "
                . "fxGetUserName(creado_por) as userName "
                . "FROM $this->table "
                . "WHERE id = '$id'";

        $result = $this->query($select);
        
        if ($result->num_rows>0) {
            $data = $this->resultToArray($result)[0];
            return $data;
        }

        return false;
    }

    public function isUsedInRecord($id, array $buscarEn = null, $andWhere = null)
    {
        return null;
    }
    
    public function guardarDatosTimbrado($data, $idFactura)
    {
        if ($this->updateString($data, " id = ".$idFactura)) {
            return true;
        }
        return null;
    }

    public function crearTablaDetallesForUser()
    {
        $login = new Login();
        $query = "CREATE TABLE IF NOT EXISTS notas_de_credito_detalles_".$login->getId()." 
                 (  
                    `token_form` char(50) NOT NULL,
                    `id` int(11) NOT NULL AUTO_INCREMENT,
                    `id_detail` int(11) NULL,
                    `id_factura` int(11) NULL,
                    `id_producto` int(11) NOT NULL,
                    `nombre` varchar(255) NOT NULL,
                    `descripcion` text NULL,
                    `cantidad` double NOT NULL,
                    `precio_unitario` double NOT NULL,
                    `descuento_detalle` double NULL,
                    `descuento_monto` double  NULL,
                    `importe` double NULL,
                    `impuestos_incluidos` varchar(255)  NULL,
                    `impuestos` varchar(50)  NULL,
                    `impuestos_aplicables` TEXT  NULL,                  
                    PRIMARY KEY (`id`)
                 )ENGINE=InnoDB DEFAULT CHARSET=utf8;";

        $result = $this->query($query);
    }

    public function insertDetalle($data)
    {
        $facturaDetallesTemp = new NotaCreditoDetailsTempRepository();
        return $facturaDetallesTemp->save($data);
    }
    public function getFacturaDetalles($token_form)
    {
        $login = new Login();
        $query = "SELECT v.*,
                    fxGetUMDescription(p.unidad_de_medida) as umName,
                    v.id as idDetailTemp,
                    p.codigo,
                    p.impuestos
                  FROM notas_de_credito_detalles_".$login->getId()." v LEFT JOIN productos p
                  ON v.id_producto = p.id
                  WHERE v.token_form = '$token_form'
                  ORDER BY v.id";
        $result = $this->query($query);

        if ($result) {
            $result = $this->resultToArray($result);
            return $result;
        }

        return null;
    }

    public function getFacturaDetallesSaved($id)
    {
        $query = "SELECT c.*,
                    p.unidad_de_medida as um,
                    p.sat_producto_clave,
                    p.sat_producto_descripcion,
                    fxGetUMDescription(p.unidad_de_medida) as umName,
                    c.id as idDetailTemp,
                    p.codigo,
                    p.impuestos,
                    p.impuestos_incluidos
                    FROM notas_de_credito_detalles c LEFT JOIN productos p ON c.id_producto = p.id
                    WHERE c.id_factura = '$id'";
        $result = $this->query($query);

        if ($result) {
            $result = $this->resultToArray($result);
            return $result;
        }
        return null;
    }

    public function setNotaCreditoDetallesById($idFactura, $tokenForm)
    {
        $repository = new NotaCreditoDetailsTempRepository();
        return $repository->setStoreInDetailsById($idFactura, $tokenForm);
    }

    public function truncateIfIsEditInfo()
    {
        $repository = new NotaCreditoDetailsTempRepository();
        $repository->truncateIfIsEditInfo();
    }

    public function getProductById($idProducto)
    {
        $query = "SELECT * FROM productos WHERE id = '$idProducto' LIMIT 1";
        $result = $this->query($query);

        if ($result->num_rows > 0) {
            $result = $this->resultToArray($result);
            return $result[0];
        }
        return null;
    }

    public function getListNotasCredito($options = null)
    {
        //var_dump($options);echo "</pre>";exit;
        $vendorInvoice = null;
        $status = null;
        $limit = null;
        $date = null;
        $folio = null;
        $serie = null;
        
        if ($options) {
            $date = $this->createFilterFecha($options, 'f.creado_fecha');
            
            if (isset($options['id_cliente'])) {
                if (is_array($options['id_cliente']) && count($options['id_cliente']) > 0) {
                    $customerIds = implode(',', $options['id_cliente']);
                    $vendorInvoice = " AND find_in_set(f.id_cliente,'{$customerIds}')";
                } else {
                    if (trim($options['id_cliente'])!= '') {
                        $vendorInvoice = " AND find_in_set(f.id_cliente,'{$options['customer_id']}')";
                    }
                }
            }
            
            if (isset($options['status']) && $options['status'] != '') {
                $status = " AND status ='{$options['status']}'";
            } else {
                $status = "";
            }
            
            if (isset($options['folio']) && $options['folio'] != '') {
                $folio = " AND folio ='{$options['folio']}' ";
            } else {
                $folio = "";
            }
            
            if (isset($options['serie']) && $options['serie'] != '') {
                $serie = " AND serie ='{$options['serie']}' ";
            } else {
                $serie = "";
            }
            
            if (is_null($date)
            && is_null($vendorInvoice)
            && is_null($status)) {
                $limit = " LIMIT 300";
            }
        } else {
            $limit = " limit 300";
        }
        
        $query = "SELECT f.*,c.rfc,c.razon_social,
        fxGetUserName(f.creado_por) AS creado_por_nombre,
        fxGetUserName(f.ultima_mod_por) AS ultima_mod_por_nombre,
                IF(`status`= 1,DATE_FORMAT(f.creado_fecha,'%d/%m/%Y'),DATE_FORMAT(convert(substring(f.fecha_timbrado,1,10),date),'%d/%m/%Y'))as fecha, 
                fxGetStatusName(f.`status`,'NotaCredito')as statusName
                FROM notas_de_credito f
                LEFT JOIN notas_de_credito_detalles d ON f.id = d.id_factura
                LEFT JOIN clientes c ON f.id_cliente = c.id
                WHERE  1=1 
                $vendorInvoice
                $date
                $status 
                $folio
                $serie
                GROUP BY f.id 
                ORDER BY f.id DESC $limit ";

    
        $result = $this->query($query);
        
        if ($result->num_rows > 0) {
            return $this->resultToArray($result);
        }
        
        return null;
    }

    public function getListFacturaByCliente($options)
    {
        $idCliente =  $options['cliente'];

        $query = "SELECT f.*,
                fxGetClienteName(f.id_cliente)as clienteName,
                DATE_FORMAT(convert(substring(f.fecha_timbrado,1,10),date),'%d/%m/%Y')as fecha
                FROM notas_de_credito f
                LEFT JOIN notas_de_credito_detalles d ON f.id = d.id_factura
                WHERE  1=1
                AND status = '2'
                AND saldo_pendiente > '0'
                AND id_cliente = '$idCliente' "
              . "GROUP BY f.id "
              . "ORDER BY f.id ASC";

        $result = $this->query($query);

        if ($result->num_rows > 0) {
            return $this->resultToArray($result);
        }
        return null;
    }

    public function getListSelectMetodosPago()
    {
        $db_admin = new DBAdminEntityRepository();
        $query = "SELECT * FROM metodos_de_pago WHERE status = '1' ORDER BY id ASC";
        $result = $db_admin->query($query);

        if ($result->num_rows > 0) {
            $array = array();
            while ($row = $result->fetch_object()) {
                $array[$row->id] = $row->metodo;
            }
            return $array;
        }
        return null;
    }

    public function getListSelectFormasPago()
    {
        $db_admin = new DBAdminEntityRepository();
        $query = "SELECT * FROM formas_de_pago WHERE status = '1' ORDER BY id ASC";
        $result = $db_admin->query($query);

        if ($result->num_rows > 0) {
            $array = array();
            while ($row = $result->fetch_object()) {
                $array[$row->codigo] = $row->forma;
            }
            return $array;
        }

        return null;
    }

    

    public function getListTiposDeComprobante()
    {
        $db_admin = new DBAdminEntityRepository();
        $query = "SELECT * FROM tipos_de_comprobante WHERE status = '1' ORDER BY comprobante ASC";
        $result = $db_admin->query($query);

        if ($result->num_rows > 0) {
            $array = array();
            while ($row = $result->fetch_object()) {
                $array[$row->comprobante] = $row->comprobante;
            }

            return $array;
        }
        return null;
    }

    

    public function getListMoneda()
    {
        $db_admin = new DBAdminEntityRepository();
        $query = "SELECT * FROM monedas ORDER BY moneda ASC";

        $result = $db_admin->query($query);

        if ($result->num_rows > 0) {
            $array = array();
            while ($row = $result->fetch_object()) {
                $array[$row->moneda] = $row->moneda.' - '.$row->descripcion;
            }
            return $array;
        }
        return null;
    }

    

    public function getListTipoRelacion()
    {
        $db_admin = new DBAdminEntityRepository();
        $query = "SELECT * FROM sat_c_tiporelacion ORDER BY clave ASC";
        $result = $db_admin->query($query);

        if ($result->num_rows > 0) {
            $array = array();
            while ($row = $result->fetch_object()) {
                $array[$row->clave] = $row->descripcion;
            }
            return $array;
        }
        return null;
    }

    

    public function getListUsoCFDI()
    {
        $db_admin = new DBAdminEntityRepository();
        $query = "SELECT * FROM sat_c_usocfdi ORDER BY clave ASC";
        $result = $db_admin->query($query);

        if ($result->num_rows > 0) {
            $array = array();
            while ($row = $result->fetch_object()) {
                $array[$row->clave] = $row->descripcion;
            }
            return $array;
        }
        return null;
    }

    

    public function getListImpuestos()
    {
        $query = "SELECT * FROM impuestos ORDER BY id ASC";
        $result = $this->query($query);

        if ($result->num_rows > 0) {
            $impuestos = array();
            foreach ($this->resultToArray($result) as $impuesto) {
                $impuestos[$impuesto['id']] = $impuesto;
            }
            return $impuestos;
        }
        return null;
    }

    

    public function esRangoDeFacturacionValido($idSucursal, $total)
    {
        $query = "SELECT r.minimo,r.maximo,IF($total >= minimo AND $total <= maximo,'si','no')as rangoValido "
                . "FROM rangos_de_facturacion r, sucursales s "
                . "WHERE r.id = s.rango_de_facturacion "
                . "AND s.id = '$idSucursal' ";
        
        $result = $this->query($query);
        if ($result) {
            return $result = $result->fetch_object();
        }
    }

    public function getListUUIDByCliente($cliente = null)
    {
        $query = "SELECT CONCAT(serie,folio)as factura,uuid FROM facturas where id_cliente = '$cliente' AND status = 2 ORDER BY id ASC";

        $result = $this->query($query);

        if ($result->num_rows > 0) {
            $array = array();
            foreach ($this->resultToArray($result) as $row) {
                #$array[$row['uuid']] = $row['factura']." - ".$row['uuid'];
                $array[$row['uuid']] = $row['factura'];
            }
            return $array;
        }
        return null;
    }

    public function createFilterFecha($options, $campoFecha = null)
    {
        if (!isset($options['startDate']) && !isset($options['endDate'])) {
            return null;
        }
        $fechaInicio = $options['startDate'];
        $fechaFin = $options['endDate'];
        $fecha = null;
        $tools = new Tools();
        if ($fechaInicio!=null) {
            $fechaInicio = $tools->setFormatDateToDB($fechaInicio);
            if ($fechaFin!=null) {
                $fechaFin = $tools->setFormatDateToDB($fechaFin);
                $fecha .=" AND (convert(substring(fecha_timbrado,1,10),date) BETWEEN '{$fechaInicio}' AND '{$fechaFin}' ";
                $fecha .=" OR $campoFecha BETWEEN '{$fechaInicio}' AND '{$fechaFin}' ) ";
            } else {
                $fecha .=" AND (convert(substring(fecha_timbrado,1,10),date) BETWEEN '{$fechaInicio}' AND '{$fechaInicio}' ";
                $fecha .=" OR $campoFecha BETWEEN '{$fechaInicio}' AND '{$fechaInicio}') ";
            }
        } elseif ($fechaFin!=null) {
            $fecha .=" AND (convert(substring(fecha_timbrado,1,10),date) BETWEEN '{$fechaFin}' AND '{$fechaFin}' ";
            $fecha .=" OR $campoFecha BETWEEN '{$fechaFin}' AND '{$fechaFin}') ";
        }
        
        return $fecha;
    }
    
    //pudin
    public function updateEnviadoNC($idNC)
    {
        $query = "UPDATE notas_de_credito SET enviado = 1 WHERE id = '$idNC'";
        $result = $this->query($query);
    } ///////////////////////////
    
    public function getListStatus()
    {
        $query = "SELECT * FROM status_codigos WHERE operacion = 'NotaCredito'";
        $result = $this->query($query);
        
        if ($result->num_rows > 0) {
            $array = array();
            foreach ($result as $status) {
                $array[$status['id']] = $status['status'];
            }
            return $array;
        }
        return null;
    }
}
