<?php
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of PagoDetailsTempRepository
 *
 * @author VillaJu
 */
class PagoDetailsTempRepository extends EntityRepository
{
    private $table = 'pagos_detalle_';
    
    public function __construct()
    {
        $login = new Login();
        $this->table = $this->table.$login->getId();
    }
    
    public function truncate()
    {
        $query = "TRUNCATE TABLE " . $this->table;
        $result = $this->query($query);
        
        if ($result) {
            return true;
        }
        
        return null;
    }
    
    public function drop()
    {
        $query = "DROP TABLE " . $this->table;
        $result = $this->query($query);
        
        if ($result) {
            return true;
        }
        return null;
    }
    
    public function saveDetalles($idPago)
    {
        $query = "SELECT * FROM $this->table";
        $result = $this->query($query);
        if ($result->num_rows > 0) {
            $result = $this->resultToArray($result);
            
            foreach ($result as $data) {
                unset($data['id']);
                unset($data['id_detail']);
                $data['id_pago'] = $idPago;
                
                parent::save($data, 'pagos_detalle');
                $this->restarSaldoAFactura(array('monto'=>$data['monto'],'idFactura'=>$data['id_factura']));
            }
        }
        return true;
    }
    
    public function updateDetalles($idPago)
    {
        $query = "SELECT * FROM pagos_detalle WHERE id_pago = '$idPago'";
        $result = $this->query($query);
        $detallesOrigin = null;
        if ($result->num_rows > 0) {
            $detallesOriginTemp = $this->resultToArray($result);
            foreach ($detallesOriginTemp as $detalle) {
                $detallesOrigin[$detalle['id']] = $detalle;
            }
        }
        
        $query = "SELECT * FROM $this->table";
        $result = $this->query($query);
        
        if ($result->num_rows > 0) {
            $idsDetalles = array();
        
            $result = $this->resultToArray($result);
            foreach ($result as $data) {
                $idDetalle = $data['id_detail'];
                unset($data['id']);
                unset($data['id_detail']);
                $data['id_pago'] = $idPago;

                if (!$idDetalle) {
                    parent::save($data, 'pagos_detalle');
                    $this->restarSaldoAFactura(array('monto'=>$data['monto'],'idFactura'=>$data['id_factura']));
                } else {
                    #contiene los idDetalles de la compra original que se mantendran, lo que no esten aqui se eliminaran.
                    $idsDetalles[] = $idDetalle;
                    parent::update($idDetalle, $data, 'pagos_detalle');
                    
                    $pagoOrigin = $detallesOrigin[$idDetalle];
                    $this->updateRestarSaldoAFactura(array(
                        'monto_actual'=>$pagoOrigin['monto'],
                        'monto_nuevo'=>$data['monto'],
                        'idFactura'=>$data['id_factura']));
                }
            }
        }
        #Se eliminan ids de tabla comprasdetalls que ya no estan en $idsDetalles (este array contiene los ids que permanececieron en la compra despues del update)
        if ($detallesOrigin) {
            foreach ($detallesOrigin as $detalle) {
                if (!in_array($detalle['id'], $idsDetalles)) {
                    parent::delete($detalle['id'], 'pagos_detalle');
                    $this->agregarSaldoAFactura(array('monto'=>$detalle['monto'],'idFactura'=>$detalle['id_factura']));
                }
            }
        }
        return true;
    }
    
    public function getById($id, $table = null, $selectAux = null)
    {
        return parent::getById($id, $this->table, null);
    }
     

    
    public function delete($id, $table = null)
    {
        return parent::delete($id, $this->table);
    }
        
    public function updateSaldoPendiente($data)
    {
        $update = " UPDATE facturas SET saldo_pendiente = (%s) WHERE id = %s ";
        $update = sprintf($update, $data['saldoPendiente'], $data['idFactura']);
        return $this->query($update);
    }
    
    public function getSaldoPendienteFactura($id)
    {
        $query = "SELECT saldo_pendiente FROM facturas WHERE id = '$id'";
        $result = $this->query($query);
        
        if ($result->num_rows > 0) {
            $result = $result->fetch_object();
            return $result->saldo_pendiente;
        }
        return null;
    }
    
    public function agregarSaldoAFactura($data)
    {
        if ($data['monto']=='0') {
            return true;
        }
        
        $saldoPendiente = $this->getSaldoPendienteFactura($data['idFactura']);
        $saldoPendiente += $data['monto'];
        
        $this->updateSaldoPendiente(array(
            'idFactura'=>$data['idFactura'],
            'saldoPendiente'=>$saldoPendiente
        ));
    }
    
    public function restarSaldoAFactura($data)
    {
        if ($data['monto']=='0') {
            return true;
        }
        
        $saldoPendiente = $this->getSaldoPendienteFactura($data['idFactura']);
        $saldoPendiente -= $data['monto'];
        
        $this->updateSaldoPendiente(array(
            'idFactura'=>$data['idFactura'],
            'saldoPendiente'=>$saldoPendiente
        ));
    }
    
    public function updateRestarSaldoFactura($data)
    {
        $montoActual = $data['monto_actual'];
        $montoNuevo = $data['monto_nuevo'];
       
        $diff = $montoNuevo - $montoActual;
        
        if ($diff > 0) {
            $data['monto'] = $diff;
            return $this->agregarSaldoAFactura($data);
        } elseif ($diff < 0) {
            $data['monto'] = abs($diff);
            return $this->restarSaldoAFactura($data);
        }
        
        return true;
    }
}
