<?php
class PagoRepository extends EntityRepository
{
    private $table = 'pagos';
    public $flashmessenger = null;

    public function __construct()
    {
        if (!$this->flashmessenger instanceof FlashMessenger) {
            $this->flashmessenger = new FlashMessenger();
        }
    }

    private $options = array(
        'tipo_documento' => 'P',
        'serie' => null,
        'folio' => null,
        'uso_cfdi' => 'P01',
        'fecha' => null,
        'cliente' => null,
        'cuenta_bancaria' => null,
        'cuenta_bancaria_ordenante'=>null,
        'forma_de_pago' => null,
        'num_operacion' => null,
        'monto' => null,
        'moneda' => null,
        'tipo_de_cambio' => null,
        'notas' => null,
        'datos_comprobante' => null,
        'datos_emisor' => null,
        'datos_receptor' => null,
        'datos_conceptos' => null,
        'uuid' => null,
        'certificado_sat' => null,
        'fecha_timbrado' => null,
        'sello_sat' => null,
        'cadena_original_sat' => null,
        'sello_cfdi' => null,
        'status' => null,
        'version_cfdi' => null
    //    'cuenta_bancaria_ordenante' => null
    );
    private $options_aux = array(
        'sucursal'=>null,
        'comprobanteName' => null,
        'formaName' => null,
        'metodoName' => null,
        'monedaName' => null,
        'usoCFDIName' => null,
        'email' => null,
        'email2' => null, //pudin
        'cuentaName' => null
    );

    private $options_files = [
        'allowed_extensions' => ['pdf', 'jpg', 'png'],
        'max_file_size' => 1000000,
        'path_to_save'=>PATH_PAGOS_FACTURAS,
    ];

    public function formaDePagoRequiereBanco($formaPago)
    {
        $formaDePagoBancosNoRequerido = array(
            '01'=>'Efectivo'
        );

        if (key_exists($formaPago, $formaDePagoBancosNoRequerido)) {
            return false;
        }
        return true;
    }

    public function setOptions($data)
    {
        foreach ($this->options as $option => $value) {
            if (isset($data[$option])) {
                $this->options[$option] = $data[$option];
            }
        }

        foreach ($this->options_aux as $option => $value) {
            if (isset($data[$option])) {
                $this->options_aux[$option] = $data[$option];
            }
        }
    }

    public function getOptions()
    {
        return $this->options;
    }

    public function getClienteEmail()
    {
        return $this->options_aux['email'];
    }

    //pudin
    public function getClienteEmail2()
    {
        return $this->options_aux['email2'];
    }
    /////
    public function getTipoComprobanteNombre()
    {
        return $this->options_aux['comprobanteName'];
    }

    public function getFormaDePagoNombre()
    {
        return $this->options_aux['formaName'];
    }

    public function getMetodoNombre()
    {
        return $this->options_aux['metodoName'];
    }

    public function getUsoCFDINombre()
    {
        return $this->options_aux['usoCFDIName'];
    }

    public function getMonedaNombre()
    {
        return $this->options_aux['monedaName'];
    }

    public function getTipoComprobante()
    {
        return $this->options['tipo_documento'];
    }

    public function getFechaPago()
    {
        // $fecha = substr($this->getFecha(), 0, 10);
        //   $fecha = strftime('%d/%m/%Y',$fecha);

        $fecha = $this->getFecha();
        $hora = substr($this->getFecha(), 11, 8);

        return $fecha . " " . '12:00:00';
    }

    public function getFechaTimbrado()
    {
        return $this->options['fecha_timbrado'];
    }

    public function getUsoCFDI()
    {
        return $this->options['uso_cfdi'];
    }

    public function getMonto()
    {
        return $this->options['monto'];
    }

    public function getMoneda()
    {
        return $this->options['moneda'];
    }

    public function getTipo_de_cambio()
    {
        return $this->options['tipo_de_cambio'];
    }

    public function getCliente()
    {
        return $this->options['cliente'];
    }

    public function getFormaDePago()
    {
        return $this->options['forma_de_pago'];
    }

    public function getNumOperacion()
    {
        return $this->options['num_operacion'];
    }

    public function getFecha()
    {
        return $this->options['fecha'];
    }

    public function getStatus()
    {
        return $this->options['status'];
    }

    public function getSerie()
    {
        return $this->options['serie'];
    }

    public function getFolio()
    {
        return str_pad($this->options['folio'], 5, "0", STR_PAD_LEFT);
    }

    public function getNumPago()
    {
        $numPago = '';
        if (trim($this->getSerie()) != '') {
            $numPago .= $this->getSerie() . "-";
        }

        return $numPago .= $this->getFolio();
    }

    public function getSucursal()
    {
        return $this->options_aux['sucursal'];
    }

    public function getDataBanco()
    {
        $cuentaBancariaRepo = new CuentaBancariaRepository();
        $dataBanco = $cuentaBancariaRepo->getDataBancoByIdCuentaBancaria($this->options['cuenta_bancaria']);

        return $dataBanco;
    }

    public function getDataCuentaBancaria()
    {
        $cuentaBancariaRepo = new CuentaBancariaRepository();
        $dataCuentaBancaria = $cuentaBancariaRepo->getById($this->options['cuenta_bancaria']);

        return $dataCuentaBancaria;
    }

    public function getDataBancoOrdenante()
    {
        $cuentaBancariaRepo = new ClienteRepository();
        $dataBanco = $cuentaBancariaRepo->getDataBancoByIdCuentaBancariaSat($this->options['cuenta_bancaria_ordenante']);

        return $dataBanco;
    }

    public function getDataCuentaBancariaOrdenante()
    {
        $cuentaBancariaRepo = new ClienteRepository();
        $dataCuentaBancaria = $cuentaBancariaRepo->getCuentasBancariasById($this->options['cuenta_bancaria_ordenante']);

        return $dataCuentaBancaria;
    }

    public function getDatosComprobante()
    {
        return unserialize($this->options['datos_comprobante']);
    }

    public function getDatosReceptor()
    {
        return unserialize($this->options['datos_receptor']);
    }

    public function getConceptos()
    {
        return unserialize($this->options['datos_conceptos']);
    }

    public function getUUID()
    {
        return $this->options['uuid'];
    }

    public function getSelloCFDI()
    {
        return $this->options['sello_cfdi'];
    }

    public function getSelloSAT()
    {
        return $this->options['sello_sat'];
    }

    public function getCadenaOriginalSAT()
    {
        return $this->options['cadena_original_sat'];
    }

    public function getNumCertificadoSAT()
    {
        return $this->options['certificado_sat'];
    }

    public function getComentarios()
    {
        return $this->options['notas'];
    }

    public function getTable()
    {
        return $this->table;
    }

    public function getTotalParaCodigoQR()
    {
        @list($entero,$decimal) = explode('.', $this->getMonto());
        $entero = str_pad($entero, 10, "0", STR_PAD_LEFT);
        $decimal = str_pad(empty($decimal) ? "0":$decimal, 6, "0", STR_PAD_RIGHT);
        return $entero . "." . $decimal;
    }

    public function getMontoLetra($monto = null)
    {
        $numLetra = new NumeroALetra();
        $numLetra->setPrefijo('');
        $numLetra->setSufijo('');
        $numLetra->setMoneda('');

        if ($monto === null) {
            $monto = $this->options['monto'];
        }

        $numLetra->setNumero($monto);

        return $numLetra->letra();
    }

    //Obtiene saldo despues del pago con id = $id

    public function getBalanceDue($idCompra = null, $fecha = null)
    {
        if ($idCompra == null) {
            $idCompra = $this->options['compra'];
        }

        if ($fecha == null) {
            $fecha = $this->options['fecha'];
        }

        return parent::getBalanceDue($idCompra, $fecha);
    }

    public function getDataToEdit($id)
    {
        $query = "SELECT p.*,"
                . "p.cliente,"
                . "p.tipo_de_cambio,"
                . "DATE_FORMAT(convert(substring(p.fecha,1,10),date),'%m/%d/%Y') as fechaPago,"
                . "p.serie as serie_pago,"
                . "p.folio as folio_pago,"
                . "fxGetClienteName(p.cliente)as clienteName,"
                . "f.id as idFactura,"
                . "f.serie as serie,"
                . "f.folio as folio,"
                . "DATE_FORMAT(convert(substring(f.fecha_timbrado,1,10),date),'%m/%d/%Y')as fecha,"
                . "f.total as montoFactura,"
                . "d.monto as montoPago,"
                . "f.saldo_pendiente as saldoPendiente "
                . "FROM pagos p,pagos_detalle d,facturas f "
                . "WHERE p.id = d.id_pago "
                . "AND d.id_factura =  f.id "
                . "AND p.id = '$id'";

        $result = $this->query($query);

        if ($result->num_rows > 0) {
            $result = $this->resultToArray($result);

            $arrayTemp = array();
            $arrayTemp['fecha'] = $result[0]['fechaPago'];
            $arrayTemp['cliente'] = $result[0]['cliente'];
            $arrayTemp['forma_de_pago'] = $result[0]['forma_de_pago'];
            $arrayTemp['cuenta_bancaria'] = $result[0]['cuenta_bancaria'];
            $arrayTemp['cuenta_bancaria_ordenante'] = $result[0]['cuenta_bancaria_ordenante'];
            $arrayTemp['num_operacion'] = $result[0]['num_operacion'];
            $arrayTemp['monto'] = $result[0]['monto'];
            $arrayTemp['moneda'] = $result[0]['moneda'];
            $arrayTemp['tipo_de_cambio'] = $result[0]['tipo_de_cambio'];
            $arrayTemp['notas'] = $result[0]['notas'];
            $arrayTemp['status'] = $result[0]['status'];
            $arrayTemp['serie'] = $result[0]['serie_pago'];
            $arrayTemp['folio'] = $result[0]['folio_pago'];

            $facturasLiquidadas = array();
            foreach ($result as $pago) {
                $pagos[$pago['idFactura']] = $pago['montoPago'];
                $pagosOriginales[$pago['idFactura']] = $pago;

                if ($pago['saldoPendiente'] <= 0) {
                    $pago['saldoPendiente'] += $pago['montoPago'];
                    $facturasLiquidadas[$pago['idFactura']] = $pago;
                }
            }

            $arrayTemp['pago'] = $pagos;

            return array(
                'data' => $arrayTemp,
                'facturasLiquidadas' => $facturasLiquidadas,
                'pagosOriginales' => $pagosOriginales);
        }
    }

    public function getIdCliente()
    {
        return $this->options['id_cliente'];
    }

    public function crearPDF()
    {
        $pdf = new PagoPDF($this->getId(), true);
        $this->pagoPDF = $pdf->getPathFileCreated();
    }

    public function crearZip()
    {
        $zipfile = new zipfile();
        $this->archivoZip = "Pago-" . $this->getNumPago() . ".zip";

        $empresa = new EmpresaRepository();
        $empresa->setOptions($empresa->getById(1));

        $zipfile->add_file(implode("", file($this->pagoPDF)), $this->getNumPago() . ".pdf");
        $zipfile->add_file(implode("", file(PATH_SAT_DOCS . "/1/Pagos/Pago-" . $this->getNumPago() . ".xml")), $this->getNumPago() . ".xml");

        $fd = fopen(PATH_SAT_DOCS . "/1/Pagos/temp-pdf/" . $this->archivoZip, "wb");
        $out = fwrite($fd, $zipfile->file());
        fclose($fd);

        return PATH_SAT_DOCS . "/1/Pagos/temp-pdf/" . $this->archivoZip;
    }

    public function descargarZip()
    {
        $file = $this->crearZip();
        $fileName = $this->getRutaArchivoZip();
        header("Content-type: application/octet-stream");
        header("Content-disposition: attachment; filename=$fileName");
        // leemos el archivo creado
        readfile($file);
    }

    public function getRutaArchivoZip()
    {
        return $this->archivoZip;
    }

    public function _getTranslation($text)
    {
        return $this->flashmessenger->_getTranslation($text);
    }

    public function delete($id, $table = null)
    {
        $data = $this->getById($id);
        $this->startTransaction();

        try {

            #status = 1 (Sin Timbrar)
            #Se elimina de la BD
            if ($data['status'] == '1') {
                if (!parent::delete($id, $this->table)) {
                    throw new Exception('Opps !!. Algo salio mal al intentar eliminar el Pago.<br/>Intente nuevamente.');
                }

                $facturaEntity = new FacturaRepository();
                $detalles = $this->getDetallesByIdPago($id);
                if ($detalles) {
                    foreach ($detalles as $detalle) {
                        if (!$this->query("DELETE FROM pagos_detalle WHERE id = '{$detalle['id']}'")) {
                            throw new Exception('No se puede eliminar el detalle del pago en la base de datos');
                        }

                        if (!$facturaEntity->setSaldoPendiente($detalle['id_factura'])) {
                            throw new Exception("No se puede actualizar el saldo pendiente en la factura");
                        }
                    }
                }

                $this->flashmessenger->addMessage(array('success' => $this->_getTranslation('Genial !!. El pago fue eliminado correctamente.')));
                $this->commit();
                return true;

                # Si no es status = 1, es status = 2 (Timbrada); entonces debe ser cancelada Electronicamente y ponerla con status = 3 (Cancelada)
                # Metodo para cancelar electronicamente factura.
            } elseif($data['status'] == 2) {
                if (!parent::update($id, array('status' => '3'), $this->table)) {
                    throw new Exception('Opps !!. Algo salio mal al intentar cancelar el Pago.<br/>Intente nuevamente.');
                }

                $facturaEntity = new FacturaRepository();
                $detalles = $this->getDetallesByIdPago($id);
                if ($detalles) {
                    foreach ($detalles as $detalle) {
                        if (!$facturaEntity->setSaldoPendiente($detalle['id_factura'])) {
                            throw new Exception("No se puede actualizar el saldo pendiente en la factura");
                        }
                    }
                }

                $pagoTimbrar = new PagoTimbrarRepository($id);
                if (!$pagoTimbrar->_cancelar()) {
                    throw new Exception('Lo sentimos. Hubo un error al intentar cancelar el Pago en el SAT. Intente nuevamente');
                }

                $this->flashmessenger->addMessage(array('success' => $this->_getTranslation('Genial !!. El pago fue cancelado correctamente.')));
                $this->commit();
                return false;
            }
        } catch (Exception $ex) {
            $this->rollback();

            throw $ex;
        }
    }


    public function getById($id, $table = null, $selectAux = null)
    {
        $select = "SELECT p.*,c.email,c.email2,"
                . "DATE_FORMAT(convert(substring(p.fecha,1,10),date),'%d/%m/%Y')as fecha,"
                . "fxGetClienteName(p.cliente)as clienteName, "
                . "DATE_FORMAT(convert(substring(p.fecha_timbrado,1,10),date),'%d/%m/%Y')as fechaT,"
                . "fxGetTipoDeComprobanteName(p.tipo_documento)as comprobanteName, "
                . "fxGetFormaDePagoName(p.forma_de_pago)as formaName, "
                . "fxGetMetodoDePagoName(p.metodo_de_pago)as metodoName, "
                . "fxGetMonedaName(p.moneda)as monedaName, "
                . "fxGetUsoCFDIName(p.uso_cfdi)as usoCFDIName, "
                . "fxGetStatusName(p.status,'Factura')as statusName, "
                . "fxGetUserName(p.creado_por) as userName "
                . "FROM $this->table p join clientes as c  "
                . "WHERE p.id = '$id' and c.id = p.cliente ";

        $result = $this->query($select);

        if ($result->num_rows>0) {
            $set = $this->resultToArray($result);
            return $set[0];
        }
        return false;
    }

    public function isUsedInRecord($id, array $buscarEn = null, $andWhere= null)
    {
        return true;
        #return parent::isUsedInRecord($id, array('facturas'=>'shipFrom'),"AND tipo = 'Inbound'");
    }

    public function save(array $data, $table = null)
    {
        $facturas = $data['pago'];
        $adjuntos = $data['adjuntos'];
        unset($data['pago'], $data['adjuntos']);

        $tools = new Tools();
        $data['status'] = '1';
        $data['fecha'] = $tools->setFormatDateToDB($data['fecha']);

        $this->startTransaction();
        $result = parent::save($data, $this->table);
        if ($result) {
            $idPago = $this->getInsertId();
            $this->setLastInsertId($idPago);
            $facturaEntity = new FacturaRepository();

            foreach ($facturas as $idFactura => $monto) {
                $ImpSaldoInsoluto = 0;
                $facturaEntity->setOptions($facturaEntity->getById($idFactura));
                $saldoPendiente = $facturaEntity->getSaldoPendiente();

                if ($monto > 0 && trim($monto!= '') && $monto !== null) {
                    $ImpSaldoInsoluto = $saldoPendiente - $monto;
                    $numParcialidad = 0;
                    if ($facturaEntity->getMetodoDePago() === 'PPD') {
                        $numParcialidad = $facturaEntity->getNextNumParcialidad($idFactura);
                    }

                    $details = array(
                          'id_pago'=>$idPago,
                          'id_factura'=>$idFactura,
                          'monto'=>$monto,
                          'num_parcialidad'=>$numParcialidad,
                          'importe_saldo_anterior'=>$saldoPendiente,
                          'importe_saldo_insoluto' => $ImpSaldoInsoluto);

                    if ($facturaEntity->getMetodoDePago() !== 'PPD' && isset($details['num_parcialidad'])) {
                        unset($details['num_parcialidad']);
                    }

                    $result = parent::save($details, 'pagos_detalle');

                    // parent::save sets the lastInsertId property and if you use a differnt the value will be incorrect
                    // need this to force it
                    $this->setLastInsertId($idPago);

                    if ($result) {
                        if (!$facturaEntity->setSaldoPendiente($idFactura)) {
                            $this->rollback();
                            $this->flashmessenger->addMessage(array('danger'=>'Error. Intenta nuevamente o contacta a tu proveedor de sistemas.'));
                            return null;
                        }
                    } else {
                        $this->flashmessenger->addMessage(array('danger'=>'Error. Intenta nuevamente o contacta a tu proveedor de sistemas.'));
                        $this->rollback();
                        return null;
                    }
                }
            }
        }
        $this->setLastInsertId($idPago);
        $this->commit();

        if($adjuntos !== null && !empty($adjuntos['name'][0])) {
            $upload = new UploadFile();
            $upload->setAllowedExtensions($this->options_files['allowed_extensions']);
            $upload->setMaxFileSizeAllowed($this->options_files['max_file_size']);
            $upload->setTempFolder($this->options_files['path_to_save']);

            if (!$upload->uploadMultipleFile($adjuntos, $this->getLastInsertId()))  {
                $this->flashmessenger->addMessage(array('warning'=>'El pago fue guardado con exito, sin embargo, los archivos no fueron guardados. Intente nuevamente o consulte con su administrador.'));
            }
        }
        return true;
    }

    public function updateMultiple($id, $data)
    {
        $facturas = $data['pago'];
        $adjuntos = $data['adjuntos'];
        unset($data['pago'], $data['adjuntos']);

        $tools = new Tools();
        $data['fecha'] = $tools->setFormatDateToDB($data['fecha']);

        $this->startTransaction();
        $result = parent::update($id, $data, $this->table);

        if ($result) {
            $facturaEntity = new FacturaRepository();
            $arrayIdsPagos = array();
            foreach ($facturas as $idFactura => $monto) {
                if ($monto > 0 && trim($monto!= '') && $monto !== null) {
                    //$idFactura[1] contiene el id de Pago
                    //Si existe $idFactura[1], significa que ya existe un pago con ese id y solo debe actualizarse
                    //Sino existe, debe agregarse.
                    if ($this->existePago($id, $idFactura)) {
                        #Se actualiza Pago
                        $result = parent::updateString(array('monto'=>$monto), " id_pago = '$id' AND id_factura = '$idFactura' ", 'pagos_detalle');
                        $arrayIdsPagos[] = $idFactura;
                        $facturaEntity->setSaldoPendiente($idFactura);
                    } else {
                        #Se inserta Pago
                        $ImpSaldoInsoluto = 0;
                        $facturaEntity->setOptions($facturaEntity->getById($idFactura));
                        $saldoPendiente = $facturaEntity->getSaldoPendiente();
                        $ImpSaldoInsoluto = $saldoPendiente - $monto;
                        if ($facturaEntity->getMetodoDePago() === 'PPD') {
                            $numParcialidad = $facturaEntity->getNextNumParcialidad($idFactura);
                        }

                        $details = array(
                                'id_pago'=>$id,
                                'id_factura'=>$idFactura,
                                'monto'=>$monto,
                                'num_parcialidad'=>$numParcialidad,
                                'importe_saldo_anterior'=>$saldoPendiente,
                                'importe_saldo_insoluto' => $ImpSaldoInsoluto);

                        if ($facturaEntity->getMetodoDePago() !== 'PPD') {
                            unset($details['num_parcialidad']);
                        }

                        $result = parent::save($details, 'pagos_detalle');
                    }

                    if ($result === null) {
                        $this->flashmessenger->addMessage(array('danger'=>'Error. Intenta nuevamente o contacta a tu proveedor de sistemas.'));
                        $this->rollback();
                        return null;
                    }
                }
            }


            foreach ($_SESSION['pagosOriginales'] as $pago) {
                if (!in_array($pago['idFactura'], $arrayIdsPagos)) {
                    $this->query("DELETE FROM pagos_detalle WHERE id_pago = '$id' AND id_factura = '{$pago['idFactura']}'");
                    $facturaEntity->setSaldoPendiente($pago['idFactura']);
                }
            }

            $this->commit();

            if($adjuntos !== null && !empty($adjuntos['name'][0])) {
                $upload = new UploadFile();
                $upload->setAllowedExtensions($this->options_files['allowed_extensions']);
                $upload->setMaxFileSizeAllowed($this->options_files['max_file_size']);
                $upload->setTempFolder($this->options_files['path_to_save']);

                if (!$upload->uploadMultipleFile($adjuntos, $id))  {
                    $this->flashmessenger->addMessage(array('warning'=>'El pago fue actualizado con exito, sin embargo, los archivos no fueron guardados. Intente nuevamente o consulte con su administrador.'));
                }
            }


            return true;
        }
        return null;
    }

    public function updateString($fields, $where, $table = null)
    {
        return parent::updateString($fields, $where, $this->table);
    }

    public function existePago($idPago, $idFactura)
    {
        $query = "SELECT * "
                . "FROM pagos p, pagos_detalle d "
                . "WHERE p.id = d.id_pago "
                . "AND p.status != 3 "
                . "AND id_pago = $idPago "
                . "AND id_factura = $idFactura";

        $result = $this->query($query);

        if ($result->num_rows > 0) {
            return true;
        }
        return null;
    }



    public function getDetallesByIdPago($idPago)
    {
        $query = "SELECT p.*,f.uuid,f.serie,f.folio,f.moneda,f.metodo_de_pago,f.tipo_de_cambio "
                . "FROM pagos_detalle p,facturas f "
                . "WHERE id_pago = '$idPago' "
                . "AND f.id = p.id_factura";

        $result = $this->query($query);
        if ($result->num_rows > 0) {
            return $this->resultToArray($result);
        }

        return null;
    }

    public function getListPagos($options = null)
    {
        $vendorInvoice = null;
        $status = null;
        $limit = null;
        $date = null;
        $folio = null;
        $serie = null;
        $factura = null;

        if (is_array($options) && count($options) > 0) {
            $date = $this->createFilterFecha($options, 'p.fecha');

            if (isset($options['cliente'])) {
                if (is_array($options['cliente']) && count($options['cliente']) > 0) {
                    $customerIds = implode(',', $options['cliente']);
                    $vendorInvoice = " AND find_in_set(p.cliente,'{$customerIds}')";
                } else {
                    if (trim($options['cliente'])!= '') {
                        $vendorInvoice = " AND find_in_set(p.cliente,'{$options['cliente']}')";
                    }
                }
            }

            if (isset($options['status']) && $options['status'] != '') {
                $status = " AND p.status ='{$options['status']}'";
            } else {
                $status = "";
            }

            if (isset($options['folio']) && $options['folio'] != '') {
                $folio = " AND p.folio ='{$options['folio']}' ";
            } else {
                $folio = "";
            }

            if (isset($options['serie']) && $options['serie'] != '') {
                $serie = " AND p.serie ='{$options['serie']}' ";
            } else {
                $serie = "";
            }

            $factura = "";
            if (isset($options['factura_id']) && !empty($options['factura_id'])) {
                $factura = " AND f.id = {$options['factura_id']} ";
            }

            if (is_null($date)
            && is_null($vendorInvoice)
            && is_null($status)) {
                $limit = " LIMIT 300";
            }
        } else {
            $limit = " limit 300";
        }

        $query = "SELECT
                p.id,
                DATE_FORMAT(p.fecha,'%d/%m/%Y')as fecha,
                p.serie,
                p.folio,
                p.tipo_de_cambio,
                p.datos_emisor,
                p.datos_receptor,
                p.sello_sat,
                p.uuid,
                GROUP_CONCAT(f.serie,f.folio)as factura,
                fxGetClienteName(p.cliente) as clienteName,
                p.num_operacion,
                p.monto as monto,
                fxGetFormaDePagoName(p.forma_de_pago)as formaPago,
                fxGetStatusName(p.status,'pago')as statusName,
                p.status,
                p.enviado,
                fxGetUserName(p.creado_por) AS creado_por_nombre,
                p.creado_fecha,
                p.fecha_timbrado,
                fxGetUserName(p.ultima_mod_por) as ultima_mod_por_nombre,
                p.ultima_mod_fecha
                FROM pagos p, pagos_detalle d, facturas f
                WHERE 1=1
                AND p.id = d.id_pago
                AND d.id_factura = f.id
                $vendorInvoice
                $date
                $status
                $folio
                $serie
                $factura
                GROUP BY p.id
                ORDER BY p.fecha DESC $limit";

        # var_dump($options);exit;
        $result = $this->query($query);

        if ($result->num_rows > 0) {
            return $this->resultToArray($result);
        }
        return null;
    }

    public function createFilterFecha($options, $campoFecha = null)
    {
        $fechaInicio = isset($options['startDate']) ? $options['startDate']:null;
        $fechaFin = isset($options['endDate']) ? $options['endDate']:null;
        $fecha = null;
        $tools = new Tools();

        if ($fechaInicio!=null) {
            $fechaInicio = $tools->setFormatDateToDB($fechaInicio);
            if ($fechaFin!=null) {
                $fechaFin = $tools->setFormatDateToDB($fechaFin);
                $fecha .=" AND $campoFecha BETWEEN '{$fechaInicio}' AND '{$fechaFin}' ";
            } else {
                $fecha .=" AND $campoFecha BETWEEN '{$fechaInicio}' AND '{$fechaInicio}' ";
            }
        } elseif ($fechaFin!=null) {
            $fecha .=" AND $campoFecha BETWEEN '{$fechaFin}' AND '{$fechaFin}' ";
        }

        return $fecha;
    }


    public function getPagosByIdFactura($id_factura)
    {
        $select = "SELECT p.*,d.monto, "
                . "fxGetClienteName(cliente)as clienteName,"
                . "IF(status = 2,DATE_FORMAT(convert(substring(fecha_timbrado,1,10),date),'%d/%m/%Y'),DATE_FORMAT(fecha,'%d/%m/%Y'))as fecha,"
                . "fxGetTipoDeComprobanteName(tipo_documento)as comprobanteName, "
                . "fxGetFormaDePagoName(forma_de_pago)as formaName, "
                . "fxGetMetodoDePagoName(metodo_de_pago)as metodoName, "
                . "fxGetMonedaName(moneda)as monedaName, "
                . "fxGetUsoCFDIName(uso_cfdi)as usoCFDIName, "
                . "fxGetStatusName(status,'Pago')as statusName, "
                . "fxGetUserName(p.creado_por) as userName "
                . "FROM $this->table p, pagos_detalle d "
                . "WHERE p.id = d.id_pago and d.id_factura = '$id_factura'";

        $result = $this->query($select);

        if ($result->num_rows>0) {
            return $this->resultToArray($result);
        }
        return false;
    }

    //pudin
    public function updateEnviadoPago($idPago)
    {
        $query = "UPDATE pagos SET enviado = 1 WHERE id = '$idPago'";
        $result = $this->query($query);
    } ///////////////////////////

    public function getListStatus()
    {
        $query = "SELECT * FROM status_codigos WHERE operacion = 'Pago'";
        $result = $this->query($query);

        if ($result->num_rows > 0) {
            $array = array();
            foreach ($result as $status) {
                $array[$status['id']] = $status['status'];
            }
            return $array;
        }
        return null;
    }

    public static function hasAttachments($id) {
        $pattern = PATH_PAGOS_FACTURAS . "$id+___+*";

        $matches = glob($pattern);

        return count($matches) > 0;
    }

    public static function getAttachmentsHmtlList($id) {
        $pattern = PATH_PAGOS_FACTURAS . "$id+___+*";
        $matches = glob($pattern);

        $html = "<ul class=\"list-group list-group-horizontal col-md-offset-3 col-md-6 \">";
        foreach($matches as $file) {
            $link = str_replace(ROOT, '', $file);
            list(,$name,) = explode('+___+', $file);
            $html .= "<li class=\"list-group-item\">";
            $html .= "  <button type=\"button\"";
            $html .= "          class=\"delete-file btn btn-danger btn-sm\"";
            $html .= "          data-filename=\"{$link}\"";
            $html .= "          data-fileusername=\"{$name}\">";
            $html .= "    <i class=\"fa fa-trash-o\"></i>";
            $html .= "  </button>";
            $html .= "  <a target=\"a\" href=\"{$link}\">{$name}</a>";
            $html .= "</li>";
        }
        $html .= "</ul>";

        return $html;
    }
}
