<?php
/**
 * Description of PagoEntity
 *
 * @author carlos
 */
class PagoTimbrarRepository Extends EntityRepository{
    public $flashmessenger = null;
    private $rutaParaGuardarXML = PATH_SAT_DOCS;
    private $conexionServicioTimbrado = null;
    private $archivoKeyPem = 'keyPem.key.pem';

    private $idPago = null;
    private $serie = null;
    private $folio = null;
    private $comprobante = null;
    private $emisor = null;
    private $expedidoEn = null;
    private $receptor = null;

    private $datosComprobante = array();
    private $datosComplemento = array();
    private $datosEmisor = array();
    private $datosReceptor = array();
    private $datosConceptos = array();

    private $datosDefaultComprobante = array(
        'version'=>'3.3',
        'subTotal'=>'0',
        'total'=>'0',
        'moneda'=>'XXX',
        'UsoCFDI'=>'P01',
        'sello'=>null
    );

    #Datos para conexion a servicio de timbrado.
    private $datosTimbrar = array();

    public function __construct($idPago) {
        if(!$this->flashmessenger instanceof FlashMessenger){
            $this->flashmessenger = new FlashMessenger();
        }

         $this->idPago = $idPago;
    }

    public function _timbrar(){
        try {
            $this->setDatosTimbrado();
            $this->setOptions();
            $this->prepararDatosComprobante();
            $this->prepararDatosComplemento();
            $this->prepararDatosEmisor();
            $this->prepararDatosReceptor();
            $this->prepararConceptos();

            $this->crearXML();
            $this->timbrar();
            $this->guardarPago();

            $this->flashmessenger->addMessage(array('success'=>'Genial!! su Pago se ha timbrado con exito.'));
            return true;

        } catch (Exception $exc) {
            $this->flashmessenger->addMessage(array('danger'=>$exc->getMessage()));
            return null;
        }
    }

    public function _cancelar(){
        try {
            $this->setOptions();
            $this->cancelar();

            $this->comprobante->update($this->getIdPago(),["status" => 3],'pagos');

            $this->flashmessenger->addMessage(array('success'=>"Genial!! Su solicitud de cancelacion ha sido enviada al SAT. Para dar seguimiento favor de visitar la <a href='https://www.sat.gob.mx/home' target='_sat'>pagina del sat</a>"));
            return true;

        } catch (Exception $exc) {
            $this->flashmessenger->addMessage(array('danger'=>$exc->getMessage()));
            return null;
        }
    }

    public function setOptions(){
        $pago = new PagoRepository();
        $pago->setOptions($pago->getById($this->getIdPago()));
        $this->comprobante = $pago;
        $this->folio = $this->comprobante->getFolio();
        $this->serie = $this->comprobante->getSerie();

        $receptor = new ClienteRepository();
        $this->receptor = $receptor->getById($this->comprobante->getCliente());

        $emisor = new EmpresaRepository();
        $this->emisor = $emisor->getById(1);

        $expedidoEn = new SucursalRepository();
        //$this->expedidoEn = $expedidoEn->getById($pago->getSucursal());
        $this->expedidoEn = $expedidoEn->getById(1);
    }

    public function setDatosTimbrado(){
        $settings = new SettingsRepository();
        $tipoConexion = 'production_'; # PRODUCTION
        #$tipoConexion = 'demo_'; # DEMO

        $this->datosTimbrar = array(
        'serverURL'=>$settings->_get($tipoConexion.'timbrado_serverURL'),
        'serverScript'=>$settings->_get('timbrado_serverScript'),
        'metodoALlamar'=>$settings->_get('timbrado_metodoALlamar'),
        'timbraRequest'=>array(
            'timbraRequest'=>array(
                'Usuario'=>$settings->_get($tipoConexion.'timbrado_usuario'),
                'Password'=>$settings->_get($tipoConexion.'timbrado_contrasena'),
                'XML'=>null)
        ));
    }

    public function prepararDatosComprobante(){
        date_default_timezone_set("Mexico/General");
        $this->setSerieFolio();

        $this->datosComprobante = array(
            'Version'=>$this->datosDefaultComprobante['version'],
            'Serie'=>$this->serie,
            'Folio'=>$this->folio,
            'Fecha'=>date("Y-m-d")."T".date("H:i:s", (strtotime ("-2 minute"))),
            #'FormaPago'=>$this->comprobante->getFormaDePago(),
            'NoCertificado'=>$this->getNoCertificado(),
            'SubTotal'=>$this->datosDefaultComprobante['subTotal'],
            'Moneda'=>$this->datosDefaultComprobante['moneda'],
            #'TipoCambio'=>$this->comprobante->getTipoDeCambio(),#Agregar campo para capturar este tipo
            'Total'=>$this->datosDefaultComprobante['total'],
            'TipoDeComprobante'=>$this->comprobante->getTipoComprobante(),
            //'MetodoPago'=>$this->comprobante->getMetodoDePago(),
            'LugarExpedicion'=>$this->emisor['codigo_postal'],
            'Sello'=>$this->datosDefaultComprobante['sello'],
            'Certificado'=>$this->getCertificado(),
        );
    }

    public function prepararDatosComplemento(){
        $documentos = array();
        foreach($this->comprobante->getDetallesByIdPago($this->getIdPago()) as $factura){
            $documento = array(
                'IdDocumento'=>$factura['uuid'],
                'MonedaDR'=>$factura['moneda'],
                'MetodoDePagoDR'=>$factura['metodo_de_pago'],
                'Serie'=>$factura['serie'],
                'Folio'=>$factura['folio'],
                'NumParcialidad'=> $factura['num_parcialidad'],
                'ImpSaldoAnt'=>number_format($factura['importe_saldo_anterior'],2,'.',''),
                'ImpPagado'=>number_format($factura['monto'],2, '.', ''),
                'ImpSaldoInsoluto'=> number_format( $factura['importe_saldo_insoluto'],2,'.','')
            );
            $documentos[] = $documento;
        }

        $this->datosComplemento['pago'] = array(
            'FechaPago'=>$this->datosComprobante['Fecha'], #Obtengo fecha que se seteo en datos comprobante (function prepararDatosComprobante)
            'FormaDePagoP'=>$this->comprobante->getFormaDePago(),
            'MonedaP'=>$this->comprobante->getMoneda(),
            'Monto'=>number_format($this->comprobante->getMonto(),2, '.', ''),
            'NumOperacion'=>$this->comprobante->getNumOperacion()
        );

        $dataBancoBeneficiario = $this->comprobante->getDataBanco();
        if($dataBancoBeneficiario['rfc'] !== null && $dataBancoBeneficiario['rfc'] !== ''){
            $this->datosComplemento['pago']['RfcEmisorCtaBen'] = $dataBancoBeneficiario['rfc'];
        }

        $CtBeneficiario = $this->comprobante->getDataCuentaBancaria();
        if(trim($CtBeneficiario['cuenta']) !== null && trim($CtBeneficiario['cuenta'])!==''){
            $this->datosComplemento['pago']['CtaBeneficiario'] = trim($CtBeneficiario['cuenta']);
        }elseif(trim($CtBeneficiario['clabe_interbancaria']) !== null && trim($CtBeneficiario['clabe_interbancaria'])!==''){
            $this->datosComplemento['pago']['CtaBeneficiario'] = trim($CtBeneficiario['clabe_interbancaria']);
        }

        $this->datosComplemento['documentosRelacionados'] = $documentos;
    }

    public function prepararDatosEmisor(){
        $this->datosEmisor = array(
            'Emisor'=>array(
                'Rfc'=>$this->emisor['rfc'],
                'Nombre'=>$this->emisor['razon_social'],
                'RegimenFiscal'=>$this->getRegimenFiscal()
            ));
    }

    public function prepararDatosReceptor(){
        $this->datosReceptor = array(
        'Receptor'=>array(
            'Rfc'=>$this->receptor['rfc'],
            'Nombre'=>$this->receptor['razon_social'],
            'UsoCFDI'=>$this->datosDefaultComprobante['UsoCFDI']
        ));
    }

    public function prepararConceptos(){
        $array = array(
            'ClaveProdServ'=>"84111506",
            'Cantidad'=>"1",
            'ClaveUnidad'=>"ACT",
            'Descripcion'=>"Pago",
            'ValorUnitario'=>"0",
            'Importe'=>"0");

             $this->datosConceptos[] = $array;
    }

    public function setSerieFolio(){
        #Toma la serie asignada para facturar y obtiene el folio siguiente si aun hay disponibles
        $id = $this->expedidoEn['serie_de_pago'];
        $query = "SELECT * FROM facturas_series_folios "
                . "WHERE id = '$id' "
                . "AND status = '1' "
                . "ORDER BY id ASC LIMIT 1";
        $result = $this->query($query);

        if($result->num_rows == 0){
            throw new Exception("No existen folios registrados para timbrar pago.");
        }else{
            $result = $result->fetch_object();
            $folio_inicio = $result->folio_inicio;
            $folio_fin = $result->folio_fin;
            $serie = $result->serie;
        }

        $query = "SELECT folio "
                . "FROM pagos "
                . "WHERE serie = '$serie'"
                . "AND status = '2' "
                . "ORDER BY CAST(FOLIO AS SIGNED) DESC LIMIT 1";

        $result = $this->query($query);

        if($result->num_rows == 0){
            $folio = $folio_inicio;
        }else{
            $result = $result->fetch_object();
            $folio = $result->folio;
            $folio++;
        }

        if($folio > $folio_fin){
           #parar script y mandar mensaje "No existen folios registrados para facturar."
           throw new Exception("No existen folios registrados para timbrar pagos.");
        }

        $this->serie = $serie;
        $this->folio = $folio;
    }

    public function getRegimenFiscal(){
        if(isset($this->expedidoEn['regimen_fiscal']) && !empty($this->expedidoEn['regimen_fiscal'])){
            return $this->expedidoEn['regimen_fiscal'];
        }

        return $this->emisor['regimen_fiscal'];
    }


    public function getNoCertificado(){
        if($this->expedidoEn['certificado_independiente']== 'Si'){
            return $this->expedidoEn['no_certificado'];
        }

        return $this->emisor['no_certificado'];
    }

    public function getCertificado(){
        if($this->expedidoEn['certificado_independiente']== 'Si'){
            return $this->expedidoEn['certificado'];
        }

        return $this->emisor['certificado'];
    }

    public function getOptions(){
        return $this->options;
    }
    public function getIdPago(){
        return $this->idPago;
    }

    public function getDatosComprobante(){
        return $this->datosComprobante;
    }

    public function getDatosEmisor(){
        return $this->datosEmisor;
    }

    public function getDatosComplemento(){
        return $this->datosComplemento;
    }

    public function getDatosReceptor(){
        return $this->datosReceptor;
    }

    public function getDatosConceptos(){
        return $this->datosConceptos;
    }

    public function getNombreArchivo(){
        $folio = str_pad($this->folio, 5, "0", STR_PAD_LEFT);
        $nombreArchivo = '';
        if(trim($this->serie)!=''){
            $nombreArchivo .= $this->serie."-";
        }

        return $nombreArchivo .= $folio;
    }

    public function getRutaParaGuardarXML(){
         if(!is_dir($this->rutaParaGuardarXML."/1/Pagos/")){
                    mkdir($this->rutaParaGuardarXML."/1/Pagos/",0777,true);
                }
        return $this->rutaParaGuardarXML."/".$this->expedidoEn['id']."/Pagos/";
    }

    public function getArchivosSAT(){
        if($this->expedidoEn['certificado_independiente']== 'Si'){
            return array(
                    'keyPem'=>PATH_SAT_DOCS."/".$this->expedidoEn['id']."/".$this->archivoKeyPem
                  );
        }
        /* 1 contiene la archivos de la empresa con lo que se debe facturar por default, cuando la empresa no tiene certificado propio*/
        return array(
                'keyPem'=>PATH_SAT_DOCS."/1/".$this->archivoKeyPem
              );
    }

    public function getPathArchivoXML(){
        return $this->getRutaParaGuardarXML().$this->getNombreArchivo().".xml";
    }

    public function getArchivoXML(){
        return file_get_contents($this->getRutaParaGuardarXML().$this->getNombreArchivo().".xml");
    }

    public function setParametroXML(){
        $this->datosTimbrar['timbraRequest']['timbraRequest']['XML'] = $this->getArchivoXML();
    }

    public function crearXML(){
        $crear_xml_factura = new crear_xml_pago();
        $crear_xml_factura->setDatosComprobante($this->getDatosComprobante());
        $crear_xml_factura->setDatosComplemento($this->getDatosComplemento());
        $crear_xml_factura->setDatosEmisor($this->getDatosEmisor());
        $crear_xml_factura->setDatosReceptor($this->getDatosReceptor());
        $crear_xml_factura->setDatosConceptos($this->getDatosConceptos());
        $crear_xml_factura->setArchivosSAT($this->getArchivosSAT());

        $crear_xml_factura->crearXML($this->getRutaParaGuardarXML(),$this->getNombreArchivo());
    }

   public function timbrar(){
       $settings = new SettingsRepository();
       $tipoTimbrado = $settings->_get('tipo_timbrado');
       $serverURL = $settings->_get($tipoTimbrado.'_timbrado_serverURL');
       $usuarioTimbrado = $settings->_get($tipoTimbrado.'_timbrado_usuario');
       $metodoALlamar = $settings->_get('timbrado_metodoALlamar');

        $params = array();
        $params['usuarioIntegrador'] = $usuarioTimbrado;
        /* Comprobante en base 64 */
        $params['xmlComprobanteBase64'] = base64_encode($this->getArchivoXML());
        /* Id del comprobante, deberÃ¡ ser un identificador Ãºnico, para efecto del ejemplo se utilizarÃ¡ un numero aleatorio */
        $params['idComprobante'] = rand(5, 999999);

        $client = new SoapClient($serverURL, $params);
        $response = $client->__soapCall($metodoALlamar, array('parameters' => $params));
        //var_dump($response);exit;
        /*Obtenemos resultado del response*/
        $tipoExcepcion = $response->TimbraCFDIResult->anyType[0];
        $numeroExcepcion = $response->TimbraCFDIResult->anyType[1];
        $descripcionResultado = $response->TimbraCFDIResult->anyType[2];
        $xmlTimbrado = $response->TimbraCFDIResult->anyType[3];
        $codigoQr = $response->TimbraCFDIResult->anyType[4];
        $cadenaOriginal = $response->TimbraCFDIResult->anyType[5];

        if($xmlTimbrado != ''){
            /*El comprobante fue timbrado correctamente*/
            /*Guardamos comprobante timbrado*/
            $this->guardarXMLTimbrado($xmlTimbrado);
            return true;
            /*Guardamos codigo qr*/
            //file_put_contents('C:\Users\Andres\Desktop\codigoQr.jpg', $codigoQr);

            /*Guardamos cadena original del complemento de certificacion del SAT*/
            //file_put_contents('C:\Users\Andres\Desktop\cadenaOriginal.txt', $cadenaOriginal);
        }else{
            #Produccion
           //throw new Exception('Oopss!!. Algo salio mal durante el proceso de facturacion.<br/> Contacta a tu proveedor del servicio para mas informacion.');

            #Develop
            throw new Exception($descripcionResultado);
        }
    }

   public function timbrarXML($xmlName){
        if(!file_exists(PATH_SAT_DOCS.$xmlName.".xml")){
            $this->flashmessenger->addMessage(array('danger'=>'No existe nombre de archivo.'));
            return null;
        }
        if($this->conectarConServicioTimbrado()){
            $this->datosTimbrar['timbraRequest']['timbraRequest']['XML'] = file_get_contents(PATH_SAT_DOCS.$xmlName.".xml");

            $timbrado = $this->conexionServicioTimbrado->call(
                $this->datosTimbrar['metodoALlamar'],
                $this->datosTimbrar['timbraRequest'],
                "uri:".$this->datosTimbrar['serverURL']."/".$this->datosTimbrar['serverScript'],
                "uri:".$this->datosTimbrar['serverURL']."/".$this->datosTimbrar['serverScript']."/".$this->datosTimbrar['metodoALlamar']
            );
            if ($timbrado['TimbraCFDIV33Result']['TimbreCorrecto'] == "true") {
               file_put_contents(PATH_SAT_DOCS."/Timbre-".$xmlName.".xml", utf8_encode(($timbrado['TimbraCFDIV33Result']['XML'])));
               $this->flashmessenger->addMessage(array('success'=>'Factura timbrada'));
            }else{
                #Produccion
                //throw new Exception('Oopss!!. Algo salio mal durante el proceso de facturacion.<br/> Contacta a tu proveedor del servicio para mas informacion.');

                #Develop
                $this->flashmessenger->addMessage(array('danger'=>$timbrado['TimbraCFDIV33Result']['Error']));
                return null;
            }
        }
    }

   public function cancelar() {
        $settings = new SettingsRepository();
        $tipoTimbrado = $settings->_get('tipo_timbrado');
        $serverURL = $settings->_get($tipoTimbrado.'_timbrado_serverURL');
        $usuarioTimbrado = $settings->_get($tipoTimbrado.'_timbrado_usuario');
        $metodoALlamar = $settings->_get('timbrado_cancelar_metodoALlamar');
        $response = '';

        try {
            $params = array();
            $params['usuarioIntegrador'] = $usuarioTimbrado;
            $params['rfcEmisor'] = $this->emisor['rfc'];
            $params['folioUUID'] = strtoupper($this->comprobante->getUUID());

            $context = stream_context_create(array(
                'ssl' => array(
                    // set some SSL/TLS specific options
                    'verify_peer' => false,
                    'verify_peer_name' => false,
                    'allow_self_signed' => false  //--> solamente true en ambiente de pruebas
                ),
                'http' => array(
                    'user_agent' => 'PHPSoapClient'
                )
            ));
            //var_dump($params);exit;
            $options = array();
            $options['stream_context'] = $context;
            $options['cache_wsdl'] = WSDL_CACHE_MEMORY;
            $options['trace'] = true;

            $client = new SoapClient($serverURL, $options);
            $response = $client->__soapCall($metodoALlamar, array('parameters' => $params));

            /* Obtenemos resultado del response */
            $tipoExcepcion = $response->CancelaCFDIResult->anyType[0];
            $numeroExcepcion = $response->CancelaCFDIResult->anyType[1];
            $descripcionResultado = $response->CancelaCFDIResult->anyType[2];
            $xmlTimbrado = $response->CancelaCFDIResult->anyType[3];
            $codigoQr = $response->CancelaCFDIResult->anyType[4];
            $cadenaOriginal = $response->CancelaCFDIResult->anyType[5];

            if ($numeroExcepcion == "0"){
                #Se guarda codigo
                $this->guardarXMLTimbradoCancelado($codigoQr);
                return true;
            } else {
                throw new Exception($descripcionResultado);
            }

        } catch (SoapFault $fault) {
            throw new Exception("SOAPFault: " . $fault->faultcode . "-" . $fault->faultstring . "\n");
        }
    }

    public function conectarConServicioTimbrado(){
        $link = $this->datosTimbrar['serverURL']."/".$this->datosTimbrar['serverScript']."?WSDL";
        $this->conexionServicioTimbrado = new nusoap_client($link, 'wsdl');

        $error = $this->conexionServicioTimbrado->getError();
        if ($error) {
           #Produccion
           #throw new Exception('Oopss!!. Algo salio mal durante el proceso de facturacion.<br/> Contacta a tu proveedor del servicio para mas informacion.');

           #Develop
           throw new Exception($error);
        }
        return true;
    }

     public function conectarConServicioCancelado(){
        $link = $this->datosCancelar['serverURL']."/".$this->datosCancelar['serverScript']."?WSDL";
        $this->conexionServicioTimbrado = new nusoap_client($link, 'wsdl');

        $error = $this->conexionServicioTimbrado->getError();
        if ($error) {
           #Produccion
           #throw new Exception('Oopss!!. Algo salio mal durante el proceso de facturacion.<br/> Contacta a tu proveedor del servicio para mas informacion.');

           #Develop
           throw new Exception($error);
        }
        return true;
    }

    public function guardarXMLTimbrado($xmlTimbrado){
        file_put_contents($this->getRutaParaGuardarXML()."/Pago-".$this->getNombreArchivo().".xml", utf8_encode($xmlTimbrado));
    }

    public function getXMLTimbrado(){
        return $this->getRutaParaGuardarXML()."/Pago-".$this->getNombreArchivo().".xml";
    }

    public function guardarXMLTimbradoCancelado($xmlCancelado){
        file_put_contents($this->getRutaParaGuardarXML()."/CancelacionPago-".$this->getNombreArchivo().".jpg", $xmlCancelado);
    }

    public function getXMLTimbradoCancelado(){
        return $this->getRutaParaGuardarXML()."/CancelacionPago-".$this->getNombreArchivo().".jpg";
    }

    public function guardarPago(){
        #Leer xml timbrado
        $xml = simplexml_load_file($this->getXMLTimbrado());
        #$xml = simplexml_load_file( $this->getRutaParaGuardarXML()."/Timbre-A-00001.xml");
        $cfdi = $xml->getNamespaces(true);
        $xml->registerXPathNamespace("c", $cfdi["tfd"]);
        $attribute = $xml->xpath("//c:TimbreFiscalDigital");

        #Obtener atributos de xml timbrado
        $version = (string)$attribute[0]->attributes()->Version;
        $uuid = (string)$attribute[0]->attributes()->UUID;
        $ftimbrado = (string)$attribute[0]->attributes()->FechaTimbrado;
        $sellocfdi = (string)$attribute[0]->attributes()->SelloCFD;
        $certificadosat = (string)$attribute[0]->attributes()->NoCertificadoSAT;
        $ssat = (string)$attribute[0]->attributes()->SelloSAT;

        $cadena_originalsat = "||".$version."|".$uuid."|".$ftimbrado."|".$sellocfdi."|".$certificadosat."||";

        $options = array(
            'serie'=>$this->serie,
            'folio'=>$this->folio, #int
            'datos_comprobante'=>serialize($this->getDatosComprobante()),
            'datos_emisor'=>  serialize($this->getDatosEmisor()),
            'datos_receptor'=>  serialize($this->getDatosReceptor()),
            'datos_conceptos'=>  serialize($this->getDatosConceptos()),
            'datos_complemento'=>  serialize($this->getDatosComplemento()),
            'uuid'=>$uuid,
            'certificado_sat'=>$certificadosat,
            'fecha_timbrado'=>$ftimbrado,
            'sello_sat'=>$ssat,
            'cadena_original_sat'=>$cadena_originalsat,
            'sello_cfdi'=>$sellocfdi,
            'status'=>'2'
        );

        $pago = new PagoRepository();
        $result = $pago->updateString($options," id = ".$this->getIdPago());

        if($result){
            return true;
        }
        return null;
    }
}
