<?php

class ProductoRepository extends EntityRepository
{
    private $table = 'productos';
    private $images = null;
    private $options_image = array(
        'allowedExtensions'=>array('jpg','jpeg','png'),
        'maxFileSizeAllowed'=>1000000,
        'pathToSave'=>PATH_IMG_PRODUCTS
    );
    
    public $flashmessenger = null;
    
    private $options = array(
        'codigo' => null,
        'nombre' => null,
        'unidad_de_medida' => null,
        'impuestos_incluidos' => null,
        'impuestos'=>null,
        'precio_unitario'=>null,
        'descuento'=>null,
        'comentarios'=>null,
        'status'=>null,
        'sat_producto_clave'=>null,
        'sat_producto_descripcion'=>null,
     );
    
    public function setOptions($data)
    {
        foreach ($this->options as $option => $value) {
            if (isset($data[$option])) {
                $this->options[$option] = $data[$option];
            }
        }
    }

    public function getOptions()
    {
        return $this->options;
    }
    
    public function __construct()
    {
        if (!$this->flashmessenger instanceof FlashMessenger) {
            $this->flashmessenger = new FlashMessenger();
        }
    }
    
    public function _getTranslation($text)
    {
        return $this->flashmessenger->_getTranslation($text);
    }
    
    public function setImage($file)
    {
        $this->images['main'] = $file;
    }
    
    public function saveImage($idProduct)
    {
        $file = new UploadFile();
        $file->setAllowedExtensions($this->options_image['allowedExtensions']);
        $file->setMaxFileSizeAllowed($this->options_image['maxFileSizeAllowed']);
        $file->setTempFolder($this->options_image['pathToSave']);

        $rsUpload = $file->uploadFile($this->images['main'], null, 'main_'.$idProduct);
        if (!$rsUpload) {
            $this->flashmessenger->addMessage(array('info'=>$file->getMessageError()));
        }
    }
    
    public function getSATProductDescription($clave)
    {
        $db_admin = new DBAdminEntityRepository();
        $query = "SELECT descripcion FROM sat_c_claveprodserv where clave = '$clave'";
        $result = $db_admin->query($query);
        
        if ($result->num_rows > 0) {
            $result = $result->fetch_object();
            return $result->descripcion;
        }
        return null;
    }

    public function save(array $data, $table = null)
    {
        $data['sat_producto_descripcion'] = utf8_encode($this->getSATProductDescription($data['sat_producto_clave']));
        if (trim($data['precio_unitario'])=='') {
            $data['precio_unitario'] = 0;
        }
        if (isset($data['impuestos']) && $data['impuestos'] !== null) {
            $data['impuestos'] = $this->impuestosArrayToString($data['impuestos']);
        }
        
        foreach ($data as $key => $value) {
            if (trim($value) == '' || trim($value) === null) {
                unset($data[$key]);
            }
        }
        $result =  parent::save($data, $this->table);
        
        if ($result) {
            if ($this->images !==null) {
                $this->saveImage($this->getInsertId());
            }
            return true;
        }
        return null;
    }

    public function update($id, $data, $table = null)
    {
        $data['sat_producto_descripcion'] = utf8_encode($this->getSATProductDescription($data['sat_producto_clave']));
        if (trim($data['precio_unitario'])=='') {
            $data['precio_unitario'] = 0;
        }
        if (isset($data['impuestos']) && $data['impuestos'] !== null) {
            $data['impuestos'] = $this->impuestosArrayToString($data['impuestos']);
        }
   
        $result =  parent::update($id, $data, $this->table);
        
        if ($result) {
            if ($this->images !==null) {
                $this->saveImage($id);
            }
            return true;
        }
        return null;
    }

    public function getById($id, $table = null, $selectAux = null)
    {
        return parent::getById($id, $this->table, $selectAux);
    }
    
    public function getByCode($code)
    {
        $query = "SELECT * FROM productos WHERE codigo = '$code' LIMIT 1";
        $result = $this->query($query);
        
        if ($result->num_rows > 0) {
            $result = $this->resultToArray($result);
            return $result[0];
        }
        return null;
    }
    
    public function getRealInfoById($id)
    {
        $query = "SELECT id,nombre
                   FROM productos
                   WHERE id = '$id'";
        
        $result = $this->query($query);
        
        if ($result->num_rows > 0) {
            $result = $this->resultToArray($result);
            return $result[0];
        }

        return null;
    }
    
    public function delete($id, $table = null)
    {
        return parent::delete($id, $this->table);
    }
    
    public function cancel($id, $table = null)
    {
        return parent::update($id, array('status'=>'2'), $this->table);
    }
    
    public function exist($idProducto)
    {
        $query = "SELECT nombre
                    FROM productos 
                    WHERE id = '$idProducto'
                    LIMIT 1 ";
        $result = $this->query($query);
        
        if ($result->num_rows > 0) {
            $result =  $this->resultToArray($result);
            return $result[0];
        }
        return null;
    }
    
    public function existeCodigo($codigo, $idProducto = null)
    {
        $codigo = strtolower(trim($codigo));
        if ($codigo == '') {
            return null;
        } else {
            $codigo = " codigo = '$codigo' ";
        }
        if ($idProducto != null && trim($idProducto)!='') {
            $idProducto = " AND id != '$idProducto' ";
        }
        
        $query = "SELECT codigo,
                         nombre
                    FROM productos 
                    WHERE $codigo $idProducto
                    LIMIT 1 ";
        $result = $this->query($query);
        
        if ($result->num_rows > 0) {
            $result =  $this->resultToArray($result);
            return $result[0];
        }
        return null;
    }

    public function isUsedInRecord($id, array $buscarEn = null, $andWhere= null)
    {
        parent::update($id, array('status'=>'2'), $this->table);
        return parent::isUsedInRecord($id, array('facturas_detalles'=>'id_producto','notas_de_credito_detalles'=>'id_producto'));
    }
    
    public function getListProductos($tipo = null)
    {
        $query = "SELECT *,
                    (SELECT GROUP_CONCAT(descripcion SEPARATOR ',') FROM impuestos WHERE FIND_IN_SET(id,impuestos)) AS impuestosNombres,
                    fxGetStatusName(status,'Producto')as status,
                    fxGetUMDescription(unidad_de_medida)as um
                    FROM productos
                    WHERE 1=1
                    ORDER BY nombre";
        $result = $this->query($query);
        
        if ($result) {
            return $this->resultToArray($result);
        }
        
        return null;
    }
    
    public function getSelectListProductos($type = null)
    {
        if ($type !== null) {
            $type = " AND tipo = '$type'";
        }
        $query = "SELECT *,
                    fxGetStatusName(status,'Producto')as status,
                    fxGetUMDescription(unidad_de_medida)as um
                    FROM productos
                    WHERE 1=1
                    $type
                    AND status = '1'
                    ORDER BY nombre";
        $result = $this->query($query);
        
        if ($result) {
            $array = array();
            while ($row = $result->fetch_assoc()) {
                $array[$row['id']] = $row['nombre']." (".$row['codigo'].")";
            }
            return $array;
        }
        
        return null;
    }
    
    public function getProductosLike($item)
    {
        $query = "SELECT *
                    FROM productos WHERE codigo like '%$item%' OR nombre like '%$item%' ORDER BY nombre";
        $result = $this->query($query);
        
        if ($result) {
            return $this->resultToArray($result);
        }
        
        return null;
    }
    
    public function getListVentaProductos($tipo = null)
    {
        $query = "SELECT *
                    FROM productos WHERE 1=1  ORDER BY nombre";
        $result = $this->query($query);
        
        if ($result) {
            return $this->resultToArray($result);
        }
    }
    
    public function getLastIdProduct()
    {
        $query = "SELECT id FROM productos ORDER BY id DESC LIMIT 1";
        
        $result =$this->query($query);
        
        if ($result->num_rows > 0) {
            $result = $result->fetch_object();
            return $result->id;
        } else {
            return 0;
        }
    }
    
    public function getListaImpuestos()
    {
        $query = "SELECT * FROM impuestos ORDER BY id ASC";
        $result = $this->query($query);
        
        if ($result) {
            $array = array();
            while ($row = $result->fetch_object()) {
                $array[$row->id] = $row->descripcion;
            }
            
            return $array;
        }
        
        return null;
    }
    
    public function getListaUndadesMedida()
    {
        $db_admin = new DBAdminEntityRepository();
        $query = "SELECT * FROM unidades_de_medida ORDER BY id ASC";
        $result = $db_admin->query($query);
        
        if ($result) {
            $array = array();
            while ($row = $result->fetch_object()) {
                $array[$row->clave] = sprintf("[%s] %s", $row->clave, $row->descripcion);
            }
            
            return $array;
        }
        
        return null;
    }
    
    public function impuestosStringToArray($impuestos)
    {
        $arrayImpuestos = array();
        $impuestos = explode(',', $impuestos);
        foreach ($impuestos as $key => $impuesto) {
            $arrayImpuestos[$impuesto] = $impuesto;
        }
        return $arrayImpuestos;
    }
    
    public function impuestosArrayToString(array $impuestos)
    {
        $impuestosString = '';
        foreach ($impuestos as $impuesto) {
            $impuestosString .= $impuesto.',';
        }
        return trim($impuestosString, ',');
    }
    
    public function getListaDivisionesSATProdServ($tipo)
    {
        $db_admin = new DBAdminEntityRepository();
        $query = "SELECT * FROM sat_c_claveprodserc_divisiones WHERE tipo = '$tipo'";
        $result = $db_admin->query($query);
        
        if ($result) {
            $array = array();
            while ($row = $result->fetch_object()) {
                $array[$row->id] = $row->descripcion;
            }
            
            return $array;
        }
        
        return null;
    }
    
    public function getListaGruposSATProdServ($division)
    {
        $db_admin = new DBAdminEntityRepository();
        $query = "SELECT * FROM sat_c_claveprodserc_grupos WHERE division = '$division'";
        $result = $db_admin->query($query);
        
        if ($result) {
            $array = array();
            while ($row = $result->fetch_object()) {
                $array[$row->id] = $row->descripcion;
            }
            
            return $array;
        }
        
        return null;
    }
    
    public function getListaSATProductos($grupo)
    {
        $db_admin = new DBAdminEntityRepository();
        if (trim($grupo == '')) {
            return null;
        }
        $query = "SELECT * FROM sat_c_claveprodserv WHERE clave like '$grupo%' ORDER BY clave ASC";
        $result =$db_admin->query($query);
        
        if ($result->num_rows > 0) {
            $array = array();
            while ($row = $result->fetch_object()) {
                $array[$row->clave] = $row->descripcion;
            }
            
            return $array;
        } else {
            return 0;
        }
    }
    
    public function searchByDescriptionWildCard($wildCard)
    {
        $db_admin = new DBAdminEntityRepository();
        $query = sprintf(" SELECT clave, descripcion from sat_c_claveprodserv WHERE UPPER(descripcion) LIKE UPPER('%%%s%%') ", mysqli_escape_string(DBAdmin::getInstance(), $wildCard));

        $result = $db_admin->query($query);
        if ($result->num_rows > 0) {
            $arrayTemp = array();
            $result = $this->resultToArray($result);
            foreach ($result as $row) {
                $arrayTemp[] = array('clave'=>$row['clave'],'descripcion'=>utf8_encode($row['descripcion']));
            }
            
            return $arrayTemp;
        } else {
            return array();
        }
    }
    
    public function getByClaveSat($clave)
    {
        $db_admin = new DBAdminEntityRepository();
        $query = sprintf(" SELECT clave, descripcion from sat_c_claveprodserv WHERE clave = '%s' ", mysqli_escape_string(DBAdmin::getInstance(), $clave));
        
        $result = $db_admin->query($query);
        if ($result->num_rows > 0) {
            return $this->resultToArray($result);
        } else {
            return array();
        }
    }
    
    public function getListaProductosSAT($grupo = null)
    {
        $db_admin = new DBAdminEntityRepository();
        if (trim($grupo == '')) {
            return null;
        }
        $query = "SELECT * FROM sat_c_claveprodserv WHERE descripcion like '$grupo%' ORDER BY clave ASC LIMIT 100";
        $result =$db_admin->query($query);
        
        if ($result->num_rows > 0) {
            return $this->resultToArray($result);
        } else {
            return 0;
        }
    }
}
