<?php

class ReporteListRepository extends EntityRepository
{
    public $flashmessenger = null;

    private $saveFile = null;

    private $options = array(

        'reporte'=>null,

        'fechaInicio'=>null,

        'fechaFin'=>null,

        'sucursal' => null,

        'cliente' => null,

        'saldoInicial' => null,

    );

    private $nombreArchivo = null;

    private $reporte = null;

    private $tempFolder = null;

    private $headerExcelReport = null;



    private $reportes = array(
        'facturasPorFecha'=>'facturasPorFecha',
        'facturas_tickets'=>'facturasTickets',
        'estado_de_cuenta'=>'estadoDeCuenta',
        'saldo_inicial'=>'saldo_inicial',
        'facturas_detalles'=>'facturas_detalles',
        'facturas_detalles_excel'=>'facturas_detalles_excel',
    );



    private $nombreReportes = array(
        'facturasPorFecha'=>'Facturas por fecha',
        'facturas_tickets'=>'Facturas de tickets',
        'estado_de_cuenta'=>'Estado de cuenta',
        'saldo_inicial'=>'Saldo inicial',
        'facturas_detalles'=>'Reporte Analitico de Facturacion',
        'facturas_detalles_excel'=>'Facturacion detallado por cliente',
    );



    #Para excel 'nombreReporte'=>'nombreArchivo en View/Reports/Excel'

    private $reportesEspeciales = array(

        'facturasPorFecha'=>'facturasPorFecha',

        'facturas_tickets'=>'facturasTickets',
        'facturas_detalles'=>'facturas_detalles',
        'facturas_detalles_excel'=>'facturas_detalles_excel',
        'estado_de_cuenta'=>'estado_de_cuenta',

    );

    #Para pdf 'nombreReporte'=>'nombreArchivo en View/Reports/Pdf'

    private $reportesEspecialesPDF = array(
        'facturasPorFecha' => 'facturas_por_fecha',
        'estado_de_cuenta'=>'estado_de_cuenta',
        'saldo_inicial'=>'saldo_inicial',
        'facturas_detalles'=>'facturas_detalles'

    );



    #Para excel 'nombreReporte'=>'nombreArchivo en View/Reports/Pantalla'

    private $reportesEspecialesPantalla = array(

        'facturasPorFecha'=>'facturasPorFecha',

        'facturas_tickets'=>'facturasTickets',

    );



    public function __construct()
    {
        if (!$this->flashmessenger instanceof FlashMessenger) {
            $this->flashmessenger = new FlashMessenger();
        }
    }



    public function _getTranslation($text)
    {
        return $this->flashmessenger->_getTranslation($text);
    }



    public function setOptions($data)
    {
        foreach ($data as $option => $value) {
            $this->options[$option] = $data[$option];
        }
        $this->createReporte();
    }



    public function getOptions()
    {
        return $this->options;
    }



    public function getNombreReporte()
    {
        return $this->options['reporte'];
    }



    public function getTituloReporte()
    {
        return $this->nombreReportes[$this->options['reporte']];
    }



    public function getNombreArchivo()
    {
        return str_replace(' ', '', $this->nombreArchivo);
    }



    public function setNombreArchivo()
    {
        if (isset($this->nombreReportes[$this->getNombreReporte()])) {
            $this->nombreArchivo = $this->nombreReportes[$this->getNombreReporte()];
        }
    }



    public function setNombreReporteManual($nombreArchivo)
    {
        $this->nombreArchivo = $nombreArchivo;
    }



    public function setHeaderExcelReportManual($headerReport)
    {
        $this->headerExcelReport = $headerReport;
    }



    public function createReporte()
    {
        ini_set('max_execution_time', 18000);

        ini_set('mysql.connect_timeout', 18000);

        ini_set('default_socket_timeout', 18000);

        ini_set('memory_limit', '-1');



        $nombreReporte = $this->reportes[$this->getNombreReporte()];

        $this->setNombreArchivo();

        $this->setReporte($this->$nombreReporte());



        $_SESSION['optionsCurrentReport'] = array(

            'options'=>$this->getOptions()

        );
    }



    public function getStringToSendGET()
    {
        $options = $this->getOptionsCurrentReport();

        $string = "?";

        foreach ($options['options'] as $key => $value) {
            $string .= $key."=".$value."&";
        }



        $string = trim($string, "&");

        return $string;
    }



    public function getOptionsCurrentReport()
    {
        return $_SESSION['optionsCurrentReport'];
    }



    public function setReporte($data)
    {
        if ($data == null) {
            $this->flashmessenger->addMessage(array('info'=>'No se encontraron resultados.'));
            header('location: '.ROOT_HOST.'/Controller/Reportes.php');
            exit;
        }

        $this->reporte = $data;
    }



    public function getReporte()
    {
        return $this->reporte;
    }

    public function facturasPorFecha()
    {
        $facturas = new FacturaRepository();
        return $facturas->getFacturasPorFecha($this->getOptions());
    }

    public function facturas_detalles()
    {
        $facturas = new FacturaRepository();
        return $facturas->getFacturasDetalles($this->getOptions());
    }

    public function facturas_detalles_excel()
    {
        $facturas = new FacturaRepository();
        return $facturas->getFacturasDetallesExcel($this->getOptions());
    }

    public function estadoDeCuenta()
    {
        $factura = new FacturaRepository();
        return $factura->getEstadoDeCuenta($this->getOptions());
    }

    public function saldo_inicial()
    {
        $factura = new FacturaRepository();
        return $factura->getSaldoInicial($this->getOptions());
    }

    public function facturasTickets()
    {
        return parent::getFacturasTickets($this->getOptions());
    }

    public function getReporteOnFile($formato)
    {
        $empresa = new EmpresaRepository();

        $empresa = $empresa->getById(1);



        $fechaInicio = $this->options['fechaInicio'];

        $fechaFin = $this->options['fechaFin'];

        if (trim($fechaInicio)=='' && trim($fechaFin)=='') {
            $fechaInicio = $this->_getTranslation("Desde el inicio de los tiempos");

            $fechaFin = strftime('%d/%m/%Y', strtotime('now'));
        } elseif (trim($fechaInicio)=='' && trim($fechaFin)!='') {
            $fechaInicio = $fechaFin;
        } elseif (trim($fechaInicio)!='' && trim($fechaFin)=='') {
            $fechaFin = $fechaInicio;
        }

        $this->setHeaderExcelReportManual($empresa['nombre']."\n".$this->_getTranslation($this->getTituloReporte())."\n".$fechaInicio." - ".$fechaFin);


        if ($formato == 'excel') {
            if (isset($this->reportesEspeciales[$this->options['reporte']])) {
                $this->reporteEspecial();
            } else {
                $this->reporteDefault();
            }
        } elseif ($formato == 'pdf') {
            if (isset($this->reportesEspecialesPDF[$this->options['reporte']])) {
                $this->reporteEspecialPDF();
            }
        }
    }


    public function reporteEspecial()
    {
        $data = $this->reporte;

        include ROOT.'/View/Reports/Excel/'.$this->options['reporte'].".php";
    }

    public function reporteEspecialPDF()
    {
        $data = $this->reporte;

        include ROOT.'/View/Reports/Pdf/'.$this->options['reporte'].".php";
    }



    public function getTemplateReporteOnScreen()
    {
        if (isset($this->reportesEspecialesPantalla[$this->options['reporte']])) {
            return ROOT.'View/Reports/Pantalla/'.$this->options['reporte'].".php";
        } else {
            return ROOT.'View/Reports/Pantalla/default.php';
        }
    }

    public function reporteDefault()
    {
        $arrayData = $this->reporte;

        $colTitulosTemp = $arrayData[0];

        foreach ($colTitulosTemp as $titulo => $value) {
            $colTitulos[] = $titulo;
        }



        $objPHPExcel = new PHPExcel();

        $col = count($colTitulos);

        $col = $this->getColLetter($col-1);

        $objPHPExcel->getActiveSheet()->getStyle("A1:".$col."1")->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID);

        $objPHPExcel->getActiveSheet()->getStyle("A1:".$col."1")->getFill()->getStartColor()->setARGB('8DB4E3');

        $objPHPExcel->getActiveSheet()->getStyle("A1:".$col."1")->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

        $objPHPExcel->getActiveSheet()->fromArray($colTitulos, null, 'A1');



        $row=2;

        foreach ($arrayData as $key => $data) {
            $i=0;

            foreach ($data as $col => $value) {
                $col = $this->getColLetter($i);

                $objPHPExcel->getActiveSheet()->setCellValue($col . $row, $value);

                $i++;
            }

            $row++;
        }

        $objPHPExcel->setActiveSheetIndex(0);

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');



        if ($this->saveFile == true) {
            $objWriter->save($this->getTempFolder()."/".$this->getNombreArchivo().".xlsx");
        } else {
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');

            header("Content-Disposition: attachment;filename=".$this->getNombreArchivo().".xlsx");

            header('Cache-Control: max-age=0');

            $objWriter->save('php://output');
        }

        unset($objWriter);
    }



    public function saveFile()
    {
        $this->setTempFolder();

        $this->saveFile = true;
    }



    private function getColLetter($i)
    {
        $colName = array("A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z","AA","AB","AC","AD","AE","AF","AG","AH","AI");



        return $colName[$i];
    }



    private function setTempFolder()
    {
        $login = new Login();

        $this->tempFolder = PATH_TEMP_DOCS.$login->getId();

        if (!is_dir($this->tempFolder)) {
            mkdir($this->tempFolder, 0777, true);
        }
    }



    private function getTempFolder()
    {
        return $this->tempFolder;
    }



    public function getFileSaved()
    {
        return $this->getTempFolder()."/".$this->getNombreArchivo().'.xlsx';
    }

    public function getFacturasPorFecha(array $options)
    {
        if ($options['cliente'] != null) {
            $cliente = implode(',', $options['cliente']);
        }

        $fecha = $this->createFilterFecha($options['fechaInicio'], $options['fechaFin'], 'fecha_timbrado_solo_fecha');
        $sucursal = $options['sucursal'] ? " AND sucursal = {$options['sucursal']} " : null;
        $cliente = $options['cliente'] ? " AND find_in_set(v.id_cliente,'$cliente') " : null;

        $query = "SELECT v.*,
                    fxGetStatusName(status,'Factura')as statusName,
                    fxGetSucursalName(sucursal) as sucursalName,
                    c.razon_social
                    FROM view_facturas_timbradas v
                    inner join clientes c on c.id = v.id_cliente
                    WHERE 1=1 $fecha
                    $sucursal
                    $cliente
                    ORDER BY serie ASC,folio DESC";

        $result = $this->query($query);

        if ($result->num_rows > 0) {
            $result = $this->resultToArray($result);

            $ventasGeneradas = 0;

            $ventasMonto = 0;



            foreach ($result as $row) {
                $ventasGeneradas++;

                $ventasMonto += $row['total'];
            }

            return array(

                'data'=>$result,

                'ventasGeneradas'=>$ventasGeneradas,

                'ventasMonto'=>number_format($ventasMonto, 2)

            );
        } else {
            return array(array('Resultado'),array('No se encontraron resultados.'));
        }
    }



    public function getFacturasTickets(array $options)
    {
        $fecha = $this->createFilterFecha($options['fechaInicio'], $options['fechaFin'], 'fecha_timbrado_solo_fecha');

        $sucursal = $options['sucursal'] ? " AND sucursal = {$options['sucursal']} " : null;

        $query = "SELECT v.*,

                    fxGetStatusName(status,'Factura')as statusName,

                    fxGetSucursalName(sucursal) as sucursalName,

                    c.razon_social

                    FROM view_facturas_timbradas v

                    inner join clientes c on c.id = v.id_cliente

                    WHERE 1=1

                    AND (ticket != '' AND ticket != 0 AND ticket is not null)

                    $fecha

                    $sucursal

                    ORDER BY serie ASC,folio DESC";



        $result = $this->query($query);



        if ($result->num_rows > 0) {
            $result = $this->resultToArray($result);

            $ventasGeneradas = 0;

            $ventasMonto = 0;



            foreach ($result as $row) {
                $ventasGeneradas++;

                $ventasMonto += $row['total'];
            }

            return array(

                'data'=>$result,

                'ventasGeneradas'=>$ventasGeneradas,

                'ventasMonto'=>number_format($ventasMonto, 2)

            );
        } else {
            return array(array('Resultado'),array('No se encontraron resultados.'));
        }
    }



    public function createFilterFecha($fechaInicio, $fechaFin, $campoFecha = null)
    {
        $fecha = null;
        $tools = new Tools();
        if ($fechaInicio!=null) {
            $fechaInicio = $tools->setFormatDateToDB($fechaInicio);
            if ($fechaFin!=null) {
                $fechaFin = $tools->setFormatDateToDB($fechaFin);
                $fecha .=" AND $campoFecha BETWEEN '{$fechaInicio}' AND '{$fechaFin}' ";
            } else {
                $fecha .=" AND $campoFecha BETWEEN '{$fechaInicio}' AND '{$fechaInicio}' ";
            }
        } elseif ($fechaFin!=null) {
            $fecha .=" AND $campoFecha BETWEEN '{$fechaFin}' AND '{$fechaFin}' ";
        }
        return $fecha;
    }


    public function getEstadoDeCuenta(array $options)
    {
        if ($options['cliente'] != null) {
            $cliente = implode(',', $options['cliente']);
        }

        $fecha = $this->createFilterFecha($options['fechaInicio'], $options['fechaFin'], "DATE_FORMAT(convert(substring(substr(v.fecha_timbrado,1,10),1,10),date),'%Y-%m-%d')");
        $cliente = $options['cliente'] ? " AND find_in_set(v.id_cliente,'$cliente') " : null;

        $query = "SELECT
                    c.id as id_cliente,
                    c.codigo,
                    c.rfc,
                    c.razon_social,
                    c.nombre_contacto,
                    c.telefono,
                    c.email,
                    v.tipo_de_cambio,
                    DATE_FORMAT(convert(substring(substr(v.fecha_timbrado,1,10),1,10),date),'%d/%m/%Y') as fecha,
                    v.id as id_factura,
                    v.serie,
                    v.folio,
                    v.total,
                    v.saldo_pendiente,
                    fxGetStatusName(v.`status`,'Factura')as statusName,
                    fxGetSucursalName(v.sucursal) as sucursalName
                    from facturas v
                    join clientes as c on v.id_cliente = c.id
                    WHERE
                    (v.status = 2 OR v.tipo_documento = 'CG')
                    $fecha
                    $cliente
                    ORDER BY v.serie ASC,v.folio DESC ";


        $result = $this->query($query);

        if ($result->num_rows > 0) {
            $result = $this->resultToArray($result);
            $estadoDeCuena = array();
            $repoPagos = new PagoRepository();

            foreach ($result as $row) {
                $datosCliente = array(
                   'nombre'=>$row['razon_social'],
                   'rfc'=>$row['rfc'],
                   'contacto'=>$row['nombre_contacto'],
                   'telefono'=>$row['telefono'],
                   'email'=>$row['email'],
               );
                unset($row['nombre'],$row['rfc'],$row['contacto'],$row['telefono'],$row['email']);

                $pagos = $repoPagos->getPagosByIdFactura($row['id_factura']);
                $row['pagos'] = $pagos;
                $estadoDeCuena[$row['id_cliente']]['datosCliente'] = $datosCliente;
                $estadoDeCuena[$row['id_cliente']]['facturas'][$row['id_factura']] = $row;
            }

            return array(
                'data'=>$estadoDeCuena,
            );
        } else {
            return null;
        }
        return null;
    }


    public function _gadget_facturasPendientesDePago()
    {
        $query = "SELECT F.id, F.creado_fecha, F.serie, F.folio, C.razon_social, F.total, F.saldo_pendiente,F.`status`,F.enviado FROM facturas AS F
                    INNER JOIN clientes AS C ON F.id_cliente = C.id
                    WHERE F.saldo_pendiente > 0 and F.tipo_documento = 'I' AND (F.`status`=1 OR (F.enviado = 0 AND F.`status`=2) OR (F.saldo_pendiente > 0 AND F.`status`=2))
                    ORDER BY F.id ASC LIMIT 20";
        $result = $this->query($query);
        //echo "<pre>";  var_dump($result); echo "</pre>"; exit;
        return $this->resultToArray($result);
        //echo "<pre>";        print_r($this->resultToArray($result)); echo "</pre>"; exit;
        if ($result->num_rows > 0) {
            $result = $this->resultToArray($result);
            foreach ($result as $row) {
                $facturas = array(
                   'id'=>$row['id'],
                   'creado_fecha'=>$row['creado_fecha'],
                   'serie'=>$row['serie'],
                   'folio'=>$row['folio'],
                   'razon_social'=>$row['razon_social'],
                   'total'=>$row['total'],
                   'saldo_pendiente'=>$row['saldo_pendiente'],
                   'status'=>$row['status'],
                   'enviado'=>$row['enviado'],
               );
                unset($row['id'],$row['creado_fecha'],$row['serie'],$row['folio'],$row['razon_social'],$row['total'],$row['saldo_pendiente'],$row['status'],$row['enviado']);
            }

            //echo "<pre>";        print_r($facturas); echo "</pre>"; exit;
            return array(
                'data'=>$facturas,
            );
        } else {
            return null;
        }
        return null;
    }

    public function _gadget_facturasPendientesDePago_cantidad()
    {
    }

    public function _gadget_ventasTotalesDelMes()
    {
        $query = "SELECT SUM(total) AS total_ventas FROM facturas WHERE tipo_documento = 'I' AND `status`=2 AND MONTH(fecha_timbrado)=MONTH(CURRENT_DATE()) AND YEAR(fecha_timbrado)=YEAR(CURRENT_DATE())";
        $result = $this->query($query);

        //echo "<pre>";        print_r($result->row['total']); echo "</pre>"; exit;

        if ($result->num_rows > 0) {
            $result = $this->resultToArray($result);
            return $result[0];
        }

        return null;
    }

    public function _gadget_pagosTotalesDelMes()
    {
        $query = "SELECT SUM(monto) AS monto FROM pagos WHERE tipo_documento = 'P' AND `status`<=2 AND month(fecha)=MONTH(CURRENT_DATE())  AND YEAR(fecha)=YEAR(CURRENT_DATE())";
        $result = $this->query($query);

        //echo "<pre>";        print_r($result->row['total']); echo "</pre>"; exit;

        if ($result->num_rows > 0) {
            $result = $this->resultToArray($result);
            return $result[0];
        }

        return null;
    }

    public function _gadget_pagosTotalesDelEjercicio()
    {
        //$query = "SELECT SUM(monto) AS monto FROM pagos WHERE tipo_documento = 'P' AND `status`<=2 AND YEAR(fecha)=YEAR(CURRENT_DATE())";
        /*
         * Aqui tengo un error, devuelvo todo lo pagado en el a�o, pero lo que nos interesa saber es el monto que esta pendiente por cobrar en el a�o
         * nota: el nombre de la funcion no corresponde al lo que devuelve, asi lo deje.
         */
        $query = "SELECT SUM(saldo_pendiente) AS monto FROM facturas WHERE tipo_documento = 'I' AND `status`<=2 AND YEAR(creado_fecha)=YEAR(CURRENT_DATE())";
        $result = $this->query($query);

        //echo "<pre>";        print_r($result->row['total']); echo "</pre>"; exit;

        if ($result->num_rows > 0) {
            $result = $this->resultToArray($result);
            return $result[0];
        }

        return null;
    }

    public function _gadget_ventasTotalesDelEjercicio()
    {
        $query = "SELECT SUM(total) AS total_ventas FROM facturas WHERE tipo_documento = 'I' AND `status`=2 AND year(fecha_timbrado)=YEAR(CURRENT_DATE())";
        $result = $this->query($query);

        //echo "<pre>";        print_r($result->row['total']); echo "</pre>"; exit;

        if ($result->num_rows > 0) {
            $result = $this->resultToArray($result);
            return $result[0];
        }

        return null;
    }

    public function _gadget_nombreEmpresa()
    {
        $query = "SELECT razon_social FROM empresa LIMIT 1";
        $result = $this->query($query);

        //echo "<pre>";        print_r($result->row['total']); echo "</pre>"; exit;

        if ($result->num_rows > 0) {
            $result = $this->resultToArray($result);
            return $result[0];
        }

        return null;
    }

    public function _gadget_ventas()
    {
        //$months = 12;
        $months = array('Ene','Feb','Mar','Abr','May','Jun','Jul','Ago','Sep','Oct','Nov','Dic');
        $aactual = date('Y');
        $aanterior = $aactual - 1;
        $data = array();
        $data2 = array();
        $data_formateado = array();
        //echo "<pre>";         echo $aactual; echo '-'.$aanterior; echo "</pre>"; exit;
        for ($i=1;$i<=12;$i++) {
            $query = "SELECT IFNULL(SUM(total),0) AS total FROM facturas WHERE `status`='2' AND MONTH(fecha_timbrado)=".$i." AND YEAR(fecha_timbrado)=".$aactual."";
            $result = $this->query($query);
            if ($result->num_rows > 0) {
                $result = $this->resultToArray($result);
                $data[$i] = $result[0];
            }
        }

        for ($j=1;$j<=12;$j++) {
            $query = "SELECT IFNULL(SUM(total),0) AS total FROM facturas WHERE `status`='2' AND MONTH(fecha_timbrado)=".$j." AND YEAR(fecha_timbrado)=".$aanterior."";
            $result = $this->query($query);
            if ($result->num_rows > 0) {
                $result = $this->resultToArray($result);
                $data2[$j] = $result[0];
                //$i++;
            }
        }

        //echo "<pre>";var_dump($data); echo "</pre>"; exit;

        $data_formateado = "{ month: 'Ene',   value:".number_format((float)$data[1]['total'], 2, '.', '')." , 'anterior': ".number_format((float)$data2[1]['total'], 2, '.', ''). " },
                        { month: 'Feb', value:".number_format((float)$data[2]['total'], 2, '.', '').", 'anterior':".number_format((float)$data2[2]['total'], 2, '.', '')." },
                        { month: 'Mar',   value:".number_format((float)$data[3]['total'], 2, '.', '').", 'anterior':".number_format((float)$data2[3]['total'], 2, '.', '')." },
                        { month: 'Abr',   value:".number_format((float)$data[4]['total'], 2, '.', '').", 'anterior':".number_format((float)$data2[4]['total'], 2, '.', '')." },
                        { month: 'May',    value:".number_format((float)$data[5]['total'], 2, '.', '').", 'anterior':".number_format((float)$data2[5]['total'], 2, '.', '')." },
                        { month: 'Jun',   value:".number_format((float)$data[6]['total'], 2, '.', '').", 'anterior':".number_format((float)$data2[6]['total'], 2, '.', '')." },
                        { month: 'Jul',   value:".number_format((float)$data[7]['total'], 2, '.', '').", 'anterior':".number_format((float)$data2[7]['total'], 2, '.', '')." },
                        { month: 'Ago',  value:".number_format((float)$data[8]['total'], 2, '.', '').", 'anterior':".number_format((float)$data2[8]['total'], 2, '.', '')." },
                        { month: 'Sep',  value:".number_format((float)$data[9]['total'], 2, '.', '').", 'anterior':".number_format((float)$data2[9]['total'], 2, '.', '')." },
                        { month: 'Oct',     value:".number_format((float)$data[10]['total'], 2, '.', '').", 'anterior':".number_format((float)$data2[10]['total'], 2, '.', '')." },
                        { month: 'Nov',   value:".number_format((float)$data[11]['total'], 2, '.', '').", 'anterior':".number_format((float)$data2[11]['total'], 2, '.', '')." },
                        { month: 'Dic',   value:".number_format((float)$data[12]['total'], 2, '.', '').", 'anterior':".number_format((float)$data2[12]['total'], 2, '.', '')." },";
        //echo "<pre>";echo $data_formateado; echo "</pre>"; exit;
        return $data_formateado;
    }
}
