<?php
class SettingsRepository extends EntityRepository
{
    private $table = 'settings';
    
    private $options = array();
    
    public function __construct()
    {
        $this->setOptions($this->getListSettings());
    }
    
    public function setOptions($options)
    {
        $this->options = $options;
    }
    
    public function _get($setting)
    {
        if (isset($this->options[$setting])) {
            return $this->options[$setting];
        }
        return null;
    }

    public function save(array $data, $table = null)
    {
        return parent::save($data, $this->table);
    }
    
    public function delete($id, $table = null)
    {
        return parent::delete($id, $this->table);
    }

    public function update($id, $data, $table = null)
    {
    }

    public function updateKey($key, $value, $desc = null, $table) {
        $k = mysqli_real_escape_string(DataBase::getInstance(), $key);
        $v = mysqli_real_escape_string(DataBase::getInstance(), $value);
        $d = (!empty($desc)) ? mysqli_real_escape_string(DataBase::getInstance(), $desc):"";

        $query  = " UPDATE settings "
               . " SET `value` = '{$v}'";
        $query .= (!empty($d)) ? " ,`description` = '$d' ":"";
        $query .= " WHERE `key` = '$k' ";
        
        return $this->query($query);
    }

    public function getById($id, $table = null, $selectAux = null)
    {
        return parent::getById($id, $this->table, $selectAux);
    }
    
    public function isRFCGenerico($rfc)
    {
        $query = "SELECT id FROM {$this->table} WHERE `key` = 'rfc_generico' AND value = '$rfc'";
        $result = $this->query($query);
        
        if ($result->num_rows > 0) {
            return true;
        }
        return null;
    }
    
    public function getListSettings()
    {
        $query = "SELECT * FROM settings";
        $result = $this->query($query);
        
        if ($result->num_rows > 0) {
            $result = $this->resultToArray($result);
            $settings = array();
            foreach ($result as $row) {
                $settings[$row['key']] = $row['value'];
            }
            
            return $settings;
        }
    }
}
