<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

class SucursalRepository extends EntityRepository
{
    private $table = 'sucursales';
    private $certificado = null;
    private $no_certificado = null;
    private $fi_certificado = '0000-00-00';
    private $ff_certificado = '0000-00-00';
    private $images = null;
    private $options_image = array(
        'allowedExtensions'=>array('image/jpg','image/jpeg','image/png','image/gif'),
        'maxFileSizeAllowed'=>16384
    );

    private $options_files = array(
        'allowedExtensions'=>array('key','cer'),
        'maxFileSizeAllowed'=>1000000,
        'pathToSave'=>PATH_SAT_DOCS
    );

    public $flashmessenger = null;

    public function __construct()
    {
        if (!$this->flashmessenger instanceof FlashMessenger) {
            $this->flashmessenger = new FlashMessenger();
        }
    }

    public function _getTranslation($text)
    {
        return $this->flashmessenger->_getTranslation($text);
    }

    private $options = array(
        'nombre'=>null,
        'no_certificado'=>null,
        'fi_certificado'=>null,
        'ff_certificado'=>null,
        'certificado'=>null,
        'calle'=>null,
        'numero_exterior'=>null,
        'numero_interior'=>null,
        'colonia'=>null,
        'ciudad'=>null,
        'estado'=>null,
        'pais'=>'MEXICO',
        'codigo_postal'=>null,
        'nombre_contacto'=>null,
        'telefono'=>null,
        'email'=>null,
        'serie_de_facturacion'=>null,
        'serie_de_notas_de_credito'=>null,
        'serie_de_pago'=>null,
        'serie_de_cuenta_de_gastos'=>null,
        'rango_de_facturacion'=>null,
        'status'=>null,
        'certificado_independiente'=>null,
        'archivos'=>null,
        'contrasena'=>null
    );

    private $options_aux = array(
        'logo'=>null,
        'image_type'=>null
    );

    public function setOptions($data)
    {
        foreach ($this->options as $option => $value) {
            if (isset($data[$option])) {
                $this->options[$option] = $data[$option];
            }
        }

        foreach ($this->options_aux as $option => $value) {
            if (isset($data[$option])) {
                $this->options_aux[$option] = $data[$option];
            }
        }
    }

    public function getOptions()
    {
        return $this->options;
    }

    public function getNombre()
    {
        return $this->options['nombre'];
    }

    public function getLogo()
    {
        return $this->options_aux['logo'];
    }

    public function getImageType()
    {
        return $this->options_aux['image_type'];
    }

    public function getRazonSocial()
    {
        return $this->options['racon_social'];
    }

    public function getRFC()
    {
        return $this->options['rfc'];
    }

    public function getCalle()
    {
        return $this->options['calle'];
    }

    public function getNumExterior()
    {
        return $this->options['numero_exterior'];
    }

    public function getNumInterior()
    {
        return $this->options['numero_interior'];
    }

    public function getCalleNum()
    {
        $direccion = $this->getCalle().' '.$this->getNumExterior();
        if (trim($this->getNumInterior())!='') {
            $direccion .= ' No. INT. '.$this->getNumInterior();
        }
        return $direccion;
    }

    public function getColonia()
    {
        return $this->options['colonia'];
    }

    public function getCiudad()
    {
        return $this->options['ciudad'];
    }

    public function getEstado()
    {
        return $this->options['estado'];
    }

    public function getCodigoPostal()
    {
        return $this->options['codigo_postal'];
    }

    public function getTable()
    {
        return $this->table;
    }

    public function save(array $data, $table = null)
    {
        unset($data['certificado'],$data['no_certificado'],$data['fi_certificado'],$data['ff_certificado']);
        $data['nombre'] = trim(($data['nombre']));
        $data['calle'] = trim(($data['calle']));
        $data['numero_interior'] = trim(($data['numero_interior']));
        $data['numero_exterior'] = trim(($data['numero_exterior']));
        $data['colonia'] = trim(($data['colonia']));

        $files = $data['archivos'];
        $contrasena = $data['contrasena'];
        unset($data['archivos'],$data['contrasena']);

        $rs = parent::save($data, $this->table);
        if ($rs) {
            $insertId = $this->getInsertId();
            $this->saveImage($insertId);

            if ($data['certificado_independiente'] == 'Si' && $files['file_cer']['name']!='') {
                $empresa = new EmpresaRepository();
                $empresa->setOptions($empresa->getById(1));

                if (!is_dir($this->options_files['pathToSave'].$empresa->getRFC()."/{$insertId}/")) {
                    mkdir($this->options_files['pathToSave'].$empresa->getRFC()."/{$insertId}/", 0777, true);
                }

                $this->saveFiles($files, $contrasena, $insertId, $empresa->getRFC());
                $this->updateInfoCertificados($insertId);
            }
        }
        return $rs;
    }

    public function update($id, $data, $table = null)
    {
        unset($data['certificado'],$data['no_certificado'],$data['fi_certificado'],$data['ff_certificado']);
        $data['nombre'] = trim(($data['nombre']));
        $data['calle'] = trim(($data['calle']));
        $data['numero_interior'] = trim(($data['numero_interior']));
        $data['numero_exterior'] = trim(($data['numero_exterior']));
        $data['colonia'] = trim(($data['colonia']));

        $files = $data['archivos'];
        $contrasena = $data['contrasena'];

        if ($data['certificado_independiente'] == 'Si' && $data['archivos']['file_cer']['name']!='') {
            $empresa = new EmpresaRepository();
            $empresa->setOptions($empresa->getById(1));

            if (!is_dir($this->options_files['pathToSave'].$empresa->getRFC()."/{$id}/")) {
                mkdir($this->options_files['pathToSave'].$empresa->getRFC()."/{$id}/", 0777, true);
            }

            $this->saveFiles($files, $contrasena, $id, $empresa->getRFC());
            $this->updateInfoCertificados($id);
        }

        unset($data['archivos'],$data['contrasena']);
        $rs = parent::update($id, $data, $this->table);
        if ($rs) {
            $this->saveImage($id);
        }

        return true;
    }

    public function delete($id, $table = null)
    {
        return parent::delete($id, $this->table);
    }

    public function saveFiles($files, $pass, $idSucursal, $rfcEmpresa)
    {
        $file = new UploadFile();
        $file->setAllowedExtensions($this->options_files['allowedExtensions']);
        $file->setMaxFileSizeAllowed($this->options_files['maxFileSizeAllowed']);
        $file->setTempFolder($this->options_files['pathToSave'].$rfcEmpresa."/$idSucursal/");

        $rsUpload = $file->uploadFile($files['file_key'], null, 'keyPem');
        $rsUpload = $file->uploadFile($files['file_cer'], null, 'certificado');

        if (!$rsUpload) {
            $this->flashmessenger->addMessage(array('info'=>$file->getMessageError()));
            return null;
        }

        $certificados = new Certificados($file->getTempFolder());
        $rsCer = $certificados->generaCerPem('certificado.cer');
        $rsKey = $certificados->generaKeyPem('keyPem.key', $pass);

        if ($rsCer !== null && $rsKey !== null) {
            if ($certificados->pareja()) {
                $this->no_certificado = $certificados->getSerialCert();
                $this->fi_certificado = $certificados->getFechaInicio();
                $this->ff_certificado = $certificados->getFechaVigencia();
                $this->certificado = $certificados->getStringCertificado('certificado.cer');
            } else {
                $this->no_certificado = '';
                $this->fi_certificado = '0000-00-00';
                $this->ff_certificado = '0000-00-00';
                $this->certificado = '';
            }
            return true;
        }
        return null;
    }

    public function updateInfoCertificados($id)
    {
        $fields = array(
            'no_certificado'=>$this->no_certificado,
            'fi_certificado'=>$this->fi_certificado,
            'ff_certificado'=>$this->ff_certificado,
            'certificado'=>$this->certificado,
        );

        return parent::update($id, $fields, $this->table);
    }

    public function getById($id, $table = null, $selectAux = null)
    {
        $query = "SELECT s.*,"
                . "f.serie as serieCuentaDeGastosName,"
                . "l.image as logo,"
                . "l.type as image_type "
                . "FROM sucursales s "
                . "LEFT JOIN logos l ON s.id = l.id_sucursal "
                . "LEFT JOIN facturas_series_folios f ON f.id = s.serie_de_cuenta_de_gastos "
                . "WHERE s.id = '$id' ";
        $result = $this->query($query);

        if ($result->num_rows > 0) {
            $result = $this->resultToArray($result);
            return $result[0];
        }
        return null;
    }


    public function isUsedInRecord($id, array $buscarEn = null, $andWhere = null)
    {
        return null;
    }

    public function getListSelectSucursales($stringIdSucursales = null)
    {
        if ($stringIdSucursales != null && trim($stringIdSucursales != '')) {
            $stringIdSucursales = " AND find_in_set(id,'$stringIdSucursales')";
        }

        $select = "SELECT * FROM $this->table WHERE 1 = 1 $stringIdSucursales";
        $result = $this->query($select);

        if ($result) {
            $array = array();
            while ($row = $result->fetch_assoc()) {
                $array[$row['id']] = $row['nombre'];
            }

            return $array;
        }
        return null;
    }

    public function getListSucursales()
    {
        $select = "SELECT *,"
                . "fxGetSerieDeFacturacionName(serie_de_facturacion)as serieName,"
                . "fxGetStatusName(status,'Sucursal')as status "
                . "FROM $this->table "
                . "WHERE id > 1 ";
        $result = $this->query($select);

        if ($result) {
            return $this->resultToArray($result);
        }
        return null;
    }

    public function getListEstados()
    {
        $query = "SELECT * FROM estados ORDER BY id ASC";
        $result = $this->query($query);

        if ($result) {
            $array = array();
            while ($row = $result->fetch_object()) {
                $array[$row->id] = $row->nombre;
            }

            return $array;
        }

        return null;
    }

    public function setImage($images)
    {
        $this->images = $images;
    }

    public function saveImage($idSucursal)
    {
        if ($this->images['name'] != '') {
            if (in_array($this->images['type'], $this->options_image['allowedExtensions']) && $this->images['size'] <= $this->options_image['maxFileSizeAllowed'] * 1024) {
                $imagen_temporal = $this->images['tmp_name'];

                // Tipo de archivo
                $tipo = $this->images['type'];
                $size = $this->images['size'];

                // Leemos contenido y escapamos caracteres especiales
                $data = file_get_contents($imagen_temporal);
                //$data = addslashes($data);

                $array = array(
                    'id_sucursal'=>$idSucursal,
                    'image'=>$data,
                    'type'=>$tipo,
                    'size'=>$size
                );

                $query = "SELECT * FROM logos WHERE id_sucursal = '$idSucursal'";
                $result = $this->query($query);
                if ($result->num_rows > 0) {
                    $result = $result->fetch_object();
                    unset($_SESSION['picture_logo']);

                    parent::update($result->id, $array, 'logos');
                } else {
                    parent::save($array, 'logos');
                }
            } else {
                $this->flashmessenger->addMessage(array(
                'danger'=>$this->_getTranslation("Formato de archivo no permitido o excede el tamaño límite de {$this->options_image['maxFileSizeAllowed']} Kbytes.")));
                return null;
            }
        }
        return true;
    }

    public function getImages($idSucursal)
    {
        $query = "SELECT * FROM logos WHERE id_sucursal = '$idSucursal'";
        $result = $this->query($query);

        if ($result->num_rows > 0) {
            return $this->resultToArray($result);
        }
        return null;
    }
}
