<?php

/**

 * Description of Usuario

 *

 * @author carlos

 */



class TicketEntity Extends TicketRepository{

    private $options = array(

        'sucursal'=>null,

        'fecha'=>null,

        'ticket'=>null,

        'total'=>null,

        'forma_de_pago'=>null,        

        'num_cuenta_pago'=>null,

        'status'=>null

    );

    

    private $options_factura = array(    

        'sucursal'=>null,

        'ticket'=>null,

        'total'=>null,

        'forma_de_pago'=>null,        

        'num_cuenta_pago'=>null,

        'status'=>'1',

        'tipo_documento'=>'I',

        'metodo_de_pago'=>'PUE', 

        'uso_cfdi'=>'G03',

        'moneda'=>'MXN',

        'tipo_de_cambio'=>'1.0',

        'id_cliente'=>null,  

        'subtotal'=>null,   

        'descuento'=>'0',

        'total_impuestos_trasladados'=>null,

        'total_impuestos_retenidos'=>'0',

        'detalles_impuestos_aplicables'=>null

    );

    

    public function setOptions($data){

      foreach ($this->options as $option => $value){

          if(isset($data[$option])){

            $this->options[$option] = $data[$option];

          }

      }

    }

    

    public function setOptionsFactura($data){

      foreach ($this->options_factura as $option => $value){

          if(isset($data[$option])){

            $this->options_factura[$option] = $data[$option];

          }

      }

    }

  

    public function getOptions(){

        return $this->options;

    }

    

    public function getOptionsFactura(){

        return $this->options_factura;

    }

    

    public function getDatosTicket($options = null) {

        return parent::getDatosTicket($this->options);

    }

    

    public function getIdSucursalParaSistema($sucursal){

        #$sucursalesEnCarls = array('2001'=>'Reynosa');

        #$sucursalesEnSistema = array('1'=>'7869 Hidalgo','2'=>'7870 Morelos','3'=>'8501 Matamoros','4'=>'8070 Periferico Exterior','5'=>'7942 Aeropuerto','6'=>'7923 Periferico Interior','7'=>'7879 Reforma');

        

        $sucursales = array(

            '2001'=>'1', //el id es el que tiene asginado en el select y el 1 en el sistema

            '2'=>'4',

            '3'=>'8',

            '4'=>'2',

            '5'=>'5',

            '6'=>'6',

            '7'=>'7',

        );

        

        return $sucursales[$sucursal];

    }

    

    public function facturarTicket($data){    

        $factura = new FacturaEntity();

        $impuestosLista = $factura->getListImpuestos();

        $impuesto = $impuestosLista[1];

        

        $producto = new ProductoEntity();
        $producto = $producto->getById(1);        

        $cliente = new ClienteEntity();
        $cliente->setOptions($data);        

        /* Agregar o Actualizar informacion de cliente*/

        if(trim($data['id_cliente']) != '' && $data['id_cliente'] != null ){

            $cliente->update($data['id_cliente'], $cliente->getOptions());

            $idCliente = $data['id_cliente'];            

        }else{

            $cliente->save($cliente->getOptions());
            $idCliente = $cliente->getInsertId();
        }



        $data['id_cliente'] = $idCliente;        
        $data['sucursal'] = $this->getIdSucursalParaSistema($data['sucursal']);        

        /*Preparar informacion para Factura*/        
        #$data = Datos que se ingresan los cliente que estan facturando ticket
        #fecha,sucursal,id_ticket,total_ticket,forma_de_pago,num_cuenta_pago
        $this->setOptionsFactura($data);        
        $datosFactura = $this->getOptionsFactura(); 
        

        # $datosTicketFromDB = Datos que se almacena cuando se genera la venta en tienda  
        $datosTicketFromDB = $this->getById($data['id_ticket_table']);        
        $datosFactura['subtotal'] = $datosTicketFromDB['subtotal'];
        $datosFactura['total'] = $datosTicketFromDB['neto'];
        $datosFactura['total_impuestos_trasladados'] = $datosTicketFromDB['iva'];    

        #Impuestos aplicables totales
        $impuestosAplicables = array('Trasladable'=>array(),'Retenible'=>array());
        $impuestosAplicables['Trasladable'][1] = array(
            'Importe'=>$datosTicketFromDB['iva'],
            'nombre'=>$impuesto['impuesto'],
            'descripcion'=>$impuesto['descripcion'],
            'Impuesto'=>$impuesto['clave'],
            'TipoFactor'=> $impuesto['tipo_factor'],
            'TasaOCuota'=>$impuesto['tasa_cuota']
        );        

        $datosFactura['detalles_impuestos_aplicables'] = serialize($impuestosAplicables);        

        #Guardar Factura
        $repo = new EntityRepository();
        $settings = new SettingsRepository();        

        $datosFactura['version_cfdi'] = $settings->_get('version_cfdi');
        $datosFactura['status'] = '1';               

        $repo->startTransaction();
        $rs = $repo->save($datosFactura, 'facturas');   
        $idFactura = $repo->getInsertId();        

        if($rs){
            #Guardar Factura Detalles

            $impuestosAplicables = array('Trasladable'=>array(),'Retenible'=>array());
            $impuestosAplicables['Trasladable'][1] = array(
                'Importe'=>$datosTicketFromDB['iva'],
                'nombre'=>$impuesto['impuesto'],
                'descripcion'=>$impuesto['descripcion'],
                'Base'=>$datosFactura['subtotal'],
                'Impuesto'=>$impuesto['clave'],
                'TipoFactor'=> $impuesto['tipo_factor'],
                'TasaOCuota'=>$impuesto['tasa_cuota']
            );
            
            $datosDetalleFactura = array(

                'id_factura'=>$idFactura,

                'id_producto'=>$producto['id'],

                'nombre'=>$producto['nombre'],

                'descripcion'=>'',

                'cantidad'=>'1',

                'precio_unitario'=>$datosFactura['subtotal'],

                'descuento_detalle'=>'0',

                'descuento_monto'=>'0',

                'importe'=>$datosFactura['subtotal'],

                'impuestos_incluidos'=>$producto['impuestos_incluidos'],

                'impuestos'=>$producto['impuestos'],

                'impuestos_aplicables' => serialize($impuestosAplicables)

            );   



            $rs = $repo->save($datosDetalleFactura, 'facturas_detalles');

            if(!$rs){

                $repo->rollback();

                return null;

            }

            

            $repo->commit();

            return $idFactura;

        }else{

            $repo->rollback();

            return null;

        }      

        

        return null;

    }

  

    public function getTable(){

        return $this->table;

    }

}