<?php
class TicketEntityRepository {
    private $id;
    private $lastInsertId = null;
    
    protected $_options = array();

    public function setId($id) {
        $this->id = $id;
    }

    public function getId() {
        return $this->id;
    }
    
    public function delete($id,$table){
        $select = "DELETE  FROM $table WHERE id = $id";
        $result = $this->query($select);
        
        if($result){
            return true;
        }        
        return null;
    }

    public function save(array $data, $table) {
        $select = "INSERT INTO $table";
        $fields = "";
        $values = "";
        foreach ($data as $key => $value) {           
            if(!is_array($value)){
                $fields .= "$key,";
                $value = mysqli_real_escape_string(DBExternalServer::getInstance(),$value);
                $values .= "'$value',";
            }else{         
                $fields .= "{$value['key']},";
                $value['value'] = mysqli_real_escape_string(DBExternalServer::getInstance(),$value['value']);
                $values .= "{$value['value']},";
            }            
            
        }
        $fields = substr($fields, 0, strlen($fields) - 1);
        $values = substr($values, 0, strlen($values) - 1);

        $select = $select . "(" . $fields . ") VALUES (" . $values . ")";
 
        return $this->query($select);        
    }
    
    public function getInsertId(){
        return DBExternalServer::getInsertId();
    }
    
    public function setLastInsertId($id){
        $this->lastInsertId = $id;
    }
    
    public function getLastInsertId(){
        return $this->lastInsertId;
    }

    public function update($id, $fields, $table) {
        //var_dump($fields);
        $select = "UPDATE $table SET ";
        foreach ($fields as $key => $value) {
            if(!is_array($value)){
                $value = mysqli_real_escape_string(DBExternalServer::getInstance(),$value);
                $select .= "$key = '$value',";
            }else{                
                $value['value'] = mysqli_real_escape_string(DBExternalServer::getInstance(),$value['value']);
                $select .= "{$value['key']} = {$value['value']},";
            }            
        }

        $select = substr($select, 0, strlen($select) - 1);
        $select .= " WHERE id = $id";
        //echo $select;exit;
        return  $this->query($select);
    }
    
    public function updateString($fields,$where,$table) {
        $select = "UPDATE $table SET ";
        foreach ($fields as $key => $value) {
            $select .= "$key = '$value',";
        }

        $select = substr($select, 0, strlen($select) - 1);
        $select .= " WHERE ".$where;
        return  $this->query($select);
    }

    public function getById($id, $table,$selectAux = null) {
        $select = "SELECT * ";
        if($selectAux){$select .= ",$selectAux";}
        
        $select = "$select FROM $table WHERE id = '$id'";
        $result = $this->query($select);

        if ($result->num_rows>0) {
            $set = $this->resultToArray($result);
            return $set[0];
        }

        return null;
    }
    
    public function isUsedInRecord($id,array $buscarEn, $andWhere = null){
        foreach($buscarEn as $key => $value){
            $select = "SELECT id FROM $key WHERE $value = '$id' $andWhere limit 1";
            $result = $this->query($select);
            if($result->num_rows > 0){
                $result = $result->fetch_object();
                return array('id'=>$result->id,'table'=>$key);
            }
        }
        
        return null;
    }
    
    public function query($query){
        $result = DBExternalServer::getInstance()->execute($query);
        return $result;
    }
    
    public function resultToArray($result){
        for ($set = array(); $row = $result->fetch_assoc(); $set[] = $row);
  
        return $set;
    }
    
    public function startTransaction(){
        return $this->query('START TRANSACTION');
    }
    
    public function commit(){
        return $this->query('COMMIT');
    }
    
    public function rollback(){
        return $this->query('ROLLBACK');
    }
}

class DBExternalServer extends mysqli{  
    static private $instance;
    private $MAIN_DB_HOSTNAME = "localhost";
    private $MAIN_DB_NAME = "lunisapp_cfdi2_fcb";
    private $MAIN_DB_USERNAME = "lunisapp_factura310N";
    private $MAIN_DB_PASSWORD = "Lun1s0905+*13+2021#";
    
    public static $a_especial_chars = array(
        'À' => 'a', '?' => 'a', 'Â' => 'a', 'Ã' => 'a', 'Ä' => 'a', 'Å' => 'a',
        'Æ' => 'a', 'Ç' => 'c', 'È' => 'e', 'É' => 'e', 'Ê' => 'e', 'Ë' => 'e',
        'Ì' => 'i', '?' => 'i', 'Î' => 'i', '?' => 'i', '?' => 'd', 'ñ' => 'n',
        'Ò' => 'o', 'Ó' => 'o', 'Ô' => 'o', 'Õ' => 'o', 'Ö' => 'o', 'Ø' => 'o',
        'Ù' => 'u', 'Ú' => 'u', 'Û' => 'u', 'Ü' => 'u', '?' => 'y', 'Þ' => 'b',
        'ß' => 's', 'à' => 'a', 'á' => 'a', 'â' => 'a', 'ã' => 'a', 'ä' => 'a',
        'å' => 'a', 'æ' => 'a', 'ç' => 'c', 'è' => 'e', 'é' => 'e', 'ê' => 'e',
        'ë' => 'e', 'ì' => 'i', 'í' => 'i', 'î' => 'i', 'ï' => 'i', 'ð' => 'd',
        'Ñ' => 'n', 'ò' => 'o', 'ó' => 'o', 'ô' => 'o', 'õ' => 'o', 'ö' => 'o',
        'ø' => 'o', 'ù' => 'u', 'ú' => 'u', 'û' => 'u', 'ý' => 'y', 'ý' => 'y',
        'þ' => 'b', 'ÿ' => 'y', '\'' => '', '%' => '', '"' => ''
    );

    const WARNING = 1;
    const STOP_CRITICAL = 2;

    public static function getInstance() {
        if (self::$instance == null) {
            self::$instance = new self();
        } 
        return self::$instance;
    }
    
    static function getInsertId(){
        return self::$instance->insert_id;
    }

    private function __construct($db = null) {
        parent::__construct($this->MAIN_DB_HOSTNAME, $this->MAIN_DB_USERNAME, $this->MAIN_DB_PASSWORD, $this->MAIN_DB_NAME);
        
        if ($this->connect_error) {
            $error = 'Oops... algo salio mal al intentar conectarse al Servidor principal: ' . $this->connect_error;
            $this->getErrorMessage($error);
        }
        return $this;
    }
    
    public function execute($query) {
        $r = $this->query($query);
        if ($r) {
          return $r;
        } else {
            $error = "Al intentar <b>$query</b> se produjo: <i>$this->error</i>";
            $this->getErrorMessage($error);
        }
    }
    
    public function getErrorMessage($error) {
        return '<span class="error_database">' . $error . '</span>';
    }
}



