<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

class UsuarioRepository extends EntityRepository
{
    private $table = 'usuarios';
    
    private $options = array(
        'usuario'=>null,
        'contrasena'=>null,
        'nombre'=>null,
        'apellido'=>null,
        'telefono'=>null,
        'email'=>null,
        'sucursal'=>null,
        'role'=>null,
        'status'=>null,
    );
    
    public function setOptions($data)
    {
        foreach ($this->options as $option => $value) {
            if (isset($data[$option])) {
                $this->options[$option] = $data[$option];
            }
        }
    }
  
    public function getOptions()
    {
        return $this->options;
    }
    
    public function getUsuario()
    {
        return $this->options['user'];
    }
    
    public function getContrasena()
    {
        return $this->options['contrasena'];
    }
    
    public function getNombre()
    {
        return $this->options['nombre'];
    }
    
    public function getTable()
    {
        return $this->table;
    }

    public function save(array $data, $table = null)
    {
        $data['contrasena'] = MD5($data['contrasena']);
        if (is_array($data['sucursal']) && count($data['sucursal']) > 0) {
            $sucursal = implode(',', $data['sucursal']);
            $data['sucursal'] = trim($sucursal, ',');
        }
        return parent::save($data, $this->table);
    }
    
    public function delete($id, $table = null)
    {
        return parent::delete($id, $this->table);
    }

    public function update($id, $data, $table = null)
    {
        if ($data['contrasena']!='' && $data['contrasena']!=null) {
            $data['contrasena'] = MD5($data['contrasena']);
        } else {
            unset($data['contrasena']);
        }
        
        if (is_array($data['sucursal']) && count($data['sucursal']) > 0) {
            $sucursal = implode(',', $data['sucursal']);
            $data['sucursal'] = trim($sucursal, ',');
        }
        
        return parent::update($id, $data, $this->table);
    }

    public function getById($id, $table = null, $selectAux = null)
    {
        return parent::getById($id, $this->table, $selectAux);
    }

    public function isUsedInRecord($id, array $buscarEn = null, $andWhere = null)
    {
        return parent::isUsedInRecord($id, array(
            'facturas' => 'creado_por'));
    }

    public function getListRoles()
    {
        $select = "SELECT id,role FROM acl_roles";
        $result = $this->query($select);

        if ($result) {
            $array = array();
            while ($row = $result->fetch_assoc()) {
                $array[$row['id']] = $row['role'];
            }
            return $array;
        }
        return null;
    }
    
    public function getUsersByIds($ids)
    {
        $select = "SELECT *,CONCAT(nombre,' ',apellido)as completeName FROM usuarios WHERE id IN($ids)";
        $result = $this->query($select);
        
        if ($result) {
            return $this->resultToArray($result);
        }
        
        return null;
    }
    
    public function getListSelectUsers()
    {
        $select = "SELECT * FROM usuarios ";
        $result = $this->query($select);

        if ($result) {
            $array = array();
            while ($row = $result->fetch_assoc()) {
                $array[$row['id']] = $row['name'];
            }
            return $array;
        }
        return null;
    }
    
    public function getListUsers()
    {
        $select = "SELECT *,"
                . "fxGetStatusName(status,'Usuario') as statusName, "
                . "fxGetRoleName(role) as roleName,"
                . "fxGetSucursalName(sucursal)as sucursalName "
                . "FROM usuarios WHERE id>1";
        
        $result = $this->query($select);

        if ($result) {
            return $this->resultToArray($result);
        }
        return null;
    }
    
    public function getListStatus()
    {
        $query = "SELECT * FROM status_codigos WHERE operacion = 'Usuario'";
        $result = $this->query($query);
        
        if ($result->num_rows > 0) {
            $array = array();
            foreach ($result as $status) {
                $array[$status['id']] = $status['status'];
            }
            return $array;
        }
        return null;
    }
    
    public function sucursalesStringToArray($sucursales)
    {
        $arraySucursales = array();
        $sucursales = explode(',', $sucursales);
        foreach ($sucursales as $key => $sucursal) {
            $arraySucursales[$sucursal] = $sucursal;
        }
        return $arraySucursales;
    }
}
