<?php
class AddProductForm extends Form
{
    public function __construct()
    {
        $this->setName('addProduct');
        parent::__construct();
        $this->init();
    }

    public function init()
    {
        /*Se utiliza para consulta si existe en la tabla de comprasdetalles_X, si existe se actualiza registro.*/
        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'idDetailTemp',
            'required'=>false
        ));
         
        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'id_product',
        ));
         
        $append = "<span class = 'btn input-group-addon' data-toggle='modal' data-target='#modalAgregarProducto'><i class='fa fa-plus'></i></span>";
        $this->addElement(array(
            'type' => 'text',
            'name' => 'product',
            'label'=>'Producto',
            'optionals'=>array('placeholder'=>'Teclea o escanea producto.'),
            'append'=>$append
         ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'quantity',
            'label'=>'Cantidad',
            'validators'=>array('double'),
            'class'=>'_maskDouble',
            'required'=>false,
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'cost',
            'label'=>'Costo',
            'validators'=>array('double'),
            'class'=>'_maskDouble',
            'required'=>false,
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'price',
            'label'=>'Precio',
            'validators'=>array('double'),
            'class'=>'_maskDouble',
            'required'=>false,
        ));
        
        $append = "<div class='input-group-btn descuento_tipo'>
                    <select class='form-control _discount_type' name='discount_type'>                    
                      <option value='monto'>Monto</option>
                      <option value='porcentaje'>Porcentaje</option>
                    </select>
                  </div>";
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'discount',
            'label'=>'Descuento',
            'class'=>'_maskDouble',
            'append'=>$append,
            'required'=>false
        ));
       
        $this->addElement(array(
            'type' => 'select',
            'name' => 'taxes',
            'label'=>'Impuestos',
            'multiOptions'=>$this->listaImpuestos(),
        ));
       
        $this->addElement(array(
            'type' => 'select',
            'name' => 'assign_to_lot',
            'label'=>'Asignar a lote',
            'multiOptions'=>$this->listLots(),
            'col-size-element'=>'8',
            'col-size-label'=>'4'
        ));
       
        $this->addElement(array(
            'type' => 'textarea',
            'name' => 'description_details',
            'label'=>'Detalles',
            'required'=>false,
            'class'=>'form-control',
            'optionals'=>array('style'=>'min-height:180px')
        ));
        
        $this->addElement(array(
            'type'=>'button',
            'name'=>'buscar',
            'value'=>$this->_getTranslation('Agregar'),
            'class'=>'btn btn-primary _addProduct'
        ));
        
        $this->addElement(array(
            'type'=>'button',
            'name'=>'cerrar_modal',
            'value'=>$this->_getTranslation('Cerrar'),
            'class'=>"btn btn-default _closeModalAddProduct"
        ));
    }
    
    public function getListProducts()
    {
        $repository = new SupplieRepository();
        #1 = status activo
        $productos = $repository->getListSupplies();
        
        $array = array('0'=>'Seleccionar una opcion...');
        foreach ($productos as $producto) {
            $array[$producto['id']] = $producto['description']." (".$producto['code'].")";
        }
        
        $list= array();
        foreach ($array as $key => $value) {
            $list[$key] = $value;
        }
        return $list;
    }
    
    public function listaImpuestos()
    {
        $repository = new GoodAndServiceCatalogRepository();
        $result = $repository->getListaSelectImpuestos();
        
        $array = array();
        if ($result) {
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }
            return $array;
        }
    }
    
    public function listLots()
    {
        $repository = new ManifestRepository;
        $result = $repository->getListaSelectLots();
        
        $array = array(''=>'Seleccionar una opcion...');
        if ($result) {
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }
            return $array;
        }
    }
}
