<?php
class AdvancedSearchForm extends Form
{
    public function __construct($controller)
    {
        $this->setName('advanced_search');
        $this->setActionForm($controller.".php");
        switch ($controller) {
            default:
                $actionController = 'list';
                break;
        }
        $this->setActionController($actionController);
        $this->setMethod('post');
        $this->setDefaultFormLabelsColSize('4');
        $this->setDefaultFormElementsColSize('8');
        parent::__construct();
        $this->init();
    }

    public function init()
    {
        $append = "<span class = 'btn input-group-addon'><i class='fa fa-calendar'></i></span>";
        $this->addElement(array(
            'type' => 'text',
            'name' => 'startDate',
            'label'=>'Fecha inicio',
            'required'=>false,
            'append'=>$append
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'endDate',
            'label'=>'Fecha fin',
            'required'=>false,
            'append'=>$append
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'folio',
            'label'=>'Folio',
            'required'=>false,
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'serie',
            'label'=>'Serie',
            'required'=>false,
        ));

        $this->addElement(array(
            'type' => 'select multiple',
            'name' => 'status_payment',
            'label'=>'Status de pago',
            'multiOptions'=>array('1'=>'Pendiente','2'=>'Pagada'),
            'required'=>false,
        ));

        $this->addElement(array(
            'type' => 'submit',
            'name' => 'search',
            'value'=> $this->_getTranslation('Buscar'),
            'class'=>'btn btn-primary'
        ));
    }

    public function getPurchaseStatus()
    {
        $manifestRepo = new ManifestRepository();
        $purchaseRepo = new PurchaseGoodAndServiceRepository();

        $manifestStatus = $manifestRepo->getListStatus();
        $purchaseStatus = $purchaseRepo->getListStatus();

        $array = array();
        foreach ($manifestStatus as $idStatus => $descriptionStatus) {
            $array[$idStatus] = $descriptionStatus.' - '.$this->_getTranslation('Producto');
        }

        foreach ($purchaseStatus as $idStatus => $descriptionStatus) {
            $idStatus += 20;
            $array[$idStatus] = $descriptionStatus.' - '.$this->_getTranslation('Bienes y servcios');
        }

        return $array;
    }

    public function getSalesOrderStatus()
    {
        $shipingRequestRepo = new ShippingRequestRepository();
        $salesOrderStatus = $shipingRequestRepo->getListStatus();

        $array = array();
        foreach ($salesOrderStatus as $idStatus => $descriptionStatus) {
            $array[$idStatus] = $descriptionStatus;
        }

        return $array;
    }

    public function getInvoiceStatus()
    {
        $invoiceRepo = new InvoiceRepository();
        $invoiceStatus = $invoiceRepo->getListStatus();

        $array = array();
        foreach ($invoiceStatus as $idStatus => $descriptionStatus) {
            $array[$idStatus] = $descriptionStatus;
        }

        return $array;
    }

    public function getShippingStatus()
    {
        $shippingRepo = new ShippingRepository();
        $shippingStatus = $shippingRepo->getListStatus();

        $array = array();
        foreach ($shippingStatus as $idStatus => $descriptionStatus) {
            $array[$idStatus] = $descriptionStatus;
        }

        return $array;
    }

    public function getWasteStatus()
    {
        $shippingRepo = new WasteRepository();
        $shippingStatus = $shippingRepo->getListStatus();

        $array = array();
        foreach ($shippingStatus as $idStatus => $descriptionStatus) {
            $array[$idStatus] = $descriptionStatus;
        }

        return $array;
    }

    public function getManufacturingStatus()
    {
        $repository = new RepackRepository();
        $status = $repository->getListStatus();

        $array = array();
        foreach ($status as $idStatus => $descriptionStatus) {
            $array[$idStatus] = $descriptionStatus;
        }

        return $array;
    }

    public function getStringFiltersForm($controller)
    {
        $formString = '';
        switch ($controller) {

            case 'SalesOrder':
                $salesOrderForm = new ShippingRequestForm();

                $this->addElement(array('type'=>'text','name'=>'sales_order_num','label'=>'Orden de venta #'));
                $this->addElement(array('type'=>'select multiple','name'=>'customer_id','label'=>'Cliente'));
                $this->setPropiedad('customer_id', array('multiOptions'=>$salesOrderForm->listClientes()));
                $this->addElement(array('type'=>'text','name'=>'customer_po','label'=>'OC de cliente'));
                $this->addElement(array('type'=>'text','name'=>'lot','label'=>'Lote'));
                $this->addElement(array('type'=>'select multiple','name'=>'invoiced','label'=>'Facturado','multiOptions'=>array('0'=>'No','1'=>'Si')));
                $this->addElement(array('type'=>'select multiple','name'=>'status','label'=>'Status'));
                $this->setPropiedad('status', array('multiOptions'=>$this->getSalesOrderStatus()));
                $append = "<span class = 'btn input-group-addon'><i class='fa fa-calendar'></i></span>";
                $this->addElement(array('type' => 'text','name' => 'deliveryStartDate','label'=>'Fecha entrega inicio','append'=>$append));
                $this->addElement(array('type' => 'text','name' => 'deliveryEndDate','label'=>'Fecha entrega fin','append'=>$append));

                $formString .= $this->getElementString('sales_order_num');
                $formString .= $this->getElementString('customer_id');
                $formString .= $this->getElementString('customer_po');
                $formString .= $this->getElementString('lot');
                $formString .= $this->getElementString('invoiced');
                $formString .= $this->getElementString('status');
                $formString .= $this->getElementString('startDate');
                $formString .= $this->getElementString('endDate');
                $formString .= $this->getElementString('deliveryStartDate');
                $formString .= $this->getElementString('deliveryEndDate');

                break;
            case 'Factura':
                $facturaForm = new FacturaForm();
                $this->addElement(array('type'=>'select multiple','name'=>'id_cliente','label'=>'Cliente'));
                $this->setPropiedad('id_cliente', array('multiOptions'=>$facturaForm->getListClientes()));
                $this->addElement(array('type'=>'select multiple','name'=>'status','label'=>'Status'));
                $this->setPropiedad('status', array('multiOptions'=>$facturaForm->getListStatus()));
                $this->addElement(array('type'=>'text','name'=>'folio','label'=>'Folio'));
                $this->setPropiedad('folio', array('text'=>''));
                $this->addElement(array('type'=>'text','name'=>'serie','label'=>'Serie'));
                $this->setPropiedad('serie', array('text'=>''));

                $formString .= $this->getElementString('id_cliente');
                $formString .= $this->getElementString('status');
                $formString .= $this->getElementString('serie');
                $formString .= $this->getElementString('folio');
                $formString .= $this->getElementString('startDate');
                $formString .= $this->getElementString('endDate');
            break;

            case 'NotaCredito':
                $notacredito = new NotaCreditoForm();
                $this->addElement(array('type'=>'select multiple','name'=>'id_cliente','label'=>'Cliente'));
                $this->setPropiedad('id_cliente', array('multiOptions'=>$notacredito->getListClientes()));
                $this->addElement(array('type'=>'select','name'=>'status','label'=>'Status'));
                $this->setPropiedad('status', array('multiOptions'=>$notacredito->getListStatus()));
                $this->addElement(array('type'=>'text','name'=>'folio','label'=>'Folio'));
                $this->setPropiedad('folio', array('text'=>''));
                $this->addElement(array('type'=>'text','name'=>'serie','label'=>'Serie'));
                $this->setPropiedad('serie', array('text'=>''));

                $formString .= $this->getElementString('id_cliente');
                $formString .= $this->getElementString('status');
                $formString .= $this->getElementString('serie');
                $formString .= $this->getElementString('folio');
                $formString .= $this->getElementString('startDate');
                $formString .= $this->getElementString('endDate');

            break;

            case 'Pago':
                $pago = new PagoForm();
                $this->addElement(array('type'=>'select multiple','name'=>'cliente','label'=>'Cliente'));
                $this->setPropiedad('cliente', array('multiOptions'=>$pago->getListClientes()));
                $this->addElement(array('type'=>'select','name'=>'status','label'=>'Status'));
                $this->setPropiedad('status', array('multiOptions'=>$pago->getListStatus()));
                $this->addElement(array('type'=>'text','name'=>'folio','label'=>'Folio'));
                $this->setPropiedad('folio', array('text'=>''));
                $this->addElement(array('type'=>'text','name'=>'serie','label'=>'Serie'));
                $this->setPropiedad('serie', array('text'=>''));

                $formString .= $this->getElementString('cliente');
                $formString .= $this->getElementString('status');
                $formString .= $this->getElementString('serie');
                $formString .= $this->getElementString('folio');
                $formString .= $this->getElementString('startDate');
                $formString .= $this->getElementString('endDate');

            break;
        }

        return $formString;
    }
}
