<?php
/**
 * Description of DatosFacturacionForm
 *
 * @author carlos
 */

class ClienteForm extends Form
{
    public function __construct()
    {
        $this->setName('cliente');
        $this->setClass('cliente');
        $this->setMethod('post');
        $this->setDefaultFormElementsColSize('8');
        $this->setDefaultFormLabelsColSize('4');
        parent::__construct();
        $this->init();
    }

    public function init()
    {
        $this->addElement(array(
            'type' => 'text',
            'name' => 'codigo',
            'label'=>'Codigo',
            'value'=>'',
            'required'=> false
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'razon_social',
            'label'=>'Razon social',
            'value'=>'',
            'required'=> true
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'rfc',
            'label'=>'RFC',
            'value'=>'',
            'class'=>'rfc',
            'validators'=>array('rfc'),
            'required'=> true
         ));
        
        $this->addElement(array(
            'type' => 'select',
            'name' => 'payment_terms',
            'label'=>'Terminos de Pago',
            'multiOptions'=>$this->getListPaymentTerms(),
            'required'=>true
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'calle',
            'label'=>'Calle',
            'value'=>'',
            'required'=> false
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'numero_exterior',
            'label'=>'Numero exterior',
            'value'=>'',
            'required'=> false,
            'col-size-label'=>'7',
            'col-size-element'=>'5',
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'numero_interior',
            'label'=>'Numero interior',
            'value'=>'',
            'required'=> false,
            'col-size-label'=>'7',
            'col-size-element'=>'5',
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'colonia',
            'label'=>'Colonia',
            'value'=>'',
            'required'=> false
        ));
        
        $this->addElement(array(
            'type' => 'select',
            'name' => 'ciudad',
            'label'=>'Ciudad',
            'multiOptions'=>array(0=>'Seleccionar una opcion...'),
            'required'=>false
        ));

        $this->addElement(array(
            'type' => 'select',
            'name' => 'estado',
            'label'=>'Estado',
            'multiOptions'=>$this->getListEstados(),
            'optionals'=>array('onchange'=>'setMunicipios();'),
            'required'=>false
        ));

        $this->addElement(array(
            'type' => 'select',
            'name' => 'pais',
            'label'=>'Pais',
            'multiOptions'=>$this->getListPaises(),
            'required'=>false
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'codigo_postal',
            'label'=>'Codigo postal',
            'multiOptions'=>$this->getListCodigosPostales(),
            'validators'=>array('codigoPostal'),
            'required'=> true
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'nombre_contacto',
            'label'=>'Nombre contacto',
            'value'=>'',
            'required'=> false
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'telefono',
            'label'=>'Telefono',
            'value'=>'',
            'required'=> false
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'email',
            'label'=>'Correo Electronico',
            'value'=>'',
            'required'=> false
         ));

        //pudin
        $this->addElement(array(
            'type' => 'text',
            'name' => 'email2',//pudin
            'label'=>'Email adicional',
            'value'=>'',
            'required'=> false
         ));
        
        $this->addElement(array(
            'type' => 'textarea',
            'name' => 'comentarios',
            'value'=>'',
            'label'=>'Comentarios',
        ));

        /*$this->addElement(array(
            'type' => 'button',
            'name' => 'send',
            'value'=> $this->_getTranslation('Terminar'),
            'optionals'=>array(
                'onclick'=>"saveCliente()"),
            'class'=>'btn btn-primary m-t-1'
        ));    */
        
        $this->addElement(array(
            'type' => 'button',
            'name' => 'send',
            'value'=> $this->_getTranslation('Terminar'),
            'optionals'=>array(
                'onclick'=>"saveCliente()"),
            'class'=>'btn btn-primary m-t-1'

        ));

        $this->addElement(array(
            'type' => 'button',
            'name' => 'cancelar',
            'value'=> $this->_getTranslation('Cancelar'),
            'class'=>'btn btn-default m-t-1 _closeModalCustomer'
        ));

        $this->addElement(array(
            'type' => 'button',
            'name' => 'guardarCliente',
            'value'=> $this->_getTranslation('Guardar'),
            'class'=>'btn btn-primary _saveCliente',
            'col-size-element'=>'12',
        ));
    }

    public function getListCodigosPostales()
    {
        $repository = new EmpresaRepository();
        $result = $repository->getListSelectCodigosPostales();

        $array = array('0' => 'Seleccionar una opcion...');
        if ($result) {
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }
            return $array;
        }
    }

    public function getListEstados()
    {
        $repository = new EmpresaRepository();
        $result = $repository->getListEstados();

        $array = array('0' => 'Seleccionar una opcion...');
        if ($result) {
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }
            return $array;
        }
    }
    
    public function getListPaises()
    {
        $repository = new EmpresaRepository();
        $result = $repository->getListPaises();

        $array = array('0' => 'Seleccionar una opcion...');
        if ($result) {
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }
            return $array;
        }
    }
    
    public function getListPaymentTerms()
    {
        $repository = new PaymentTermRepository();
        $result = $repository->getListSelectPaymentTerm();

        $array = array();
        if ($result) {
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }
        }
        return $array;
    }

    public function getListCiudades($estado)
    {
        $repository = new EmpresaRepository();
        $result = $repository->getListSelectMunicipios($estado);

        $array = array('0' => 'Seleccionar una opcion...');
        if ($result) {
            foreach ($result as $key => $value) {
                $array[utf8_encode($key)] = ($value);
            }
            return $array;
        }
    }

    public function getModalFormString()
    {
        $formString = "<div class='col-lg-4 col-md-4 col-sm-12'>";
        $formString .= $this->getElementString('codigo');
        $formString .= $this->getElementString('rfc');
        $formString .= $this->getElementString('razon_social');
        $formString .= $this->getElementString('pais');
        $formString .= $this->getElementString('codigo_postal');
        $formString .= "</div>";

        $formString .= "<div class='col-lg-4 col-md-4 col-sm-12'>";
        $formString .= $this->getElementString('estado');
        $formString .= $this->getElementString('ciudad');
        $formString .= $this->getElementString('colonia');
        $formString .= $this->getElementString('calle');
        $formString .= $this->getElementString('numero_exterior');
        $formString .= $this->getElementString('numero_interior');
        $formString .= "</div>";

        $formString .= "<div class='col-lg-4 col-md-4 col-sm-12'>";
        $formString .= $this->getElementString('nombre_contacto');
        $formString .= $this->getElementString('telefono');
        $formString .= $this->getElementString('email');
        $formString .= $this->getElementString('comentarios');
        $formString .= "</div>";

        return $formString;
    }

    public function populate($data)
    {
        if ($data['estado'] != null && $data['estado'] != '0') {
            $this->addProperties('ciudad', array('multiOptions'=>$this->getListCiudades($data['estado'])));
        }
        parent::populate($data);
    }

    public function isValid()
    {
        $result = parent::isValid();
        #Para validar que RFC no se repita

        if ($result) {
            $entity = new ClienteRepository();
            $existeRFC = null;
            $rfc = $this->getValueElement('rfc');
            if ($this->getActionController() == 'insert') {
                $existeRFC = $entity->existeRFC($rfc);
            } elseif ($this->getActionController() == 'edit') {
                $existeRFC = $entity->existeRFC($rfc, $this->getId());
            }
            
            /*
            if($existeRFC){
                $flashmessenger = new FlashMessenger();
                $flashmessenger->addMessage(array('danger'=>'Lo sentimos, el RFC que intenta registrar ya se encuentra registrado.'));
                return null;
            } */
        }
        return $result;
    }
}
