<?php
/**
 * Description of CuentaBancariaForm
 * @author carlos
 */
class CuentaBancariaForm extends Form
{
    public function __construct()
    {
        $this->setActionForm('CuentaBancaria.php');
        $this->setName('CuentaBancaria');
        $this->setClass('usuario');
        $this->setMethod('post');
        $this->setDefaultFormElementsColSize('8');
        $this->setDefaultFormLabelsColSize('4');
        parent::__construct();
        $this->init();
    }

    public function init()
    {
        $this->addElement(array(
            'type' => 'select',
            'name' => 'banco',
            'label'=>'Banco',
            'multiOptions' => $this->getListBancos(),
            'required'=> true
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'cuenta',
            'label'=>'Cuenta',
            'required'=> true
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'clabe_interbancaria',
            'label'=>'CLABE',
            'required'=> false
        ));
        

        $this->addElement(array(
            'type' => 'select',
            'name' => 'status',
            'label'=>'Status',
            'multiOptions' => $this->getListStatus(),
            'required'=> true
        ));

        $this->addElement(array(
            'type' => 'button',
            'name' => 'send',
            'value'=> $this->_getTranslation('Terminar'),
            'optionals'=>array(
                'onclick'=>"submit()"),
            'class'=>'btn btn-primary m-t-1'
        ));

        $this->addElement(array(
            'type' => 'button',
            'name' => 'cancelar',
            'value'=> $this->_getTranslation('Cancelar'),
            'class'=>'btn btn-default m-t-1 _closeModalUser'
        ));
    }

    public function getListStatus()
    {
        $repository = new CuentaBancariaRepository();
        $list = $repository->getListStatus();

        $array = array(''=>'Seleccionar una opcion...');
        foreach ($list as $key => $value) {
            $array[$key] = $value;
        }
        return $array;
    }

    public function getListBancos()
    {
        $repository = new CuentaBancariaRepository();
        $list = $repository->getListSelectBancos();

        $array = array(''=>'Seleccionar una opcion...');
        foreach ($list as $key => $value) {
            $array[$key] = $value;
        }
        return $array;
    }
    public function isValid()
    {
        $valid = parent::isValid();
        return $valid;
    }
}
