<?php
class FacturaBuscarForm extends Form
{
    public function __construct()
    {
        $this->setName('FacturaBuscarForm');
        /*En View_SpecialOrderListProduction lo cambiamos a list-production*/
        $this->setActionController('list');
        $this->setMethod('post');
        parent::__construct();
        $this->init();
    }

    public function init()
    {
        $this->addElement(array(
            'type' => 'select multiple',
            'name' => 'sucursal',
            'label'=>'Sucursal',
            'multiOptions'=>$this->getListStores()
         ));
        
        $this->addElement(array(
            'type' => 'select multiple',
            'name' => 'id_cliente',
            'label'=>'Cliente',
            'multiOptions'=>$this->getListCustomers()
        ));

        $this->addElement(array(
            'type' => 'select multiple',
            'name' => 'status',
            'label'=>'Status',
            'multiOptions'=>array('0'=>'Seleccionar una opcion...','1'=>'Sin Timbrar','2'=>'Timbrada', '3'=>'Cancelada'),
            'required'=>false
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'startDate',
            'label'=>'Fecha inicio',
            'validators'=>array('date'),
            'required'=>false
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'endDate',
            'label'=>'Fecha fin',
            'validators'=>array('date'),
        ));

        $this->addElement(array(
            'type'=>'submit',
            'name'=>'search',
            'label'=>'',
            'value'=>$this->_getTranslation('Buscar'),
            'class'=>'btn btn-primary'
        ));
  
        $this->addElement(array(
            'type' => 'button',
            'name' => 'cerrar',
            'value'=> $this->_getTranslation('Cerrar'),
            'class'=>'btn btn-default',
            'optionals'=>array(
                'data-dismiss'=>'modal',
                'aria-hidden'=>'true',
                )
        ));
    }
    public function getListCustomers()
    {
        $repository = new ClienteRepository();
        $result = $repository->getListSelectClientes();
        $array = array(''=>'Seleccionar una opcion...');
        if ($result) {
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }
            return $array;
        }
    }
    
    public function getListStores()
    {
        $repo = new SucursalRepository();
        $result = $repo->getListSelectSucursales();
        
        $login = new Login();
        $array = array(''=>'Seleccionar una opcion...');
        if ($result) {
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }
        }
        
        return $array;
    }
}
