<?php

class FacturaForm extends Form
{
    public function __construct()
    {
        $this->setName('factura');
        $this->setActionForm('Factura.php');
        $this->setClass('factura form-horizontal');
        $this->setEnctype('multipart/form-data');
        $this->setMethod('post');
        parent::__construct();
        $this->init();
        $this->populateDefault();
    }

    public function init()
    {
        $attributes_wrapper_append_date = array('class' => 'datePicker');
        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'status',
            'required' => false
        ));

        $this->addElement(array(
            'type' => 'select',
            'name' => 'sucursal',
            'label' => 'Sucursal',
            'multiOptions' => $this->getListSucursales(),
            'required' => true
        ));

        $append = "<a class = 'btn input-group-addon' data-toggle='modal' data-action='insert' href='#modalAddCustomerModal'><i class='fa fa-plus'></i></a>";

        //$append .= "<span class = 'btn input-group-addon' data-action='edit' onclick='setModalCliente(this)'><i class='fa fa-pencil'></i></span>";

        $this->addElement(array(
            'type' => 'select',
            'name' => 'id_cliente',
            'label' => 'Cliente',
            // 'multiOptions'=>$this->getListClientes(),
            'optionals' => array('onchange' => 'setUuidByCliente()', 'onChange' => 'getVendorMethodPaymentOnSale()'),
            'required' => true,
            'append' => $append,
        ));
        if (!$this->useAutoComplete()) {
            $this->addProperties('id_cliente', [
                'multiOptions' => $this->getListClientes(),
                'class' => 'no-autocomplete'
            ]);
        } else {
            $this->addProperties('id_cliente', [
                'class' => 'autocomplete'
            ]);
        }

        $append = "<span class = 'btn input-group-addon'><i class='fa fa-calendar'></i></span>";
        $this->addElement(array(
            'type' => 'text',
            'name' => 'date',
            'label' => 'Fecha',
            'class' => 'datePicker',
            'validators' => array('date'),
            'required' => true,
            'value' => date('m/d/Y'),
            'append' => $append,
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'due_date',
            'label' => 'Fecha de Pago',
            'class' => 'datePicker',
            'validators' => array('date'),
            'required' => true,
            'value' => date('m/d/Y'),
            'append' => $append,
        ));

        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'tipo_documento',
            'value' => 'I',
            'required' => true
        ));

        /*
        $this->addElement(array(
            'type' => 'select',
            'name' => 'lugar_de_expedicion',
            'label'=>'Lugar de expedicion',
            'multiOptions'=>array('Reynosa'=>'Reynosa'),
            'required'=>true
        ));  */

        $this->addElement(array(
            'type' => 'select',
            'name' => 'forma_de_pago',
            'label' => 'Forma de pago',
            'multiOptions' => $this->getListFormasDePago(),
            'optionals' => array('onchange' => 'setNumCuentaPago()'),
            'value' => 'Efectivo',
            'required' => true
        ));

        $this->addElement(array(
            'type' => 'select',
            'name' => 'metodo_de_pago',
            'label' => 'Metodo de pago',
            'multiOptions' => $this->getListMetodosDePago(),
            'required' => true
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'num_cuenta_pago',
            'label' => 'Num cuenta de pago',
            'required' => false
        ));

        $this->addElement(array(
            'type' => 'select',
            'name' => 'moneda',
            'label' => 'Moneda',
            'multiOptions' => $this->getListMonedas(),
            'required' => true
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'tipo_de_cambio',
            'label' => 'Tipo de cambio'
        ));

        $this->addElement(array(
            'type' => 'select',
            'name' => 'uso_cfdi',
            'label' => 'Uso de CFDI',
            'multiOptions' => $this->getListUsoCFDI(),
            'required' => true
        ));

        $this->addElement(array(
            'type' => 'select',
            'name' => 'tipo_relacion',
            'label' => 'Tipo de relacion',
            'multiOptions' => $this->getListTipoRelacion(),
            'required' => false
        ));

        $this->addElement(array(
            'type' => 'select multiple',
            'name' => 'uuid_relacionados',
            'label' => 'CFDI relacionados',
            'multiOptions' => $this->getListUUID(),
            'required' => false
        ));

        $this->addElement(array(
            'type' => 'select multiple',
            'name' => 'uuid_relacionados_otros',
            'label' => 'Otros UUID',
            'multiOptions' => array(),
            'required' => false,
            'optionals' => array('style' => 'font-size:10px')
        ));

        $append = "<span class = 'btn input-group-addon' onclick='addUUID()'><i class='fa fa-plus'></i></span>";
        $this->addElement(array(
            'type' => 'text',
            'name' => 'add_uuid_relacionados_otros',
            'label' => 'Agregar UUID',
            'required' => false,
            'append' => $append,
            'optionals' => array('style' => 'font-size:10px;padding:7px')
        ));

        /* Ya no se utiliza en version 3.3
        $this->addElement(array(
            'type' => 'select',
            'name' => 'condiciones_de_pago',
            'label'=>'Condiciones de pago',
            'multiOptions'=>array('Contado'=>'Contado','Credito'=>'Credito'),
            'required'=>true        ));
         */

        $this->addElement(array(
            'type' => 'textarea',
            'name' => 'comentarios',
            'label' => 'Comentarios',
            'required' => false
        ));

        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'subtotal',
            'validators' => array('double'),
            'required' => true,
            'col-size-element' => '12'
        ));

        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'descuento',
            'validators' => array('double'),
            'required' => false,
            'col-size-element' => '12'
        ));

        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'total',
            'validators' => array('double'),
            'required' => false,
            'col-size-element' => '12'
        ));

        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'total_impuestos_retenidos',
            'validators' => array('double'),
            'required' => false,
        ));

        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'total_impuestos_trasladados',
            'validators' => array('double'),
            'required' => false,
        ));

        /*Se utiliza para consulta si existe en la tabla de comprasdetalles_X, si existe se actualiza registro.*/

        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'idDetailTemp',
            'required' => false
        ));


        $append = "<span class = 'btn input-group-addon _addProduct'><i class='fa fa-plus'></i></span>";
        $this->addElement(array(
            'type' => 'select',
            'name' => 'id_producto',
            'label' => 'Producto',
            // 'multiOptions'=>$this->getListProducts(),
            'optionals' => array('onchange' => 'getProductoInfo()'),
            'col-size-label' => '12',
            'col-size-element' => '12',
            'append' => $append

        ));
        if (!$this->useAutoComplete()) {
            $this->addProperties('id_producto', [
                'multiOptions' => $this->getListProducts(),
                'class' => 'no-autocomplete'
            ]);
        } else {
            $this->addProperties('id_producto', [
                'class' => 'autocomplete'
            ]);
        }

        $this->addElement(array(
            'type' => 'text',
            'name' => 'descripcion',
            'label' => 'Descripcion',
            'col-size-element' => '12'
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'cantidad',
            'label' => 'Cantidad',
            'validators' => array('double'),
            'required' => false,
            'col-size-element' => '12'
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'precio_unitario',
            'label' => 'Precio',
            'validators' => array('double'),
            'required' => false,
            'col-size-element' => '12'
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'descuento_detalle',
            'label' => '% Dcto.',
            'validators' => array('double'),
            'required' => false,
            'col-size-element' => '12'
        ));

        /*No esta en uso... ver FacturaView*/
        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'impuestos_incluidos',
            'multiOptions' => array('Si' => 'Si', 'No' => 'No'),
            'col-size-element' => '12'
        ));


        $this->addElement(array(
            'type' => 'button',
            'name' => 'buscar',
            'value' => $this->_getTranslation('Agregar'),
            'class' => 'btn btn-default',
            'optionals' => array('onClick' => 'setFacturaDetalles()')
        ));

        $this->addElement(array(
            'type' => 'button',
            'name' => 'terminar',
            'value' => $this->_getTranslation('Guardar'),
            'class' => 'btn btn-primary',
            'optionals' => array("onClick" => "submit('factura')")
        ));

        /*CG CUENTA DE GASTOS */
        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'cg_idDetailTemp',
            'required' => false
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'total_cuenta_de_gastos',
            'validators' => array('double'),
            'required' => false,
        ));

        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'idDetailTemp',
            'required' => false
        ));


        $append = "<span class = 'btn input-group-addon' data-toggle='modal' data-target='#modalAgregarProducto'><i class='fa fa-plus'></i></span>";
        $this->addElement(array(
            'type' => 'select',
            'name' => 'cg_id_producto',
            'label' => 'Producto',
            'multiOptions' => $this->getListProducts(),
            'optionals' => array('onchange' => 'getProductoInfoCG()'),
            'col-size-label' => '12',
            'col-size-element' => '12',
            'append' => $append

        ));

        $this->addElement(array(
            'type' => 'select',
            'name' => 'payment_terms',
            'label' => 'Terminos de Pago',
            'multiOptions' => $this->listPaymentTerms(),
            'required' => true
        ));

        $this->addElement(array(
            'id' => 'adjunto',
            'type' => 'file',
            'name' => "adjunto[]",
            'label' => 'Documentos adjuntos',
            'class' => 'file upload',
            'required' => false,
            'optionals' => array(
                'title' => 'Documentos adjuntos',
                'multiple' => '',
                'data-show-preview' => false,
                'data-show-upload' => false

            )
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'cg_descripcion',
            'label' => 'Descripcion',
            'col-size-element' => '12'
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'cg_precio_unitario',
            'label' => 'Precio',
            'validators' => array('double'),
            'required' => false,
            'col-size-element' => '12'
        ));

        $this->addElement(array(
            'type' => 'button',
            'name' => 'buscar_cg',
            'value' => $this->_getTranslation('Agregar'),
            'class' => 'btn btn-default',
            'optionals' => array('onClick' => 'setCuentaDeGastosDetalles()')
        ));

        /* END CUENTA DE GASTOS*/
    }

    public function populateDefault()
    {
        $settings = new SettingsRepository();
        $array = array(
            'default_factura_metodoDePago' => 'metodo_de_pago',
            'default_factura_moneda' => 'moneda',
            'default_forma_pago' => 'forma_de_pago',
            'default_uso_cfdi' => 'uso_cfdi'
        );

        foreach ($array as $key => $field) {
            $defaultValue = $settings->_get($key);
            if ($defaultValue) {
                $this->setValueToElement($defaultValue, $field);
            }
        }
    }

    public function getListClientes()
    {
        $repository = new ClienteRepository();
        $result = $repository->getListSelectClientes();

        $array = array('' => 'Seleccionar una opcion...');
        if ($result) {
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }
            return $array;
        }
    }

    public function listPaymentTerms()
    {
        $repository = new PaymentTermRepository();
        $result = $repository->getListSelectPaymentTerm();

        $array = array('' => 'Seleccionar una opcion...');
        if ($result) {
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }
        }
        return $array;
    }

    public function getListUUID($cliente = null)
    {
        $repository = new FacturaRepository();
        $result = $repository->getListUUIDByCliente($cliente);

        $array = array();
        if ($result) {
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }
        }
        return $array;
    }

    public function getListMonedas()
    {
        $repository = new FacturaRepository();
        $result = $repository->getListMoneda();

        $array = array('' => 'Seleccionar una opcion...');
        if ($result) {
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }
            return $array;
        }
    }



    public function getListFormasDePago()
    {
        $repository = new FacturaRepository();
        $result = $repository->getListSelectFormasPago();

        if (count($result) > 1) {
            $array = array('' => 'Seleccionar una opcion...');
        }
        //if(count($result)>1){ $array = array('1'=>'Efectivo');}
        if ($result) {
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }
            return $array;
        }
    }


    public function getListMetodosDePago()
    {
        $repository = new FacturaRepository();

        $result = $repository->getListSelectMetodosPago();



        if (count($result) > 1) {
            $array = array('' => 'Seleccionar una opcion...');
        }

        if ($result) {
            foreach ($result as $key => $value) {
                $array[$key] = "{$key} - {$value}";
            }

            return $array;
        }
    }



    public function getListTipoRelacion()
    {
        $repository = new FacturaRepository();

        $result = $repository->getListTipoRelacion();



        $array = array('0' => 'Seleccionar una opcion...');

        if ($result) {
            foreach ($result as $key => $value) {
                $array[$key] = "{$key} - {$value}";
            }

            return $array;
        }
    }



    public function getListUsoCFDI()
    {
        $repository = new FacturaRepository();

        $result = $repository->getListUsoCFDI();



        $array = array('' => 'Seleccionar una opcion...');

        if ($result) {
            foreach ($result as $key => $value) {
                $array[$key] = "{$key} - {$value}";
            }

            return $array;
        }
    }



    public function getListProducts()
    {
        $repository = new ProductoRepository();
        #1 = status activo
        $productos = $repository->getSelectListProductos();

        $array = array('' => 'Seleccionar una opcion...');

        foreach ($productos as $key => $value) {
            $array[$key] = $value;
        }
        return $array;
    }
    public function getListStatus()
    {
        $repo = new FacturaRepository();
        $status = $repo->getListStatus();
        $array = array('' => 'Seleccionar una opcion...');

        foreach ($status as $key => $value) {
            $array[$key] = $value;
        }
        return $array;
    }



    public function getListSucursales()
    {
        $login = new Login();
        $repository = new SucursalRepository();
        $list = $repository->getListSelectSucursales($login->getSucursal());

        $array = array();
        if (count($list) > 1) {
            $array = array('' => 'Seleccionar una opcion...');
        }
        foreach ($list as $key => $value) {
            $array[$key] = $value;
        }
        return $array;
    }

    public function prepareUuidFromPOST($uuids)
    {
        if (!is_array($uuids)) {
            return null;
        }

        $array = array();

        foreach ($uuids as $key => $uuid) {
            $array[$uuid] = $uuid;
        }

        return $array;
    }



    public function prepareUuidFromGET($uuids)
    {
        if (trim($uuids) == '' or trim($uuids) == null) {
            return null;
        }

        $array = array();

        $uuids = explode(',', $uuids);

        foreach ($uuids as $key => $uuid) {
            $array[$uuid] = $uuid;
        }

        return $array;
    }



    public function populate($data)
    {
        $tools = new Tools();
        if (isset($data['date']) && $tools->isValidaDateYYYMMDD($data['date'])) {
            $data['date'] = $tools->setFormatDateToForm($data['date']);
        }
        $this->addProperties('uuid_relacionados', array('multiOptions' => $this->getListUUID($data['id_cliente'])));
        if (isset($data['uuid_relacionados_otros'])) {
            $this->addProperties('uuid_relacionados_otros', array('multiOptions' => $data['uuid_relacionados_otros']));
        }

        parent::populate($data);
    }



    public function isValid()
    {
        $rs = parent::isValid();



        if ($rs) {
            $factura = new FacturaRepository();

            $rango = $factura->esRangoDeFacturacionValido($this->getValueElement('sucursal'), $this->getValueElement('total'));

            if ($rango->rangoValido == 'no') {
                $flashmessenger = new FlashMessenger();
                $flashmessenger->addMessage(array('info' => 'El total de facturacion esta fuera del rango permitido.<br/>Minimo: $' . number_format($rango->minimo, 2) . '<br/>Maximo: $' . number_format($rango->maximo, 2)));
                return null;
            }
        }

        return $rs;
    }

    public function getDefaultFormaDePago()
    {
        return "Efectivo";
    }

    public function useAutoComplete()
    {
        $settings = new SettingsRepository();

        $useAutoComplete = $settings->_get('use_autocomplete');

        return (!is_null($useAutoComplete) && $useAutoComplete == 'YES');
    }
}
