<?php

class NotaCreditoForm extends Form
{
    public function __construct()
    {
        $this->setName('notaCredito');
        $this->setActionForm('NotaCredito.php');
        $this->setClass('notaCredito form-horizontal');
        $this->setMethod('post');
        parent::__construct();
        $this->init();
        $this->populateDefault();
    }

    public function init()
    {
        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'status',
            'required'=>false
        ));

        $this->addElement(array(
            'type' => 'select',
            'name' => 'sucursal',
            'label'=>'Sucursal',
            'multiOptions' => $this->getListSucursales(),
            'required'=>true
        ));

        //$append = "<span class = 'btn input-group-addon' data-action='insert' onclick='setModalCliente(this)'><i class='fa fa-plus'></i></span>";
        $append = "<span class = 'btn input-group-addon' data-action='edit' onclick='setModalCliente(this)'><i class='fa fa-pencil'></i></span>";

        $this->addElement(array(
            'type' => 'select',
            'name' => 'id_cliente',
            'label'=>'Cliente',
            // 'multiOptions'=>$this->getListClientes(),
            'optionals'=>array('onchange'=>'setUuidByCliente()'),
            'required'=>true,
            'append'=>$append,
        ));

        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'tipo_documento',
            'value'=>'E',
            'required'=>true
        ));

        $this->addElement(array(
            'type' => 'select',
            'name' => 'forma_de_pago',
            'label'=>'Forma de pago',
            'multiOptions'=>$this->getListFormasDePago(),
            'optionals'=>array('onchange'=>'setNumCuentaPago()'),
            'required'=>true
        ));

        $this->addElement(array(
            'type' => 'select',
            'name' => 'metodo_de_pago',
            'label'=>'Metodo de pago',
            'multiOptions'=>$this->getListMetodosDePago(),
            'required'=>true
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'num_cuenta_pago',
            'label'=>'Num cuenta de pago',
            'required'=>false
        ));

        $this->addElement(array(
            'type' => 'select',
            'name' => 'moneda',
            'label'=>'Moneda',
            'multiOptions'=>$this->getListMonedas(),
            'optionals' => array(
                'onchange' => "defaultExchangeRate(this.value)"
            ),
            'required'=>true
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'tipo_de_cambio',
            'label'=>'Tipo de cambio'
        ));

        $this->addElement(array(
            'type' => 'select',
            'name' => 'uso_cfdi',
            'label'=>'Uso de CFDI',
            'multiOptions'=>$this->getListUsoCFDI(),
            'required'=>true
        ));

        $this->addElement(array(
            'type' => 'select',
            'name' => 'tipo_relacion',
            'label'=>'Tipo de relacion',
            'multiOptions'=>$this->getListTipoRelacion(),
            'required'=>false
        ));

        $this->addElement(array(
            'type' => 'select multiple',
            'name' => 'uuid_relacionados',
            'label'=>'CFDI relacionados',
            'multiOptions'=>$this->getListUUID(),
            'required'=>false
        ));

        $this->addElement(array(
            'type' => 'select multiple',
            'name' => 'uuid_relacionados_otros',
            'label'=>'Otros UUID',
            'multiOptions'=>array(),
            'required'=>false,
            'optionals'=>array('style'=>'font-size:10px')
        ));

        $append = "<span class = 'btn input-group-addon' onclick='addUUID()'><i class='fa fa-plus'></i></span>";
        $this->addElement(array(
            'type' => 'text',
            'name' => 'add_uuid_relacionados_otros',
            'label'=>'Agregar UUID',
            'required'=>false,
            'append'=>$append,
            'optionals'=>array('style'=>'font-size:10px;padding:7px')
        ));

        /* Ya no se utiliza en version 3.3
        $this->addElement(array(
            'type' => 'select',
            'name' => 'condiciones_de_pago',
            'label'=>'Condiciones de pago',
            'multiOptions'=>array('Contado'=>'Contado','Credito'=>'Credito'),
            'required'=>true        ));
         */

        $this->addElement(array(
            'type' => 'textarea',
            'name' => 'comentarios',
            'label'=>'Comentarios',
            'required'=>false
        ));

        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'subtotal',
            'validators'=>array('double'),
            'required'=>true,
            'col-size-element'=>'12'
        ));

        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'descuento',
            'validators'=>array('double'),
            'required'=>false,
            'col-size-element'=>'12'
        ));

        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'total',
            'validators'=>array('double'),
            'required'=>false,
            'col-size-element'=>'12'
        ));

        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'total_impuestos_retenidos',
            'validators'=>array('double'),
            'required'=>false,
        ));

        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'total_impuestos_trasladados',
            'validators'=>array('double'),
            'required'=>false,
        ));

        /*Se utiliza para consulta si existe en la tabla de comprasdetalles_X, si existe se actualiza registro.*/

        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'idDetailTemp',
            'required'=>false
        ));


        $append = "<span class = 'btn input-group-addon' data-toggle='modal' data-target='#modalAgregarProducto'><i class='fa fa-plus'></i></span>";
        $this->addElement(array(
            'type' => 'select',
            'name' => 'id_producto',
            'label'=>'Producto',
            //'multiOptions'=>$this->getListProducts(),
            'optionals'=>array('onchange'=>'getProductoInfoNotas()'),
            'col-size-label'=>'12',
            'col-size-element'=>'12',
            'append'=>$append

         ));

        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'descripcion',
            //'label'=>'Descripcion',
            'col-size-element'=>'12'
        ));

        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'cantidad',
            //'label'=>'Cantidad',
            'validators'=>array('double'),
            'required'=>false,
            'value'=>1,
            'col-size-element'=>'12'
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'precio_unitario',
            'label'=>'Precio',
            'validators'=>array('double'),
            'required'=>false,
            'col-size-element'=>'12'
        ));

        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'descuento_detalle',
            //'label'=>'Descuento',
            'validators'=>array('double'),
            'required'=>false,
            'col-size-element'=>'12'
        ));

        /*No esta en uso... ver FacturaView*/
        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'impuestos_incluidos',
            'multiOptions'=>array('Si'=>'Si','No'=>'No'),
            'col-size-element'=>'12'
         ));


        $this->addElement(array(
            'type'=>'button',
            'name'=>'buscar',
            'value'=>$this->_getTranslation('Agregar'),
            'class'=>'btn btn-default',
            'optionals'=>array('onClick'=>'setNotaCreditoDetalles()')
        ));

        $this->addElement(array(
            'type'=>'button',
            'name'=>'terminar',
            'value'=>$this->_getTranslation('Guardar'),
            'class'=>'btn btn-primary',
            'optionals'=>array("onClick"=>"setNotaCreditoDetalles(function(){submit('notaCredito');})")
        ));
    }

    public function populateDefault()
    {
        $settings = new SettingsRepository();
        $array = array(
            'default_factura_metodoDePago'=>'metodo_de_pago',
            'default_factura_moneda'=>'moneda');

        foreach ($array as $key => $field) {
            $defaultValue = $settings->_get($key);
            if ($defaultValue) {
                $this->setValueToElement($defaultValue, $field);
            }
        }
    }

    public function getListClientes()
    {
        $repository = new ClienteRepository();
        $result = $repository->getListSelectClientes();

        $array = array(''=>'Seleccionar una opcion...');
        if ($result) {
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }
            return $array;
        }
    }

    public function getListUUID($cliente = null)
    {
        $repository = new FacturaRepository();
        $result = $repository->getListUUIDByCliente($cliente);

        $array = array();
        if ($result) {
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }
        }
        return $array;
    }

    public function getListMonedas()
    {
        $repository = new FacturaRepository();
        $result = $repository->getListMoneda();

        $array = array(''=>'Seleccionar una opcion...');
        if ($result) {
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }
            return $array;
        }
    }

    public function getListFormasDePago()
    {
        $repository = new FacturaRepository();
        $result = $repository->getListSelectFormasPago();

        if (count($result)>1) {
            $array = array(''=>'Seleccionar una opcion...');
        }
        if ($result) {
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }
            return $array;
        }
    }



    public function getListMetodosDePago()
    {
        $repository = new FacturaRepository();
        $result = $repository->getListSelectMetodosPago();

        if (count($result)>1) {
            $array = array(''=>'Seleccionar una opcion...');
        }
        if ($result) {
            foreach ($result as $key => $value) {
                $array[$key] = "{$key} - {$value}";
            }
            return $array;
        }
    }

    public function getListTipoRelacion()
    {
        $repository = new FacturaRepository();
        $result = $repository->getListTipoRelacion();

        $array = array('0'=>'Seleccionar una opcion...');
        if ($result) {
            foreach ($result as $key => $value) {
                $array[$key] = "{$key} - {$value}";
            }
            return $array;
        }
    }

    public function getListUsoCFDI()
    {
        $repository = new FacturaRepository();
        $result = $repository->getListUsoCFDI();

        $array = array(''=>'Seleccionar una opcion...');
        if ($result) {
            foreach ($result as $key => $value) {
                $array[$key] = "{$key} - {$value}";
            }
            return $array;
        }
    }

    public function getListStatus()
    {
        $repo = new NotaCreditoRepository();
        $status = $repo->getListStatus();
        $array = array(''=>'Seleccionar una opcion...');

        foreach ($status as $key => $value) {
            $array[$key] = $value;
        }
        return $array;
    }

    public function getListProducts()
    {
        $repository = new ProductoRepository();
        #1 = status activo
        $productos = $repository->getSelectListProductos(3);

        $array = array(''=>'Seleccionar una opcion...');

        foreach ($productos as $key => $value) {
            $array[$key] = $value;
        }
        return $array;
    }

    public function getListSucursales()
    {
        $login = new Login();
        $repository = new SucursalRepository();
        $list = $repository->getListSelectSucursales($login->getSucursal());

        $array = array();
        if (count($list) > 1) {
            $array = array(''=>'Seleccionar una opcion...');
        }
        foreach ($list as $key => $value) {
            $array[$key] = $value;
        }
        return $array;
    }

    public function prepareUuidFromPOST($uuids)
    {
        if (!is_array($uuids)) {
            return null;
        }
        $array = array();

        foreach ($uuids as $key => $uuid) {
            $array[$uuid] = $uuid;
        }
        return $array;
    }

    public function prepareUuidFromGET($uuids)
    {
        if (trim($uuids)=='' or trim($uuids) == null) {
            return null;
        }
        $array = array();
        $uuids = explode(',', $uuids);
        foreach ($uuids as $key => $uuid) {
            $array[$uuid] = $uuid;
        }
        return $array;
    }

    public function populate($data)
    {
        $tools = new Tools();
        if (isset($data['date']) && $tools->isValidaDateYYYMMDD($data['date'])) {
            $data['date'] = $tools->setFormatDateToForm($data['date']);
        }

        $this->addProperties('uuid_relacionados', array('multiOptions'=>$this->getListUUID($data['id_cliente'])));
        if (isset($data['uuid_relacionados_otros'])) {
            $this->addProperties('uuid_relacionados_otros', array('multiOptions'=>$data['uuid_relacionados_otros']));
        }
        parent::populate($data);
    }

    public function isValid()
    {
        $rs = parent::isValid();

        if ($rs) {
            $notaCredito = new FacturaRepository();
            $rango = $notaCredito->esRangoDeFacturacionValido($this->getValueElement('sucursal'), $this->getValueElement('total'));

            if ($rango->rangoValido == 'no') {
                $flashmessenger = new FlashMessenger();
                $flashmessenger->addMessage(array('info'=>'El total la Nota de credito esta fuera del rango permitido.<br/>Minimo: $'.number_format($rango->minimo, 2).'<br/>Maximo: $'.number_format($rango->maximo, 2)));
                return null;
            }
        }
        return $rs;
    }
}
